/*****************************************************************************
 * CM4Uart_shell_addin.c
 *****************************************************************************/
#include "cm.h"
#include "driverlib_cm.h"
#include "CM4Uart.h"
#include <wxemac.h>

/* extern Debug Shell. */
extern UART_DEBUG_t debug_tbl_Basic[];
extern UART_DEBUG_t debug_tbl_addin2[];
extern UART_DEBUG_t debug_tbl_addin3[];

/* typedef------------------------- */
typedef struct uart_tbl {
    void* addr;        // UART_DEBUG_t pointer
    const char* title; // title>
    const char* help;  // Description
} UART_TBL_t;
/* Define-------------------------- */
/* Global Variable----------------- */
UART_DEBUG_t* debug_shell_addin = (UART_DEBUG_t*)&debug_tbl_Basic;

/* Debug Table Change. */
#define UART_TABLE_CNT 4
UART_TBL_t uart_table[ UART_TABLE_CNT ] = {
  { (void*)&debug_tbl_Basic,  "",      "Basic."},            // Basic
  { (void*)&debug_tbl_addin2, "test1", "Debug test table."},
  { (void*)&debug_tbl_addin3, "test2", "Debug test table."},
  { NULL, "", "" }  //
};

/* Variable------------------------ */
/* Prototype----------------------- */
/* RAM Section Functions ---------- */

void shell_help(char *line, int sline)
{
    uint32_t i = 0;
    wxdbg_shell_printf(" help \r\n");
    wxdbg_shell_printf(" ======================== \r\n");
    while( debug_shell_addin[i].cmd_func != NULL ) {
        wxdbg_shell_printf(" %s : %s \r\n", debug_shell_addin[i].cmd, debug_shell_addin[i].help);
        i++;
    }
    wxdbg_shell_printf(" ======================== \r\n");
}
void shell_table(char *line, int sline)
{
    uint32_t id = 0, i = 0;
    char cmd[16];

    wxdbg_shell_printf(" Debug table change. \r\n");

    sscanf( line, "%s %u", cmd, (unsigned int*)&id );
    if ( id == 0 || id > UART_TABLE_CNT ) {
        // Description
        wxdbg_shell_printf(" ======================== \r\n");
        while ( uart_table[i].addr != NULL ) {
            wxdbg_shell_printf("%d : %s \r\n", i+1, uart_table[i].help);
            i++;
        }
        wxdbg_shell_printf(" ======================== \r\n");
    }
    else {
        debug_shell_addin = (UART_DEBUG_t*)(uart_table[ id-1 ].addr);
        wxdbg_shell_printf("   Set Debug Table [%s]. \r\n", uart_table[ id-1 ].help );
        CM4Uart_title( uart_table[ id-1 ].title );
    }

}
static void shell_db(char line[], int sline)
{
    char cmd[16], addr[16];
    uint8_t *val;

    sscanf(line, "%s %s", cmd, addr);
    val = (uint8_t *)strtoul(addr, NULL, 0);
    wxdbg_shell_printf("0x%08lx: 0x%02x\r\n", (uint32_t)val, *(volatile uint8_t *)val);
}
static void shell_dw(char line[], int sline)
{
    char cmd[16], addr[16];
    uint16_t *val;

    sscanf(line, "%s %s", cmd, addr);
    val = (uint16_t *)strtoul(addr, NULL, 0);
    wxdbg_shell_printf("0x%08lx: 0x%04x\r\n", (uint32_t)val, *(volatile uint16_t *)val);
}
static void shell_dd(char line[], int sline)
{
    char cmd[16], addr[16];
    uint32_t *val;

    sscanf(line, "%s %s", cmd, addr);
    val = (uint32_t *)strtoul(addr, NULL, 0);
    wxdbg_shell_printf("0x%08lx: 0x%08lx\r\n", (uint32_t)val, *(volatile uint32_t *)val);
}
static void shell_eb(char line[], int sline)
{
    char cmd[16], addr[16], value[16];
    uint8_t *add, val;

    sscanf(line, "%s %s %s", cmd, addr, value);
    add = (uint8_t *)strtoul(addr, NULL, 0);
    val = (uint8_t)strtoul(value, NULL, 0);
    *(volatile uint8_t *)add = val;
    wxdbg_shell_printf("0x%08lx: 0x%02x\r\n", (uint32_t)add, *add);
}
static void shell_ew(char line[], int sline)
{
    char cmd[16], addr[16], value[16];
    uint16_t *add, val;

    sscanf(line, "%s %s %s", cmd, addr, value);
    add = (uint16_t *)strtoul(addr, NULL, 0);
    val = (uint16_t)strtoul(value, NULL, 0);
    *(volatile uint16_t *)add = val;
    wxdbg_shell_printf("0x%08lx: 0x%04x\r\n", (uint32_t)add, *add);
}
static void shell_ed(char line[], int sline)
{
    char cmd[16], addr[16], value[16];
    uint32_t *add, val;

    sscanf(line, "%s %s %s", cmd, addr, value);
    add = (uint32_t *)strtoul(addr, NULL, 0);
    val = (uint32_t)strtoul(value, NULL, 0);
    *(volatile uint32_t *)add = val;
    wxdbg_shell_printf("0x%08lx: 0x%08lx\r\n", (uint32_t)add, *add);
}

#define CHAR_BIT 8
//static void printb(uint32_t v)
static void printb(uint16_t v)
{
  uint32_t mask = (uint32_t)((int)1 << (sizeof(v) * CHAR_BIT - 1));
  uint8_t enter = 0;
  do {
      wxdbg_shell_printf( "%s", (mask & v ? "1" : "0") );
      if ( ++enter == 8 ) { wxdbg_shell_printf( " " ); enter = 0; }
  } while (mask >>= 1);
}

extern WXEMAC_HANDLE main_emacHandle; // CM4Run.c
static uint16_t initCheck = 0;   // need

static void cm_Ether_exec(char line[], int sline)
{
    WXEMAC_ERROR ret = WXEMAC_ERROR_MAX;
    WXEMAC_FRAME* frame = NULL;
    int i = 0;

    wxdbg_shell_printf("ete : ether exec_send. \r\n");
    if ( main_emacHandle == NULL ) {
        wxdbg_shell_printf("ete : no handle. call [ets]. \r\n");
        return;
    }


    // frame get
    while ( WxEmac_TxFrameChk() == false ) DEVICE_DELAY_US(100); // 100us
    frame = WxEmac_AllocFrame();
    if ( frame == NULL ) {
        wxdbg_shell_printf("ete : error alloc frame. \r\n");
        return;
    }

    // data set
#ifdef ETHER_BOARD2BOARD_TEST_UART
    /* #undef BOARD_2_TEST */
    *((uint32_t*)&frame->buffer)     = (uint32_t)0x0708090A; // LOW
    *((uint32_t*)&frame->buffer + 1) = (uint32_t)0xFFFF0B0C; // HIGH
    for ( i = 8; i < 1514; i++ ) frame->buffer[i] = i;
    frame->len = 1514;
#else // ETHER_BOARD2BOARD_TEST_UART
#if 1
    *((uint32_t*)&frame->buffer)     = (uint32_t)0x01020304; // LOW
    *((uint32_t*)&frame->buffer + 1) = (uint32_t)0xFFFF0506; // HIGH
//    *((uint32_t*)&frame->buffer)     = (uint32_t)0xFFFFFFFF; // LOW  // bloadcast
//    *((uint32_t*)&frame->buffer + 1) = (uint32_t)0xFFFFFFFF; // HIGH // bloadcast
    for ( i = 8; i < 1500; i++ ) frame->buffer[i] = i;
    frame->len = 1500;
#else
    for ( i = 0; i < 132 / 4; i++ ) {
        if(i == 0)      *((uint32_t *)frame->buffer + i) = (uint32_t)0x01020304;
        else if(i == 1) *((uint32_t *)frame->buffer + i) = (uint32_t)0xFFFF0506;
        else            *((uint32_t *)frame->buffer + i) = (uint32_t)0x88888888;
    }
    frame->len = 132;
#endif
#endif // ETHER_BOARD2BOARD_TEST_UART

    //data send
    ret = WxEmac_Write( main_emacHandle, frame );
    if ( ret != WXEMAC_ERROR_SUCCESS ) {
        wxdbg_shell_printf("ete : Write error = %d. \r\n", ret );
        return;
    }
    wxdbg_shell_printf("ete : exec_send success. \r\n");

}

static void cm_Ether_exec2(char line[], int sline)
{
    WXEMAC_ERROR ret1 = WXEMAC_ERROR_MAX;
    WXEMAC_FRAME* frame1 = NULL;
    int i,j;

    wxdbg_shell_printf("ete2 : ether exec_send. \r\n");
    if ( main_emacHandle == NULL ) {
        wxdbg_shell_printf("ete2 : no handle. call [ets]. \r\n");
        return;
    }

    for ( j = 0; j < 300; j++ ) {
        wxdbg_shell_printf("\r\n%d ",(j+1));
        // frame get
        while ( WxEmac_TxFrameChk() == false ) DEVICE_DELAY_US(100); // 100us
        frame1 = WxEmac_AllocFrame();
        if ( frame1 == NULL ) { wxdbg_shell_printf("ete2 : error alloc frame1. \r\n"); return; }

        // data set
#ifdef ETHER_BOARD2BOARD_TEST_UART
        *((uint32_t*)&frame1->buffer)     = (uint32_t)0x0708090A; // LOW
        *((uint32_t*)&frame1->buffer + 1) = (uint32_t)0xFFFF0B0C; // HIGH
        for( i = 8; i < 1500; i++) {
            frame1->buffer[i] = i;
        }
        frame1->len = 1500;
#else // ETHER_BOARD2BOARD_TEST_UART
#if 0
        for ( i = 0; i < 132 / 4; i++ ) {
            if(i == 0)      *((uint32_t *)frame1->buffer + i) = (uint32_t)0x01020304;
            else if(i == 1) *((uint32_t *)frame1->buffer + i) = (uint32_t)0xFFFF0506;
            else            *((uint32_t *)frame1->buffer + i) = (uint32_t)0x88888888;
        }
        frame1->len = 132;
#endif
#if 1
        *((uint32_t*)&frame1->buffer)     = (uint32_t)0x01020304; // LOW
        *((uint32_t*)&frame1->buffer + 1) = (uint32_t)0xFFFF0506; // HIGH
        for( i = 8; i < 1500; i++) {
            frame1->buffer[i] = i;
        }
        frame1->len = 1500;
#endif
#if 0
        for ( i = 0; i < 32 / 4; i++ ) {
            if(i == 0)      *((uint32_t *)frame1->buffer + i) = (uint32_t)0x01020304;
            else if(i == 1) *((uint32_t *)frame1->buffer + i) = (uint32_t)0xFFFF0506;
            else            *((uint32_t *)frame1->buffer + i) = (uint32_t)0x88888888;
        }
        frame1->len = 32;
#endif
#endif // ETHER_BOARD2BOARD_TEST_UART

        //data send
        ret1 = WxEmac_Write( main_emacHandle, frame1 );
        if ( ret1 != WXEMAC_ERROR_SUCCESS ) {
            wxdbg_shell_printf("ete2 : Write error = %d. \r\n", ret1 );
        }

        frame1 = NULL;
        ret1 = WXEMAC_ERROR_MAX;
        DEVICE_DELAY_US(5000); // 5ms RX compleate Delay.
    }
    wxdbg_shell_printf("ete2 : exec_send success. \r\n");
}

static void cm_Ether_ReadMDIO(char line[], int sline)
{
    extern uint16_t PHY_MdioRegRead( uint16_t regAdr );
    char cmd[16], addr[16];
    uint16_t a, b;
    addr[0] = '\0';

    wxdbg_shell_printf("etp : Read MDIO. \r\n" );

    sscanf(line, "%s %s", cmd, addr);
    if ( addr[0] != '\0' ) {
        b = (uint16_t)strtoul(addr, NULL, 0);
        a = PHY_MdioRegRead( b );
        wxdbg_shell_printf("  0x%04X : ", b ); printb( a ); wxdbg_shell_printf("\r\n");
    }
    else{
        a = PHY_MdioRegRead( 0x0000 ); wxdbg_shell_printf("  0x0000 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0001 ); wxdbg_shell_printf("  0x0001 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0002 ); wxdbg_shell_printf("  0x0002 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0003 ); wxdbg_shell_printf("  0x0003 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0004 ); wxdbg_shell_printf("  0x0004 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0005 ); wxdbg_shell_printf("  0x0005 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0006 ); wxdbg_shell_printf("  0x0006 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0007 ); wxdbg_shell_printf("  0x0007 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0008 ); wxdbg_shell_printf("  0x0008 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0009 ); wxdbg_shell_printf("  0x0009 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x000A ); wxdbg_shell_printf("  0x000A : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x000B ); wxdbg_shell_printf("  0x000B : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x000D ); wxdbg_shell_printf("  0x000D : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x000E ); wxdbg_shell_printf("  0x000E : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x000F ); wxdbg_shell_printf("  0x000F : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0010 ); wxdbg_shell_printf("  0x0010 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0011 ); wxdbg_shell_printf("  0x0011 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0012 ); wxdbg_shell_printf("  0x0012 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0013 ); wxdbg_shell_printf("  0x0013 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0014 ); wxdbg_shell_printf("  0x0014 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0015 ); wxdbg_shell_printf("  0x0015 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0016 ); wxdbg_shell_printf("  0x0016 : "); printb( a ); wxdbg_shell_printf("\r\n");
        a = PHY_MdioRegRead( 0x0017 ); wxdbg_shell_printf("  0x0017 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0018 ); wxdbg_shell_printf("  0x0018 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x0019 ); wxdbg_shell_printf("  0x0019 : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x001A ); wxdbg_shell_printf("  0x001A : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x001B ); wxdbg_shell_printf("  0x001B : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x001C ); wxdbg_shell_printf("  0x001C : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x001E ); wxdbg_shell_printf("  0x001E : "); printb( a ); wxdbg_shell_printf("\r\n");
//        a = PHY_MdioRegRead( 0x001F ); wxdbg_shell_printf("  0x001F : "); printb( a ); wxdbg_shell_printf("\r\n");
    }
}

static void cm_Ether_WriteMDIO(char line[], int sline)
{
    extern uint16_t PHY_MdioRegRead( uint16_t regAdr );
    extern uint16_t PHY_MdioRegWrite( uint16_t regAdr, uint16_t regDat );
    char cmd[16], addr[16], data[16];
    uint16_t a, b, c;
    addr[0] = data[0] = '\0';

    wxdbg_shell_printf("etw : Write MDIO. \r\n" );

    sscanf(line, "%s %s %s", cmd, addr, data );
    if ( addr[0] != '\0' && data[0] != '\0' ) {
        b = (uint16_t)strtoul(addr, NULL, 0);
        c = (uint16_t)strtoul(data, NULL, 0);
        a = PHY_MdioRegRead( b );
        PHY_MdioRegWrite( b, c );
        c = PHY_MdioRegRead( b );
        wxdbg_shell_printf("  before 0x%04X : ", b ); printb( a ); wxdbg_shell_printf("\r\n");
        wxdbg_shell_printf("  after  0x%04X : ", b ); printb( c ); wxdbg_shell_printf("\r\n");
    }
    else{
        a = PHY_MdioRegRead( 0x0000 );
        a &= 0xEFFF;
        PHY_MdioRegWrite( 0x0000, a ); // AutoNego OFF. default [Full-Duplex. Spped=100M.]
        a = PHY_MdioRegRead( 0x0000 );
        wxdbg_shell_printf("  0x0000 : "); printb( a ); wxdbg_shell_printf("\r\n");
    }
}

static void cm_Ether_GetStatistic(char line[], int sline)
{
    WXEMAC_STATISTIC statistic[WXEMAC_STATISTIC_MAX];
    uint16_t i;

    WxEmac_GetStatistic( (WXEMAC_DEV)0, statistic );
    for ( i = 0; i < WXEMAC_STATISTIC_MAX; i++ ) {
        wxdbg_shell_printf("%s = %ld\r\n", statistic[i].name, statistic[i].count );
    }
}


static void test(char *line, int sline)
{
    uint32_t id = 0, val = 0;
    char cmd[16];

    sscanf( line, "%s %u %u", cmd, (unsigned int*)&id, (unsigned int*)&val );

    wxdbg_shell_printf(" TEST id = %u, val = %u \r\n", id, val);
}
static void test2(char *line, int sline)
{
    uint32_t id = 0, val = 0;
    char cmd[16];
    sscanf( line, "%s %u %u", cmd, (unsigned int*)&id, (unsigned int*)&val );

    wxdbg_shell_printf(" TEST2 id = %u, val = %u \r\n", id, val);
}

UART_DEBUG_t debug_tbl_Basic[] = {
    {"help",        shell_help,    "help."},
    {"tbl",         shell_table,   "Debug table change."},
    {"db",          shell_db,      "Dump byte."},
    {"dw",          shell_dw,      "Dump ward."},
    {"dd",          shell_dd,      "Dump double."},
    {"eb",          shell_eb,      "Enter byte."},
    {"ew",          shell_ew,      "Enter ward."},
    {"ed",          shell_ed,      "Enter double."},
    {"ete",         cm_Ether_exec    ,"Ethernet exec"},
    {"ete2",        cm_Ether_exec2   ,"Ethernet exec"},
    {"etp",         cm_Ether_ReadMDIO,"Ethernet MDIO read"},
    {"etw",         cm_Ether_WriteMDIO,"Ethernet MDIO write"},
    {"etg",         cm_Ether_GetStatistic,"Ethernet statistic"},
    {"", NULL, ""}
};

UART_DEBUG_t debug_tbl_addin2[] = {
    {"help",        shell_help,     "help."},
    {"tbl",         shell_table,    "Debug table change."},
    {"test",        test,           "test."},
    {"test2",       test2,          "test2."},
    {"", NULL, ""}
};

UART_DEBUG_t debug_tbl_addin3[] = {
    {"help",        shell_help,     "help."},
    {"tbl",         shell_table,    "Debug table change."},
    {"test",        test,           "test."},
    {"", NULL, ""}
};
