/* wxemac.h */
#ifndef _WXEMAC_H_
#define _WXEMAC_H_

// chose 1 -------------
//#define ETHER_BOARD2BOARD_TEST_SENDER   // main board2 debug
#define ETHER_BOARD2BOARD_TEST_RECIEVER // main board2 debug
//----------------------
// chose 1 -------------
#define PHY_100M_FULL
//#define PHY_10M_FULL
//#define PHY_100M_HALF
//#define PHY_10M_HALF
//#define PHY_AUTONEGO_TEST
//----------------------
// chose 1 -------------
#define ETHER_EMAC_CLK_EXTERNAL
//#define ETHER_EMAC_CLK_INTERNAL
//----------------------
// ---------------------
/* Debug LoopBack. */
//#define LOOPBACK_MODE_EMAC
//#define LOOPBACK_MODE_PHY_MII
//#define LOOPBACK_MODE_PHY_DEGITAL
//----------------------

typedef enum _wxemac_error {
	WXEMAC_ERROR_SUCCESS = 0,
	WXEMAC_ERROR_SYSTEM,
	WXEMAC_ERROR_ARGS,
	WXEMAC_ERROR_HANDLE,
	WXEMAC_ERROR_FRAME,
	WXEMAC_ERROR_ALREADY_OPEN,
	WXEMAC_ERROR_LINKDOWN,
	WXEMAC_ERROR_NODATA,

	// for SHARC processer
	WXEMAC_ERROR_ADIOPEN = 1000,
	WXEMAC_ERROR_ADISETMAC,
	WXEMAC_ERROR_ADIENABLEMAC,

	// for Zynq processer
	WXEMAC_ERROR_XILINIT = 1100,
	WXEMAC_ERROR_XILINIT_BD,
	WXEMAC_ERROR_XILOPEN,

	WXEMAC_ERROR_MAX
} WXEMAC_ERROR;

typedef enum _wxemac_dev {
	WXEMAC_DEV_0 = 0, // WELD Driver only
	WXEMAC_DEV_MAX
} WXEMAC_DEV;

#define WXEMAC_STATUS_ACTIVE		(0x10000000)
#define WXEMAC_STATUS_LINKUP		(0x00000001)
#define WXEMAC_STATUS_SPEED_MASK	(0x00000030)
#define WXEMAC_STATUS_SPEED_10		(0x00000000)
#define WXEMAC_STATUS_SPEED_100		(0x00000010)
#define WXEMAC_STATUS_SPEED_1000	(0x00000020)
#define WXEMAC_STATUS_FULL			(0x00000080)
typedef uint32_t WXEMAC_STATUS;

typedef enum _wxemac_link {
	WXEMAC_LINK_DOWN = 0,
	WXEMAC_LINK_UP,
	WXEMAC_LINK_MAX
} WXEMAC_LINK;

typedef enum {
	WXEMAC_PHYMODE_AUTO = 0,
	WXEMAC_PHYMODE_10HALF,
	WXEMAC_PHYMODE_10FULL,
	WXEMAC_PHYMODE_100HALF,
	WXEMAC_PHYMODE_100FULL,
	WXEMAC_PHYMODE_1000HALF,
	WXEMAC_PHYMODE_1000FULL,
	WXEMAC_PHYMODE_LOOPBACK,
	WXEMAC_PHYMODE_MAX
} WXEMAC_PHYMODE;

typedef enum _wxemac_event {
	WXEMAC_EVENT_LINK_DOWN = 0,
	WXEMAC_EVENT_LINK_UP,
	WXEMAC_EVENT_RECEIVE_FRAME,
	WXEMAC_EVENT_MAX
} WXEMAC_EVENT;

typedef void (*wxemac_cbfunc) (uint32_t event, void *param);

typedef struct _wxemac_open_param {
	uint8_t			mac_address[6];
	WXEMAC_PHYMODE	phymode;

	wxemac_cbfunc	cbfunc;
	void			*cbparam;
} WXEMAC_OPEN_PARAM;

typedef struct _wxemac_info {
	WXEMAC_DEV		dev;
	WXEMAC_STATUS	status;			// status
	uint8_t			mac_address[6];	// mac address

	uint64_t		txcnt;			// number of received tx packets
	uint64_t		rxcnt;			// number of received rx packets
	uint64_t		rx_dropped;		// number of dropped rx packets due to overflow
} WXEMAC_INFO;

#define WXEMAC_FRAME_LENGTH		(1536)			// 1536(32x48) Byte
#define WXEMAC_FRAME_DLENGTH	(72)            // descriptor size (Ethernet_Pkt_Desc)
typedef struct _wxemac_frame {
	uint8_t		buffer[WXEMAC_FRAME_LENGTH];	// Ethernet frame buffer
	uint16_t	len;							// Ethernet frame length
	uint16_t	padding;

	uint8_t		drivers[WXEMAC_FRAME_DLENGTH];	// driver private data
} WXEMAC_FRAME;									// total 1600(32x50) Byte


#define WXEMAC_FRAME_DST(frame)     (uint8_t *)(&(frame->buffer[0]))
#define WXEMAC_FRAME_SRC(frame)     (uint8_t *)(&(frame->buffer[6]))
#define WXEMAC_FRAME_TYPE(frame)    *(uint16_t *)(&(frame->buffer[12]))
#define WXEMAC_FRAME_DATA(frame)    (uint8_t *)(&(frame->buffer[14]))
#define WXEMAC_FRAME_HEAD(frame)	WXEMAC_FRAME_DST(frame)

#define WXEMAC_STAT_STRING		(64)
#define WXEMAC_STATISTIC_MAX    (57)
typedef struct _wxemac_statistic {
    uint32_t    offset;
    char        name[WXEMAC_STAT_STRING];
    uint32_t    count;
} WXEMAC_STATISTIC;

typedef void* WXEMAC_HANDLE;

WXEMAC_ERROR WxEmac_Init(void);
WXEMAC_ERROR WxEmac_Fin(void);

WXEMAC_ERROR WxEmac_Open(WXEMAC_DEV dev, WXEMAC_OPEN_PARAM *poparam, WXEMAC_HANDLE *phandle);
WXEMAC_ERROR WxEmac_Close(WXEMAC_HANDLE handle);
void WxEmac_Poll(void);
WXEMAC_ERROR WxEmac_GetInfo(WXEMAC_DEV dev, WXEMAC_INFO *pinfo);
int32_t WxEmac_GetStatistic(WXEMAC_DEV dev, WXEMAC_STATISTIC stats[WXEMAC_STATISTIC_MAX]);
void WxEmac_UpdateStats(WXEMAC_DEV dev);

WXEMAC_ERROR WxEmac_Read(WXEMAC_HANDLE handle, WXEMAC_FRAME **pframe);
WXEMAC_ERROR WxEmac_Write(WXEMAC_HANDLE handle, WXEMAC_FRAME *pframe);
WXEMAC_FRAME *WxEmac_AllocFrame(void);
WXEMAC_ERROR WxEmac_FreeFrame(WXEMAC_FRAME *pframe);

bool WxEmac_TxFrameChk(void);      // true = Tx Frame OK. false = Tx Frame Ng. wait.

#endif /* _WXEMAC_H_ */
