
MEMORY
{
   /* BEGIN is used for the "boot to Flash" bootloader mode   */
   BEGIN            : origin = 0x080000, length = 0x000002 /* boot to Flash bootloader mode */
   RESET            : origin = 0x3FFFC0, length = 0x000002 /* Reset */

   BOOT_RSVD        : origin = 0x000002, length = 0x0001A7 /* Part of M0, BOOT rom will use this for stack */
   RAMM             : origin = 0x0001AC, length = 0x000654
//   RAMM1_RSVD       : origin = 0x0007F8, length = 0x000008     /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */
   RAMD             : origin = 0x00C000, length = 0x001000
   RAMLS0_6         : origin = 0x008000, length = 0x003800
   RAMLS7           : origin = 0x00B800, length = 0x000800

   RAMGS0           : origin = 0x00D000, length = 0x001000
   RAMGS1           : origin = 0x00E000, length = 0x001000
   RAMGS2           : origin = 0x00F000, length = 0x001000
   RAMGS3           : origin = 0x010000, length = 0x001000
   RAMGS4           : origin = 0x011000, length = 0x001000
   RAMGS5           : origin = 0x012000, length = 0x001000
   RAMGS6           : origin = 0x013000, length = 0x001000
   RAMGS7           : origin = 0x014000, length = 0x001000
   RAMGS8           : origin = 0x015000, length = 0x001000
   RAMGS9           : origin = 0x016000, length = 0x001000
   RAMGS10          : origin = 0x017000, length = 0x001000
   RAMGS11          : origin = 0x018000, length = 0x001000
   RAMGS12          : origin = 0x019000, length = 0x001000
   RAMGS13          : origin = 0x01A000, length = 0x001000
   RAMGS14          : origin = 0x01B000, length = 0x001000
   RAMGS15          : origin = 0x01C000, length = 0x000FF8
//   RAMGS15_RSVD     : origin = 0x01CFF8, length = 0x000008     /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */

   /* Flash sectors */
   FLASH           : origin = 0x080002, length = 0x03FFEE     /* on-chip Flash */
//   FLASH13_RSVD     : origin = 0x0BFFF0, length = 0x000010  /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */

   CPU1TOCPU2RAM   : origin = 0x03A000, length = 0x000800
   CPU2TOCPU1RAM   : origin = 0x03B000, length = 0x000800
   CPUTOCMRAM      : origin = 0x039000, length = 0x000800
   CMTOCPURAM      : origin = 0x038000, length = 0x000800

   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800
}

SECTIONS
{
   codestart           : > BEGIN, ALIGN(4)
   .text               : >> FLASH, ALIGN(4)
   .cinit              : > FLASH, ALIGN(4)
   .switch             : > FLASH, ALIGN(4)
   .reset              : > RESET, TYPE = DSECT /* not used, */
   .stack              : > RAMD

#if defined(__TI_EABI__)
   .init_array      : > FLASH, ALIGN(4)
   .bss             : > RAMM | RAMLS0_6
   .bss:output      : > RAMM | RAMLS0_6
   .bss:cio         : > RAMM | RAMLS0_6
   .data            : > RAMM | RAMLS0_6
   .sysmem          : > RAMM | RAMLS0_6
   /* Initalized sections go in Flash */
   .const           : > FLASH, ALIGN(4)
#else
   .pinit           : > FLASH, ALIGN(4)
   .ebss            : > RAMM | RAMLS0_6
   .esysmem         : > RAMM | RAMLS0_6
   .cio             : > RAMM | RAMLS0_6
   /* Initalized sections go in Flash */
   .econst          : >> FLASH, ALIGN(4)
#endif

//   ramgs0 : > RAMGS0, type=NOINIT
//   ramgs1 : > RAMGS1, type=NOINIT
   
   MSGRAM_CPU1_TO_CPU2 : > CPU1TOCPU2RAM, type=NOINIT
   MSGRAM_CPU2_TO_CPU1 : > CPU2TOCPU1RAM, type=NOINIT
   MSGRAM_CPU_TO_CM    : > CPUTOCMRAM, type=NOINIT
   MSGRAM_CM_TO_CPU    : > CMTOCPURAM, type=NOINIT

   /* The following section definition are for SDFM examples */
//   Filter_RegsFile  : > RAMGS0
//   Filter1_RegsFile : > RAMGS1, fill=0x1111
//   Filter2_RegsFile : > RAMGS2, fill=0x2222
//   Filter3_RegsFile : > RAMGS3, fill=0x3333
//   Filter4_RegsFile : > RAMGS4, fill=0x4444
//   Difference_RegsFile : >RAMGS5, fill=0x3333

#if defined(__TI_EABI__)
   .TI.ramfunc : {} LOAD = FLASH,
                    RUN = RAMLS0_6,
                    LOAD_START(RamfuncsLoadStart),
                    LOAD_SIZE(RamfuncsLoadSize),
                    LOAD_END(RamfuncsLoadEnd),
                    RUN_START(RamfuncsRunStart),
                    RUN_SIZE(RamfuncsRunSize),
                    RUN_END(RamfuncsRunEnd),
                    ALIGN(4)
#else
   .TI.ramfunc : {} LOAD = FLASH,
                    RUN = RAMLS0_6,
                    LOAD_START(_RamfuncsLoadStart),
                    LOAD_SIZE(_RamfuncsLoadSize),
                    LOAD_END(_RamfuncsLoadEnd),
                    RUN_START(_RamfuncsRunStart),
                    RUN_SIZE(_RamfuncsRunSize),
                    RUN_END(_RamfuncsRunEnd),
                    ALIGN(4)
#endif
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/




