/*****************************************************************************
 * Dsp2Run.c
 *****************************************************************************/
#include <Dsp2Run.h>

/* Define-------------------------- */
/* Global Variable----------------- */
/* Variable------------------------ */
/* Prototype----------------------- */
static void Dsp2Run_MainLoop( void );

/* RAM Section Functions ---------- */
#pragma CODE_SECTION(Dsp2Run_MainLoop, ".TI.ramfunc");

/* main                      */
/* User Program Entry Point. */
int main(void)
{
    DINT;
    IER = 0x0000;
    IFR = 0x0000;

    /* Initialize device clock and peripherals */
    Device_init();

    /* Initialize PIE and clear PIE registers. Disables CPU interrupts. */
    Interrupt_initModule();
    /* Initialize the PIE vector table with pointers to the shell Interrupt */
    /* Service Routines (ISR). */
    Interrupt_initVectorTable();
    /* Enable the PIE block. */
    PieCtrlRegs.PIECTRL.bit.ENPIE = 1;

    /* CPU12 Sync. */
    IPC_waitForFlag( IPC_CPU1_L_CPU2_R, IPC_FLAG4 ); // IPC Flg wait. C1 => [C2]
    IPC_ackFlagRtoL( IPC_CPU1_L_CPU2_R, IPC_FLAG4 ); // IPC ACK set.  C1 <= [C2]

    /* Enable Global Interrupt (INTM) and realtime interrupt (DBGM) */
    EINT; // Enable Global interrupt INTM
    ERTM; // Enable Global realtime interrupt DBGM

    Dsp2Run_MainLoop(); // not return.

	return 0;
}

/* MainLoop. */
static void Dsp2Run_MainLoop( void )
{
    while(1) {

    }
}
