/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>

void myResetFunction()
{
    asm(" EALLOW");
    asm(" MOVW DP, #0x01F0");
    asm(" ZAPA");
    asm(" MOV AH, #0x8000");
    asm(" MOVL @0xA, ACC");
    asm(" EDIS");

    /* Turn it off */
    //asm(" MOVW DP, #0x01FC");
    //asm(" ZAPA");
    //asm(" MOV AH, #0x8000");
    //asm(" MOVL @0x2, ACC");
    //asm(" MOVW DP, #0x0");
}


/*
 *  ======== taskFxn ========
 */
Void taskFxn(UArg a0, UArg a1)
{
    System_printf("enter taskFxn()\n");

    Task_sleep(1000);

    System_printf("exit taskFxn()\n");

    System_flush(); /* force SysMin output to console */
    /* Enable LED */

    /* Turn it on */
    asm(" MOVW DP, #0x01FC");
    asm(" ZAPA");
    asm(" MOV AH, #0x8000");
    asm(" MOVL @0x4, ACC");
    asm(" MOVW DP, #0x0");

}

/*
 *  ======== main ========
 */
Int main()
{ 
    Task_Handle task;
    Error_Block eb;

    System_printf("enter main()\n");

    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);
    if (task == NULL) {
        System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    BIOS_start();    /* does not return */
    return(0);
}
