#include "c2000BoardSupport.h"
#include "F2837xD_device.h"
#include "F2837xD_Examples.h"
#include "F2837xD_GlobalPrototypes.h"
#include "rtwtypes.h"
#include "GridLinkDemoNew_CAN.h"
#include "GridLinkDemoNew_CAN_private.h"

void config_ADCA_SOC12()
{
  EALLOW;
  AdcaRegs.ADCSOC12CTL.bit.CHSEL = 3;  /* Set SOC12 channel select to ADCIN3*/
  AdcaRegs.ADCSOC12CTL.bit.TRIGSEL = 27;
  AdcaRegs.ADCSOC12CTL.bit.ACQPS = 12.0;
                              /* Set SOC12 S/H Window to 13.0 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL2.bit.SOC12 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC0()
{
  EALLOW;
  AdcaRegs.ADCSOC0CTL.bit.CHSEL = 0;   /* Set SOC0 channel select to ADCIN0*/
  AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 27;
  AdcaRegs.ADCSOC0CTL.bit.ACQPS = 12.0;
                               /* Set SOC0 S/H Window to 13.0 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL1.bit.SOC0 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC15()
{
  EALLOW;
  AdcaRegs.ADCSOC15CTL.bit.CHSEL = 1;  /* Set SOC15 channel select to ADCIN1*/
  AdcaRegs.ADCSOC15CTL.bit.TRIGSEL = 27;
  AdcaRegs.ADCSOC15CTL.bit.ACQPS = 12.0;
                              /* Set SOC15 S/H Window to 13.0 ADC Clock Cycles*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1; /* Enabled/Disable ADCINT1 interrupt*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 15;/* Setup EOC15 to trigger ADCINT1*/
  AdcaRegs.ADCINTSEL1N2.bit.INT1CONT = 0;
                                     /* Enable/Disable ADCINT1 Continuous mode*/
  AdcaRegs.ADCINTSOCSEL2.bit.SOC15 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCB_SOC3()
{
  EALLOW;
  AdcbRegs.ADCSOC3CTL.bit.CHSEL = 2;   /* Set SOC3 channel select to ADCIN2*/
  AdcbRegs.ADCSOC3CTL.bit.TRIGSEL = 27;
  AdcbRegs.ADCSOC3CTL.bit.ACQPS = 12.0;
                               /* Set SOC3 S/H Window to 13.0 ADC Clock Cycles*/
  AdcbRegs.ADCINTSOCSEL1.bit.SOC3 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC4()
{
  EALLOW;
  AdcdRegs.ADCSOC4CTL.bit.CHSEL = 14;  /* Set SOC4 channel select to ADCIN14*/
  AdcdRegs.ADCSOC4CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC4CTL.bit.ACQPS = 12.0;
                               /* Set SOC4 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC4 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCC_SOC5()
{
  EALLOW;
  AdccRegs.ADCSOC5CTL.bit.CHSEL = 2;   /* Set SOC5 channel select to ADCIN2*/
  AdccRegs.ADCSOC5CTL.bit.TRIGSEL = 27;
  AdccRegs.ADCSOC5CTL.bit.ACQPS = 12.0;
                               /* Set SOC5 S/H Window to 13.0 ADC Clock Cycles*/
  AdccRegs.ADCINTSOCSEL1.bit.SOC5 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdccRegs.ADCOFFTRIM.bit.OFFTRIM = AdccRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdccRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdccRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCB_SOC2()
{
  EALLOW;
  AdcbRegs.ADCSOC2CTL.bit.CHSEL = 1;   /* Set SOC2 channel select to ADCIN1*/
  AdcbRegs.ADCSOC2CTL.bit.TRIGSEL = 27;
  AdcbRegs.ADCSOC2CTL.bit.ACQPS = 12.0;
                               /* Set SOC2 S/H Window to 13.0 ADC Clock Cycles*/
  AdcbRegs.ADCINTSOCSEL1.bit.SOC2 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCB_SOC13()
{
  EALLOW;
  AdcbRegs.ADCSOC13CTL.bit.CHSEL = 0;  /* Set SOC13 channel select to ADCIN0*/
  AdcbRegs.ADCSOC13CTL.bit.TRIGSEL = 27;
  AdcbRegs.ADCSOC13CTL.bit.ACQPS = 12.0;
                              /* Set SOC13 S/H Window to 13.0 ADC Clock Cycles*/
  AdcbRegs.ADCINTSOCSEL2.bit.SOC13 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC2()
{
  EALLOW;
  AdcdRegs.ADCSOC2CTL.bit.CHSEL = 4;   /* Set SOC2 channel select to ADCIN4*/
  AdcdRegs.ADCSOC2CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC2CTL.bit.ACQPS = 12.0;
                               /* Set SOC2 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC2 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCA_SOC9()
{
  EALLOW;
  AdcaRegs.ADCSOC9CTL.bit.CHSEL = 5;   /* Set SOC9 channel select to ADCIN5*/
  AdcaRegs.ADCSOC9CTL.bit.TRIGSEL = 27;
  AdcaRegs.ADCSOC9CTL.bit.ACQPS = 12.0;
                               /* Set SOC9 S/H Window to 13.0 ADC Clock Cycles*/
  AdcaRegs.ADCINTSOCSEL2.bit.SOC9 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcaRegs.ADCOFFTRIM.bit.OFFTRIM = AdcaRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcaRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCB_SOC10()
{
  EALLOW;
  AdcbRegs.ADCSOC10CTL.bit.CHSEL = 4;  /* Set SOC10 channel select to ADCIN4*/
  AdcbRegs.ADCSOC10CTL.bit.TRIGSEL = 27;
  AdcbRegs.ADCSOC10CTL.bit.ACQPS = 12.0;
                              /* Set SOC10 S/H Window to 13.0 ADC Clock Cycles*/
  AdcbRegs.ADCINTSOCSEL2.bit.SOC10 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcbRegs.ADCOFFTRIM.bit.OFFTRIM = AdcbRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcbRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcbRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC11()
{
  EALLOW;
  AdcdRegs.ADCSOC11CTL.bit.CHSEL = 5;  /* Set SOC11 channel select to ADCIN5*/
  AdcdRegs.ADCSOC11CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC11CTL.bit.ACQPS = 12.0;
                              /* Set SOC11 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL2.bit.SOC11 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC6()
{
  EALLOW;
  AdcdRegs.ADCSOC6CTL.bit.CHSEL = 0;   /* Set SOC6 channel select to ADCIN0*/
  AdcdRegs.ADCSOC6CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC6CTL.bit.ACQPS = 12.0;
                               /* Set SOC6 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC6 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC7()
{
  EALLOW;
  AdcdRegs.ADCSOC7CTL.bit.CHSEL = 1;   /* Set SOC7 channel select to ADCIN1*/
  AdcdRegs.ADCSOC7CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC7CTL.bit.ACQPS = 12.0;
                               /* Set SOC7 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL1.bit.SOC7 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void config_ADCD_SOC8()
{
  EALLOW;
  AdcdRegs.ADCSOC8CTL.bit.CHSEL = 2;   /* Set SOC8 channel select to ADCIN2*/
  AdcdRegs.ADCSOC8CTL.bit.TRIGSEL = 27;
  AdcdRegs.ADCSOC8CTL.bit.ACQPS = 12.0;
                               /* Set SOC8 S/H Window to 13.0 ADC Clock Cycles*/
  AdcdRegs.ADCINTSOCSEL2.bit.SOC8 = 0;
                                   /* SOCx No ADCINT Interrupt Trigger Select.*/
  AdcdRegs.ADCOFFTRIM.bit.OFFTRIM = AdcdRegs.ADCOFFTRIM.bit.OFFTRIM;/* Set Offset Error Correctino Value*/
  AdcdRegs.ADCCTL1.bit.INTPULSEPOS = 1;
                                /* Late interrupt pulse trips AdcResults latch*/
  AdcdRegs.ADCSOCPRICTL.bit.SOCPRIORITY = 0;/* All in round robin mode SOC Priority*/
  EDIS;
}

void InitAdcA()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_A = 1;
  AdcaRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCA, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcB()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_B = 1;
  AdcbRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCB, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcbRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcC()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_C = 1;
  AdccRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCC, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdccRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}

void InitAdcD()
{
  EALLOW;
  CpuSysRegs.PCLKCR13.bit.ADC_D = 1;
  AdcdRegs.ADCCTL2.bit.PRESCALE = 8;
  AdcSetMode(ADC_ADCD, ADC_RESOLUTION_12BIT, ADC_SIGNALMODE_SINGLE);

  //power up the ADC
  AdcdRegs.ADCCTL1.bit.ADCPWDNZ = 1;

  //delay for 1ms to allow ADC time to power up
  DELAY_US(1000);
  EDIS;
}
