//#############################################################################
//
// FILE:   empty_driverlib_main.c
//
//! \addtogroup driver_example_list
//! <h1>Empty Project Example</h1> 
//!
//! This example is an empty project setup for Driverlib development.
//!
//
//#############################################################################
//
//
// $Copyright:
// Copyright (C) 2024 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################

//
// Included Files
//
#include "driverlib.h"
#include "device.h"
#include "board.h"
#include "c2000ware_libraries.h"

//
// Macros and global variables
//

bool status = 0;
uint32_t NoOfInts = 0;



//
// Function prototypes
//

void MyGPIOInit(void);

__interrupt void MyGPIO_ISR(void);






//
// Main
//
void main(void)
{

    //
    // Initialize device clock and peripherals
    //
    Device_init();

    //
    // Disable pin locks and enable internal pull-ups.
    //
    Device_initGPIO();

    MyGPIOInit();


    //
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    //
    Interrupt_initModule();

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    //
    Interrupt_initVectorTable();


    // Interrupt enable configuration.

    Interrupt_enable(INT_XINT1);                    // Enable XINT1 interrupt.
    Interrupt_register(INT_XINT1, &MyGPIO_ISR);     //Link XINT1 int to ISR MyGPIO_ISR.


    //
    // PinMux and Peripheral Initialization
    //
    Board_init();




    //
    // C2000Ware Library initialization
    //
    C2000Ware_libraries_init();

    //
    // Enable Global Interrupt (INTM) and real time interrupt (DBGM)
    //
    EINT;
    ERTM;

    // USER CODE


    while(1)
    {

    }
}

// Function definitions

void MyGPIOInit(void)
{


    // Configure LED1 GPIO as output with default value 1.
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LED1);                            // Configure LED pin GPIO20 as GPIO.
    GPIO_setPadConfig(DEVICE_GPIO_PIN_LED1, GPIO_PIN_TYPE_STD);         // Configure output as push-pull.
    GPIO_writePin(DEVICE_GPIO_PIN_LED1, 1);                             // Preload output pin state 1.
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_LED1, GPIO_DIR_MODE_OUT);     // Configure pin GPIO20 as output.


    // Configure LED2 GPIO as output with default value 1.
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LED2);
    GPIO_setPadConfig(DEVICE_GPIO_PIN_LED2, GPIO_PIN_TYPE_STD);
    GPIO_writePin(DEVICE_GPIO_PIN_LED2, 1);
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_LED2, GPIO_DIR_MODE_OUT);


    // Configure GPIO as dOut with interrupt XINT1 during transition from 0 to 1.
    GPIO_setPinConfig(GPIO_0_GPIO0);                                     // Configure GPIO 0 as GPIO.
    GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);                            // Push-pull output config.
    GPIO_writePin(0, 0);                                                // Default low output.
    GPIO_setDirectionMode(0, GPIO_DIR_MODE_OUT);                        // Configuration as output.

    GPIO_setInterruptType(GPIO_INT_XINT1, GPIO_INT_TYPE_RISING_EDGE);   // Set int trigger rising edge.
    GPIO_setInterruptPin(0, GPIO_INT_XINT1);                            // Connect int XINT1 to GPIO 0.
    GPIO_enableInterrupt(GPIO_INT_XINT1);                               // Enable XINT1 in GPIO.
}


// ISR Definitions.

__interrupt void MyGPIO_ISR(void)
{
    GPIO_togglePin(22);
    NoOfInts++;
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);                  // Clear ACK bit of group 1.
}


//
// End of File
//
