/*
 * ADC_config.c
 *
 *  Created on: 3. jun. 2024
 *      Author: Smodis
 */


// Includes ===========================================================================================================


#include "device.h"
#include "driverlib.h"

#include "ADC_config.h"


// Variables ===========================================================================================================






// Function definitions ===============================================================================================


void MyADC_init(void)
{
    // Konfiguriram prescaler ADC ure iz CPU ure.

    ADC_setPrescaler(ADCA_BASE, ADC_CLK_DIV_3_0);       // ADCA clk = 120/3 = 40 MHz.


    // Ustvarim SoC0 konfiguracijo na CH0 (pin 15).

//    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 100);


    // Ustvarim SoC1 na CH0 (pin 25), trigger ePWM2 SoCA, t_AQ = ns

    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM2_SOCA, ADC_CH_ADCIN0, 20);


    // SoC1 pretvorba prozi ADC interrupt 1.

    ADC_setInterruptPulseMode(ADCA_BASE, ADC_PULSE_END_OF_CONV);    // EOC flag se postavi ob koncu pretvorbe.

    ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER1);    // SoC1 prozi ADCA int 1.

    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);   // Preventivno pobrisem interrupt triggerje.

    ADC_disableContinuousMode(ADCA_BASE, ADC_INT_NUMBER1);  // Samo en interrupt na enkrat.

    ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);    // Omogocim ADC int 1.


    // Omogocim ADCa modul

    ADC_enableConverter(ADCA_BASE);
    DEVICE_DELAY_US(500);



    return;
}

void MyADCC_Init(void)
{
    // Konfiguriram prescaler na 3 iz SysClk na ADCcClk

    ADC_setPrescaler(ADCC_BASE, ADC_CLK_DIV_3_0);


    // Ustvarim SoC konfiguracije

    // SoC0 za zajem Temperature posode T_pot

    ADC_setupSOC(ADCC_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM7_SOCA, ADC_CH_ADCIN0, 50);

    // SoC1 za zajem Temperature hladila T_HS

    ADC_setupSOC(ADCC_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM7_SOCA, ADC_CH_ADCIN1, 50);


    // Konfiguriram lastnosti interrupta ADCc4, v skupini PIE 10.

    ADC_setInterruptPulseMode(ADCC_BASE, ADC_PULSE_END_OF_CONV);

    ADC_setInterruptSource(ADCC_BASE, ADC_INT_NUMBER4, ADC_SOC_NUMBER1);

    ADC_clearInterruptStatus(ADCC_BASE, ADC_INT_NUMBER4);

    ADC_disableContinuousMode(ADCC_BASE, ADC_INT_NUMBER4);

    ADC_enableInterrupt(ADCC_BASE, ADC_INT_NUMBER4);


    // Omogocim ADCc modul

    ADC_enableConverter(ADCC_BASE);
    DEVICE_DELAY_US(500);

    return;
}

