/*
 * CMPSS_config.c
 *
 *  Created on: 7. jun. 2024
 *      Author: Smodis
 */


// Includes ===========================================================================================================


#include "device.h"
#include "driverlib.h"

#include "CMPSS_config.h"


// Variables ===========================================================================================================






// Function definitions ===============================================================================================

void MyCMPSS1_init(void)
{
    // Omogocim zgornji komparator1 + vhod 0 (CMP1_HP0 pin 9).

    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_1, 0);

    // Konfiguriram zgornji komparator tako, da je referenca iz DACa.

    CMPSS_configHighComparator(CMPSS1_BASE, CMPSS_INSRC_DAC);

    // Konfiguriram DAC za zgornji komparator tako, da se posodobi vsak SysClk cikel in da vzame podatek in shadow registra.

    CMPSS_configDAC(CMPSS1_BASE, (CMPSS_DACVAL_SYSCLK | CMPSS_DACSRC_SHDW));

    // Nastavim vrednost zgornjega DACa.

    CMPSS_setDACValueHigh(CMPSS1_BASE, 2048U); // 1.65V

    // Omogocim komparator modul.

    CMPSS_enableModule(CMPSS1_BASE);

    // Konfiguriram digitalni filter zgornjega komparatorja.

    CMPSS_configFilterHigh(CMPSS1_BASE, CMPSS1_H_FILTER_SMPL_PRESCALE, CMPSS1_H_FILTER_SMPL_WINDOW, CMPSS1_H_FILTER_THRESHOLD);

    // Inicializiram vrednosti v filter FIFO bufferju.

    CMPSS_initFilterHigh(CMPSS1_BASE);

    // Konfiguriram kateri signal bo povezan na izhod komparatorja.

    CMPSS_configOutputsHigh(CMPSS1_BASE, (CMPSS_TRIPOUT_FILTER | CMPSS_TRIP_FILTER));

    // Konfiguriram histerezo komparatorja.

//    CMPSS_setHysteresis(CMPSS1_BASE, CMPSS1_HYSTERESIS);




    return;
}
