/*
 * GPIO_config.c
 *
 *  Created on: 29. maj 2024
 *      Author: Smodis
 */


// Includes ===========================================================================================================


#include "device.h"
#include "driverlib.h"

#include "GPIO_config.h"


// Variables ===========================================================================================================




// Function definitions ===============================================================================================


void MyGPIOInit(void)
{

    // Configure LED1 GPIO as output with default value 1.
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LED1);                            // Configure LED pin GPIO20 as GPIO.
    GPIO_setPadConfig(DEVICE_GPIO_PIN_LED1, GPIO_PIN_TYPE_STD);         // Configure output as push-pull.
    GPIO_writePin(DEVICE_GPIO_PIN_LED1, 1);                             // Preload output pin state 1.
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_LED1, GPIO_DIR_MODE_OUT);     // Configure pin GPIO20 as output.


    // Configure LED2 GPIO as output with default value 1.
    GPIO_setPinConfig(DEVICE_GPIO_CFG_LED2);
    GPIO_setPadConfig(DEVICE_GPIO_PIN_LED2, GPIO_PIN_TYPE_STD);
    GPIO_writePin(DEVICE_GPIO_PIN_LED2, 1);
    GPIO_setDirectionMode(DEVICE_GPIO_PIN_LED2, GPIO_DIR_MODE_OUT);


    // Konfiguriram GPIO0 kot izhod CMPSS1H komparatorja preko OUTPUTXBAR7.
    GPIO_setPinConfig(GPIO_0_OUTPUTXBAR7);                                  // Configure GPIO 0 as .
//    GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);                            // Push-pull output config.
//    GPIO_writePin(0, 0);                                                // Default low output.
//    GPIO_setDirectionMode(0, GPIO_DIR_MODE_OUT);                        // Configuration as output.


    // Configure GPIO 1 as input which will trigger XINT1.
//    GPIO_setPinConfig(GPIO_1_GPIO1);
//    GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
//    GPIO_setDirectionMode(1, GPIO_DIR_MODE_IN);
//
//    GPIO_setInterruptType(GPIO_INT_XINT1, GPIO_INT_TYPE_RISING_EDGE);   // Set int trigger rising edge.
//    GPIO_setInterruptPin(1, GPIO_INT_XINT1);                            // Connect int XINT1 to GPIO 0.
//    GPIO_enableInterrupt(GPIO_INT_XINT1);                               // Enable XINT1 in GPIO.


    // EPWM GPIO pin mux.

    // Configure GPIO2 as EPWM2_A.

    GPIO_setPinConfig(GPIO_2_EPWM2_A);
    GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);


    // Configure GPIO3 as EPWM2_B.

    GPIO_setPinConfig(GPIO_3_EPWM2_B);
    GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);


    // Konfiguriram GPIO4 kot OUTPUTXBAR3 zato, da lahko vidim izhod komparatorja.

    GPIO_setPinConfig(GPIO_4_OUTPUTXBAR3);
}











