/*
 * eCAP_config.c
 *
 *  Created on: 13. jun. 2024
 *      Author: Smodis
 */


// Includes ===========================================================================================================


#include "device.h"
#include "driverlib.h"

#include "eCAP_config.h"


// Variables ===========================================================================================================

#define eCAP1_Pin                5               // GPIO5 uporabim kot input za eCAP1 modul.
#define eCAP1_PinConfig          GPIO_5_GPIO5    // pin 5 funkcionalnost je GPIO.

#define eCAP1_XBAR_INPUT_LINE    XBAR_INPUT1    // Izbere Input Xbar linijo preko katere poveem pin in eCAP1 modul.
#define eCAP1_InputMuxIndex

#define eCAP1_PRESCALER         0U              // Ne prescalam vhoda.


// Function definitions ===============================================================================================


void MyECAP1_init(void)
{

    // Konfiguriram izbran GPIO pin za eCAP1 vhod

    GPIO_setPinConfig(eCAP1_PinConfig);
    GPIO_setDirectionMode(eCAP1_Pin, GPIO_DIR_MODE_IN);
    GPIO_setPadConfig(eCAP1_Pin, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(eCAP1_Pin, GPIO_QUAL_6SAMPLE);


    // Poveem izbran pin na input xBar.

    XBAR_setInputPin(INPUTXBAR_BASE, eCAP1_XBAR_INPUT_LINE, eCAP1_Pin);


    // Izberem ustrezeno input xBar linijo v eCAP1 input muxu.

    ECAP_selectECAPInput(ECAP1_BASE, ECAP_INPUT_INPUTXBAR1);


    // Konfiguriram polariteto in event qualifier

    ECAP_setEventPrescaler(ECAP1_BASE, eCAP1_PRESCALER);    // Nastavim prescaler.

    ECAP_setEmulationMode(ECAP1_BASE, ECAP_EMULATION_FREE_RUN );    // Omogocim neprekinjeno delovanje tudi ob SW breakpointih.

    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_1, ECAP_EVNT_FALLING_EDGE);
    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_2, ECAP_EVNT_FALLING_EDGE);
    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_3, ECAP_EVNT_FALLING_EDGE);
    ECAP_setEventPolarity(ECAP1_BASE, ECAP_EVENT_4, ECAP_EVNT_FALLING_EDGE);

    ECAP_enableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_1);   // Prvi event resetira tevec.
    ECAP_enableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_2);   // Prvi event resetira tevec.
    ECAP_enableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_3);   // Prvi event resetira tevec.
    ECAP_enableCounterResetOnEvent(ECAP1_BASE, ECAP_EVENT_4);   // Prvi event resetira tevec.

    ECAP_enableTimeStampCapture(ECAP1_BASE);    // Omogoim, da se zajame vrednost tevca ob nastanku eventa.

    ECAP_enableCaptureMode(ECAP1_BASE);     // Omogoim delovanje v capture in ne APWM reimu.

    ECAP_setCaptureMode(ECAP1_BASE, ECAP_CONTINUOUS_CAPTURE_MODE, ECAP_EVENT_4);

//    ECAP_setSyncInPulseSource(ECAP1_BASE, ECAP_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM2);    // Nastavim vir SyncIn pulza.

    ECAP_enableLoadCounter(ECAP1_BASE); // Omogocim nalaganje vrednosti v stevec ob syncin pulzu.

    ECAP_setPhaseShiftCount(ECAP1_BASE, 0U); // Nastavim vrednost s katere zacne stevec ob SyncIn pulzu.

//    EPWM_enableSyncOutPulseSource(EPWM2_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);   // Nastavim vir epwm syncout pulza.

    ECAP_resetCounters(ECAP1_BASE);     // Ponastavim vse stevce v eCAP1 modulu in pripravim na zagon.

    ECAP_startCounter(ECAP1_BASE);      // Pozenem stevec eCAP1 modula.





    return;
}
