/*
 * ePWM_config.c
 *
 *  Created on: 29. maj 2024
 *      Author: Smodis
 */


// Includes ===========================================================================================================


#include "device.h"
#include "driverlib.h"

#include "ePWM_config.h"


// Variables ===========================================================================================================






// Function definitions ===============================================================================================




void MyEPWM7_init(void)
{

    // Konfiguriram Time base submodul.

    EPWM_setClockPrescaler(EPWM7_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
    EPWM_setTimeBasePeriod(EPWM7_BASE, 6000U);
    EPWM_setTimeBaseCounter(EPWM7_BASE, 0);
    EPWM_setTimeBaseCounterMode(EPWM7_BASE, EPWM_COUNTER_MODE_UP_DOWN);

    EPWM_setEmulationMode(EPWM7_BASE, EPWM_EMULATION_FREE_RUN);     // Omogocim real-time delovanje ePWM modula.



    // Konfiguriram proenje ADC SOC.

    EPWM_setADCTriggerSource(EPWM7_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_PERIOD);    // ADC SoCA se prozi ob CNT=PERIOD.

    EPWM_setADCTriggerEventPrescale(EPWM7_BASE, EPWM_SOC_A, 1); // Ob vsaki periodi se prozi SoCA.

    EPWM_enableADCTrigger(EPWM7_BASE, EPWM_SOC_A);      // EPWM7 prozi ADC SOCA.

    return;
}

void MyEPWM_init(void)
{
    // Configure Time Base submodule of ePWM2.

    EPWM_setClockPrescaler(EPWM2_BASE, EPWM2_CLOCK_DIVIDER, EPWM2_HSCLOCK_DIVIDER);    // TBCLK enak SYSCLK
    EPWM_setTimeBasePeriod(EPWM2_BASE, PERIOD);
    EPWM_setTimeBaseCounter(EPWM2_BASE, 0);
    EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM2_COUNT_MODE);

    EPWM_setEmulationMode(EPWM2_BASE, EPWM_EMULATION_FREE_RUN);     // Omogocim real-time delovanje ePWM modula.


    // Set initial compare values to 0.

    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, 0);
    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, 0);



    // Configure Action Qualifier submodule of ePWM2.

    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);


    // Configure Dead Band submodule of ePWM2.

    EPWM_setDeadBandDelayMode(EPWM2_BASE, EPWM_DB_RED, true);    // Omogocim RED delay.
    EPWM_setDeadBandDelayMode(EPWM2_BASE, EPWM_DB_FED, true);   // Omogocim FED delay.

    EPWM_setDeadBandDelayPolarity(EPWM2_BASE, EPWM_DB_FED, EPWM_DB_POLARITY_ACTIVE_LOW); // Konfiguriram Acitve high complementary rezim.

    EPWM_setRisingEdgeDelayCount(EPWM2_BASE, 120);  // Osnovna nastavitev RED je 120 ciklov oz 1000 ns.
    EPWM_setFallingEdgeDelayCount(EPWM2_BASE, 120); // Osnovna nastavitev FED je 120 ciklov oz 1000 ns.


    // Configure Trip Zone signals.

//    EPWM_enableTripZoneSignals(EPWM2_BASE, EPWM_TZ_SIGNAL_CBC1);   // Omogocim TZ1 signal v CBC nacinu.
//    EPWM_selectCycleByCycleTripZoneClearEvent(EPWM2_BASE, EPWM_TZ_CBC_PULSE_CLR_CNTR_ZERO); // CBC Flag se pocisti ob CNT=0.
//
//    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZA, EPWM_TZ_ACTION_LOW);   // Ob TZ1 gre PWMA LOW.
//    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZB, EPWM_TZ_ACTION_LOW);   // Ob TZ1 gre PWMB low.


    // Konfiguriram lastnosti prozenja interruptov

    EPWM_enableInterrupt(EPWM2_BASE);   // Omogoim generacijo int v ePWM2 modulu.

    EPWM_setInterruptSource(EPWM2_BASE, EPWM_INT_TBCTR_PERIOD); // Dogodek, ki prozi int je CNT=PERIOD.

    EPWM_setInterruptEventCount(EPWM2_BASE, 1); // Int se prozi ob vsakem dogodku.


    // Konfiguriram proenje ADC SOC.


    EPWM_setADCTriggerSource(EPWM2_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_PERIOD);    // ADC SoCA se prozi ob CNT=PERIOD.

    EPWM_setADCTriggerEventPrescale(EPWM2_BASE, EPWM_SOC_A, 1); // Ob vsaki periodi se prozi SoCA.

    EPWM_enableADCTrigger(EPWM2_BASE, EPWM_SOC_A);      // EPWM2 prozi ADC SOCA.



//    Konfiguracija ePWM modula za Cycle by Cycle zaito ob previsokem toku.


    // 0. Dolocim da se ob prozenja Trip Zone A signala izklopi PWMA signal

    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZA, EPWM_TZ_ACTION_LOW);
    EPWM_setTripZoneAction(EPWM2_BASE, EPWM_TZ_ACTION_EVENT_TZB, EPWM_TZ_ACTION_DISABLE);


    // 1. Omogocim Cycle by cycle prozenje na DCAEVT2.force signalu iz Digital Compare submodula

     EPWM_enableTripZoneSignals(EPWM2_BASE, EPWM_TZ_SIGNAL_DCAEVT2);


     // 2. CBC Flag pobriem ob CNT = PERIOD

     EPWM_selectCycleByCycleTripZoneClearEvent(EPWM2_BASE, EPWM_TZ_CBC_PULSE_CLR_CNTR_PERIOD);


     // 3. Poveem DCAEVT2.force z DCAEVT2 signalom v DC subomodulu.

     EPWM_setDigitalCompareCBCLatchMode(EPWM2_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_2, EPWM_DC_CBC_LATCH_DISABLED);
     EPWM_setDigitalCompareEventSyncMode(EPWM2_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_2, EPWM_DC_EVENT_INPUT_NOT_SYNCED);
     EPWM_setDigitalCompareEventSource(EPWM2_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_2, EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);


     // 3. Poveem DCAEVT2 z DCAH signalom v DC submodulu.

     EPWM_setTripZoneDigitalCompareEventCondition(EPWM2_BASE, EPWM_TZ_DC_OUTPUT_A2, EPWM_TZ_EVENT_DCXH_HIGH);


     // 4.  ePWM XBAR TRIP4 proi DCAH signal v DC submodulu.

     EPWM_selectDigitalCompareTripInput(EPWM2_BASE, EPWM_DC_TRIP_TRIPIN4, EPWM_DC_TYPE_DCAH);


     // 6. Poveem TRIP4 signal z CMPSS1_CTRIPH izhodom komparatorja 1 High.

     XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX00_CMPSS1_CTRIPH);
     XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX00);



}

/*
 * Posodobim PWM frekvenco in vklopno razmerje
 * Frekvenca mora biti 1000 <= freq <= 100 000 kHz.
 * Duty mora biti 0.0f <= duty <= 1.0f.
 */

void UpdatePWMFreqAndDuty(uint32_t freq, float duty)
{
    // Posodobim vrednost frekvence PWM2A in PWM2B. Frekvenca mora biti 1000 <= PWM_freq <= 100 000 kHz drugae gremo v error handler.

    if ((1000U <= freq) && (freq <= 100000U))
    {
        EPWM_setTimeBasePeriod(EPWM2_BASE, ( EPWM2_TB_FREQ / (2* freq) ));

        // Posodobim vrednost vklopnega razmerja PWM2A in PWM2B. duty mora biti 0.0 <= duty <= 1.0 drugae gremo v error handler.

        if (0.0f <= duty && duty <= 1.0f)
        {
            EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, ( EPWM_getTimeBasePeriod(EPWM2_BASE) * duty ));
            EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, ( EPWM_getTimeBasePeriod(EPWM2_BASE) * duty ));
        }
//            else Error_handler();     // Komentiram, ker ne deluje pravilno, nevem zakaj.
    }
//        else Error_handler();         // Komentiram, ker ne deluje pravilno, nevem zakaj.

    return;
}



/*
 *  Posodobi dead time registre za rising in falling edge.
 *  Deadtime mora biti 100 <= T_dead <= 1000.
 */

void UpdateDeadTime(uint16_t T_dead_r_ns, uint16_t T_dead_f_ns)
{
    uint16_t t_dead_r_count = 0;
    uint16_t t_dead_f_count = 0;

    if (100 <= T_dead_r_ns && T_dead_r_ns <= 1000)
     {
         t_dead_r_count = (uint16_t) (0.000000001f * EPWM2_TB_FREQ * T_dead_r_ns);
         EPWM_setRisingEdgeDelayCount(EPWM2_BASE, t_dead_r_count);
     }

     if (100 <= T_dead_f_ns && T_dead_f_ns <= 1000)
     {
         t_dead_f_count = (uint16_t) (0.000000001f * EPWM2_TB_FREQ * T_dead_f_ns);
         EPWM_setFallingEdgeDelayCount(EPWM2_BASE, t_dead_f_count);
     }

     return;
}



