/*
 * ePWM_config.h
 *
 *  Created on: 29. maj 2024
 *      Author: Smodis
 */

#ifndef EPWM_CONFIG_H_
#define EPWM_CONFIG_H_


// Includes ====================================================================================================

#include "device.h"
#include "driverlib.h"

#include "main.h"



// Defines =======================================================================================================


// Definicije za ePWM2 modul.

#define EPWM2_PWM_FREQ          75000U     // Doloi ePWM2 PWM frekvenca.
#define EPWM2_PWMA_DUTY         0.50F       // Doloi PWMA duty.
#define EPWM2_PWMB_DUTY         0.50F       // Doloi PWMB duty
#define EPWM2_PWMB_IS_INVERTED  true        // Ali je PWMB signal invertiran?

// Konfiguracija Time Base submodula.

#define EPWM2_CLOCK_DIVIDER         EPWM_CLOCK_DIVIDER_1    // Doloi Clock makro divider za ePWM2 uro.
#define EPWM2_CLOCK_DIVIDER_VALUE   1                       // Prepii tevilno vrednost dividerja.
#define EPWM2_HSCLOCK_DIVIDER       EPWM_HSCLOCK_DIVIDER_1  // Doloi HS Clock divider za ePWM2 uro.
#define EPWM2_HSCLOCK_DIVIDER_VALUE 1                       // Prepii tevilno vrednost dividerja.
#define EPWM2_TB_FREQ           (DEVICE_SYSCLK_FREQ / (EPWM2_CLOCK_DIVIDER_VALUE * EPWM2_HSCLOCK_DIVIDER_VALUE))    // TB Clk ePWM2 modula.
#define EPWM2_COUNT_MODE        EPWM_COUNTER_MODE_UP_DOWN   // Doloi reim tetja counterja.

#define PERIOD  (EPWM2_TB_FREQ / (2* EPWM2_PWM_FREQ))    // Period register value.
#define COMPA   (PERIOD * EPWM2_PWMA_DUTY)              // Compare A value.
#define COMPB   (PERIOD * EPWM2_PWMB_DUTY)


// Function prototypes =======================================================================================

void MyEPWM_init(void);
void MyEPWM7_init(void);

void UpdateDeadTime(uint16_t T_dead_r_ns, uint16_t T_dead_f_ns);
void UpdatePWMFreqAndDuty(uint32_t freq, float duty);





#endif /* EPWM_CONFIG_H_ */
