// TI File $Revision: /main/3 $
// Checkin $Date: June 28, 2010   09:18:20 $

#include "DSP28x_Project.h"     // Device Headerfile and Examples Include File



// Prototype statements for functions found within this file.
interrupt void epwm1_isr(void);


#define SYSOUTCLK   300000000UL
#define LSPCLK_Hz (SYSOUTCLK)
#define CHECK_PLL_TIME      (400)   // 20ms, 20kHz/50Hz
#define CHECK_SYNC_TIME     (200)   // 10ms, 20kHz/100Hz

//Default Value
#define INVERTER_SWITCHING_FREQUENCY_Hz  20e3f  // 20 kHz.
//#define CONVERTER_SWITCHING_FREQUENCY_Hz 100e3f  // 100kHz is ok
float CONVERTER_SWITCHING_FREQUENCY_Hz = 90e3f;  // 90kHz is not ok.
#define INVERTER_DEAD_TIME_ns            400.0f
#define CONVERTER_DEAD_TIME_ns           450.0f
#define EPWM_PHASE_COEF                  (1.0f / 180.0f) // For phase in degrees 0-180 mapped to TBPRD fraction

#define EPWM_CLK_Hz         SYSOUTCLK
#define EPWM_CLK_HALF_Hz    (EPWM_CLK_Hz / 2)

void configureSymmetricComplementaryPWM(volatile struct EPWM_REGS *EPwmRegs, float freq_Hz, Uint16 masterSync)
{
    float fTemp;
    fTemp = SYSOUTCLK / freq_Hz;

    EPwmRegs->TBPRD = (Uint16)fTemp;
    EPwmRegs->TBPHS.half.TBPHS = 0;
    EPwmRegs->TBCTR = 0x0000;

    EPwmRegs->TBCTL.bit.CTRMODE = TB_COUNT_UPDOWN;
    EPwmRegs->TBCTL.bit.PRDLD = TB_SHADOW;
    EPwmRegs->TBCTL.bit.CLKDIV = TB_DIV1;
    EPwmRegs->TBCTL.bit.HSPCLKDIV = TB_DIV1;

    if(masterSync)
    {
        EPwmRegs->TBCTL.bit.PHSEN = TB_DISABLE;
        EPwmRegs->TBCTL.bit.SYNCOSEL = TB_CTR_ZERO;
    }
    else // Slave module
    {
        EPwmRegs->TBCTL.bit.PHSEN = TB_ENABLE;
        EPwmRegs->TBCTL.bit.SYNCOSEL = TB_SYNC_IN;
    }
    EPwmRegs->TBCTL.bit.PHSDIR = TB_DOWN;

    // Setup shadow register loads
    EPwmRegs->CMPCTL.bit.SHDWAMODE = CC_SHADOW;
    EPwmRegs->CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwmRegs->CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;
    EPwmRegs->CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    EPwmRegs->AQCTLA.bit.CAD = AQ_SET;           // Set on CMPA down-count
    EPwmRegs->AQCTLA.bit.CAU = AQ_CLEAR;         // Clear on CMPA up-count
    EPwmRegs->AQCTLB.bit.CAD = AQ_SET;
    EPwmRegs->AQCTLB.bit.CAU = AQ_CLEAR;
    EPwmRegs->AQCTLA.bit.ZRO = AQ_NO_ACTION;
    EPwmRegs->AQCTLA.bit.PRD = AQ_NO_ACTION;

    EPwmRegs->DBCTL.bit.IN_MODE = DBA_RED_DBB_FED;
    EPwmRegs->DBCTL.bit.POLSEL = DB_ACTV_HIC;      // Active High complementary
    EPwmRegs->DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;

    EPwmRegs->HRCNFG.bit.EDGMODE = 0;

    // Initialize Dead-Band values - these will be updated by updateDeadtime()
    EPwmRegs->DBRED = 0;
    EPwmRegs->DBFED = 0;

    // Initialize CMPA and CMPB values
    EPwmRegs->CMPA.half.CMPA = 0;
    EPwmRegs->CMPB = 0;
}

void updateDuty(volatile struct EPWM_REGS *EPwmRegs, float duty)    // UP-DOWN Counter Mode
{
    EPwmRegs->CMPA.half.CMPA = (Uint16)(EPwmRegs->TBPRD * duty);
}

void updateFreq(volatile struct EPWM_REGS *EPwmRegs, float freq_Hz)    // UP-DOWN Counter Mode
{
    float fTemp;
    fTemp = EPWM_CLK_HALF_Hz/ freq_Hz;
    EPwmRegs->TBPRD = (Uint16)fTemp;
}

void updateDeadtime(volatile struct EPWM_REGS *EPwmRegs, float deadtime_ns)
{
    Uint16 deadband;

    deadband = (Uint16)(deadtime_ns * 1e-9f * EPWM_CLK_Hz);

    EPwmRegs->DBFED = deadband;
    EPwmRegs->DBRED = deadband;
}
void updatePhase(volatile struct EPWM_REGS *EPwmRegs, float phase)
{
    if (phase < 0.0f)   phase = 0.0f;
    if (phase > 180.0)  phase = 180.0;
    EPwmRegs->TBPHS.half.TBPHS = (Uint16)(EPwmRegs->TBPRD * phase * EPWM_PHASE_COEF);
}
void updatePhase_360(volatile struct EPWM_REGS* ep, float deg)
{
    while(deg >= 360.f) deg -= 360.f;
    while(deg <   0.f ) deg += 360.f;

    if (deg <= 180.f) {
        ep->TBCTL.bit.PHSEN  = TB_ENABLE;   // Slave
        ep->TBCTL.bit.PHSDIR = TB_DOWN;       // 0~180
        ep->TBPHS.half.TBPHS = (Uint16)((ep->TBPRD * (deg/180.f)) + 0.5f);
    }
    else {
        ep->TBCTL.bit.PHSEN  = TB_ENABLE;
        ep->TBCTL.bit.PHSDIR = TB_UP;     // 180~360
        ep->TBPHS.half.TBPHS = (Uint16)((ep->TBPRD * (1.f - (deg - 180.f)/180.f)) + 0.5f);

    }
}

void main(void)
{
// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2834x_SysCtrl.c file.
   InitSysCtrl();

// Step 2. Initalize GPIO: 
// This example function is found in the DSP2834x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
// InitGpio();  // Skipped for this example  

// For this case just init GPIO pins for ePWM1, ePWM2, ePWM3
// These functions are in the DSP2834x_EPwm.c file
   InitEPwm1Gpio();
   InitEPwm2Gpio();
   InitEPwm3Gpio();

   InitEPwm4Gpio();
   InitEPwm5Gpio();
   InitEPwm6Gpio();
   InitEPwm7Gpio();
   InitEPwm8Gpio();
//   InitEPwm9Gpio();
   
// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts 
   DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.  
// This function is found in the DSP2834x_PieCtrl.c file.
   InitPieCtrl();
   
// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt 
// Service Routines (ISR).  
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2834x_DefaultIsr.c.
// This function is found in DSP2834x_PieVect.c.
   InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.  
   EALLOW;  // This is needed to write to EALLOW protected registers
   PieVectTable.EPWM1_INT = &epwm1_isr;
   EDIS;    // This is needed to disable write to EALLOW protected registers

// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP2834x_InitPeripherals.c
// InitPeripherals();  // Not required for this example

// For this example, only initialize the ePWM

   EALLOW;
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
   EDIS;

   configureSymmetricComplementaryPWM(&EPwm1Regs, INVERTER_SWITCHING_FREQUENCY_Hz, 1);
   configureSymmetricComplementaryPWM(&EPwm2Regs, INVERTER_SWITCHING_FREQUENCY_Hz, 0);
   configureSymmetricComplementaryPWM(&EPwm3Regs, INVERTER_SWITCHING_FREQUENCY_Hz, 0);
   // if enable -> PWM7 ok.
#if 1
   EALLOW;
   EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;       // ܺ ȣ 
   EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE; //  Sync   ( !)
   EPwm2Regs.TBCTL.bit.PHSEN = TB_DISABLE;
   EPwm2Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE;
   EPwm3Regs.TBCTL.bit.PHSEN = TB_DISABLE;
   EPwm3Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE;
   EDIS;
#endif
   updateFreq(&EPwm1Regs, INVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm2Regs, INVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm3Regs, INVERTER_SWITCHING_FREQUENCY_Hz);
   updateDeadtime(&EPwm1Regs, INVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm2Regs, INVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm3Regs, INVERTER_DEAD_TIME_ns);
   updatePhase(&EPwm2Regs, 0);
   updatePhase(&EPwm3Regs, 0);
   EALLOW;
   EPwm3Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE; // 11: Sync Output Disabled
   EDIS;
   EPwm1Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / INVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm2Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / INVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm3Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / INVERTER_SWITCHING_FREQUENCY_Hz / 2;


   //---------------------
   configureSymmetricComplementaryPWM(&EPwm4Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 1);
   configureSymmetricComplementaryPWM(&EPwm5Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 0);
   configureSymmetricComplementaryPWM(&EPwm6Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 0);
   configureSymmetricComplementaryPWM(&EPwm7Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 0);
   configureSymmetricComplementaryPWM(&EPwm8Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 1);
//   configureSymmetricComplementaryPWM(&EPwm9Regs, CONVERTER_SWITCHING_FREQUENCY_Hz, 0);
   EALLOW;
   EPwm7Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_DISABLE; // 11: Sync Output Disabled
   EDIS;
   updateFreq(&EPwm4Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm5Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm6Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm7Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   updateFreq(&EPwm8Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   //updateFreq(&EPwm9Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
   updateDeadtime(&EPwm4Regs, CONVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm5Regs, CONVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm6Regs, CONVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm7Regs, CONVERTER_DEAD_TIME_ns);
   updateDeadtime(&EPwm8Regs, CONVERTER_DEAD_TIME_ns);
//   updateDeadtime(&EPwm9Regs, CONVERTER_DEAD_TIME_ns);

   updatePhase_360(&EPwm5Regs, 0); //S3
   updatePhase_360(&EPwm6Regs, 0); //S5
   updatePhase_360(&EPwm7Regs, 0); //S7
   updatePhase_360(&EPwm8Regs, 0); //S7
//   updatePhase_360(&EPwm9Regs, 0); //S7

   EPwm4Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm5Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm6Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm7Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm8Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;
   EPwm9Regs.CMPA.half.CMPA = EPWM_CLK_HALF_Hz / CONVERTER_SWITCHING_FREQUENCY_Hz / 2;

   EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;
   EPwm1Regs.ETSEL.bit.INTEN = 1;
   EPwm1Regs.ETPS.bit.INTPRD = ET_1ST;


#if 0
   EPwm1Regs.ETSEL.bit.SOCAEN = 0x1;
   EPwm1Regs.ETSEL.bit.SOCASEL = 0x1;
   EPwm1Regs.ETPS.bit.SOCAPRD = 0x1;
   // Enable extsoc1A set polarity
   SysCtrlRegs.EXTSOCCFG.bit.EXTSOC1AEN = 0x1;     // Enable extsoc1 A
   SysCtrlRegs.EXTSOCCFG.bit.EXTSOC1APOLSEL= 0x1;  // Set inverted polarity (CONVST is active low)
#endif

   EALLOW;
   EPwm4Regs.TBCTL.bit.SWFSYNC = 1; // to make the pulses phase shifted
   EPwm5Regs.TBCTL.bit.SWFSYNC = 1;
   EPwm6Regs.TBCTL.bit.SWFSYNC = 1;
   EPwm7Regs.TBCTL.bit.SWFSYNC = 1; // to make the pulses phase shifted
   EPwm8Regs.TBCTL.bit.SWFSYNC = 1;
//   EPwm9Regs.TBCTL.bit.SWFSYNC = 1;

   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
   EDIS;
   
// Step 5. User specific code, enable interrupts:

// Enable CPU INT3 which is connected to EPWM1-3 INT:
   IER |= M_INT3;

// Enable EPWM INTn in the PIE: Group 3 interrupt 1-3
   PieCtrlRegs.PIEIER3.bit.INTx1 = 1;

// Enable global Interrupts and higher priority real-time debug events:
   EINT;   // Enable Global interrupt INTM
   ERTM;   // Enable Global realtime interrupt DBGM

// Step 6. IDLE loop. Just sit and loop forever (optional):
   for(;;)
   {
       asm("          NOP");
   }

} 



float pwm5 = 0;
float pwm6 = 0;
float pwm7 = 0;
//float pwm8 = 0;
//float pwm9 = 0;

interrupt void epwm1_isr(void)
{
   // Update the CMPA and CMPB values

    updateDuty(&EPwm1Regs, 0.5);
    updateDuty(&EPwm2Regs, 0.5);
    updateDuty(&EPwm3Regs, 0.5);

    updateFreq(&EPwm4Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
    updateFreq(&EPwm5Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
    updateFreq(&EPwm6Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
    updateFreq(&EPwm7Regs, CONVERTER_SWITCHING_FREQUENCY_Hz);
//
    updateDuty(&EPwm4Regs, 0.5);
    updateDuty(&EPwm5Regs, 0.5);
    updateDuty(&EPwm6Regs, 0.5);
    updateDuty(&EPwm7Regs, 0.5);

    updatePhase_360(&EPwm5Regs, pwm5); // Work
    updatePhase_360(&EPwm6Regs, pwm6); // Work
    updatePhase_360(&EPwm7Regs, pwm7); // It doesnt work.
//    updatePhase_360(&EPwm8Regs, pwm8);
//    updatePhase_360(&EPwm9Regs, pwm9);



   // Clear INT flag for this timer
   EPwm1Regs.ETCLR.bit.INT = 1;

   // Acknowledge this interrupt to receive more interrupts from group 3
   PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}

//===========================================================================
// No more.
//===========================================================================
