
CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start

MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */
   BEGIN           	: origin = 0x000000, length = 0x000002
   RAMD0           	: origin = 0x00B000, length = 0x000800
   RAMD1           	: origin = 0x00B800, length = 0x000800
   RAMLS0          	: origin = 0x008000, length = 0x000800
   RAMLS12          : origin = 0x008800, length = 0x001000
   //RAMLS2      	: origin = 0x009000, length = 0x000800
   RAMGS0      		: origin = 0x00C000, length = 0x001000
   RAMGS1      		: origin = 0x00D000, length = 0x001000
   RAMGS2      		: origin = 0x00E000, length = 0x001000
   RAMGS3      		: origin = 0x00F000, length = 0x001000
   RESET           	: origin = 0x3FFFC0, length = 0x000002

PAGE 1 :

   BOOT_RSVD       	: origin = 0x000002, length = 0x000120     /* Part of M0, BOOT rom will use this for stack */
   RAMM0            : origin = 0x000122, length = 0x0002DE
   RAMM1           	: origin = 0x000400, length = 0x000400     /* on-chip RAM block M1 */

   RAMLS3      		: origin = 0x009800, length = 0x000800
   RAMLS4      		: origin = 0x00A000, length = 0x000800
   RAMLS5      		: origin = 0x00A800, length = 0x000800

   RAMGS4      		: origin = 0x010000, length = 0x001000
   RAMGS5      		: origin = 0x011000, length = 0x001000
   RAMGS6      		: origin = 0x012000, length = 0x001000
   RAMGS7      		: origin = 0x013000, length = 0x001000

   CPU2TOCPU1RAM   	: origin = 0x03F800, length = 0x000400
   CPU1TOCPU2RAM   	: origin = 0x03FC00, length = 0x000400
   
   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800
}


SECTIONS
{
   codestart        : > BEGIN,     PAGE = 0
   ramfuncs         : > RAMLS12      PAGE = 0
   .text            : >> RAMGS0 | RAMGS1 | RAMGS2 | RAMGS3,   PAGE = 0
   .cinit           : > RAMD1,     PAGE = 0
   .pinit           : > RAMD1,     PAGE = 0
   .switch          : > RAMD1,     PAGE = 0
   .reset           : > RESET,     PAGE = 0, TYPE = DSECT /* not used, */

   Cla1Prog			: > RAMLS0,    PAGE = 0

   .stack           : > RAMM0,     PAGE = 1
   .ebss            : >> RAMLS4 | RAMLS5,    PAGE = 1
   .econst          : > RAMLS5,    PAGE = 1
   .esysmem         : > RAMLS4,    PAGE = 1

   Cla1Data			: > RAMLS3,    PAGE = 1

   CLAscratch       :{ *.obj(CLAscratch)
                     . += CLA_SCRATCHPAD_SIZE;
                     *.obj(CLAscratch_end) } >  RAMLS3,  PAGE = 1
   
   /* The following section definitions are required when using the IPC API Drivers */ 
    GROUP : > CPU1TOCPU2RAM, PAGE = 1 
    {
        PUTBUFFER 
        PUTWRITEIDX 
        GETREADIDX 
    }
    
    GROUP : > CPU2TOCPU1RAM, PAGE = 1
    {
        GETBUFFER :    TYPE = DSECT
        GETWRITEIDX :  TYPE = DSECT
        PUTREADIDX :   TYPE = DSECT
    }  
	
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
