/* ----------------------------------------------------------------------------
οDatasheet page164 "6.3.1 C28x Memory Map"

CLAɷʵRAM
LS0~LS7:	2KW*8 = 16KW

MSG RAM	128W*2 = 256W

CPUɷʵRAM
M0~M1		1KW*2 = 2KW
GS0~GS3	8KW*4 = 32KW

Flash
Bank0		4KW*16 = 64KW
Bank1		4KW*16 = 64KW
---------------------------------------------------------------------------- */

/* ============================================================================
cmdļmemory䣺
CPU_STACK		M0~M1		1KW*2 = 2KW
CPU_DATA_RAM	GS0~2		8KW*3 = 24KW
CPU_PROG_RAM	GS3			8KW

CLA_PROG_RAM	LS0~3		2KW*4 = 8KW
CLA_DATA_RAM	LS4~7		2KW*4 = 8KW

BOOTLOADER_FLASH	BANK0 SECTOR0~1		4KW*2 = 8KW
EEPROM				BANK0 SECTOR2~3		4KW*2 = 8KW
APP_PROG_FLASH		BANK0 SECTOR4~15	4KW*12 = 48KW
============================================================================ */

_Cla1Prog_Start = _Cla1funcsRunStart;
-heap 0x200
-stack 0x200

// Define a size for the CLA scratchpad area that will be used
// by the CLA compiler for local symbols and temps
// Also force references to the special symbols that mark the
// scratchpad are.
CLA_SCRATCHPAD_SIZE = 256;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start


MEMORY
{
PAGE 0 :
	CLA_PROG_RAM		: origin = 0x008000, length = 0x002000	// LS0~3: 8KW
	CPU_PROG_RAM		: origin = 0x012000, length = 0x002000	// GS3: 8KW

   /* BEGIN is used for the "boot to Flash" bootloader mode   */
    BEGIN				: origin = 0x080000, length = 0x000002
//	BOOTLOADER_FLASH	: origin = 0x080002, length = 0x001FFD	// BANK0 SECTOR0~1
//	BOOTLOADER_VER		: origin = 0x081FFF, length = 0x000001
//    DATA_FLASH		    : origin = 0x082000, length = 0x002000
//    APP_BEGIN			: origin = 0x084000, length = 0x000002
//	APP_PROG_FLASH		: origin = 0x084002, length = 0x00BFB5
	APP_PROG_FLASH		: origin = 0x080002, length = 0x00B000
	CINIT_FLASH			: origin = 0x08B002, length = 0x003000
	INIT_FLASH			: origin = 0x08E002, length = 0x001FB5
	APP_CRC16			: origin = 0x08FFB7, length = 0x000001
//	INIT_FLASH			: origin = 0x08C902, length = 0x003000
//	APP_CRC16			: origin = 0x08F902, length = 0x000001

/*
	APP_PROG_FLASH		: origin = 0x094002, length = 0x007000
	CINIT_FLASH			: origin = 0x09B002, length = 0x001900
	INIT_FLASH			: origin = 0x09C902, length = 0x0036B5
	APP_CRC16			: origin = 0x09FFB7, length = 0x000001
*/

    RESET				: origin = 0x3FFFC0, length = 0x000002

PAGE 1 :
	BOOT_RSVD           : origin = 0x000002, length = 0x0000F3      // Part of M0, BOOT rom will use this for stack
	CPU_STACK           : origin = 0x0000F5, length = 0x00070B		// M0~M1   0x70b W
	CLA_DATA_RAM	    : origin = 0x00A000, length = 0x002000		// LS4~7: 8KW
	CPU_DATA_RAM	    : origin = 0x00C000, length = 0x002000		// GS0~2 24KW


	CLA1_MSGRAMLOW      : origin = 0x001480, length = 0x000080
	CLA1_MSGRAMHIGH     : origin = 0x001500, length = 0x000080
}


SECTIONS
{
// CLA Sections
	Cla1Prog		: LOAD = APP_PROG_FLASH,
                          RUN  = CLA_PROG_RAM,
                          LOAD_START(_Cla1funcsLoadStart),
                          LOAD_END  (_Cla1funcsLoadEnd),
                          RUN_START (_Cla1funcsRunStart),
                          LOAD_SIZE (_Cla1funcsLoadSize),
                          PAGE = 0

	CLA1mathTables	: > CLA_DATA_RAM,
                          LOAD_START(_Cla1mathTablesLoadStart),
                      	  LOAD_END(_Cla1mathTablesLoadEnd),
                      	  LOAD_SIZE(_Cla1mathTablesLoadSize),
                      	  RUN_START(_Cla1mathTablesRunStart),
                      	  PAGE = 1


	ClaDataRam      : > CLA_DATA_RAM,		PAGE = 1
   	ClaToCpuMsgRam  : > CLA1_MSGRAMLOW,		PAGE = 1
   	CpuToClaMsgRam  : > CLA1_MSGRAMHIGH,	PAGE = 1

	CLAscratch		:{ *.obj(CLAscratch)
						   . += CLA_SCRATCHPAD_SIZE;
                          *.obj(CLAscratch_end) } > CLA_DATA_RAM,
				          PAGE = 1

   	.scratchpad      : > CLA_DATA_RAM,		PAGE = 1

	.bss_cla         : > CLA_DATA_RAM,		PAGE = 1
   	.const_cla       : > CLA_DATA_RAM,		PAGE = 1


// CPU sections:
	codestart        : > BEGIN,   			PAGE = 0, ALIGN(4)
//	bootloader_ver   : > BOOTLOADER_VER,    PAGE = 0, ALIGN(1)
//	data_flash       : > DATA_FLASH,        PAGE = 0, ALIGN(4)
// 	app_codestart    : > APP_BEGIN,   		PAGE = 0, ALIGN(4)
   	.text            : > APP_PROG_FLASH,	PAGE = 0, ALIGN(4)

//   	.cinit           : > APP_PROG_FLASH,	PAGE = 0, ALIGN(4)
//   	.pinit           : > APP_PROG_FLASH,	PAGE = 0, ALIGN(4)
//   	.switch          : > APP_PROG_FLASH,	PAGE = 0, ALIGN(4)

   	.cinit           : > CINIT_FLASH,	PAGE = 0//, ALIGN(4)
   	.pinit           : > INIT_FLASH,	PAGE = 0//, ALIGN(4)
   	.switch          : > INIT_FLASH,	PAGE = 0//, ALIGN(4)

   	.reset           : > RESET,				PAGE = 0, TYPE = DSECT /* not used, */

   	.stack           : > CPU_STACK,			PAGE = 1
   	.ebss            : > CPU_DATA_RAM,		PAGE = 1
   	.esysmem         : > CPU_DATA_RAM, 		PAGE = 1
   	.econst          : > APP_PROG_FLASH,	PAGE = 0, ALIGN(4)

   //ramgs0           : > RAMGS0,    PAGE = 1
   //ramgs1           : > RAMGS1,    PAGE = 1

   	ramfuncs         : LOAD = APP_PROG_FLASH,
                         RUN = CPU_PROG_RAM,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsLoadSize),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart),
                         RUN_SIZE(_RamfuncsRunSize),
                         RUN_END(_RamfuncsRunEnd),
                         PAGE = 0, ALIGN(4)

#ifdef __TI_COMPILER_VERSION
   #if __TI_COMPILER_VERSION >= 15009000
    .TI.ramfunc : {} LOAD = APP_PROG_FLASH,
                         RUN = CPU_PROG_RAM,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsLoadSize),
                         LOAD_END(_RamfuncsLoadEnd),
                         RUN_START(_RamfuncsRunStart),
                         RUN_SIZE(_RamfuncsRunSize),
                         RUN_END(_RamfuncsRunEnd),
                         PAGE = 0, ALIGN(4)
   #endif
#endif
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/

