/*
 * spi_test_v1.c
 *
 *  Created on: Nov 20, 2023
 *      Author: nerod
 */

#include "driverlib.h"
#include "device.h"
#include "board.h"
#include <stdio.h>

// Ҫͷļ
#define MAX_DAC_VALUE 4095  // DAC12λ
#define MIN_DAC_VALUE 0


//__interrupt void sciaTXFIFOISR(void);
//__interrupt void sciaRXFIFOISR(void);
uint16_t adcResult;
float temperature;
void SPI_GPIO_Init();
void spi_init();
void spi_TX(uint16_t data);
uint16_t calculate_DAC_value(float voltage);
short read_current_temperature();
void initADC();
void initADCSOC();
void initEPWM();
__interrupt void adcA1ISR();
//void initSCI(void);
void SCISendData(const char *string);

// PI Controller Variables
volatile short tsvo_pg, tsvo_ig;    // Proportional Gain (PG) and Integral Gain (IG)
volatile short tsvo_setpoint, tsvo_err, tsvo_out;
volatile long tsvo_acc, tsvo_mem;

void spi_initController() {
    Device_init();
    Device_initGPIO();
    //initSCI(); // ʼSCI
    Interrupt_initModule(); //FOR TEST
    Interrupt_initVectorTable();//FOR TEST
    Interrupt_register(INT_ADCA1, &adcA1ISR);//FOR TEST

    initADC();
    initADCSOC(); // ʼADC
    initEPWM();   // ʼePWM

    ASysCtl_enableTemperatureSensor();//FOR TEST
    DEVICE_DELAY_US(500);//FOR TEST

    Interrupt_enable(INT_ADCA1);//FOR TEST

    EINT;
    ERTM;

    EPWM_enableADCTrigger(EPWM1_BASE, EPWM_SOC_A);//FOR TEST
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);//FOR TEST

    DINT;
    SPI_GPIO_Init();
    spi_init();

    // ʼPIĲ
    tsvo_pg = 2000;  // Proportional Gain
    tsvo_ig = 200;   // Integral Gain
    tsvo_mem = 0;    // Integral memory initialization

    float target_temperature = 60.0;  // Ŀ¶60C
    tsvo_setpoint = calculate_DAC_value(target_temperature);  // 趨
}


void spi_updateController() {
//        short read_current_temperature = 59;
        short currentTemperature = read_current_temperature();

        tsvo_err = tsvo_setpoint - read_current_temperature();
        tsvo_acc = tsvo_err * tsvo_pg;
        tsvo_acc += tsvo_mem;

        tsvo_out = tsvo_acc >> 16;
        if (tsvo_out > MAX_DAC_VALUE) tsvo_out = MAX_DAC_VALUE;
        if (tsvo_out < MIN_DAC_VALUE) tsvo_out = MIN_DAC_VALUE;

        spi_TX(tsvo_out);

        tsvo_mem += tsvo_err * tsvo_ig;

        // ӡǰ¶
        char tempStr[32];
//        sprintf(tempStr, "Current Temp: %d\r\n", currentTemperature);
        sprintf(tempStr, "Temperature: %d\r\n", currentTemperature);
//        sprintf(tempStr, "Temperature: 60\r\n");
        SCISendData(tempStr);
        //SCISendData("Hello World\r\n");
        // SCIջ
        //if(SCI_getRxFIFOStatus(SCIA_BASE) > SCI_FIFO_RX0) {
            //char receivedChar = SCI_readCharNonBlocking(SCIA_BASE);
            // յַ
            // 磺Խյַ
            //char echoStr[2] = {receivedChar, '\0'};
                //SCISendData(echoStr);
                //}
        DEVICE_DELAY_US(40000);
    }

void SPI_GPIO_Init() {
    // GPIOô뱣ֲ
}

void spi_init() {
    // SPIô뱣ֲ
}

void spi_TX(uint16_t data) {
    // SPIʹ뱣ֲ
}

uint16_t calculate_DAC_value(float voltage) {
    float maxVoltage = 3.7; // ѹΪ3.7

    // ȷѹΧ
    if (voltage < 0) {
        voltage = 0;
    } else if (voltage > maxVoltage) {
        voltage = maxVoltage;
    }

    // ѹֵӳ䵽DACֵ
    uint16_t dacValue = (uint16_t)((voltage / maxVoltage) * MAX_DAC_VALUE);

    return dacValue;
}


short read_current_temperature() {
    // ADCת
    ADC_forceSOC(ADCA_BASE, ADC_SOC_NUMBER0);
    SCISendData("5.ADC conversion triggered\r\n");
    // ȴת
    while(ADC_getInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1) == false) {
    }
    SCISendData("6.ADC conversion complete\r\n");
    // ȡADCת
    adcResult = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
    char adcResultStr[50];
    sprintf(adcResultStr, "ADC Result: %d\r\n", adcResult);
    SCISendData(adcResultStr);
    // ADCתΪ¶ֵ
    temperature = ADC_getTemperatureC(adcResult, 3.0f);

    // ¶ֵתΪDACֵ
    return calculate_DAC_value(temperature);
}


void initADC()
{
//    SCISendData("1Starting ADC initialization\r\n");
    //
    // Set ADCDLK divider to /4
    //
    ADC_setPrescaler(ADCA_BASE, ADC_CLK_DIV_4_0);

    //
    // Set resolution and signal mode (see #defines above) and load
    // corresponding trims.
    //
    ADC_setMode(ADCA_BASE, ADC_RESOLUTION_12BIT, ADC_MODE_SINGLE_ENDED);

    //
    // Set pulse positions to late
    //
    ADC_setInterruptPulseMode(ADCA_BASE, ADC_PULSE_END_OF_CONV);

    //
    // Power up the ADC and then delay for 1 ms
    //
    ADC_enableConverter(ADCA_BASE);
    DEVICE_DELAY_US(1000);
    SCISendData("1.ADC initialization complete\r\n");
}


void initADCSOC() {
//    SCISendData("3Starting ADC SOC initialization\r\n");
    // ADC SOCô
    // adc_ex3_temp_sensor.cļиƶӦô
    ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN13, 140);
//    char message[100];
//    sprintf(message, "ADC_SOC_NUMBER0: %d, ADC_TRIGGER_EPWM1_SOCA: %d, ADC_CH_ADCIN13: %d\r\n", ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN13);
//    SCISendData(message);
//    SCISendData("ADC SOC setup complete\r\n");
    ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER0);
//    SCISendData("ADC interrupt source set\r\n");
    ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);
//    SCISendData("ADC interrupt enabled\r\n");
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
//    SCISendData("ADC interrupt status cleared\r\n");

    SCISendData("2.ADC SOC initialization complete\r\n");
}



void initEPWM() {
    // ePWMʼ
    // adc_ex3_temp_sensor.cļиƶӦô
    EPWM_disableADCTrigger(EPWM1_BASE, EPWM_SOC_A);
    EPWM_setADCTriggerSource(EPWM1_BASE, EPWM_SOC_A, EPWM_SOC_TBCTR_U_CMPA);
    EPWM_setADCTriggerEventPrescale(EPWM1_BASE, EPWM_SOC_A, 1);
    EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 1000);
    EPWM_setTimeBasePeriod(EPWM1_BASE, 1999);
    EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
    EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_STOP_FREEZE);
    SCISendData("3.EPWM initialization complete\r\n");
}

__interrupt void adcA1ISR()
{
    //
    // Read the raw result
    //
    SCISendData("ADC ISR triggered\r\n");
    adcResult = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);

    //
    // Convert the result to a temperature in degrees C
    //
    temperature = ADC_getTemperatureC(adcResult, 3.0f);

    //
    // Clear the interrupt flag
    //
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);

    //
    // Check if overflow has occurred
    //
    if(true == ADC_getInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1))
    {
        ADC_clearInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1);
        ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
    }

    //
    // Acknowledge the interrupt
    //
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);
}


void SCISendData(const char *string) {
    // ʹFIFO
    while (*string != '\0') {
        SCI_writeCharBlockingFIFO(SCIA_BASE, *string++);
    }
}





