# TMS320F28379D-GPIO

TMS320F28379D将GPIO分为Port A、B、C、D、E、F，具体分配如下表所示。

| 分组名称 | GPIO端口        |
| -------- | --------------- |
| Port A   | GPIO0-GPIO31    |
| Port B   | GPIO32-GPIO63   |
| Port C   | GPIO64-GPIO95   |
| Port D   | GPIO96-GPIO127  |
| Port E   | GPIO128-GPIO159 |
| Port F   | GPIO160-GPIO168 |

具体的GPIO结构框图如下图所示：

![image-20230616212425697](GPIO.assets/image-20230616212425697.png)

1. 规划设备引脚列出应用程序所需的所有外围设备
   使用设备数据手册中的外设多路复用信息，选择外设信号使用的GPIO。决定剩余的哪个GPIO用作每个CPU和CLA的输入和输出。一旦选择了外设复用，就应该通过将适当的值写入GPyGMUX1/2和GPyGMUX1/2寄存器来实现。当更改引脚的GPyGMUX值时，总是首先将相应的GPyMUX位设置为零，以避免互斥器出现故障。默认情况下，所有引脚都是通用I/O。不是外围信号。
2. (可选)使能内部上拉电阻
   要启用或禁用上拉电阻，请写入GPIO上拉禁用寄存器(GPyPUD)中的相应位。默认情况下，所有的下拉都是禁用的。当没有外部信号驱动时，拉接可用于保持输入引脚处于已知状态。
3. 选择输入条件
   如果引脚将用作输入，则指定所需的输入资格(如果有的话)。在GPyCTRL寄存器中选择输入限定采样周期，而在GPyQSEL1和GPyQSEL2寄存器中选择限定类型。缺省情况下，所有限定同步，采样周期为PLLSYSCLK。
4. 选择任意通用I/O引脚的方向
   对于配置为GPIO的每个引脚，使用GPyDIR寄存器指定引脚的输入或输出方向。缺省情况下，所有GPIO引脚都是输入。在将引脚更改为输出之前，通过将该值写入GPySET, GPyCLEAR或GPyDATl寄存器来加载要驱动的值的输出锁存器。加载锁存器后，写入GPyDIR以改变引脚方向。默认情况下，所有输出锁存为零。
5. 选择低功耗模式唤醒源
6. 选择外部中断源
   配置外部中断是一个两步过程。首先，必须启用中断本身，并且必须通过XINTnCR寄存器配置它们的极性。其次，必须通过分别选择输入X-BAR信号4、5、6、13和14的源来设置XINT1-5 GPIO引脚。有关输入X-BAR体系结构的更多信息，请参阅本手册的交叉栏(XBAR)章节。

## 通过LED灯实验验证GPIO的配置

![image-20230616224638781](GPIO.assets/image-20230616224638781.png)

