#ifndef GLOBALVARIABLES_H_
#define GLOBALVARIABLES_H_

/* C2000 Clocking
 *
 * XTAL_OSC: LaunchPad: 10MHz
 *           ControlCard: 20MHz
 *
 * PLLSYSCLK = (XTAL_OSC) * (IMULT + FMULT) / (PLLSYSCLKDIV)
 *     Default setup in F2837xD_SysCtrl.c: InitSysPll(XTAL_OSC, IMULT_20, FMULT_0, PLLCLK_BY_2);
 *
 *     LaunchPad: 10MHz * 20 / 2 = 100MHz
 *     ControlCard: 20MHz * 20 / 2 = 200MHz
 *
 * EPWMCLK = PLLSYSCLK/2
 *     LaunchPad: 100MHz/2 = 50MHz
 *     ControlCard: 200MHz/2 = 100MHz
 *
 * EPWM_TBPRD = EPWMCLK/(2*EPWM_FREQUENCY)
 *
 * Example: EPWM_TBPRD = 100kHz
 *     LaunchPad: EPWM_TBPRD = 50e6/(2*100e3) = 250
 *     ControlCard: EPWM_TBPRD = 100e6/(2*100e3) = 500
 *
 * Note: can remove discrepancy between TBPRD numbers for ControlCard and LaunchPad by setting EPWMCLKDIV in main.c
 */

// calculations for 4-Level converter switching at 100 kHz

#define EPWM_TBPRD 501 // calculation for control card (close to 100 kHz calculation, adjusted to make divisible by 3)

#define EPWM_CMP_INIT (EPWM_TBPRD/2)       // initialize with 50% duty ratio
#define EPWM_DEADTIME 5                    // deadtime in EPWMCLK ticks

#define TBCTR_INIT_1 0               // unused for 4 Level
#define TBCTR_INIT_2 0               // unused for 4 Level
#define TBCTR_INIT_3 0               // unused for 4 Level
#define TBCTR_INIT_4 0               // unused for 4 Level
#define TBCTR_INIT_5 0               // unused for 4 Level
#define TBCTR_INIT_6 0               // unused for 4 Level
#define TBCTR_INIT_7 0               // unused for 4 Level
#define TBCTR_INIT_8 0               // unused for 4 Level
#define TBCTR_INIT_9  0   // counter 3 starts at 1/3 of period, counting down
#define TBCTR_INIT_10 ((2*EPWM_TBPRD)/3) // counter 2 starts at 1/3 of period, counting up
#define TBCTR_INIT_11 ((2*EPWM_TBPRD)/3) // counter 1 starts at peak, counting down

#define DIR_1 0  // unused for 4 Level
#define DIR_2 0  // unused for 4 Level
#define DIR_3 0  // unused for 4 Level
#define DIR_4 0  // unused for 4 Level
#define DIR_5 0  // unused for 4 Level
#define DIR_6 0  // unused for 4 Level
#define DIR_7 0  // unused for 4 Level
#define DIR_8 0  // unused for 4 Level
#define DIR_9 1  // 4 Level #3 carrier (s3), starts counting up
#define DIR_10 0 // 4 Level #2 carrier (s2), starts counting down
#define DIR_11 1 // 4 Level #1 carrier (s1), starts counting up


#define DUTY_MAX 0.95f
#define DUTY_MIN 0.05f

#define DUTY_INIT 0.5f

#define ADCACQ_12Bit 14

#endif /* GLOBALVARIABLES_H_ */
