/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM5 -> TimerMSG Pinmux
//
//
// EPWM5A - GPIO Settings
//
#define GPIO_PIN_EPWM5A 153
#define TimerMSG_EPWMA_GPIO 153
#define TimerMSG_EPWMA_PIN_CONFIG GPIO_153_EPWM5A
//
// EPWM5B - GPIO Settings
//
#define GPIO_PIN_EPWM5B 154
#define TimerMSG_EPWMB_GPIO 154
#define TimerMSG_EPWMB_PIN_CONFIG GPIO_154_EPWM5B

//
// EPWM4 -> TimerLED Pinmux
//
//
// EPWM4A - GPIO Settings
//
#define GPIO_PIN_EPWM4A 151
#define TimerLED_EPWMA_GPIO 151
#define TimerLED_EPWMA_PIN_CONFIG GPIO_151_EPWM4A
//
// EPWM4B - GPIO Settings
//
#define GPIO_PIN_EPWM4B 152
#define TimerLED_EPWMB_GPIO 152
#define TimerLED_EPWMB_PIN_CONFIG GPIO_152_EPWM4B
//
// GPIO31 - GPIO Settings
//
#define CPU1_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31
//
// GPIO34 - GPIO Settings
//
#define CPU2_LED_GPIO_PIN_CONFIG GPIO_34_GPIO34
//
// GPIO32 - GPIO Settings
//
#define CPU1_DEBUG2_GPIO_PIN_CONFIG GPIO_32_GPIO32
//
// GPIO67 - GPIO Settings
//
#define CPU2_DEBUG5_GPIO_PIN_CONFIG GPIO_67_GPIO67
//
// GPIO95 - GPIO Settings
//
#define CPU1_BUTTON_GPIO_PIN_CONFIG GPIO_95_GPIO95

//
// CANA -> myCAN0 Pinmux
//
//
// CANRXA - GPIO Settings
//
#define GPIO_PIN_CANRXA 18
#define myCAN0_CANRX_GPIO 18
#define myCAN0_CANRX_PIN_CONFIG GPIO_18_CANRXA
//
// CANTXA - GPIO Settings
//
#define GPIO_PIN_CANTXA 19
#define myCAN0_CANTX_GPIO 19
#define myCAN0_CANTX_PIN_CONFIG GPIO_19_CANTXA

//*****************************************************************************
//
// CPUTIMER Configurations
//
//*****************************************************************************
#define myCPUTIMER0_BASE CPUTIMER0_BASE
void myCPUTIMER0_init();

//*****************************************************************************
//
// DAC Configurations
//
//*****************************************************************************
#define DACB_DEBUG_BASE DACB_BASE
void DACB_DEBUG_init();

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define TimerMSG_BASE EPWM5_BASE
#define TimerMSG_TBPRD 65535
#define TimerMSG_COUNTER_MODE EPWM_COUNTER_MODE_STOP_FREEZE
#define TimerMSG_TBPHS 0
#define TimerMSG_CMPA 0
#define TimerMSG_CMPB 0
#define TimerMSG_CMPC 0
#define TimerMSG_CMPD 0
#define TimerMSG_DBRED 0
#define TimerMSG_DBFED 0
#define TimerMSG_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define TimerMSG_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define TimerMSG_INTERRUPT_SOURCE EPWM_INT_TBCTR_PERIOD
#define TimerLED_BASE EPWM4_BASE
#define TimerLED_TBPRD 65104
#define TimerLED_COUNTER_MODE EPWM_COUNTER_MODE_UP
#define TimerLED_TBPHS 0
#define TimerLED_CMPA 0
#define TimerLED_CMPB 0
#define TimerLED_CMPC 0
#define TimerLED_CMPD 0
#define TimerLED_DBRED 0
#define TimerLED_DBFED 0
#define TimerLED_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define TimerLED_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define TimerLED_INTERRUPT_SOURCE EPWM_INT_TBCTR_PERIOD

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define CPU1_LED 31
void CPU1_LED_init();
#define CPU2_LED 34
void CPU2_LED_init();
#define CPU1_DEBUG2 32
void CPU1_DEBUG2_init();
#define CPU2_DEBUG5 67
void CPU2_DEBUG5_init();
#define CPU1_BUTTON 95
void CPU1_BUTTON_init();

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for INT_myCPUTIMER0
#define INT_myCPUTIMER0 INT_TIMER0
#define INT_myCPUTIMER0_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void INT_myCPUTIMER0_ISR(void);

// Interrupt Settings for INT_TimerMSG
#define INT_TimerMSG INT_EPWM5
#define INT_TimerMSG_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP3
extern __interrupt void INT_TimerMSG_ISR(void);

// Interrupt Settings for INT_TimerLED
#define INT_TimerLED INT_EPWM4
#define INT_TimerLED_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP3
extern __interrupt void INT_TimerLED_ISR(void);

// Interrupt Settings for IPC_1
#define IPC_1 INT_IPC_1
#define IPC_1_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_1_ISR(void);

// Interrupt Settings for IPC_3
#define IPC_3 INT_IPC_3
#define IPC_3_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_3_ISR(void);

//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
#define CPU1_to_CPU2_IPC_FLAG0 IPC_FLAG0
#define CPU1_to_CPU2_IPC_FLAG2 IPC_FLAG2
#define IPC_SYNC IPC_FLAG31
#define CPU2_to_CPU1_IPC_FLAG1 IPC_FLAG1
#define CPU2_to_CPU1_IPC_FLAG3 IPC_FLAG3
#define IPC_SYNC IPC_FLAG31
#define BOOT_MODE_CPU2 C1C2_BROM_BOOTMODE_BOOT_FROM_FLASH

//*****************************************************************************
//
// MEMCFG Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	CPUTIMER_init();
void	DAC_init();
void	EPWM_init();
void	GPIO_init();
void	INTERRUPT_init();
void	IPC_SYSCFG_init();
void	MEMCFG_init();
void	SYNC_init();
void	PinMux_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
