//#############################################################################
//
// FILE:   led_ex2_sysconfig_cpu1.c
//
// TITLE: SysConfig LED Blinky Example
//
//! \addtogroup driver_dual_example_list
//! <h1> LED Blinky Example</h1>
//!
//! This example demonstrates how to blink a LED using CPU1 and blink another
//! LED using CPU2 (led_ex1_blinky_cpu2.c).
//!
//! \b External \b Connections \n
//!  - None.
//!
//! \b Watch \b Variables \n
//!  - None.
//!
//
//#############################################################################
//
// 
// $Copyright:
// Copyright (C) 2013-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################


/* -----------------------------------------------------------------------------
 *
 * C2000Ware: v5.02
 * SysConfig: v1.17
 * Compatible BitField: OK
 *
 * Mise en route mode DEBUG:
 * - Mettre entre commentaire la macro _STANDALONE
 * - Choisir active la config RAM ou FLASH pour le projet _multi
 * - Lancer le projet _multi en mode DEBUG
 * - Run le projet _cpu1
 * - Run le projet _cpu2
 *
 * Mise en route mode STANDALONE
 * - Ne pas mettre entre commentaire la macro _STANDALONE
 * - Choisir active la config FLASH pour le projet _multi
 * - Charger le programme du projet _multi
 * - dconnecter la sonde JTAG (LAUNCHPAD: positionner dipswitch3 vers le bas, OFF)
 *
 * -----------------------------------------------------------------------------
 */



//
// Included Files
//


#include "F28x_Project.h"
#include "driverlib.h"
#include "device.h"
#include "board.h"
#include "c2000ware_libraries.h"




// TYPES STANDARDS A UTILISER (CPU)
// ==================================

/*
    int16_t
    int32_t
    int64_t
    uint16_t
    uint32_t
    uint64_t
    float32_t
    float64_t

*/


//
// Defines
//




// Mode STANDALONE:
// ----------------
// fonctionnement du double coeur sans connexion JTAG (dconnexion sonde puis reset)
// Configuration FLASH seulement (RAM suppose un programme dans la RAM de CPU2 aprs reset)
// mise en oeuvre: enlever les commentaires de #define _STANDALONE
//
#define _STANDALONE




// Fonctions Interruptions
// -----------------------
__interrupt void INT_TimerMSG_ISR(void);
__interrupt void INT_myCPUTIMER0_ISR(void);
__interrupt void IPC_1_ISR(void);
__interrupt void IPC_3_ISR(void);
__interrupt void INT_TimerLED_ISR(void);


//
// Main
//
void main(void)
{


    //
    // Initialize device clock and peripherals
    //
    Device_init();
    SysCtl_setEPWMClockDivider(SYSCTL_EPWMCLK_DIV_2);                           // non gnr par SYSCONFIG dans clocktree.h, non inclus dans Device_init();

    // MODE STANDALONE
    // ---------------
    // le STANDALONE sur la RAM (saut en 0x0000) est prvu mais inutile
    // le CPU1 donne l'ordre de boot au CPU2 et attend le positionnement du Flag de communication 31
    // le CPU1 ne fait pas l'acknolowdge de ce flag
    // --> soit aknowledge manuel
    // --> soit placement de cette fonction avant Interrupt_initModule(); qui reset tous les Flags

#ifdef _STANDALONE
#ifdef _FLASH
    //
    // Send boot command to allow the CPU2 application to begin execution
    //
    Device_bootCPU2(C1C2_BROM_BOOTMODE_BOOT_FROM_FLASH);
#else
    //
    // Send boot command to allow the CPU2 application to begin execution
    //
    Device_bootCPU2(C1C2_BROM_BOOTMODE_BOOT_FROM_RAM);

#endif // _FLASH
#endif // _STANDALONE

    //
    // Initialize GPIO and configure the GPIO pin as a push-pull output
    //
    Device_initGPIO();

    //
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    //
    Interrupt_initModule();

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    //
    Interrupt_initVectorTable();

    //
    // Initialize SysConfig Configuration
    //
    Board_init();

    //
    // Selection des CPU pour les modules priphriques utiliss (non gr par SysConfig)
    //
    SysCtl_selectCPUForPeripheral(SYSCTL_CPUSEL8_CAN,1, SYSCTL_CPUSEL_CPU2);
    SysCtl_selectCPUForPeripheral(SYSCTL_CPUSEL8_CAN,2, SYSCTL_CPUSEL_CPU2);
    SysCtl_selectCPUForPeripheral(SYSCTL_CPUSEL0_EPWM,8, SYSCTL_CPUSEL_CPU2);
    SysCtl_selectCPUForPeripheral(SYSCTL_CPUSEL0_EPWM,7, SYSCTL_CPUSEL_CPU2);


    // Note: quivalent aux lignes ci-dessous:
    /*
        EALLOW;
        DevCfgRegs.CPUSEL8.bit.CAN_A=1;
        DevCfgRegs.CPUSEL8.bit.CAN_B=1;
        DevCfgRegs.CPUSEL0.bit.EPWM8=1;
        EDIS;
    */



    //
    // Sync CPUs so the blinking starts at the same time, though the LEDs toggle at different frequency
    //
    IPC_sync(IPC_CPU1_L_CPU2_R, IPC_SYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;


    // INITIALISATIONS UTILISATEUR
    // =============================

    // Initialisation Timer Messages
    // -----------------------------------
    EPWM_setTimeBasePeriod(TimerMSG_BASE, 65000);                                       // 39062 Interruption quand gal  priode (Timer=500ms)
    EPWM_setTimeBaseCounter(TimerMSG_BASE, 0);
    EPWM_setTimeBaseCounterMode(TimerMSG_BASE, EPWM_COUNTER_MODE_UP);







    while(1)
    {
        DEVICE_DELAY_US(500000);


    }





    //
    // Loop Forever
    //



}


/* ===================================================================================================================================================
 *
 * Interruptions TimerMSG: Envoi message  CPU2 pour CANB
 * Positionne l'Event TMR_MSG dfini par macro
 * L'interruption ne doit pas contenir l'attente d'acquittement IPC de la part de CPU2 attendu suite  un SET IPC qui gnre une interruption CPU2
 *
 * ===================================================================================================================================================
 */

__interrupt void INT_TimerMSG_ISR(void)
{



    // Gestion Interruption
    // --------------------
    EPWM_clearEventTriggerInterruptFlag(TimerMSG_BASE);
    Interrupt_clearACKGroup(INT_TimerMSG_INTERRUPT_ACK_GROUP);
}



/* ===================================================================================================
 *
 * Interruptions Timer CPU 0 (non utilis)
 *
 * ===================================================================================================
 */
__interrupt void INT_myCPUTIMER0_ISR(void)
{
    CPUTimer_reloadTimerCounter(myCPUTIMER0_BASE);
    CPUTimer_clearOverflowFlag(myCPUTIMER0_BASE);
    Interrupt_clearACKGroup(INT_myCPUTIMER0_INTERRUPT_ACK_GROUP);
}






/* ============================================================================================
 * ISR Flag1 CPU2 --> CPU1
 * Flag positionn par CPU1 aprs avoir rempli les tableaux de message CANB.X1
 *
 * Note: Nesting impossible --> il est impossible de vidanger les FIFO pendant ce remplissage
 * =========================================================================================== */

__interrupt void IPC_1_ISR(void)
{

    IpcRegs.IPCACK.bit.IPC1=1;

    // Acquittement du groupe
    // ----------------------
    Interrupt_clearACKGroup(IPC_1_INTERRUPT_ACK_GROUP);
}


/* ============================================================================================
 * ISR Flag3 CPU2 --> CPU1
 * Flag positionn par CPU2 aprs avoir rempli les tableaux de message CANA.RX1
 *
 * Note: Nesting impossible --> il est impossible de vidanger les FIFO pendant ce remplissage
 * =========================================================================================== */

__interrupt void IPC_3_ISR(void)
{


    //IPC_ackFlagRtoL(IPC_CPU1_L_CPU2_R, IPC_3);        // Local = CPU1 Remote=CPU2
    IpcRegs.IPCACK.bit.IPC3=1;

    // Acquittement du groupe
    // ----------------------
    Interrupt_clearACKGroup(IPC_3_INTERRUPT_ACK_GROUP);
}


/* ============================================================================================
 * ISR Timer LED
 * Clignotement de la LED tmoin
 *
 *
 * =========================================================================================== */

__interrupt void INT_TimerLED_ISR(void)
{

    GPIO_togglePin(DEVICE_GPIO_PIN_LED1);
    EPWM_clearEventTriggerInterruptFlag(TimerLED_BASE);
    Interrupt_clearACKGroup(INT_TimerLED_INTERRUPT_ACK_GROUP);

}












//
// End of File
//

