/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM5 -> TimerMSG Pinmux
//
//
// EPWM5A - GPIO Settings
//
#define GPIO_PIN_EPWM5A 153
#define TimerMSG_EPWMA_GPIO 153
#define TimerMSG_EPWMA_PIN_CONFIG GPIO_153_EPWM5A
//
// EPWM5B - GPIO Settings
//
#define GPIO_PIN_EPWM5B 154
#define TimerMSG_EPWMB_GPIO 154
#define TimerMSG_EPWMB_PIN_CONFIG GPIO_154_EPWM5B

//
// EPWM4 -> TimerLED Pinmux
//
//
// EPWM4A - GPIO Settings
//
#define GPIO_PIN_EPWM4A 151
#define TimerLED_EPWMA_GPIO 151
#define TimerLED_EPWMA_PIN_CONFIG GPIO_151_EPWM4A
//
// EPWM4B - GPIO Settings
//
#define GPIO_PIN_EPWM4B 152
#define TimerLED_EPWMB_GPIO 152
#define TimerLED_EPWMB_PIN_CONFIG GPIO_152_EPWM4B
//
// GPIO31 - GPIO Settings
//
#define CPU1_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31
//
// GPIO34 - GPIO Settings
//
#define CPU2_LED_GPIO_PIN_CONFIG GPIO_34_GPIO34
//
// GPIO32 - GPIO Settings
//
#define CPU1_DEBUG2_GPIO_PIN_CONFIG GPIO_32_GPIO32
//
// GPIO67 - GPIO Settings
//
#define CPU2_DEBUG5_GPIO_PIN_CONFIG GPIO_67_GPIO67
//
// GPIO95 - GPIO Settings
//
#define CPU1_BUTTON_GPIO_PIN_CONFIG GPIO_95_GPIO95

//
// CANA -> myCAN0 Pinmux
//
//
// CANRXA - GPIO Settings
//
#define GPIO_PIN_CANRXA 18
#define myCAN0_CANRX_GPIO 18
#define myCAN0_CANRX_PIN_CONFIG GPIO_18_CANRXA
//
// CANTXA - GPIO Settings
//
#define GPIO_PIN_CANTXA 19
#define myCAN0_CANTX_GPIO 19
#define myCAN0_CANTX_PIN_CONFIG GPIO_19_CANTXA

//*****************************************************************************
//
// CAN Configurations
//
//*****************************************************************************
#define myCAN0_BASE CANA_BASE

void myCAN0_init();


//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for IPC_0
#define IPC_0 INT_IPC_0
#define IPC_0_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_0_ISR(void);

// Interrupt Settings for IPC_2
#define IPC_2 INT_IPC_2
#define IPC_2_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_2_ISR(void);

//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
#define CPU1_to_CPU2_IPC_FLAG0 IPC_FLAG0
#define CPU1_to_CPU2_IPC_FLAG2 IPC_FLAG2
#define IPC_SYNC IPC_FLAG31
#define CPU2_to_CPU1_IPC_FLAG1 IPC_FLAG1
#define CPU2_to_CPU1_IPC_FLAG3 IPC_FLAG3
#define IPC_SYNC IPC_FLAG31

//*****************************************************************************
//
// MEMCFG Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define CPU1_LED 31
#define CPU2_LED 34
#define CPU1_DEBUG2 32
#define CPU2_DEBUG5 67
#define CPU1_BUTTON 95

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	CAN_init();
void	INTERRUPT_init();
void	IPC_SYSCFG_init();
void	MEMCFG_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
