/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM5 -> TimerMSG Pinmux
//
//
// EPWM5A - GPIO Settings
//
#define GPIO_PIN_EPWM5A 153
#define TimerMSG_EPWMA_GPIO 153
#define TimerMSG_EPWMA_PIN_CONFIG GPIO_153_EPWM5A
//
// EPWM5B - GPIO Settings
//
#define GPIO_PIN_EPWM5B 154
#define TimerMSG_EPWMB_GPIO 154
#define TimerMSG_EPWMB_PIN_CONFIG GPIO_154_EPWM5B

//
// EPWM4 -> TimerLED Pinmux
//
//
// EPWM4A - GPIO Settings
//
#define GPIO_PIN_EPWM4A 151
#define TimerLED_EPWMA_GPIO 151
#define TimerLED_EPWMA_PIN_CONFIG GPIO_151_EPWM4A
//
// EPWM4B - GPIO Settings
//
#define GPIO_PIN_EPWM4B 152
#define TimerLED_EPWMB_GPIO 152
#define TimerLED_EPWMB_PIN_CONFIG GPIO_152_EPWM4B

//
// EPWM1 -> PWM_LE Pinmux
//
//
// EPWM1A - GPIO Settings
//
#define GPIO_PIN_EPWM1A 0
#define PWM_LE_EPWMA_GPIO 0
#define PWM_LE_EPWMA_PIN_CONFIG GPIO_0_EPWM1A
//
// EPWM1B - GPIO Settings
//
#define GPIO_PIN_EPWM1B 1
#define PWM_LE_EPWMB_GPIO 1
#define PWM_LE_EPWMB_PIN_CONFIG GPIO_1_EPWM1B

//
// EPWM2 -> PWM_LA Pinmux
//
//
// EPWM2A - GPIO Settings
//
#define GPIO_PIN_EPWM2A 2
#define PWM_LA_EPWMA_GPIO 2
#define PWM_LA_EPWMA_PIN_CONFIG GPIO_2_EPWM2A
//
// EPWM2B - GPIO Settings
//
#define GPIO_PIN_EPWM2B 3
#define PWM_LA_EPWMB_GPIO 3
#define PWM_LA_EPWMB_PIN_CONFIG GPIO_3_EPWM2B

//
// EPWM6 -> TimerADC Pinmux
//
//
// EPWM6A - GPIO Settings
//
#define GPIO_PIN_EPWM6A 10
#define TimerADC_EPWMA_GPIO 10
#define TimerADC_EPWMA_PIN_CONFIG GPIO_10_EPWM6A
//
// EPWM6B - GPIO Settings
//
#define GPIO_PIN_EPWM6B 11
#define TimerADC_EPWMB_GPIO 11
#define TimerADC_EPWMB_PIN_CONFIG GPIO_11_EPWM6B
//
// GPIO31 - GPIO Settings
//
#define CPU1_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31
//
// GPIO34 - GPIO Settings
//
#define CPU2_LED_GPIO_PIN_CONFIG GPIO_34_GPIO34
//
// GPIO32 - GPIO Settings
//
#define CPU1_DEBUG2_GPIO_PIN_CONFIG GPIO_32_GPIO32
//
// GPIO67 - GPIO Settings
//
#define CPU2_DEBUG5_GPIO_PIN_CONFIG GPIO_67_GPIO67
//
// GPIO95 - GPIO Settings
//
#define CPU1_BUTTON_GPIO_PIN_CONFIG GPIO_95_GPIO95

//
// CANB -> CANB_DEBUG Pinmux
//
//
// CANRXB - GPIO Settings
//
#define GPIO_PIN_CANRXB 17
#define CANB_DEBUG_CANRX_GPIO 17
#define CANB_DEBUG_CANRX_PIN_CONFIG GPIO_17_CANRXB
//
// CANTXB - GPIO Settings
//
#define GPIO_PIN_CANTXB 12
#define CANB_DEBUG_CANTX_GPIO 12
#define CANB_DEBUG_CANTX_PIN_CONFIG GPIO_12_CANTXB

//
// CANA -> CANA_APP Pinmux
//
//
// CANRXA - GPIO Settings
//
#define GPIO_PIN_CANRXA 18
#define CANA_APP_CANRX_GPIO 18
#define CANA_APP_CANRX_PIN_CONFIG GPIO_18_CANRXA
//
// CANTXA - GPIO Settings
//
#define GPIO_PIN_CANTXA 19
#define CANA_APP_CANTX_GPIO 19
#define CANA_APP_CANTX_PIN_CONFIG GPIO_19_CANTXA

//
// EPWM8 -> EMPW_Timer1_CANTX Pinmux
//
//
// EPWM8A - GPIO Settings
//
#define GPIO_PIN_EPWM8A 14
#define EMPW_Timer1_CANTX_EPWMA_GPIO 14
#define EMPW_Timer1_CANTX_EPWMA_PIN_CONFIG GPIO_14_EPWM8A
//
// EPWM8B - GPIO Settings
//
#define GPIO_PIN_EPWM8B 15
#define EMPW_Timer1_CANTX_EPWMB_GPIO 15
#define EMPW_Timer1_CANTX_EPWMB_PIN_CONFIG GPIO_15_EPWM8B

//
// EPWM7 -> EMPW_Timer2_CANTX Pinmux
//
//
// EPWM7A - GPIO Settings
//
#define GPIO_PIN_EPWM7A 157
#define EMPW_Timer2_CANTX_EPWMA_GPIO 157
#define EMPW_Timer2_CANTX_EPWMA_PIN_CONFIG GPIO_157_EPWM7A
//
// EPWM7B - GPIO Settings
//
#define GPIO_PIN_EPWM7B 13
#define EMPW_Timer2_CANTX_EPWMB_GPIO 13
#define EMPW_Timer2_CANTX_EPWMB_PIN_CONFIG GPIO_13_EPWM7B

//*****************************************************************************
//
// CAN Configurations
//
//*****************************************************************************
#define CANB_DEBUG_BASE CANB_BASE

#define CANB_DEBUG_MessageObj1_ID 256
#define CANB_DEBUG_MessageObj2_ID 768
#define CANB_DEBUG_MessageObj11_ID 512
void CANB_DEBUG_init();

#define CANA_APP_BASE CANA_BASE

#define CANA_APP_MessageObj1_ID 256
#define CANA_APP_MessageObj11_ID 775
#define CANA_APP_MessageObj12_ID 519
void CANA_APP_init();


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define EMPW_Timer1_CANTX_BASE EPWM8_BASE
#define EMPW_Timer1_CANTX_TBPRD 11161
#define EMPW_Timer1_CANTX_COUNTER_MODE EPWM_COUNTER_MODE_UP
#define EMPW_Timer1_CANTX_TBPHS 0
#define EMPW_Timer1_CANTX_CMPA 0
#define EMPW_Timer1_CANTX_CMPB 0
#define EMPW_Timer1_CANTX_CMPC 0
#define EMPW_Timer1_CANTX_CMPD 0
#define EMPW_Timer1_CANTX_DBRED 0
#define EMPW_Timer1_CANTX_DBFED 0
#define EMPW_Timer1_CANTX_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EMPW_Timer1_CANTX_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EMPW_Timer1_CANTX_INTERRUPT_SOURCE EPWM_INT_TBCTR_PERIOD
#define EMPW_Timer2_CANTX_BASE EPWM7_BASE
#define EMPW_Timer2_CANTX_TBPRD 11161
#define EMPW_Timer2_CANTX_COUNTER_MODE EPWM_COUNTER_MODE_UP
#define EMPW_Timer2_CANTX_TBPHS 0
#define EMPW_Timer2_CANTX_CMPA 0
#define EMPW_Timer2_CANTX_CMPB 0
#define EMPW_Timer2_CANTX_CMPC 0
#define EMPW_Timer2_CANTX_CMPD 0
#define EMPW_Timer2_CANTX_DBRED 0
#define EMPW_Timer2_CANTX_DBFED 0
#define EMPW_Timer2_CANTX_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EMPW_Timer2_CANTX_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define EMPW_Timer2_CANTX_INTERRUPT_SOURCE EPWM_INT_TBCTR_PERIOD

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for INT_CANB_DEBUG_0
#define INT_CANB_DEBUG_0 INT_CANB0
#define INT_CANB_DEBUG_0_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP9
extern __interrupt void INT_CANB_DEBUG_0_ISR(void);

// Interrupt Settings for INT_CANB_DEBUG_1
#define INT_CANB_DEBUG_1 INT_CANB1
#define INT_CANB_DEBUG_1_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP9
extern __interrupt void INT_CANB_DEBUG_1_ISR(void);

// Interrupt Settings for INT_CANA_APP_0
#define INT_CANA_APP_0 INT_CANA0
#define INT_CANA_APP_0_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP9
extern __interrupt void INT_CANA_APP_0_ISR(void);

// Interrupt Settings for INT_CANA_APP_1
#define INT_CANA_APP_1 INT_CANA1
#define INT_CANA_APP_1_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP9
extern __interrupt void INT_CANA_APP_1_ISR(void);

// Interrupt Settings for INT_EMPW_Timer1_CANTX
#define INT_EMPW_Timer1_CANTX INT_EPWM8
#define INT_EMPW_Timer1_CANTX_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP3
extern __interrupt void INT_EMPW_Timer1_CANTX_ISR(void);

// Interrupt Settings for INT_EMPW_Timer2_CANTX
#define INT_EMPW_Timer2_CANTX INT_EPWM7
#define INT_EMPW_Timer2_CANTX_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP3
extern __interrupt void INT_EMPW_Timer2_CANTX_ISR(void);

// Interrupt Settings for IPC_0
#define IPC_0 INT_IPC_0
#define IPC_0_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_0_ISR(void);

// Interrupt Settings for IPC_2
#define IPC_2 INT_IPC_2
#define IPC_2_INTERRUPT_ACK_GROUP INTERRUPT_ACK_GROUP1
extern __interrupt void IPC_2_ISR(void);

//*****************************************************************************
//
// IPC Configurations
//
//*****************************************************************************
#define CPU1_to_CPU2_IPC_FLAG0 IPC_FLAG0
#define CPU1_to_CPU2_IPC_FLAG2 IPC_FLAG2
#define IPC_SYNC IPC_FLAG31
#define CPU2_to_CPU1_IPC_FLAG1 IPC_FLAG1
#define CPU2_to_CPU1_IPC_FLAG3 IPC_FLAG3
#define IPC_SYNC IPC_FLAG31

//*****************************************************************************
//
// SYNC Scheme Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// GPIO Configurations
//
//*****************************************************************************
#define CPU1_LED 31
#define CPU2_LED 34
#define CPU1_DEBUG2 32
#define CPU2_DEBUG5 67
#define CPU1_BUTTON 95

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	CAN_init();
void	EPWM_init();
void	INTERRUPT_init();
void	IPC_SYSCFG_init();
void	SYNC_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
