//#############################################################################
//
// FILE:   led_ex2_sysconfig_cpu2.c
//
// TITLE: SysConfig LED Blinky Example
//
// <h1> LED Blinky Example (CPU2) </h1>
//
// This example demonstrates how to blink a LED using CPU2.
//
// \b External \b Connections \n
//  - None.
//
// \b Watch \b Variables \n
//  - None.
//
//
//#############################################################################
//
// 
// $Copyright:
// Copyright (C) 2013-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################




//
// Included Files

#include "F28x_Project.h"
#include "driverlib.h"
#include "device.h"
#include "board.h"
#include "c2000ware_libraries.h"






// Interruptions
// =============
__interrupt void IPC_0_ISR(void);                       // Rception messages de CPU1
__interrupt void IPC_2_ISR(void);







//
// Main
//
void main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();
    SysCtl_setEPWMClockDivider(SYSCTL_EPWMCLK_DIV_2);


    //
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    //
    Interrupt_initModule();

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    //
    Interrupt_initVectorTable();

    Board_init();


    // Rcupration de la vitesse initiale (valeur d'initialisation la priode du Timer)
    // ---------------------------------------------------------------------------------
    //uint16_CANBTX1TimerPER=EPWM_getTimeBasePeriod(EMPW_Timer1_CANTX_BASE);


    //
    // Sync CPUs so the blinking starts at the same time, though the LEDs toggle at different frequency
    //
    IPC_sync(IPC_CPU2_L_CPU1_R, IPC_SYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;



    //
    // Loop Forever
    //


    while(1)
    {
        //
        // Turn on LED
        //
        GPIO_writePin(DEVICE_GPIO_PIN_LED2, 1);

        //
        // Delay for a bit.
        //
        DEVICE_DELAY_US(500000);

        //
        // Turn off LED
        //
        GPIO_writePin(DEVICE_GPIO_PIN_LED2, 0);

        //
        // Delay for a bit.
        //
        DEVICE_DELAY_US(500000);
    }
}


/**********************************************************************************************************************************************************
 * *******************************************************************************************************************************************************
 *
 * CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB CANB
 *
 * * *****************************************************************************************************************************************************
 **********************************************************************************************************************************************************/


/* ============================================================================================
 * ISR Flag0 CPU1 --> CPU2
 * Flag positionn par CPU1 aprs avoir rempli les tableaux de message TX1
 *
 * Note: Nesting impossible --> il est impossible de vidanger les FIFO pendant ce remplissage
 * =========================================================================================== */

__interrupt void IPC_0_ISR(void)
{


    // Acquittement du Flag positionn par CPU1
    // ------------------------------------------
    //IPC_ackFlagRtoL(IPC_CPU2_L_CPU1_R, IPC_0);        // Local = CPU2 Remote=CPU1
    IpcRegs.IPCACK.bit.IPC0=1;

    // Acquittement du groupe
    // ----------------------
    Interrupt_clearACKGroup(IPC_0_INTERRUPT_ACK_GROUP);
}






/* ============================================================================================
 * ISR Flag2 CPU1 --> CPU2
 * Flag positionn par CPU1 aprs avoir rempli les tableaux de message TX1
 *
 * Note: Nesting impossible --> il est impossible de vidanger les FIFO pendant ce remplissage
 * =========================================================================================== */

__interrupt void IPC_2_ISR(void)
{

    // Acquittement du Flag positionn par CPU1
    // ------------------------------------------
    //IPC_ackFlagRtoL(IPC_CPU2_L_CPU1_R, IPC_2);        // Local = CPU2 Remote=CPU1
    IpcRegs.IPCACK.bit.IPC2=1;

    // Acquittement du groupe
    // ----------------------
    Interrupt_clearACKGroup(IPC_2_INTERRUPT_ACK_GROUP);
}







//
// End of File
//

