let ERAD_Owner = [
	{ name: "ERAD_OWNER_NOOWNER", displayName: "No owner" },
	{ name: "ERAD_OWNER_DEBUGGER", displayName: "Debugger owned" },
	{ name: "ERAD_OWNER_APPLICATION", displayName: "Application owned" },
]
let ERAD_Status = [
	{ name: "ERAD_STATE_IDLE", displayName: "Module is idle" },
	{ name: "ERAD_STATE_ENABLED", displayName: "Module is enabled" },
	{ name: "ERAD_STATE_COMPLETED", displayName: "Module was enabled and an event occurred" },
]
let ERAD_BusComp_Bus_Select = [
	{ name: "ERAD_BUSCOMP_BUS_PAB", displayName: "Use the Program Address Bus (PAB)" },
	{ name: "ERAD_BUSCOMP_BUS_DWAB", displayName: "Use the Data Write Address Bus (DWAB)" },
	{ name: "ERAD_BUSCOMP_BUS_DRAB_W", displayName: "Use the Data Read Address Bus (DRAB_W)" },
	{ name: "ERAD_BUSCOMP_BUS_DRAB1_W", displayName: "Use the Data Read Address Bus (DRAB1_W)" },
	{ name: "ERAD_BUSCOMP_BUS_DRAB2_W", displayName: "Use the Data Read Address Bus (DRAB2_W)" },
	{ name: "ERAD_BUSCOMP_BUS_DWDB", displayName: "Use the Data Write Data Bus (DWDB)" },
	{ name: "ERAD_BUSCOMP_BUS_DRDB", displayName: "Use the Data Read Data Bus (DRDB)" },
	{ name: "ERAD_BUSCOMP_BUS_DRDB1", displayName: "Use the Data Read Data Bus (DRDB1)" },
	{ name: "ERAD_BUSCOMP_BUS_DRDB2", displayName: "Use the Data Read Data Bus (DRDB2)" },
	{ name: "ERAD_BUSCOMP_BUS_VPC_I_ALIGNED", displayName: "Use VPC Instruction aligned match" },
	{ name: "ERAD_BUSCOMP_BUS_VPC_W_ALIGNED", displayName: "Use VPC Write aligned match" },
]
let ERAD_BusComp_Comp_Mode = [
	{ name: "ERAD_BUSCOMP_COMPMODE_EQ", displayName: "Check for equality, use a mask value" },
	{ name: "ERAD_BUSCOMP_COMPMODE_GT", displayName: "Check for greater than" },
	{ name: "ERAD_BUSCOMP_COMPMODE_GE", displayName: "Check for greater than or equal to" },
	{ name: "ERAD_BUSCOMP_COMPMODE_LT", displayName: "Check for lesser than" },
	{ name: "ERAD_BUSCOMP_COMPMODE_LE", displayName: "Check for lesser than or equal to" },
]
let ERAD_Counter_Event_Mode = [
	{ name: "ERAD_COUNTER_MODE_ACTIVE", displayName: "Count number of CPU Cycles event is active for" },
	{ name: "ERAD_COUNTER_MODE_RISING_EDGE", displayName: "Count number of Rising Edges of event" },
]
let ERAD_Counter_Input_Event = [
	{ name: "ERAD_EVENT_EBC0", displayName: "EVENT EBC0" },
	{ name: "ERAD_EVENT_EBC1", displayName: "EVENT EBC1" },
	{ name: "ERAD_EVENT_EBC2", displayName: "EVENT EBC2" },
	{ name: "ERAD_EVENT_EBC3", displayName: "EVENT EBC3" },
	{ name: "ERAD_EVENT_EBC4", displayName: "EVENT EBC4" },
	{ name: "ERAD_EVENT_EBC5", displayName: "EVENT EBC5" },
	{ name: "ERAD_EVENT_EBC6", displayName: "EVENT EBC6" },
	{ name: "ERAD_EVENT_EBC7", displayName: "EVENT EBC7" },
	{ name: "ERAD_EVENT_COUNTER0_EVENT", displayName: "EVENT COUNTER0 EVENT" },
	{ name: "ERAD_EVENT_COUNTER1_EVENT", displayName: "EVENT COUNTER1 EVENT" },
	{ name: "ERAD_EVENT_COUNTER2_EVENT", displayName: "EVENT COUNTER2 EVENT" },
	{ name: "ERAD_EVENT_COUNTER3_EVENT", displayName: "EVENT COUNTER3 EVENT" },
	{ name: "ERAD_EVENT_ERAD_OR_MASK0", displayName: "EVENT ERAD OR MASK0" },
	{ name: "ERAD_EVENT_ERAD_OR_MASK1", displayName: "EVENT ERAD OR MASK1" },
	{ name: "ERAD_EVENT_ERAD_OR_MASK2", displayName: "EVENT ERAD OR MASK2" },
	{ name: "ERAD_EVENT_ERAD_OR_MASK3", displayName: "EVENT ERAD OR MASK3" },
	{ name: "ERAD_EVENT_ERAD_AND_MASK0", displayName: "EVENT ERAD AND MASK0" },
	{ name: "ERAD_EVENT_ERAD_AND_MASK1", displayName: "EVENT ERAD AND MASK1" },
	{ name: "ERAD_EVENT_ERAD_AND_MASK2", displayName: "EVENT ERAD AND MASK2" },
	{ name: "ERAD_EVENT_ERAD_AND_MASK3", displayName: "EVENT ERAD AND MASK3" },
	{ name: "ERAD_EVENT_PIPE_INT", displayName: "EVENT PIPE INT" },
	{ name: "ERAD_EVENT_PIPE_RTINT", displayName: "EVENT PIPE RTINT" },
	{ name: "ERAD_EVENT_PIPE_NMI", displayName: "EVENT PIPE NMI" },
	{ name: "ERAD_EVENT_CPU1_TIMER0_INT", displayName: "CPU1 TIMER0 Interrupt" },
	{ name: "ERAD_EVENT_CPU1_TIMER1_INT", displayName: "CPU1 TIMER1 Interrupt" },
	{ name: "ERAD_EVENT_CPU1_TIMER2_INT", displayName: "CPU1 TIMER2 Interrupt" },
	{ name: "ERAD_EVENT_CPU2_TIMER0_INT", displayName: "CPU2 TIMER0 Interrupt" },
	{ name: "ERAD_EVENT_CPU2_TIMER1_INT", displayName: "CPU2 TIMER1 Interrupt" },
	{ name: "ERAD_EVENT_CPU2_TIMER2_INT", displayName: "CPU2 TIMER2 Interrupt" },
	{ name: "ERAD_EVENT_CPU3_TIMER0_INT", displayName: "CPU3 TIMER0 Interrupt" },
	{ name: "ERAD_EVENT_CPU3_TIMER1_INT", displayName: "CPU3 TIMER1 Interrupt" },
	{ name: "ERAD_EVENT_CPU3_TIMER2_INT", displayName: "CPU3 TIMER2 Interrupt" },
	{ name: "ERAD_EVENT_RTDMA1_CH1INT", displayName: "EVENT RTDMA1 CH1INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH2INT", displayName: "EVENT RTDMA1 CH2INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH3INT", displayName: "EVENT RTDMA1 CH3INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH4INT", displayName: "EVENT RTDMA1 CH4INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH5INT", displayName: "EVENT RTDMA1 CH5INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH6INT", displayName: "EVENT RTDMA1 CH6INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH7INT", displayName: "EVENT RTDMA1 CH7INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH8INT", displayName: "EVENT RTDMA1 CH8INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH9INT", displayName: "EVENT RTDMA1 CH9INT" },
	{ name: "ERAD_EVENT_RTDMA1_CH10INT", displayName: "EVENT RTDMA1 CH10INT" },
	{ name: "ERAD_EVENT_ADCAEVTINT", displayName: "EVENT ADCAEVTINT" },
	{ name: "ERAD_EVENT_ADCBEVTINT", displayName: "EVENT ADCBEVTINT" },
	{ name: "ERAD_EVENT_ADCCEVTINT", displayName: "EVENT ADCCEVTINT" },
	{ name: "ERAD_EVENT_ADCDEVTINT", displayName: "EVENT ADCDEVTINT" },
	{ name: "ERAD_EVENT_ADCEEVTINT", displayName: "EVENT ADCEEVTINT" },
	{ name: "ERAD_EVENT_ADCSOCA", displayName: "EVENT ADCSOCA" },
	{ name: "ERAD_EVENT_ADCSOCB", displayName: "EVENT ADCSOCB" },
	{ name: "ERAD_EVENT_RTDMA2_CH1INT", displayName: "EVENT RTDMA2 CH1INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH2INT", displayName: "EVENT RTDMA2 CH2INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH3INT", displayName: "EVENT RTDMA2 CH3INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH4INT", displayName: "EVENT RTDMA2 CH4INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH5INT", displayName: "EVENT RTDMA2 CH5INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH6INT", displayName: "EVENT RTDMA2 CH6INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH7INT", displayName: "EVENT RTDMA2 CH7INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH8INT", displayName: "EVENT RTDMA2 CH8INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH9INT", displayName: "EVENT RTDMA2 CH9INT" },
	{ name: "ERAD_EVENT_RTDMA2_CH10INT", displayName: "EVENT RTDMA2 CH10INT" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT1", displayName: "EVENT EPWMXBAR OUT1" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT2", displayName: "EVENT EPWMXBAR OUT2" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT3", displayName: "EVENT EPWMXBAR OUT3" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT4", displayName: "EVENT EPWMXBAR OUT4" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT5", displayName: "EVENT EPWMXBAR OUT5" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT6", displayName: "EVENT EPWMXBAR OUT6" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT7", displayName: "EVENT EPWMXBAR OUT7" },
	{ name: "ERAD_EVENT_EPWMXBAR_OUT8", displayName: "EVENT EPWMXBAR OUT8" },
	{ name: "ERAD_EVENT_INPUTXBAR1", displayName: "EVENT INPUTXBAR1" },
	{ name: "ERAD_EVENT_INPUTXBAR2", displayName: "EVENT INPUTXBAR2" },
	{ name: "ERAD_EVENT_INPUTXBAR3", displayName: "EVENT INPUTXBAR3" },
	{ name: "ERAD_EVENT_INPUTXBAR4", displayName: "EVENT INPUTXBAR4" },
	{ name: "ERAD_EVENT_INPUTXBAR5", displayName: "EVENT INPUTXBAR5" },
	{ name: "ERAD_EVENT_INPUTXBAR6", displayName: "EVENT INPUTXBAR6" },
	{ name: "ERAD_EVENT_INPUTXBAR7", displayName: "EVENT INPUTXBAR7" },
	{ name: "ERAD_EVENT_INPUTXBAR8", displayName: "EVENT INPUTXBAR8" },
	{ name: "ERAD_EVENT_INPUTXBAR9", displayName: "EVENT INPUTXBAR9" },
	{ name: "ERAD_EVENT_INPUTXBAR10", displayName: "EVENT INPUTXBAR10" },
	{ name: "ERAD_EVENT_INPUTXBAR11", displayName: "EVENT INPUTXBAR11" },
	{ name: "ERAD_EVENT_INPUTXBAR12", displayName: "EVENT INPUTXBAR12" },
	{ name: "ERAD_EVENT_INPUTXBAR13", displayName: "EVENT INPUTXBAR13" },
	{ name: "ERAD_EVENT_INPUTXBAR14", displayName: "EVENT INPUTXBAR14" },
	{ name: "ERAD_EVENT_INPUTXBAR15", displayName: "EVENT INPUTXBAR15" },
	{ name: "ERAD_EVENT_INPUTXBAR16", displayName: "EVENT INPUTXBAR16" },
	{ name: "ERAD_EVENT_CMPSS1_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS1 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS2_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS2 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS3_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS3 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS4_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS4 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS5_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS5 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS6_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS6 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS7_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS7 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS8_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS8 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS9_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS9 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS10_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS10 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS11_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS11 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_CMPSS12_CTRIPH_OR_CTRIPL", displayName: "EVENT CMPSS12 CTRIPH OR CTRIPL" },
	{ name: "ERAD_EVENT_SD1FLT1_COMPH_OR_COMPL", displayName: "EVENT SD1FLT1 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD1FLT2_COMPH_OR_COMPL", displayName: "EVENT SD1FLT2 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD1FLT3_COMPH_OR_COMPL", displayName: "EVENT SD1FLT3 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD1FLT4_COMPH_OR_COMPL", displayName: "EVENT SD1FLT4 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD2FLT1_COMPH_OR_COMPL", displayName: "EVENT SD2FLT1 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD2FLT2_COMPH_OR_COMPL", displayName: "EVENT SD2FLT2 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD2FLT3_COMPH_OR_COMPL", displayName: "EVENT SD2FLT3 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD2FLT4_COMPH_OR_COMPL", displayName: "EVENT SD2FLT4 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD3FLT1_COMPH_OR_COMPL", displayName: "EVENT SD3FLT1 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD3FLT2_COMPH_OR_COMPL", displayName: "EVENT SD3FLT2 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD3FLT3_COMPH_OR_COMPL", displayName: "EVENT SD3FLT3 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD3FLT4_COMPH_OR_COMPL", displayName: "EVENT SD3FLT4 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD4FLT1_COMPH_OR_COMPL", displayName: "EVENT SD4FLT1 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD4FLT2_COMPH_OR_COMPL", displayName: "EVENT SD4FLT2 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD4FLT3_COMPH_OR_COMPL", displayName: "EVENT SD4FLT3 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_SD4FLT4_COMPH_OR_COMPL", displayName: "EVENT SD4FLT4 COMPH OR COMPL" },
	{ name: "ERAD_EVENT_ADCAINT1", displayName: "EVENT ADCAINT1" },
	{ name: "ERAD_EVENT_ADCAINT2", displayName: "EVENT ADCAINT2" },
	{ name: "ERAD_EVENT_ADCAINT3", displayName: "EVENT ADCAINT3" },
	{ name: "ERAD_EVENT_ADCAINT4", displayName: "EVENT ADCAINT4" },
	{ name: "ERAD_EVENT_ADCBINT1", displayName: "EVENT ADCBINT1" },
	{ name: "ERAD_EVENT_ADCBINT2", displayName: "EVENT ADCBINT2" },
	{ name: "ERAD_EVENT_ADCBINT3", displayName: "EVENT ADCBINT3" },
	{ name: "ERAD_EVENT_ADCBINT4", displayName: "EVENT ADCBINT4" },
	{ name: "ERAD_EVENT_ADCCINT1", displayName: "EVENT ADCCINT1" },
	{ name: "ERAD_EVENT_ADCCINT2", displayName: "EVENT ADCCINT2" },
	{ name: "ERAD_EVENT_ADCCINT3", displayName: "EVENT ADCCINT3" },
	{ name: "ERAD_EVENT_ADCCINT4", displayName: "EVENT ADCCINT4" },
	{ name: "ERAD_EVENT_ADCDINT1", displayName: "EVENT ADCDINT1" },
	{ name: "ERAD_EVENT_ADCDINT2", displayName: "EVENT ADCDINT2" },
	{ name: "ERAD_EVENT_ADCDINT3", displayName: "EVENT ADCDINT3" },
	{ name: "ERAD_EVENT_ADCDINT4", displayName: "EVENT ADCDINT4" },
	{ name: "ERAD_EVENT_ADCEINT1", displayName: "EVENT ADCEINT1" },
	{ name: "ERAD_EVENT_ADCEINT2", displayName: "EVENT ADCEINT2" },
	{ name: "ERAD_EVENT_ADCEINT3", displayName: "EVENT ADCEINT3" },
	{ name: "ERAD_EVENT_ADCEINT4", displayName: "EVENT ADCEINT4" },
	{ name: "ERAD_EVENT_ECAT_PDI_SOF", displayName: "EVENT ECAT PDI SOF" },
	{ name: "ERAD_EVENT_ECAT_PDI_EOF", displayName: "EVENT ECAT PDI EOF" },
	{ name: "ERAD_EVENT_ECAT_PCI_WD_TRIGGER", displayName: "EVENT ECAT PCI WD TRIGGER" },
	{ name: "ERAD_EVENT_ECAT_PDI_UC_IRQ", displayName: "EVENT ECAT PDI UC IRQ" },
	{ name: "ERAD_EVENT_ECAT_SYNC_OUT0", displayName: "EVENT ECAT SYNC OUT0" },
	{ name: "ERAD_EVENT_ECAT_SYNC_OUT1", displayName: "EVENT ECAT SYNC OUT1" },
	{ name: "ERAD_EVENT_ECAT_DRAM_PARITY_ERROR", displayName: "EVENT ECAT DRAM PARITY ERROR" },
	{ name: "ERAD_EVENT_INPUTXBAR17", displayName: "EVENT INPUTXBAR17" },
	{ name: "ERAD_EVENT_INPUTXBAR18", displayName: "EVENT INPUTXBAR18" },
	{ name: "ERAD_EVENT_INPUTXBAR19", displayName: "EVENT INPUTXBAR19" },
	{ name: "ERAD_EVENT_INPUTXBAR20", displayName: "EVENT INPUTXBAR20" },
	{ name: "ERAD_EVENT_INPUTXBAR21", displayName: "EVENT INPUTXBAR21" },
	{ name: "ERAD_EVENT_INPUTXBAR22", displayName: "EVENT INPUTXBAR22" },
	{ name: "ERAD_EVENT_INPUTXBAR23", displayName: "EVENT INPUTXBAR23" },
	{ name: "ERAD_EVENT_INPUTXBAR24", displayName: "EVENT INPUTXBAR24" },
	{ name: "ERAD_EVENT_INPUTXBAR25", displayName: "EVENT INPUTXBAR25" },
	{ name: "ERAD_EVENT_INPUTXBAR26", displayName: "EVENT INPUTXBAR26" },
	{ name: "ERAD_EVENT_INPUTXBAR27", displayName: "EVENT INPUTXBAR27" },
	{ name: "ERAD_EVENT_INPUTXBAR28", displayName: "EVENT INPUTXBAR28" },
	{ name: "ERAD_EVENT_INPUTXBAR29", displayName: "EVENT INPUTXBAR29" },
	{ name: "ERAD_EVENT_INPUTXBAR30", displayName: "EVENT INPUTXBAR30" },
	{ name: "ERAD_EVENT_INPUTXBAR31", displayName: "EVENT INPUTXBAR31" },
	{ name: "ERAD_EVENT_INPUTXBAR32", displayName: "EVENT INPUTXBAR32" },
	{ name: "ERAD_EVENT_FSIA_DATA_PKT_RCVD", displayName: "EVENT FSIA DATA PKT RCVD" },
	{ name: "ERAD_EVENT_FSIA_ERROR_PKT_RCVD", displayName: "EVENT FSIA ERROR PKT RCVD" },
	{ name: "ERAD_EVENT_FSIA_PING_PKT_RCVD", displayName: "EVENT FSIA PING PKT RCVD" },
	{ name: "ERAD_EVENT_FSIA_PING_FRAME_TAG_MATCH", displayName: "EVENT FSIA PING FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIA_DATA_FRAME_TAG_MATCH", displayName: "EVENT FSIA DATA FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIA_ERROR_FRAME_TAG_MATCH", displayName: "EVENT FSIA ERROR FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIA_FRAME_DONE", displayName: "EVENT FSIA FRAME DONE" },
	{ name: "ERAD_EVENT_FSIB_DATA_PKT_RCVD", displayName: "EVENT FSIB DATA PKT RCVD" },
	{ name: "ERAD_EVENT_FSIB_ERROR_PKT_RCVD", displayName: "EVENT FSIB ERROR PKT RCVD" },
	{ name: "ERAD_EVENT_FSIB_PING_PKT_RCVD", displayName: "EVENT FSIB PING PKT RCVD" },
	{ name: "ERAD_EVENT_FSIB_PING_FRAME_TAG_MATCH", displayName: "EVENT FSIB PING FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIB_DATA_FRAME_TAG_MATCH", displayName: "EVENT FSIB DATA FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIB_ERROR_FRAME_TAG_MATCH", displayName: "EVENT FSIB ERROR FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIB_FRAME_DONE", displayName: "EVENT FSIB FRAME DONE" },
	{ name: "ERAD_EVENT_FSIC_DATA_PKT_RCVD", displayName: "EVENT FSIC DATA PKT RCVD" },
	{ name: "ERAD_EVENT_FSIC_ERROR_PKT_RCVD", displayName: "EVENT FSIC ERROR PKT RCVD" },
	{ name: "ERAD_EVENT_FSIC_PING_PKT_RCVD", displayName: "EVENT FSIC PING PKT RCVD" },
	{ name: "ERAD_EVENT_FSIC_PING_FRAME_TAG_MATCH", displayName: "EVENT FSIC PING FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIC_DATA_FRAME_TAG_MATCH", displayName: "EVENT FSIC DATA FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIC_ERROR_FRAME_TAG_MATCH", displayName: "EVENT FSIC ERROR FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSIC_FRAME_DONE", displayName: "EVENT FSIC FRAME DONE" },
	{ name: "ERAD_EVENT_FSID_DATA_PKT_RCVD", displayName: "EVENT FSID DATA PKT RCVD" },
	{ name: "ERAD_EVENT_FSID_ERROR_PKT_RCVD", displayName: "EVENT FSID ERROR PKT RCVD" },
	{ name: "ERAD_EVENT_FSID_PING_PKT_RCVD", displayName: "EVENT FSID PING PKT RCVD" },
	{ name: "ERAD_EVENT_FSID_PING_FRAME_TAG_MATCH", displayName: "EVENT FSID PING FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSID_DATA_FRAME_TAG_MATCH", displayName: "EVENT FSID DATA FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSID_ERROR_FRAME_TAG_MATCH", displayName: "EVENT FSID ERROR FRAME TAG MATCH" },
	{ name: "ERAD_EVENT_FSID_FRAME_DONE", displayName: "EVENT FSID FRAME DONE" },
	{ name: "ERAD_EVENT_TRACE_HIT_EVENT", displayName: "EVENT TRACE HIT EVENT" },
	{ name: "ERAD_EVENT_CPU1_LCMCM_ERR", displayName: "CPU1 EVENT LCMCM ERR" },
	{ name: "ERAD_EVENT_RTDMA_LCM_CMP_ERR", displayName: "EVENT RTDMA LCM CMP ERR" },
	{ name: "ERAD_EVENT_MCANA_EVT0", displayName: "EVENT MCANA EVT0" },
	{ name: "ERAD_EVENT_MCANA_EVT1", displayName: "EVENT MCANA EVT1" },
	{ name: "ERAD_EVENT_MCANA_EVT2", displayName: "EVENT MCANA EVT2" },
	{ name: "ERAD_EVENT_MCANB_EVT0", displayName: "EVENT MCANB EVT0" },
	{ name: "ERAD_EVENT_MCANB_EVT1", displayName: "EVENT MCANB EVT1" },
	{ name: "ERAD_EVENT_MCANB_EVT2", displayName: "EVENT MCANB EVT2" },
	{ name: "ERAD_EVENT_MCANC_EVT0", displayName: "EVENT MCANC EVT0" },
	{ name: "ERAD_EVENT_MCANC_EVT1", displayName: "EVENT MCANC EVT1" },
	{ name: "ERAD_EVENT_MCANC_EVT2", displayName: "EVENT MCANC EVT2" },
	{ name: "ERAD_EVENT_MCAND_EVT0", displayName: "EVENT MCAND EVT0" },
	{ name: "ERAD_EVENT_MCAND_EVT1", displayName: "EVENT MCAND EVT1" },
	{ name: "ERAD_EVENT_MCAND_EVT2", displayName: "EVENT MCAND EVT2" },
	{ name: "ERAD_EVENT_MCANE_EVT0", displayName: "EVENT MCANE EVT0" },
	{ name: "ERAD_EVENT_MCANE_EVT1", displayName: "EVENT MCANE EVT1" },
	{ name: "ERAD_EVENT_MCANE_EVT2", displayName: "EVENT MCANE EVT2" },
	{ name: "ERAD_EVENT_MCANF_EVT0", displayName: "EVENT MCANF EVT0" },
	{ name: "ERAD_EVENT_MCANF_EVT1", displayName: "EVENT MCANF EVT1" },
	{ name: "ERAD_EVENT_MCANF_EVT2", displayName: "EVENT MCANF EVT2" },
	{ name: "ERAD_EVENT_CPUx_INT_ACK", displayName: "CPUx INT ACK" },
	{ name: "ERAD_EVENT_CPUx_RTINT_ACK", displayName: "CPUx RTINT ACK" },
	{ name: "ERAD_EVENT_CPUx_VIS_R1_PC_VALID", displayName: "CPUx VIS R1 PC VALID" },
	{ name: "ERAD_EVENT_CPUx_VIS_W_DR1_REQ", displayName: "CPUx VIS W DR1 REQ" },
	{ name: "ERAD_EVENT_CPUx_VIS_W_DR2_REQ", displayName: "CPUx VIS W DR2 REQ" },
	{ name: "ERAD_EVENT_CPUx_VIS_W_DW_REQ", displayName: "CPUx VIS W DW REQ" },
	{ name: "ERAD_EVENT_CPUx_CPI_D2_READY", displayName: "CPUx CPI D2 READY" },
	{ name: "ERAD_EVENT_CPUx_CPI_R1_READY", displayName: "CPUx CPI R1 READY" },
	{ name: "ERAD_EVENT_CPUx_CPI_EXE_READY", displayName: "CPUx CPI EXE READY" },
	{ name: "ERAD_EVENT_NO_EVENT", displayName: "EVENT NO EVENT" },
]
let ERAD_BusCompInstance = [
	{ name: "ERAD_BUSCOMP0", displayName: "BUSCOMP0" },
	{ name: "ERAD_BUSCOMP1", displayName: "BUSCOMP1" },
	{ name: "ERAD_BUSCOMP2", displayName: "BUSCOMP2" },
	{ name: "ERAD_BUSCOMP3", displayName: "BUSCOMP3" },
	{ name: "ERAD_BUSCOMP4", displayName: "BUSCOMP4" },
	{ name: "ERAD_BUSCOMP5", displayName: "BUSCOMP5" },
	{ name: "ERAD_BUSCOMP6", displayName: "BUSCOMP6" },
	{ name: "ERAD_BUSCOMP7", displayName: "BUSCOMP7" },
]
let ERAD_CounterInstance = [
	{ name: "ERAD_COUNTER0", displayName: "COUNTER0" },
	{ name: "ERAD_COUNTER1", displayName: "COUNTER1" },
	{ name: "ERAD_COUNTER2", displayName: "COUNTER2" },
	{ name: "ERAD_COUNTER3", displayName: "COUNTER3" },
]
let ERAD_Mask = [
	{ name: "ERAD_AND_MASK0", displayName: "AND MASK0" },
	{ name: "ERAD_AND_MASK1", displayName: "AND MASK1" },
	{ name: "ERAD_AND_MASK2", displayName: "AND MASK2" },
	{ name: "ERAD_AND_MASK3", displayName: "AND MASK3" },
	{ name: "ERAD_OR_MASK0", displayName: "OR MASK0" },
	{ name: "ERAD_OR_MASK1", displayName: "OR MASK1" },
	{ name: "ERAD_OR_MASK2", displayName: "OR MASK2" },
	{ name: "ERAD_OR_MASK3", displayName: "OR MASK3" },
]
let ERAD_Counter_Input_Type = [
	{ name: "ERAD_COUNTER_COUNT_INPUT", displayName: "COUNTER COUNT INPUT" },
	{ name: "ERAD_COUNTER_START_INPUT", displayName: "COUNTER START INPUT" },
	{ name: "ERAD_COUNTER_STOP_INPUT", displayName: "COUNTER STOP INPUT" },
	{ name: "ERAD_COUNTER_RESET_INPUT", displayName: "COUNTER RESET INPUT" },
]
let ERAD_PCTrace_Windowed_Qualifier = [
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC0", displayName: "PCTRACE WINDOWED QUAL EBC0" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC1", displayName: "PCTRACE WINDOWED QUAL EBC1" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC2", displayName: "PCTRACE WINDOWED QUAL EBC2" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC3", displayName: "PCTRACE WINDOWED QUAL EBC3" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC4", displayName: "PCTRACE WINDOWED QUAL EBC4" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC5", displayName: "PCTRACE WINDOWED QUAL EBC5" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC6", displayName: "PCTRACE WINDOWED QUAL EBC6" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_EBC7", displayName: "PCTRACE WINDOWED QUAL EBC7" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_OR_MASK0", displayName: "PCTRACE WINDOWED QUAL OR MASK0" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_OR_MASK1", displayName: "PCTRACE WINDOWED QUAL OR MASK1" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_OR_MASK2", displayName: "PCTRACE WINDOWED QUAL OR MASK2" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_OR_MASK3", displayName: "PCTRACE WINDOWED QUAL OR MASK3" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_AND_MASK0", displayName: "PCTRACE WINDOWED QUAL AND MASK0" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_AND_MASK1", displayName: "PCTRACE WINDOWED QUAL AND MASK1" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_AND_MASK2", displayName: "PCTRACE WINDOWED QUAL AND MASK2" },
	{ name: "ERAD_PCTRACE_WINDOWED_QUAL_AND_MASK3", displayName: "PCTRACE WINDOWED QUAL AND MASK3" },
]
let ERAD_INST = [
	{ name: "ERAD_INST_BUSCOMP0", displayName: "Bus Comparator 0 (EBC0)" },
	{ name: "ERAD_INST_BUSCOMP1", displayName: "Bus Comparator 1 (EBC1)" },
	{ name: "ERAD_INST_BUSCOMP2", displayName: "Bus Comparator 2 (EBC2)" },
	{ name: "ERAD_INST_BUSCOMP3", displayName: "Bus Comparator 3 (EBC3)" },
	{ name: "ERAD_INST_BUSCOMP4", displayName: "Bus Comparator 4 (EBC4)" },
	{ name: "ERAD_INST_BUSCOMP5", displayName: "Bus Comparator 5 (EBC5)" },
	{ name: "ERAD_INST_BUSCOMP6", displayName: "Bus Comparator 6 (EBC6)" },
	{ name: "ERAD_INST_BUSCOMP7", displayName: "Bus Comparator 7 (EBC7)" },
	{ name: "ERAD_INST_COUNTER0", displayName: "Counter 0 (SEC0)" },
	{ name: "ERAD_INST_COUNTER1", displayName: "Counter 1 (SEC1)" },
	{ name: "ERAD_INST_COUNTER2", displayName: "Counter 2 (SEC2)" },
	{ name: "ERAD_INST_COUNTER3", displayName: "Counter 3 (SEC3)" },
]
let ERAD_INPUT_INVERT = [
	{ name: "ERAD_INPUT_INVERT_DISABLE", displayName: "Do not invert the input" },
	{ name: "ERAD_INPUT_INVERT_ENABLE", displayName: "Invert the input" },
]
module.exports = {
	ERAD_Owner: ERAD_Owner,
	ERAD_Status: ERAD_Status,
	ERAD_BusComp_Bus_Select: ERAD_BusComp_Bus_Select,
	ERAD_BusComp_Comp_Mode: ERAD_BusComp_Comp_Mode,
	ERAD_Counter_Event_Mode: ERAD_Counter_Event_Mode,
	ERAD_Counter_Input_Event: ERAD_Counter_Input_Event,
	ERAD_BusCompInstance: ERAD_BusCompInstance,
	ERAD_CounterInstance: ERAD_CounterInstance,
	ERAD_Mask: ERAD_Mask,
	ERAD_Counter_Input_Type: ERAD_Counter_Input_Type,
	ERAD_PCTrace_Windowed_Qualifier: ERAD_PCTrace_Windowed_Qualifier,
	ERAD_INST: ERAD_INST,
	ERAD_INPUT_INVERT: ERAD_INPUT_INVERT,
}
