let GPIORegisters = [
	{ name: "GPACTRL", description: "GPIO A Qualification Sampling Period Control (GPIO0 to 31)", offset: "0x0",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO0 to GPIO7", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO8 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO16 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO24 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPAQSEL1", description: "GPIO A Qualifier Select 1 Register (GPIO0 to 15)", offset: "0x4",
		bits: [
			{ name: "GPIO0", description: "Select input qualification type for GPIO0", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO1", description: "Select input qualification type for GPIO1", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO2", description: "Select input qualification type for GPIO2", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO3", description: "Select input qualification type for GPIO3", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO4", description: "Select input qualification type for GPIO4", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO5", description: "Select input qualification type for GPIO5", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO6", description: "Select input qualification type for GPIO6", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO7", description: "Select input qualification type for GPIO7", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO8", description: "Select input qualification type for GPIO8", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO9", description: "Select input qualification type for GPIO9", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO10", description: "Select input qualification type for GPIO10", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO11", description: "Select input qualification type for GPIO11", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO12", description: "Select input qualification type for GPIO12", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO13", description: "Select input qualification type for GPIO13", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO14", description: "Select input qualification type for GPIO14", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO15", description: "Select input qualification type for GPIO15", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPAQSEL2", description: "GPIO A Qualifier Select 2 Register (GPIO16 to 31)", offset: "0x8",
		bits: [
			{ name: "GPIO16", description: "Select input qualification type for GPIO16", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO17", description: "Select input qualification type for GPIO17", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO18", description: "Select input qualification type for GPIO18", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO19", description: "Select input qualification type for GPIO19", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO20", description: "Select input qualification type for GPIO20", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO21", description: "Select input qualification type for GPIO21", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO22", description: "Select input qualification type for GPIO22", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO23", description: "Select input qualification type for GPIO23", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO24", description: "Select input qualification type for GPIO24", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO25", description: "Select input qualification type for GPIO25", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO26", description: "Select input qualification type for GPIO26", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO27", description: "Select input qualification type for GPIO27", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO28", description: "Select input qualification type for GPIO28", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO29", description: "Select input qualification type for GPIO29", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO30", description: "Select input qualification type for GPIO30", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO31", description: "Select input qualification type for GPIO31", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPAMUX1", description: "GPIO A Mux 1 Register (GPIO0 to 15)", offset: "0xC",
		bits: [
			{ name: "GPIO0", description: "Defines pin-muxing selection for GPIO0", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO1", description: "Defines pin-muxing selection for GPIO1", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO2", description: "Defines pin-muxing selection for GPIO2", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO3", description: "Defines pin-muxing selection for GPIO3", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO4", description: "Defines pin-muxing selection for GPIO4", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO5", description: "Defines pin-muxing selection for GPIO5", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO6", description: "Defines pin-muxing selection for GPIO6", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO7", description: "Defines pin-muxing selection for GPIO7", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO8", description: "Defines pin-muxing selection for GPIO8", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO9", description: "Defines pin-muxing selection for GPIO9", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO10", description: "Defines pin-muxing selection for GPIO10", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO11", description: "Defines pin-muxing selection for GPIO11", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO12", description: "Defines pin-muxing selection for GPIO12", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO13", description: "Defines pin-muxing selection for GPIO13", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO14", description: "Defines pin-muxing selection for GPIO14", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO15", description: "Defines pin-muxing selection for GPIO15", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPAMUX2", description: "GPIO A Mux 2 Register (GPIO16 to 31)", offset: "0x10",
		bits: [
			{ name: "GPIO16", description: "Defines pin-muxing selection for GPIO16", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO17", description: "Defines pin-muxing selection for GPIO17", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO18", description: "Defines pin-muxing selection for GPIO18", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO19", description: "Defines pin-muxing selection for GPIO19", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO20", description: "Defines pin-muxing selection for GPIO20", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO21", description: "Defines pin-muxing selection for GPIO21", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO22", description: "Defines pin-muxing selection for GPIO22", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO23", description: "Defines pin-muxing selection for GPIO23", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO24", description: "Defines pin-muxing selection for GPIO24", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO25", description: "Defines pin-muxing selection for GPIO25", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO26", description: "Defines pin-muxing selection for GPIO26", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO27", description: "Defines pin-muxing selection for GPIO27", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO28", description: "Defines pin-muxing selection for GPIO28", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO29", description: "Defines pin-muxing selection for GPIO29", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO30", description: "Defines pin-muxing selection for GPIO30", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO31", description: "Defines pin-muxing selection for GPIO31", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPAPUD", description: "GPIO A Pull Up Disable Register (GPIO0 to 31)", offset: "0x18",
		bits: [
			{ name: "GPIO0", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Pull-Up Disable control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Pull-Up Disable control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Pull-Up Disable control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Pull-Up Disable control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Pull-Up Disable control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Pull-Up Disable control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Pull-Up Disable control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Pull-Up Disable control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Pull-Up Disable control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPAINV", description: "GPIO A Input Polarity Invert Registers (GPIO0 to 31)", offset: "0x20",
		bits: [
			{ name: "GPIO0", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Input inversion control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Input inversion control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Input inversion control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Input inversion control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Input inversion control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Input inversion control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Input inversion control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Input inversion control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Input inversion control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPAODR", description: "GPIO A Open Drain Output Register (GPIO0 to GPIO31)", offset: "0x24",
		bits: [
			{ name: "GPIO0", description: "Outpout Open-Drain control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Outpout Open-Drain control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Outpout Open-Drain control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Outpout Open-Drain control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Outpout Open-Drain control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Outpout Open-Drain control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Outpout Open-Drain control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Outpout Open-Drain control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Outpout Open-Drain control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Outpout Open-Drain control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Outpout Open-Drain control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Outpout Open-Drain control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Outpout Open-Drain control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Outpout Open-Drain control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Outpout Open-Drain control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Outpout Open-Drain control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Outpout Open-Drain control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Outpout Open-Drain control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Outpout Open-Drain control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Outpout Open-Drain control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Outpout Open-Drain control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Outpout Open-Drain control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Outpout Open-Drain control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Outpout Open-Drain control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Outpout Open-Drain control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Outpout Open-Drain control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Outpout Open-Drain control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Outpout Open-Drain control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Outpout Open-Drain control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Outpout Open-Drain control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Outpout Open-Drain control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Outpout Open-Drain control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPAGMUX1", description: "GPIO A Peripheral Group Mux (GPIO0 to 15)", offset: "0x40",
		bits: [
			{ name: "GPIO0", description: "Defines pin-muxing selection for GPIO0", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO1", description: "Defines pin-muxing selection for GPIO1", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO2", description: "Defines pin-muxing selection for GPIO2", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO3", description: "Defines pin-muxing selection for GPIO3", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO4", description: "Defines pin-muxing selection for GPIO4", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO5", description: "Defines pin-muxing selection for GPIO5", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO6", description: "Defines pin-muxing selection for GPIO6", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO7", description: "Defines pin-muxing selection for GPIO7", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO8", description: "Defines pin-muxing selection for GPIO8", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO9", description: "Defines pin-muxing selection for GPIO9", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO10", description: "Defines pin-muxing selection for GPIO10", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO11", description: "Defines pin-muxing selection for GPIO11", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO12", description: "Defines pin-muxing selection for GPIO12", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO13", description: "Defines pin-muxing selection for GPIO13", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO14", description: "Defines pin-muxing selection for GPIO14", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO15", description: "Defines pin-muxing selection for GPIO15", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPAGMUX2", description: "GPIO A Peripheral Group Mux (GPIO16 to 31)", offset: "0x44",
		bits: [
			{ name: "GPIO16", description: "Defines pin-muxing selection for GPIO16", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO17", description: "Defines pin-muxing selection for GPIO17", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO18", description: "Defines pin-muxing selection for GPIO18", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO19", description: "Defines pin-muxing selection for GPIO19", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO20", description: "Defines pin-muxing selection for GPIO20", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO21", description: "Defines pin-muxing selection for GPIO21", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO22", description: "Defines pin-muxing selection for GPIO22", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO23", description: "Defines pin-muxing selection for GPIO23", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO24", description: "Defines pin-muxing selection for GPIO24", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO25", description: "Defines pin-muxing selection for GPIO25", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO26", description: "Defines pin-muxing selection for GPIO26", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO27", description: "Defines pin-muxing selection for GPIO27", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO28", description: "Defines pin-muxing selection for GPIO28", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO29", description: "Defines pin-muxing selection for GPIO29", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO30", description: "Defines pin-muxing selection for GPIO30", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO31", description: "Defines pin-muxing selection for GPIO31", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPACSEL1", description: "GPIO A Core Select Register (GPIO0 to 7)", offset: "0x50",
		bits: [
			{ name: "GPIO0", description: "GPIO0 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO1", description: "GPIO1 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO2", description: "GPIO2 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO3", description: "GPIO3 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO4", description: "GPIO4 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO5", description: "GPIO5 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO6", description: "GPIO6 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO7", description: "GPIO7 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPACSEL2", description: "GPIO A Core Select Register (GPIO8 to 15)", offset: "0x54",
		bits: [
			{ name: "GPIO8", description: "GPIO8 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO9", description: "GPIO9 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO10", description: "GPIO10 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO11", description: "GPIO11 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO12", description: "GPIO12 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO13", description: "GPIO13 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO14", description: "GPIO14 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO15", description: "GPIO15 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPACSEL3", description: "GPIO A Core Select Register (GPIO16 to 23)", offset: "0x58",
		bits: [
			{ name: "GPIO16", description: "GPIO16 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO17", description: "GPIO17 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO18", description: "GPIO18 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO19", description: "GPIO19 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO20", description: "GPIO20 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO21", description: "GPIO21 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO22", description: "GPIO22 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO23", description: "GPIO23 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPACSEL4", description: "GPIO A Core Select Register (GPIO24 to 31)", offset: "0x5C",
		bits: [
			{ name: "GPIO24", description: "GPIO24 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO25", description: "GPIO25 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO26", description: "GPIO26 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO27", description: "GPIO27 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO28", description: "GPIO28 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO29", description: "GPIO29 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO30", description: "GPIO30 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO31", description: "GPIO31 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPALOCK", description: "GPIO A Lock Configuration Register (GPIO0 to 31)", offset: "0x78",
		bits: [
			{ name: "GPIO0", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Configuration Lock bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Configuration Lock bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Configuration Lock bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Configuration Lock bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Configuration Lock bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Configuration Lock bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Configuration Lock bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Configuration Lock bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Configuration Lock bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPACR", description: "GPIO A Lock Commit Register (GPIO0 to 31)", offset: "0x7C",
		bits: [
			{ name: "GPIO0", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Configuration lock commit bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Configuration lock commit bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Configuration lock commit bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Configuration lock commit bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Configuration lock commit bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Configuration lock commit bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Configuration lock commit bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Configuration lock commit bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Configuration lock commit bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBCTRL", description: "GPIO B Qualification Sampling Period Control (GPIO32 to 63)", offset: "0x80",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO32 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO40 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO48 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO56 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPBQSEL1", description: "GPIO B Qualifier Select 1 Register (GPIO32 to 47)", offset: "0x84",
		bits: [
			{ name: "GPIO32", description: "Select input qualification type for GPIO32", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO33", description: "Select input qualification type for GPIO33", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO34", description: "Select input qualification type for GPIO34", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO35", description: "Select input qualification type for GPIO35", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO36", description: "Select input qualification type for GPIO36", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO37", description: "Select input qualification type for GPIO37", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO38", description: "Select input qualification type for GPIO38", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO39", description: "Select input qualification type for GPIO39", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO40", description: "Select input qualification type for GPIO40", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO41", description: "Select input qualification type for GPIO41", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO42", description: "Select input qualification type for GPIO42", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO43", description: "Select input qualification type for GPIO43", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO44", description: "Select input qualification type for GPIO44", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO45", description: "Select input qualification type for GPIO45", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO46", description: "Select input qualification type for GPIO46", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO47", description: "Select input qualification type for GPIO47", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBQSEL2", description: "GPIO B Qualifier Select 2 Register (GPIO48 to 63)", offset: "0x88",
		bits: [
			{ name: "GPIO48", description: "Select input qualification type for GPIO48", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO49", description: "Select input qualification type for GPIO49", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO50", description: "Select input qualification type for GPIO50", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO51", description: "Select input qualification type for GPIO51", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO52", description: "Select input qualification type for GPIO52", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO53", description: "Select input qualification type for GPIO53", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO54", description: "Select input qualification type for GPIO54", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO55", description: "Select input qualification type for GPIO55", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO56", description: "Select input qualification type for GPIO56", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO57", description: "Select input qualification type for GPIO57", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO58", description: "Select input qualification type for GPIO58", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO59", description: "Select input qualification type for GPIO59", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO60", description: "Select input qualification type for GPIO60", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO61", description: "Select input qualification type for GPIO61", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO62", description: "Select input qualification type for GPIO62", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO63", description: "Select input qualification type for GPIO63", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBMUX1", description: "GPIO B Mux 1 Register (GPIO32 to 47)", offset: "0x8C",
		bits: [
			{ name: "GPIO32", description: "Defines pin-muxing selection for GPIO32", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO33", description: "Defines pin-muxing selection for GPIO33", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO34", description: "Defines pin-muxing selection for GPIO34", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO35", description: "Defines pin-muxing selection for GPIO35", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO36", description: "Defines pin-muxing selection for GPIO36", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO37", description: "Defines pin-muxing selection for GPIO37", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO38", description: "Defines pin-muxing selection for GPIO38", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO39", description: "Defines pin-muxing selection for GPIO39", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO40", description: "Defines pin-muxing selection for GPIO40", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO41", description: "Defines pin-muxing selection for GPIO41", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO42", description: "Defines pin-muxing selection for GPIO42", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO43", description: "Defines pin-muxing selection for GPIO43", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO44", description: "Defines pin-muxing selection for GPIO44", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO45", description: "Defines pin-muxing selection for GPIO45", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO46", description: "Defines pin-muxing selection for GPIO46", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO47", description: "Defines pin-muxing selection for GPIO47", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBMUX2", description: "GPIO B Mux 2 Register (GPIO48 to 63)", offset: "0x90",
		bits: [
			{ name: "GPIO48", description: "Defines pin-muxing selection for GPIO48", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO49", description: "Defines pin-muxing selection for GPIO49", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO50", description: "Defines pin-muxing selection for GPIO50", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO51", description: "Defines pin-muxing selection for GPIO51", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO52", description: "Defines pin-muxing selection for GPIO52", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO53", description: "Defines pin-muxing selection for GPIO53", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO54", description: "Defines pin-muxing selection for GPIO54", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO55", description: "Defines pin-muxing selection for GPIO55", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO56", description: "Defines pin-muxing selection for GPIO56", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO57", description: "Defines pin-muxing selection for GPIO57", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO58", description: "Defines pin-muxing selection for GPIO58", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO59", description: "Defines pin-muxing selection for GPIO59", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO60", description: "Defines pin-muxing selection for GPIO60", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO61", description: "Defines pin-muxing selection for GPIO61", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO62", description: "Defines pin-muxing selection for GPIO62", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO63", description: "Defines pin-muxing selection for GPIO63", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBPUD", description: "GPIO B Pull Up Disable Register (GPIO32 to 63)", offset: "0x98",
		bits: [
			{ name: "GPIO32", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Pull-Up Disable control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Pull-Up Disable control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Pull-Up Disable control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Pull-Up Disable control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Pull-Up Disable control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Pull-Up Disable control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Pull-Up Disable control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Pull-Up Disable control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Pull-Up Disable control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBINV", description: "GPIO B Input Polarity Invert Registers (GPIO32 to 63)", offset: "0xA0",
		bits: [
			{ name: "GPIO32", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Input inversion control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Input inversion control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Input inversion control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Input inversion control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Input inversion control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Input inversion control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Input inversion control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Input inversion control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Input inversion control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBODR", description: "GPIO B Open Drain Output Register (GPIO32 to GPIO63)", offset: "0xA4",
		bits: [
			{ name: "GPIO32", description: "Outpout Open-Drain control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Outpout Open-Drain control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Outpout Open-Drain control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Outpout Open-Drain control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Outpout Open-Drain control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Outpout Open-Drain control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Outpout Open-Drain control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Outpout Open-Drain control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Outpout Open-Drain control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Outpout Open-Drain control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Outpout Open-Drain control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Outpout Open-Drain control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Outpout Open-Drain control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Outpout Open-Drain control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Outpout Open-Drain control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Outpout Open-Drain control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Outpout Open-Drain control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Outpout Open-Drain control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Outpout Open-Drain control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Outpout Open-Drain control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Outpout Open-Drain control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Outpout Open-Drain control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Outpout Open-Drain control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Outpout Open-Drain control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Outpout Open-Drain control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Outpout Open-Drain control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Outpout Open-Drain control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Outpout Open-Drain control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Outpout Open-Drain control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Outpout Open-Drain control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Outpout Open-Drain control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Outpout Open-Drain control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBGMUX1", description: "GPIO B Peripheral Group Mux (GPIO32 to 47)", offset: "0xC0",
		bits: [
			{ name: "GPIO32", description: "Defines pin-muxing selection for GPIO32", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO33", description: "Defines pin-muxing selection for GPIO33", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO34", description: "Defines pin-muxing selection for GPIO34", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO35", description: "Defines pin-muxing selection for GPIO35", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO36", description: "Defines pin-muxing selection for GPIO36", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO37", description: "Defines pin-muxing selection for GPIO37", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO38", description: "Defines pin-muxing selection for GPIO38", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO39", description: "Defines pin-muxing selection for GPIO39", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO40", description: "Defines pin-muxing selection for GPIO40", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO41", description: "Defines pin-muxing selection for GPIO41", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO42", description: "Defines pin-muxing selection for GPIO42", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO43", description: "Defines pin-muxing selection for GPIO43", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO44", description: "Defines pin-muxing selection for GPIO44", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO45", description: "Defines pin-muxing selection for GPIO45", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO46", description: "Defines pin-muxing selection for GPIO46", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO47", description: "Defines pin-muxing selection for GPIO47", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBGMUX2", description: "GPIO B Peripheral Group Mux (GPIO48 to 63)", offset: "0xC4",
		bits: [
			{ name: "GPIO48", description: "Defines pin-muxing selection for GPIO48", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO49", description: "Defines pin-muxing selection for GPIO49", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO50", description: "Defines pin-muxing selection for GPIO50", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO51", description: "Defines pin-muxing selection for GPIO51", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO52", description: "Defines pin-muxing selection for GPIO52", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO53", description: "Defines pin-muxing selection for GPIO53", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO54", description: "Defines pin-muxing selection for GPIO54", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO55", description: "Defines pin-muxing selection for GPIO55", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO56", description: "Defines pin-muxing selection for GPIO56", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO57", description: "Defines pin-muxing selection for GPIO57", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO58", description: "Defines pin-muxing selection for GPIO58", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO59", description: "Defines pin-muxing selection for GPIO59", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO60", description: "Defines pin-muxing selection for GPIO60", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO61", description: "Defines pin-muxing selection for GPIO61", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO62", description: "Defines pin-muxing selection for GPIO62", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO63", description: "Defines pin-muxing selection for GPIO63", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPBCSEL1", description: "GPIO B Core Select Register (GPIO32 to 39)", offset: "0xD0",
		bits: [
			{ name: "GPIO32", description: "GPIO32 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO33", description: "GPIO33 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO34", description: "GPIO34 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO35", description: "GPIO35 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO36", description: "GPIO36 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO37", description: "GPIO37 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO38", description: "GPIO38 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO39", description: "GPIO39 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPBCSEL2", description: "GPIO B Core Select Register (GPIO40 to 47)", offset: "0xD4",
		bits: [
			{ name: "GPIO40", description: "GPIO40 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO41", description: "GPIO41 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO42", description: "GPIO42 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO43", description: "GPIO43 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO44", description: "GPIO44 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO45", description: "GPIO45 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO46", description: "GPIO46 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO47", description: "GPIO47 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPBCSEL3", description: "GPIO B Core Select Register (GPIO48 to 55)", offset: "0xD8",
		bits: [
			{ name: "GPIO48", description: "GPIO48 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO49", description: "GPIO49 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO50", description: "GPIO50 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO51", description: "GPIO51 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO52", description: "GPIO52 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO53", description: "GPIO53 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO54", description: "GPIO54 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO55", description: "GPIO55 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPBCSEL4", description: "GPIO B Core Select Register (GPIO56 to 63)", offset: "0xDC",
		bits: [
			{ name: "GPIO56", description: "GPIO56 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO57", description: "GPIO57 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO58", description: "GPIO58 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO59", description: "GPIO59 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO60", description: "GPIO60 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO61", description: "GPIO61 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO62", description: "GPIO62 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO63", description: "GPIO63 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPBLOCK", description: "GPIO B Lock Configuration Register (GPIO32 to 63)", offset: "0xF8",
		bits: [
			{ name: "GPIO32", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Configuration Lock bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Configuration Lock bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Configuration Lock bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Configuration Lock bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Configuration Lock bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Configuration Lock bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Configuration Lock bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Configuration Lock bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Configuration Lock bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBCR", description: "GPIO B Lock Commit Register (GPIO32 to 63)", offset: "0xFC",
		bits: [
			{ name: "GPIO32", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Configuration lock commit bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Configuration lock commit bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Configuration lock commit bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Configuration lock commit bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Configuration lock commit bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Configuration lock commit bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Configuration lock commit bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Configuration lock commit bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Configuration lock commit bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCCTRL", description: "GPIO C Qualification Sampling Period Control (GPIO64 to 95)", offset: "0x100",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO64 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO72 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO80 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO88 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPCQSEL1", description: "GPIO C Qualifier Select 1 Register (GPIO64 to 79)", offset: "0x104",
		bits: [
			{ name: "GPIO64", description: "Select input qualification type for GPIO64", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO65", description: "Select input qualification type for GPIO65", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO66", description: "Select input qualification type for GPIO66", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO67", description: "Select input qualification type for GPIO67", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO68", description: "Select input qualification type for GPIO68", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO69", description: "Select input qualification type for GPIO69", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO70", description: "Select input qualification type for GPIO70", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO71", description: "Select input qualification type for GPIO71", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO72", description: "Select input qualification type for GPIO72", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO73", description: "Select input qualification type for GPIO73", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO74", description: "Select input qualification type for GPIO74", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO75", description: "Select input qualification type for GPIO75", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO76", description: "Select input qualification type for GPIO76", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO77", description: "Select input qualification type for GPIO77", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO78", description: "Select input qualification type for GPIO78", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO79", description: "Select input qualification type for GPIO79", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCQSEL2", description: "GPIO C Qualifier Select 2 Register (GPIO80  to 95)", offset: "0x108",
		bits: [
			{ name: "GPIO80", description: "Select input qualification type for GPIO80", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO81", description: "Select input qualification type for GPIO81", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO82", description: "Select input qualification type for GPIO82", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO83", description: "Select input qualification type for GPIO83", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO84", description: "Select input qualification type for GPIO84", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO85", description: "Select input qualification type for GPIO85", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO86", description: "Select input qualification type for GPIO86", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO87", description: "Select input qualification type for GPIO87", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO88", description: "Select input qualification type for GPIO88", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO89", description: "Select input qualification type for GPIO89", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO90", description: "Select input qualification type for GPIO90", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO91", description: "Select input qualification type for GPIO91", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO92", description: "Select input qualification type for GPIO92", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO93", description: "Select input qualification type for GPIO93", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO94", description: "Select input qualification type for GPIO94", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO95", description: "Select input qualification type for GPIO95", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCMUX1", description: "GPIO C Mux 1 Register (GPIO64 to 79)", offset: "0x10C",
		bits: [
			{ name: "GPIO64", description: "Defines pin-muxing selection for GPIO64", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO65", description: "Defines pin-muxing selection for GPIO65", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO66", description: "Defines pin-muxing selection for GPIO66", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO67", description: "Defines pin-muxing selection for GPIO67", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO68", description: "Defines pin-muxing selection for GPIO68", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO69", description: "Defines pin-muxing selection for GPIO69", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO70", description: "Defines pin-muxing selection for GPIO70", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO71", description: "Defines pin-muxing selection for GPIO71", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO72", description: "Defines pin-muxing selection for GPIO72", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO73", description: "Defines pin-muxing selection for GPIO73", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO74", description: "Defines pin-muxing selection for GPIO74", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO75", description: "Defines pin-muxing selection for GPIO75", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO76", description: "Defines pin-muxing selection for GPIO76", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO77", description: "Defines pin-muxing selection for GPIO77", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO78", description: "Defines pin-muxing selection for GPIO78", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO79", description: "Defines pin-muxing selection for GPIO79", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCMUX2", description: "GPIO C Mux 2 Register (GPIO80  to 95)", offset: "0x110",
		bits: [
			{ name: "GPIO80", description: "Defines pin-muxing selection for GPIO80", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO81", description: "Defines pin-muxing selection for GPIO81", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO82", description: "Defines pin-muxing selection for GPIO82", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO83", description: "Defines pin-muxing selection for GPIO83", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO84", description: "Defines pin-muxing selection for GPIO84", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO85", description: "Defines pin-muxing selection for GPIO85", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO86", description: "Defines pin-muxing selection for GPIO86", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO87", description: "Defines pin-muxing selection for GPIO87", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO88", description: "Defines pin-muxing selection for GPIO88", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO89", description: "Defines pin-muxing selection for GPIO89", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO90", description: "Defines pin-muxing selection for GPIO90", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO91", description: "Defines pin-muxing selection for GPIO91", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO92", description: "Defines pin-muxing selection for GPIO92", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO93", description: "Defines pin-muxing selection for GPIO93", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO94", description: "Defines pin-muxing selection for GPIO94", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO95", description: "Defines pin-muxing selection for GPIO95", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCPUD", description: "GPIO C Pull Up Disable Register (GPIO64 to 95)", offset: "0x118",
		bits: [
			{ name: "GPIO64", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Pull-Up Disable control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Pull-Up Disable control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Pull-Up Disable control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Pull-Up Disable control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Pull-Up Disable control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Pull-Up Disable control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Pull-Up Disable control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Pull-Up Disable control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Pull-Up Disable control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCINV", description: "GPIO C Input Polarity Invert Registers (GPIO64 to 95)", offset: "0x120",
		bits: [
			{ name: "GPIO64", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Input inversion control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Input inversion control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Input inversion control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Input inversion control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Input inversion control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Input inversion control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Input inversion control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Input inversion control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Input inversion control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCODR", description: "GPIO C Open Drain Output Register (GPIO64 to GPIO95)", offset: "0x124",
		bits: [
			{ name: "GPIO64", description: "Outpout Open-Drain control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Outpout Open-Drain control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Outpout Open-Drain control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Outpout Open-Drain control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Outpout Open-Drain control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Outpout Open-Drain control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Outpout Open-Drain control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Outpout Open-Drain control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Outpout Open-Drain control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Outpout Open-Drain control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Outpout Open-Drain control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Outpout Open-Drain control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Outpout Open-Drain control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Outpout Open-Drain control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Outpout Open-Drain control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Outpout Open-Drain control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Outpout Open-Drain control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Outpout Open-Drain control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Outpout Open-Drain control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Outpout Open-Drain control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Outpout Open-Drain control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Outpout Open-Drain control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Outpout Open-Drain control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Outpout Open-Drain control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Outpout Open-Drain control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Outpout Open-Drain control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Outpout Open-Drain control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Outpout Open-Drain control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Outpout Open-Drain control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Outpout Open-Drain control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Outpout Open-Drain control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Outpout Open-Drain control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCGMUX1", description: "GPIO C Peripheral Group Mux (GPIO64 to 79)", offset: "0x140",
		bits: [
			{ name: "GPIO64", description: "Defines pin-muxing selection for GPIO64", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO65", description: "Defines pin-muxing selection for GPIO65", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO66", description: "Defines pin-muxing selection for GPIO66", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO67", description: "Defines pin-muxing selection for GPIO67", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO68", description: "Defines pin-muxing selection for GPIO68", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO69", description: "Defines pin-muxing selection for GPIO69", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO70", description: "Defines pin-muxing selection for GPIO70", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO71", description: "Defines pin-muxing selection for GPIO71", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO72", description: "Defines pin-muxing selection for GPIO72", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO73", description: "Defines pin-muxing selection for GPIO73", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO74", description: "Defines pin-muxing selection for GPIO74", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO75", description: "Defines pin-muxing selection for GPIO75", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO76", description: "Defines pin-muxing selection for GPIO76", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO77", description: "Defines pin-muxing selection for GPIO77", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO78", description: "Defines pin-muxing selection for GPIO78", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO79", description: "Defines pin-muxing selection for GPIO79", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCGMUX2", description: "GPIO C Peripheral Group Mux (GPIO80  to 95)", offset: "0x144",
		bits: [
			{ name: "GPIO80", description: "Defines pin-muxing selection for GPIO80", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO81", description: "Defines pin-muxing selection for GPIO81", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO82", description: "Defines pin-muxing selection for GPIO82", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO83", description: "Defines pin-muxing selection for GPIO83", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO84", description: "Defines pin-muxing selection for GPIO84", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO85", description: "Defines pin-muxing selection for GPIO85", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO86", description: "Defines pin-muxing selection for GPIO86", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO87", description: "Defines pin-muxing selection for GPIO87", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO88", description: "Defines pin-muxing selection for GPIO88", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO89", description: "Defines pin-muxing selection for GPIO89", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO90", description: "Defines pin-muxing selection for GPIO90", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO91", description: "Defines pin-muxing selection for GPIO91", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO92", description: "Defines pin-muxing selection for GPIO92", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO93", description: "Defines pin-muxing selection for GPIO93", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO94", description: "Defines pin-muxing selection for GPIO94", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO95", description: "Defines pin-muxing selection for GPIO95", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPCCSEL1", description: "GPIO C Core Select Register (GPIO64 to 71)", offset: "0x150",
		bits: [
			{ name: "GPIO64", description: "GPIO64 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO65", description: "GPIO65 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO66", description: "GPIO66 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO67", description: "GPIO67 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO68", description: "GPIO68 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO69", description: "GPIO69 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO70", description: "GPIO70 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO71", description: "GPIO71 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPCCSEL2", description: "GPIO C Core Select Register (GPIO72 to 79)", offset: "0x154",
		bits: [
			{ name: "GPIO72", description: "GPIO72 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO73", description: "GPIO73 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO74", description: "GPIO74 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO75", description: "GPIO75 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO76", description: "GPIO76 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO77", description: "GPIO77 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO78", description: "GPIO78 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO79", description: "GPIO79 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPCCSEL3", description: "GPIO C Core Select Register (GPIO80  to 87)", offset: "0x158",
		bits: [
			{ name: "GPIO80", description: "GPIO80 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO81", description: "GPIO81 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO82", description: "GPIO82 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO83", description: "GPIO83 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO84", description: "GPIO84 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO85", description: "GPIO85 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO86", description: "GPIO86 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO87", description: "GPIO87 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPCCSEL4", description: "GPIO C Core Select Register (GPIO88 to 95)", offset: "0x15C",
		bits: [
			{ name: "GPIO88", description: "GPIO88 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO89", description: "GPIO89 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO90", description: "GPIO90 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO91", description: "GPIO91 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO92", description: "GPIO92 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO93", description: "GPIO93 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO94", description: "GPIO94 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO95", description: "GPIO95 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPCLOCK", description: "GPIO C Lock Configuration Register (GPIO64 to 95)", offset: "0x178",
		bits: [
			{ name: "GPIO64", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Configuration Lock bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Configuration Lock bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Configuration Lock bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Configuration Lock bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Configuration Lock bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Configuration Lock bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Configuration Lock bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Configuration Lock bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Configuration Lock bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCCR", description: "GPIO C Lock Commit Register (GPIO64 to 95)", offset: "0x17C",
		bits: [
			{ name: "GPIO64", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Configuration lock commit bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Configuration lock commit bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Configuration lock commit bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Configuration lock commit bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Configuration lock commit bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Configuration lock commit bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Configuration lock commit bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Configuration lock commit bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Configuration lock commit bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDCTRL", description: "GPIO D Qualification Sampling Period Control (GPIO96 to 127)", offset: "0x180",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO96 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO104 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO120 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPDQSEL1", description: "GPIO D Qualifier Select 1 Register (GPIO96 to 111)", offset: "0x184",
		bits: [
			{ name: "GPIO96", description: "Select input qualification type for GPIO96", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO97", description: "Select input qualification type for GPIO97", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO98", description: "Select input qualification type for GPIO98", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO99", description: "Select input qualification type for GPIO99", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO100", description: "Select input qualification type for GPIO100", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO101", description: "Select input qualification type for GPIO101", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO103", description: "Select input qualification type for GPIO103", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO105", description: "Select input qualification type for GPIO105", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPDQSEL2", description: "GPIO D Qualifier Select 2 Register (GPIO112 to 127)", offset: "0x188",
		bits: [
			{ name: "GPIO127", description: "Select input qualification type for GPIO127", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPDMUX1", description: "GPIO D Mux 1 Register (GPIO96 to 111)", offset: "0x18C",
		bits: [
			{ name: "GPIO96", description: "Defines pin-muxing selection for GPIO96", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO97", description: "Defines pin-muxing selection for GPIO97", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO98", description: "Defines pin-muxing selection for GPIO98", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO99", description: "Defines pin-muxing selection for GPIO99", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO100", description: "Defines pin-muxing selection for GPIO100", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO101", description: "Defines pin-muxing selection for GPIO101", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO103", description: "Defines pin-muxing selection for GPIO103", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO105", description: "Defines pin-muxing selection for GPIO105", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPDMUX2", description: "GPIO D Mux 2 Register (GPIO112 to 127)", offset: "0x190",
		bits: [
			{ name: "GPIO127", description: "Defines pin-muxing selection for GPIO127", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPDPUD", description: "GPIO D Pull Up Disable Register (GPIO96 to 127)", offset: "0x198",
		bits: [
			{ name: "GPIO96", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDINV", description: "GPIO D Input Polarity Invert Registers (GPIO96 to 127)", offset: "0x1A0",
		bits: [
			{ name: "GPIO96", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDODR", description: "GPIO D Open Drain Output Register (GPIO96 to GPIO127)", offset: "0x1A4",
		bits: [
			{ name: "GPIO96", description: "Outpout Open-Drain control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Outpout Open-Drain control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Outpout Open-Drain control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Outpout Open-Drain control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Outpout Open-Drain control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Outpout Open-Drain control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Outpout Open-Drain control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Outpout Open-Drain control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Outpout Open-Drain control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDGMUX1", description: "GPIO D Peripheral Group Mux (GPIO96 to 111)", offset: "0x1C0",
		bits: [
			{ name: "GPIO96", description: "Defines pin-muxing selection for GPIO96", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO97", description: "Defines pin-muxing selection for GPIO97", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO98", description: "Defines pin-muxing selection for GPIO98", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO99", description: "Defines pin-muxing selection for GPIO99", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO100", description: "Defines pin-muxing selection for GPIO100", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO101", description: "Defines pin-muxing selection for GPIO101", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO103", description: "Defines pin-muxing selection for GPIO103", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO105", description: "Defines pin-muxing selection for GPIO105", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPDGMUX2", description: "GPIO D Peripheral Group Mux (GPIO112 to 127)", offset: "0x1C4",
		bits: [
			{ name: "GPIO127", description: "Defines pin-muxing selection for GPIO127", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPDCSEL1", description: "GPIO D Core Select Register (GPIO96 to 103)", offset: "0x1D0",
		bits: [
			{ name: "GPIO96", description: "GPIO96 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO97", description: "GPIO97 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO98", description: "GPIO98 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO99", description: "GPIO99 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO100", description: "GPIO100 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO101", description: "GPIO101 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO103", description: "GPIO103 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPDCSEL2", description: "GPIO D Core Select Register (GPIO104 to 111)", offset: "0x1D4",
		bits: [
			{ name: "GPIO105", description: "GPIO105 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
		]
	},
	{ name: "GPDCSEL4", description: "GPIO D Core Select Register (GPIO120 to 127)", offset: "0x1DC",
		bits: [
			{ name: "GPIO127", description: "GPIO127 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPDLOCK", description: "GPIO D Lock Configuration Register (GPIO96 to 127)", offset: "0x1F8",
		bits: [
			{ name: "GPIO96", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDCR", description: "GPIO D Lock Commit Register (GPIO96 to 127)", offset: "0x1FC",
		bits: [
			{ name: "GPIO96", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFCTRL", description: "GPIO F Qualification Sampling Period Control (GPIO160 to 191)", offset: "0x280",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO160 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO168", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO176 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO184 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPFQSEL1", description: "GPIO F Qualifier Select 1 Register (GPIO160 to 168)", offset: "0x284",
		bits: [
			{ name: "GPIO160", description: "Select input qualification type for GPIO160", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO161", description: "Select input qualification type for GPIO161", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO162", description: "Select input qualification type for GPIO162", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO163", description: "Select input qualification type for GPIO163", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO164", description: "Select input qualification type for GPIO164", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO165", description: "Select input qualification type for GPIO165", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO166", description: "Select input qualification type for GPIO166", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO167", description: "Select input qualification type for GPIO167", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO168", description: "Select input qualification type for GPIO168", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO169", description: "Select input qualification type for GPIO169", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO170", description: "Select input qualification type for GPIO170", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO171", description: "Select input qualification type for GPIO171", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO172", description: "Select input qualification type for GPIO172", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO173", description: "Select input qualification type for GPIO173", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO174", description: "Select input qualification type for GPIO174", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO175", description: "Select input qualification type for GPIO175", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFQSEL2", description: "GPIO F Qualifier Select 2 Register (GPIO176 to 191)", offset: "0x288",
		bits: [
			{ name: "GPIO176", description: "Select input qualification type for GPIO176", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO177", description: "Select input qualification type for GPIO177", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO178", description: "Select input qualification type for GPIO178", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO179", description: "Select input qualification type for GPIO179", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO180", description: "Select input qualification type for GPIO180", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO181", description: "Select input qualification type for GPIO181", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO182", description: "Select input qualification type for GPIO182", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO183", description: "Select input qualification type for GPIO183", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO184", description: "Select input qualification type for GPIO184", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO185", description: "Select input qualification type for GPIO185", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO186", description: "Select input qualification type for GPIO186", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO187", description: "Select input qualification type for GPIO187", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO188", description: "Select input qualification type for GPIO188", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO189", description: "Select input qualification type for GPIO189", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO190", description: "Select input qualification type for GPIO190", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO191", description: "Select input qualification type for GPIO191", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFMUX1", description: "GPIO F Mux 1 Register (GPIO160 to 175)", offset: "0x28C",
		bits: [
			{ name: "GPIO160", description: "Defines pin-muxing selection for GPIO160", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO161", description: "Defines pin-muxing selection for GPIO161", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO162", description: "Defines pin-muxing selection for GPIO162", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO163", description: "Defines pin-muxing selection for GPIO163", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO164", description: "Defines pin-muxing selection for GPIO164", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO165", description: "Defines pin-muxing selection for GPIO165", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO166", description: "Defines pin-muxing selection for GPIO166", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO167", description: "Defines pin-muxing selection for GPIO167", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO168", description: "Defines pin-muxing selection for GPIO168", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO169", description: "Defines pin-muxing selection for GPIO169", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO170", description: "Defines pin-muxing selection for GPIO170", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO171", description: "Defines pin-muxing selection for GPIO171", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO172", description: "Defines pin-muxing selection for GPIO172", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO173", description: "Defines pin-muxing selection for GPIO173", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO174", description: "Defines pin-muxing selection for GPIO174", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO175", description: "Defines pin-muxing selection for GPIO175", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFMUX2", description: "GPIO F Mux 2 Register (GPIO176 to 191)", offset: "0x290",
		bits: [
			{ name: "GPIO176", description: "Defines pin-muxing selection for GPIO176", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO177", description: "Defines pin-muxing selection for GPIO177", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO178", description: "Defines pin-muxing selection for GPIO178", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO179", description: "Defines pin-muxing selection for GPIO179", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO180", description: "Defines pin-muxing selection for GPIO180", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO181", description: "Defines pin-muxing selection for GPIO181", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO182", description: "Defines pin-muxing selection for GPIO182", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO183", description: "Defines pin-muxing selection for GPIO183", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO184", description: "Defines pin-muxing selection for GPIO184", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO185", description: "Defines pin-muxing selection for GPIO185", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO186", description: "Defines pin-muxing selection for GPIO186", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO187", description: "Defines pin-muxing selection for GPIO187", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO188", description: "Defines pin-muxing selection for GPIO188", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO189", description: "Defines pin-muxing selection for GPIO189", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO190", description: "Defines pin-muxing selection for GPIO190", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO191", description: "Defines pin-muxing selection for GPIO191", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFPUD", description: "GPIO F Pull Up Disable Register (GPIO160 to 191)", offset: "0x298",
		bits: [
			{ name: "GPIO160", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Pull-Up Disable control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Pull-Up Disable control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Pull-Up Disable control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Pull-Up Disable control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Pull-Up Disable control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Pull-Up Disable control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Pull-Up Disable control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Pull-Up Disable control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Pull-Up Disable control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFINV", description: "GPIO F Input Polarity Invert Registers (GPIO160 to 191)", offset: "0x2A0",
		bits: [
			{ name: "GPIO160", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Input inversion control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Input inversion control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Input inversion control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Input inversion control for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Input inversion control for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Input inversion control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Input inversion control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Input inversion control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Input inversion control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFAMSEL", description: "GPIO F Analog Mode Select register (GPIO160 to GPIO191)", offset: "0x2A8",
		bits: [
			{ name: "GPIO160", description: "Analog Mode select for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Analog Mode select for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Analog Mode select for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Analog Mode select for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Analog Mode select for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Analog Mode select for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Analog Mode select for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Analog Mode select for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Analog Mode select for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Analog Mode select for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Analog Mode select for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Analog Mode select for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Analog Mode select for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Analog Mode select for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Analog Mode select for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Analog Mode select for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Analog Mode select for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Analog Mode select for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Analog Mode select for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Analog Mode select for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Analog Mode select for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Analog Mode select for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Analog Mode select for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Analog Mode select for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Analog Mode select for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Analog Mode select for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Analog Mode select for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Analog Mode select for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Analog Mode select for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Analog Mode select for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Analog Mode select for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Analog Mode select for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFGMUX1", description: "GPIO F Peripheral Group Mux (GPIO160 to 175)", offset: "0x2C0",
		bits: [
			{ name: "GPIO160", description: "Defines pin-muxing selection for GPIO160", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO161", description: "Defines pin-muxing selection for GPIO161", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO162", description: "Defines pin-muxing selection for GPIO162", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO163", description: "Defines pin-muxing selection for GPIO163", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO164", description: "Defines pin-muxing selection for GPIO164", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO165", description: "Defines pin-muxing selection for GPIO165", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO166", description: "Defines pin-muxing selection for GPIO166", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO167", description: "Defines pin-muxing selection for GPIO167", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO168", description: "Defines pin-muxing selection for GPIO168", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO169", description: "Defines pin-muxing selection for GPIO169", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO170", description: "Defines pin-muxing selection for GPIO170", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO171", description: "Defines pin-muxing selection for GPIO171", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO172", description: "Defines pin-muxing selection for GPIO172", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO173", description: "Defines pin-muxing selection for GPIO173", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO174", description: "Defines pin-muxing selection for GPIO174", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO175", description: "Defines pin-muxing selection for GPIO175", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFGMUX2", description: "GPIO F Peripheral Group Mux (GPIO176 to 191)", offset: "0x2C4",
		bits: [
			{ name: "GPIO176", description: "Defines pin-muxing selection for GPIO176", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO177", description: "Defines pin-muxing selection for GPIO177", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO178", description: "Defines pin-muxing selection for GPIO178", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO179", description: "Defines pin-muxing selection for GPIO179", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO180", description: "Defines pin-muxing selection for GPIO180", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO181", description: "Defines pin-muxing selection for GPIO181", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO182", description: "Defines pin-muxing selection for GPIO182", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO183", description: "Defines pin-muxing selection for GPIO183", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO184", description: "Defines pin-muxing selection for GPIO184", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO185", description: "Defines pin-muxing selection for GPIO185", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO186", description: "Defines pin-muxing selection for GPIO186", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO187", description: "Defines pin-muxing selection for GPIO187", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO188", description: "Defines pin-muxing selection for GPIO188", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO189", description: "Defines pin-muxing selection for GPIO189", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO190", description: "Defines pin-muxing selection for GPIO190", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO191", description: "Defines pin-muxing selection for GPIO191", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPFCSEL1", description: "GPIO F Core Select Register (GPIO160 to 167)", offset: "0x2D0",
		bits: [
			{ name: "GPIO160", description: "GPIO160 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO161", description: "GPIO161 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO162", description: "GPIO162 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO163", description: "GPIO163 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO164", description: "GPIO164 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO165", description: "GPIO165 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO166", description: "GPIO166 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO167", description: "GPIO167 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPFCSEL2", description: "GPIO F Core Select Register (GPIO168 to 175)", offset: "0x2D4",
		bits: [
			{ name: "GPIO168", description: "GPIO168 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO169", description: "GPIO169 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO170", description: "GPIO170 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO171", description: "GPIO171 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO172", description: "GPIO172 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO173", description: "GPIO173 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO174", description: "GPIO174 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO175", description: "GPIO175 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPFCSEL3", description: "GPIO F Core Select Register (GPIO176 to 183)", offset: "0x2D8",
		bits: [
			{ name: "GPIO176", description: "GPIO176 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO177", description: "GPIO177 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO178", description: "GPIO178 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO179", description: "GPIO179 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO180", description: "GPIO180 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO181", description: "GPIO181 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO182", description: "GPIO182 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO183", description: "GPIO183 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPFCSEL4", description: "GPIO F Core Select Register (GPIO184 to 191)", offset: "0x2DC",
		bits: [
			{ name: "GPIO184", description: "GPIO184 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO185", description: "GPIO185 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO186", description: "GPIO186 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO187", description: "GPIO187 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO188", description: "GPIO188 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO189", description: "GPIO189 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO190", description: "GPIO190 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO191", description: "GPIO191 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPFLOCK", description: "GPIO F Lock Configuration Register (GPIO160 to 191)", offset: "0x2F8",
		bits: [
			{ name: "GPIO160", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Configuration Lock bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Configuration Lock bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Configuration Lock bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Configuration Lock bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Configuration Lock bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Configuration Lock bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Configuration Lock bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Configuration Lock bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Configuration Lock bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFCR", description: "GPIO F Lock Commit Register (GPIO160 to 191)", offset: "0x2FC",
		bits: [
			{ name: "GPIO160", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Configuration lock commit bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Configuration lock commit bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Configuration lock commit bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Configuration lock commit bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Configuration lock commit bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Configuration lock commit bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Configuration lock commit bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Configuration lock commit bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Configuration lock commit bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGCTRL", description: "GPIO G Qualification Sampling Period Control (GPIO192 to 223)", offset: "0x300",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO192 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO200 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO208 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO216 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPGQSEL1", description: "GPIO G Qualifier Select 1 Register (GPIO192 to 207)", offset: "0x304",
		bits: [
			{ name: "GPIO192", description: "Select input qualification type for GPIO192", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO193", description: "Select input qualification type for GPIO193", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO194", description: "Select input qualification type for GPIO194", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO195", description: "Select input qualification type for GPIO195", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO196", description: "Select input qualification type for GPIO196", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO197", description: "Select input qualification type for GPIO197", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO198", description: "Select input qualification type for GPIO198", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO199", description: "Select input qualification type for GPIO199", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO200", description: "Select input qualification type for GPIO200", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO201", description: "Select input qualification type for GPIO201", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO202", description: "Select input qualification type for GPIO202", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO203", description: "Select input qualification type for GPIO203", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO204", description: "Select input qualification type for GPIO204", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO205", description: "Select input qualification type for GPIO205", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO206", description: "Select input qualification type for GPIO206", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO207", description: "Select input qualification type for GPIO207", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGQSEL2", description: "GPIO G Qualifier Select 2 Register (GPIO208 to 223)", offset: "0x308",
		bits: [
			{ name: "GPIO208", description: "Select input qualification type for GPIO208", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO209", description: "Select input qualification type for GPIO209", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO210", description: "Select input qualification type for GPIO210", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO211", description: "Select input qualification type for GPIO211", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO212", description: "Select input qualification type for GPIO212", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO213", description: "Select input qualification type for GPIO213", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO219", description: "Select input qualification type for GPIO219", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO220", description: "Select input qualification type for GPIO220", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO221", description: "Select input qualification type for GPIO221", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO222", description: "Select input qualification type for GPIO222", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO223", description: "Select input qualification type for GPIO223", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGMUX1", description: "GPIO G Mux 1 Register (GPIO192 to 207)", offset: "0x30C",
		bits: [
			{ name: "GPIO192", description: "Defines pin-muxing selection for GPIO192", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO193", description: "Defines pin-muxing selection for GPIO193", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO194", description: "Defines pin-muxing selection for GPIO194", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO195", description: "Defines pin-muxing selection for GPIO195", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO196", description: "Defines pin-muxing selection for GPIO196", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO197", description: "Defines pin-muxing selection for GPIO197", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO198", description: "Defines pin-muxing selection for GPIO198", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO199", description: "Defines pin-muxing selection for GPIO199", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO200", description: "Defines pin-muxing selection for GPIO200", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO201", description: "Defines pin-muxing selection for GPIO201", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO202", description: "Defines pin-muxing selection for GPIO202", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO203", description: "Defines pin-muxing selection for GPIO203", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO204", description: "Defines pin-muxing selection for GPIO204", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO205", description: "Defines pin-muxing selection for GPIO205", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO206", description: "Defines pin-muxing selection for GPIO206", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO207", description: "Defines pin-muxing selection for GPIO207", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGMUX2", description: "GPIO G Mux 2 Register (GPIO208 to 223)", offset: "0x310",
		bits: [
			{ name: "GPIO208", description: "Defines pin-muxing selection for GPIO208", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO209", description: "Defines pin-muxing selection for GPIO209", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO210", description: "Defines pin-muxing selection for GPIO210", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO211", description: "Defines pin-muxing selection for GPIO211", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO212", description: "Defines pin-muxing selection for GPIO212", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO213", description: "Defines pin-muxing selection for GPIO213", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO219", description: "Defines pin-muxing selection for GPIO219", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO220", description: "Defines pin-muxing selection for GPIO220", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO221", description: "Defines pin-muxing selection for GPIO221", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO222", description: "Defines pin-muxing selection for GPIO222", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO223", description: "Defines pin-muxing selection for GPIO223", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGPUD", description: "GPIO G Pull Up Disable Register (GPIO192 to 223)", offset: "0x318",
		bits: [
			{ name: "GPIO192", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO219", description: "Pull-Up Disable control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Pull-Up Disable control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Pull-Up Disable control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Pull-Up Disable control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Pull-Up Disable control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGINV", description: "GPIO G Input Polarity Invert Registers (GPIO192 to 223)", offset: "0x320",
		bits: [
			{ name: "GPIO192", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO219", description: "Input inversion control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Input inversion control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Input inversion control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Input inversion control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Input inversion control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGODR", description: "GPIO G Open Drain Output Register (GPIO192 to 223)", offset: "0x324",
		bits: [
			{ name: "GPIO219", description: "Outpout Open-Drain control for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Outpout Open-Drain control for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Outpout Open-Drain control for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Outpout Open-Drain control for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Outpout Open-Drain control for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGAMSEL", description: "GPIO G Analog Mode Select register (GPIO192 to 223)", offset: "0x328",
		bits: [
			{ name: "GPIO192", description: "Analog Mode select for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Analog Mode select for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Analog Mode select for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Analog Mode select for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Analog Mode select for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Analog Mode select for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Analog Mode select for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Analog Mode select for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Analog Mode select for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Analog Mode select for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Analog Mode select for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Analog Mode select for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Analog Mode select for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Analog Mode select for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Analog Mode select for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Analog Mode select for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Analog Mode select for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Analog Mode select for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Analog Mode select for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Analog Mode select for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Analog Mode select for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Analog Mode select for this pin", size: "1", shift: "21", mask: "0x200000" },
		]
	},
	{ name: "GPGGMUX1", description: "GPIO G Peripheral Group Mux (GPIO192 to 207)", offset: "0x340",
		bits: [
			{ name: "GPIO192", description: "Defines pin-muxing selection for GPIO192", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO193", description: "Defines pin-muxing selection for GPIO193", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO194", description: "Defines pin-muxing selection for GPIO194", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO195", description: "Defines pin-muxing selection for GPIO195", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO196", description: "Defines pin-muxing selection for GPIO196", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO197", description: "Defines pin-muxing selection for GPIO197", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO198", description: "Defines pin-muxing selection for GPIO198", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO199", description: "Defines pin-muxing selection for GPIO199", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO200", description: "Defines pin-muxing selection for GPIO200", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO201", description: "Defines pin-muxing selection for GPIO201", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO202", description: "Defines pin-muxing selection for GPIO202", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO203", description: "Defines pin-muxing selection for GPIO203", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO204", description: "Defines pin-muxing selection for GPIO204", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO205", description: "Defines pin-muxing selection for GPIO205", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO206", description: "Defines pin-muxing selection for GPIO206", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO207", description: "Defines pin-muxing selection for GPIO207", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGGMUX2", description: "GPIO G Peripheral Group Mux (GPIO208 to 223)", offset: "0x344",
		bits: [
			{ name: "GPIO208", description: "Defines pin-muxing selection for GPIO208", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO209", description: "Defines pin-muxing selection for GPIO209", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO210", description: "Defines pin-muxing selection for GPIO210", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO211", description: "Defines pin-muxing selection for GPIO211", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO212", description: "Defines pin-muxing selection for GPIO212", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO213", description: "Defines pin-muxing selection for GPIO213", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO219", description: "Defines pin-muxing selection for GPIO219", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO220", description: "Defines pin-muxing selection for GPIO220", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO221", description: "Defines pin-muxing selection for GPIO221", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO222", description: "Defines pin-muxing selection for GPIO222", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO223", description: "Defines pin-muxing selection for GPIO223", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPGCSEL1", description: "GPIO G Core Select Register (GPIO192 to 199)", offset: "0x350",
		bits: [
			{ name: "GPIO192", description: "GPIO192 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO193", description: "GPIO193 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO194", description: "GPIO194 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO195", description: "GPIO195 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO196", description: "GPIO196 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO197", description: "GPIO197 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO198", description: "GPIO198 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO199", description: "GPIO199 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPGCSEL2", description: "GPIO G Core Select Register (GPIO200 to 207)", offset: "0x354",
		bits: [
			{ name: "GPIO200", description: "GPIO200 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO201", description: "GPIO201 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO202", description: "GPIO202 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO203", description: "GPIO203 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO204", description: "GPIO204 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO205", description: "GPIO205 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO206", description: "GPIO206 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO207", description: "GPIO207 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPGCSEL3", description: "GPIO G Core Select Register (GPIO208 to 215)", offset: "0x358",
		bits: [
			{ name: "GPIO208", description: "GPIO208 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO209", description: "GPIO209 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO210", description: "GPIO210 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO211", description: "GPIO211 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO212", description: "GPIO212 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO213", description: "GPIO213 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
		]
	},
	{ name: "GPGCSEL4", description: "GPIO G Core Select Register (GPIO216 to 223)", offset: "0x35C",
		bits: [
			{ name: "GPIO219", description: "GPIO219 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO220", description: "GPIO220 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO221", description: "GPIO221 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO222", description: "GPIO222 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO223", description: "GPIO223 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPGLOCK", description: "GPIO G Lock Configuration Register (GPIO192 to 223)", offset: "0x378",
		bits: [
			{ name: "GPIO192", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO219", description: "Configuration Lock bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Configuration Lock bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Configuration Lock bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Configuration Lock bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Configuration Lock bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGCR", description: "GPIO G Lock Commit Register (GPIO192 to 223)", offset: "0x37C",
		bits: [
			{ name: "GPIO192", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO219", description: "Configuration lock commit bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Configuration lock commit bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Configuration lock commit bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Configuration lock commit bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Configuration lock commit bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPHCTRL", description: "GPIO H Qualification Sampling Period Control (GPIO224 to 255)", offset: "0x380",
		bits: [
			{ name: "QUALPRD0", description: "Qualification sampling period for GPIO224 to", size: "8", shift: "0", mask: "0xFF" },
			{ name: "QUALPRD1", description: "Qualification sampling period for GPIO232 to", size: "8", shift: "8", mask: "0xFF00" },
			{ name: "QUALPRD2", description: "Qualification sampling period for GPIO240 to", size: "8", shift: "16", mask: "0xFF0000" },
			{ name: "QUALPRD3", description: "Qualification sampling period for GPIO248 to", size: "8", shift: "24", mask: "0xFF000000" },
		]
	},
	{ name: "GPHQSEL1", description: "GPIO H Qualifier Select 1 Register (GPIO224 to 239)", offset: "0x384",
		bits: [
			{ name: "GPIO224", description: "Select input qualification type for this GPIO", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO225", description: "Select input qualification type for this GPIO", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO226", description: "Select input qualification type for this GPIO", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO227", description: "Select input qualification type for this GPIO", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO228", description: "Select input qualification type for this GPIO", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO229", description: "Select input qualification type for this GPIO", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO230", description: "Select input qualification type for this GPIO", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO231", description: "Select input qualification type for this GPIO", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO232", description: "Select input qualification type for this GPIO", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO233", description: "Select input qualification type for this GPIO", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO234", description: "Select input qualification type for this GPIO", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO235", description: "Select input qualification type for this GPIO", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO236", description: "Select input qualification type for this GPIO", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO237", description: "Select input qualification type for this GPIO", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO238", description: "Select input qualification type for this GPIO", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO239", description: "Select input qualification type for this GPIO", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPHQSEL2", description: "GPIO H Qualifier Select 2 Register (GPIO240 to 255)", offset: "0x388",
		bits: [
			{ name: "GPIO240", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO241", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO242", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO243", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO244", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO245", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO246", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO247", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO248", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO249", description: "Select input qualification type for this GPIO Pin", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPHMUX1", description: "GPIO H Mux 1 Register (GPIO224 to 239)", offset: "0x38C",
		bits: [
			{ name: "GPIO224", description: "Defines pin-muxing selection for GPIO224", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO225", description: "Defines pin-muxing selection for GPIO225", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO226", description: "Defines pin-muxing selection for GPIO226", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO227", description: "Defines pin-muxing selection for GPIO227", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO228", description: "Defines pin-muxing selection for GPIO228", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO229", description: "Defines pin-muxing selection for GPIO229", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO230", description: "Defines pin-muxing selection for GPIO230", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO231", description: "Defines pin-muxing selection for GPIO231", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO232", description: "Defines pin-muxing selection for GPIO232", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO233", description: "Defines pin-muxing selection for GPIO233", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO234", description: "Defines pin-muxing selection for GPIO234", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO235", description: "Defines pin-muxing selection for GPIO235", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO236", description: "Defines pin-muxing selection for GPIO236", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO237", description: "Defines pin-muxing selection for GPIO237", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO238", description: "Defines pin-muxing selection for GPIO238", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO239", description: "Defines pin-muxing selection for GPIO239", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPHMUX2", description: "GPIO H Mux 2 Register (GPIO240 to 255)", offset: "0x390",
		bits: [
			{ name: "GPIO240", description: "Defines pin-muxing selection for GPIO240", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO241", description: "Defines pin-muxing selection for GPIO241", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO242", description: "Defines pin-muxing selection for GPIO242", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO243", description: "Defines pin-muxing selection for GPIO243", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO244", description: "Defines pin-muxing selection for GPIO244", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO245", description: "Defines pin-muxing selection for GPIO245", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO246", description: "Defines pin-muxing selection for GPIO246", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO247", description: "Defines pin-muxing selection for GPIO247", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO248", description: "Defines pin-muxing selection for GPIO248", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO249", description: "Defines pin-muxing selection for GPIO249", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPHPUD", description: "GPIO H Pull Up Disable Register (GPIO224 to 255)", offset: "0x398",
		bits: [
			{ name: "GPIO224", description: "Pull-Up Disable control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Pull-Up Disable control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Pull-Up Disable control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Pull-Up Disable control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Pull-Up Disable control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Pull-Up Disable control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Pull-Up Disable control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Pull-Up Disable control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Pull-Up Disable control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Pull-Up Disable control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Pull-Up Disable control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Pull-Up Disable control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Pull-Up Disable control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Pull-Up Disable control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Pull-Up Disable control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Pull-Up Disable control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Pull-Up Disable control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Pull-Up Disable control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Pull-Up Disable control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Pull-Up Disable control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Pull-Up Disable control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Pull-Up Disable control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Pull-Up Disable control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Pull-Up Disable control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Pull-Up Disable control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Pull-Up Disable control for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHINV", description: "GPIO H Input Polarity Invert Registers (GPIO224 to 255)", offset: "0x3A0",
		bits: [
			{ name: "GPIO224", description: "Input inversion control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Input inversion control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Input inversion control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Input inversion control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Input inversion control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Input inversion control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Input inversion control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Input inversion control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Input inversion control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Input inversion control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Input inversion control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Input inversion control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Input inversion control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Input inversion control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Input inversion control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Input inversion control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Input inversion control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Input inversion control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Input inversion control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Input inversion control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Input inversion control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Input inversion control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Input inversion control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Input inversion control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Input inversion control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Input inversion control for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHODR", description: "GPIO H Open Drain Output Register (GPIO224 to GPIO255)", offset: "0x3A4",
		bits: [
			{ name: "GPIO224", description: "Outpout Open-Drain control for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Outpout Open-Drain control for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Outpout Open-Drain control for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Outpout Open-Drain control for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Outpout Open-Drain control for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Outpout Open-Drain control for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Outpout Open-Drain control for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Outpout Open-Drain control for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Outpout Open-Drain control for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Outpout Open-Drain control for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Outpout Open-Drain control for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Outpout Open-Drain control for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Outpout Open-Drain control for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Outpout Open-Drain control for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Outpout Open-Drain control for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Outpout Open-Drain control for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Outpout Open-Drain control for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Outpout Open-Drain control for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Outpout Open-Drain control for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Outpout Open-Drain control for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Outpout Open-Drain control for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Outpout Open-Drain control for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Outpout Open-Drain control for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Outpout Open-Drain control for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Outpout Open-Drain control for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Outpout Open-Drain control for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHAMSEL", description: "GPIO H Analog Mode Select register (GPIO224 to GPIO255)", offset: "0x3A8",
		bits: [
			{ name: "GPIO224", description: "Analog Mode select for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Analog Mode select for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Analog Mode select for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Analog Mode select for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Analog Mode select for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Analog Mode select for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Analog Mode select for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Analog Mode select for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Analog Mode select for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Analog Mode select for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Analog Mode select for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Analog Mode select for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Analog Mode select for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Analog Mode select for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Analog Mode select for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Analog Mode select for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Analog Mode select for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Analog Mode select for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Analog Mode select for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Analog Mode select for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Analog Mode select for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Analog Mode select for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Analog Mode select for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Analog Mode select for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Analog Mode select for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Analog Mode select for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHGMUX1", description: "GPIO H Peripheral Group Mux (GPIO224 to 239)", offset: "0x3C0",
		bits: [
			{ name: "GPIO224", description: "Defines pin-muxing selection for GPIO224", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO225", description: "Defines pin-muxing selection for GPIO225", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO226", description: "Defines pin-muxing selection for GPIO226", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO227", description: "Defines pin-muxing selection for GPIO227", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO228", description: "Defines pin-muxing selection for GPIO228", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO229", description: "Defines pin-muxing selection for GPIO229", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO230", description: "Defines pin-muxing selection for GPIO230", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO231", description: "Defines pin-muxing selection for GPIO231", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO232", description: "Defines pin-muxing selection for GPIO232", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO233", description: "Defines pin-muxing selection for GPIO233", size: "2", shift: "18", mask: "0xC0000" },
			{ name: "GPIO234", description: "Defines pin-muxing selection for GPIO234", size: "2", shift: "20", mask: "0x300000" },
			{ name: "GPIO235", description: "Defines pin-muxing selection for GPIO235", size: "2", shift: "22", mask: "0xC00000" },
			{ name: "GPIO236", description: "Defines pin-muxing selection for GPIO236", size: "2", shift: "24", mask: "0x3000000" },
			{ name: "GPIO237", description: "Defines pin-muxing selection for GPIO237", size: "2", shift: "26", mask: "0xC000000" },
			{ name: "GPIO238", description: "Defines pin-muxing selection for GPIO238", size: "2", shift: "28", mask: "0x30000000" },
			{ name: "GPIO239", description: "Defines pin-muxing selection for GPIO239", size: "2", shift: "30", mask: "0xC0000000" },
		]
	},
	{ name: "GPHGMUX2", description: "GPIO H Peripheral Group Mux (GPIO240 to 255)", offset: "0x3C4",
		bits: [
			{ name: "GPIO240", description: "Defines pin-muxing selection for GPIO240", size: "2", shift: "0", mask: "0x3" },
			{ name: "GPIO241", description: "Defines pin-muxing selection for GPIO241", size: "2", shift: "2", mask: "0xC" },
			{ name: "GPIO242", description: "Defines pin-muxing selection for GPIO242", size: "2", shift: "4", mask: "0x30" },
			{ name: "GPIO243", description: "Defines pin-muxing selection for GPIO243", size: "2", shift: "6", mask: "0xC0" },
			{ name: "GPIO244", description: "Defines pin-muxing selection for GPIO244", size: "2", shift: "8", mask: "0x300" },
			{ name: "GPIO245", description: "Defines pin-muxing selection for GPIO245", size: "2", shift: "10", mask: "0xC00" },
			{ name: "GPIO246", description: "Defines pin-muxing selection for GPIO246", size: "2", shift: "12", mask: "0x3000" },
			{ name: "GPIO247", description: "Defines pin-muxing selection for GPIO247", size: "2", shift: "14", mask: "0xC000" },
			{ name: "GPIO248", description: "Defines pin-muxing selection for GPIO248", size: "2", shift: "16", mask: "0x30000" },
			{ name: "GPIO249", description: "Defines pin-muxing selection for GPIO249", size: "2", shift: "18", mask: "0xC0000" },
		]
	},
	{ name: "GPHCSEL1", description: "GPIO H Core Select Register (GPIO224 to 231)", offset: "0x3D0",
		bits: [
			{ name: "GPIO224", description: "GPIO224 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO225", description: "GPIO225 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO226", description: "GPIO226 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO227", description: "GPIO227 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO228", description: "GPIO228 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO229", description: "GPIO229 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO230", description: "GPIO230 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO231", description: "GPIO231 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPHCSEL2", description: "GPIO H Core Select Register (GPIO232 to 239)", offset: "0x3D4",
		bits: [
			{ name: "GPIO232", description: "GPIO232 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO233", description: "GPIO233 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO234", description: "GPIO234 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO235", description: "GPIO235 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO236", description: "GPIO236 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO237", description: "GPIO237 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO238", description: "GPIO238 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO239", description: "GPIO239 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPHCSEL3", description: "GPIO H Core Select Register (GPIO240 to 247)", offset: "0x3D8",
		bits: [
			{ name: "GPIO240", description: "GPIO240 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO241", description: "GPIO241 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
			{ name: "GPIO242", description: "GPIO242 Controller CPU Select", size: "4", shift: "8", mask: "0xF00" },
			{ name: "GPIO243", description: "GPIO243 Controller CPU Select", size: "4", shift: "12", mask: "0xF000" },
			{ name: "GPIO244", description: "GPIO244 Controller CPU Select", size: "4", shift: "16", mask: "0xF0000" },
			{ name: "GPIO245", description: "GPIO245 Controller CPU Select", size: "4", shift: "20", mask: "0xF00000" },
			{ name: "GPIO246", description: "GPIO246 Controller CPU Select", size: "4", shift: "24", mask: "0xF000000" },
			{ name: "GPIO247", description: "GPIO247 Controller CPU Select", size: "4", shift: "28", mask: "0xF0000000" },
		]
	},
	{ name: "GPHCSEL4", description: "GPIO H Core Select Register (GPIO248 to 255)", offset: "0x3DC",
		bits: [
			{ name: "GPIO248", description: "GPIO248 Controller CPU Select", size: "4", shift: "0", mask: "0xF" },
			{ name: "GPIO249", description: "GPIO249 Controller CPU Select", size: "4", shift: "4", mask: "0xF0" },
		]
	},
	{ name: "GPHLOCK", description: "GPIO H Lock Configuration Register (GPIO224 to 255)", offset: "0x3F8",
		bits: [
			{ name: "GPIO224", description: "Configuration Lock bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Configuration Lock bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Configuration Lock bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Configuration Lock bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Configuration Lock bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Configuration Lock bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Configuration Lock bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Configuration Lock bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Configuration Lock bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Configuration Lock bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Configuration Lock bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Configuration Lock bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Configuration Lock bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Configuration Lock bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Configuration Lock bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Configuration Lock bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Configuration Lock bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Configuration Lock bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Configuration Lock bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Configuration Lock bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Configuration Lock bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Configuration Lock bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Configuration Lock bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Configuration Lock bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Configuration Lock bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Configuration Lock bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHCR", description: "GPIO H Lock Commit Register (GPIO224 to 255)", offset: "0x3FC",
		bits: [
			{ name: "GPIO224", description: "Configuration lock commit bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Configuration lock commit bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Configuration lock commit bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Configuration lock commit bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Configuration lock commit bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Configuration lock commit bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Configuration lock commit bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Configuration lock commit bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Configuration lock commit bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Configuration lock commit bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Configuration lock commit bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Configuration lock commit bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Configuration lock commit bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Configuration lock commit bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Configuration lock commit bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Configuration lock commit bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Configuration lock commit bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Configuration lock commit bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Configuration lock commit bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Configuration lock commit bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Configuration lock commit bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Configuration lock commit bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Configuration lock commit bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Configuration lock commit bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Configuration lock commit bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Configuration lock commit bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPADAT", description: "GPIO A Data Register (GPIO0 to 31)", offset: "0x0",
		bits: [
			{ name: "GPIO0", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Data Register for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Data Register for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Data Register for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Data Register for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Data Register for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Data Register for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Data Register for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Data Register for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Data Register for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPASET", description: "GPIO A Data Set Register (GPIO0 to 31)", offset: "0x4",
		bits: [
			{ name: "GPIO0", description: "Output Set bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Output Set bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Output Set bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Output Set bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Output Set bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Output Set bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Output Set bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Output Set bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Output Set bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Output Set bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Output Set bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Output Set bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Output Set bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Output Set bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Output Set bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Output Set bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Output Set bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Output Set bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Output Set bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Output Set bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Output Set bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Output Set bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Output Set bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Output Set bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Output Set bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Output Set bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Output Set bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Output Set bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Output Set bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Output Set bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Output Set bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Output Set bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPACLEAR", description: "GPIO A Data Clear Register (GPIO0 to 31)", offset: "0x8",
		bits: [
			{ name: "GPIO0", description: "Output Clear bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Output Clear bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Output Clear bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Output Clear bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Output Clear bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Output Clear bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Output Clear bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Output Clear bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Output Clear bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Output Clear bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Output Clear bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Output Clear bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Output Clear bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Output Clear bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Output Clear bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Output Clear bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Output Clear bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Output Clear bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Output Clear bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Output Clear bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Output Clear bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Output Clear bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Output Clear bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Output Clear bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Output Clear bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Output Clear bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Output Clear bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Output Clear bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Output Clear bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Output Clear bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Output Clear bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Output Clear bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPATOGGLE", description: "GPIO A Data Toggle Register (GPIO0 to 31)", offset: "0xC",
		bits: [
			{ name: "GPIO0", description: "Output Toggle bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Output Toggle bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Output Toggle bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Output Toggle bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Output Toggle bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Output Toggle bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Output Toggle bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Output Toggle bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Output Toggle bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Output Toggle bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Output Toggle bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Output Toggle bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Output Toggle bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Output Toggle bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Output Toggle bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Output Toggle bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Output Toggle bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Output Toggle bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Output Toggle bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Output Toggle bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Output Toggle bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Output Toggle bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Output Toggle bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Output Toggle bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Output Toggle bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Output Toggle bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Output Toggle bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Output Toggle bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Output Toggle bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Output Toggle bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Output Toggle bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Output Toggle bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPADIR", description: "GPIO A Direction Register (GPIO0 to 31)", offset: "0x10",
		bits: [
			{ name: "GPIO0", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO1", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO2", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO3", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO4", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO5", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO6", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO7", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO8", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO9", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO10", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO11", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO12", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO13", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO14", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO15", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO16", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO17", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO18", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO19", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO20", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO21", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO22", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO23", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO24", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO25", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO26", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO27", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO28", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO29", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO30", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO31", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBDAT", description: "GPIO B Data Register (GPIO32 to 63)", offset: "0x14",
		bits: [
			{ name: "GPIO32", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Data Register for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Data Register for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Data Register for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Data Register for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Data Register for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Data Register for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Data Register for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Data Register for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Data Register for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBSET", description: "GPIO B Data Set Register (GPIO32 to 63)", offset: "0x18",
		bits: [
			{ name: "GPIO32", description: "Output Set bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Output Set bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Output Set bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Output Set bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Output Set bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Output Set bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Output Set bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Output Set bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Output Set bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Output Set bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Output Set bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Output Set bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Output Set bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Output Set bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Output Set bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Output Set bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Output Set bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Output Set bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Output Set bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Output Set bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Output Set bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Output Set bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Output Set bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Output Set bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Output Set bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Output Set bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Output Set bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Output Set bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Output Set bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Output Set bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Output Set bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Output Set bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBCLEAR", description: "GPIO B Data Clear Register (GPIO32 to 63)", offset: "0x1C",
		bits: [
			{ name: "GPIO32", description: "Output Clear bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Output Clear bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Output Clear bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Output Clear bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Output Clear bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Output Clear bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Output Clear bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Output Clear bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Output Clear bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Output Clear bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Output Clear bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Output Clear bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Output Clear bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Output Clear bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Output Clear bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Output Clear bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Output Clear bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Output Clear bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Output Clear bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Output Clear bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Output Clear bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Output Clear bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Output Clear bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Output Clear bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Output Clear bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Output Clear bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Output Clear bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Output Clear bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Output Clear bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Output Clear bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Output Clear bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Output Clear bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBTOGGLE", description: "GPIO B Data Toggle Register (GPIO32 to 63)", offset: "0x20",
		bits: [
			{ name: "GPIO32", description: "Output Toggle bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Output Toggle bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Output Toggle bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Output Toggle bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Output Toggle bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Output Toggle bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Output Toggle bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Output Toggle bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Output Toggle bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Output Toggle bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Output Toggle bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Output Toggle bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Output Toggle bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Output Toggle bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Output Toggle bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Output Toggle bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Output Toggle bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Output Toggle bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Output Toggle bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Output Toggle bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Output Toggle bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Output Toggle bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Output Toggle bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Output Toggle bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Output Toggle bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Output Toggle bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Output Toggle bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Output Toggle bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Output Toggle bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Output Toggle bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Output Toggle bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Output Toggle bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPBDIR", description: "GPIO B Direction Register (GPIO0 to 31)", offset: "0x24",
		bits: [
			{ name: "GPIO32", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO33", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO34", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO35", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO36", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO37", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO38", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO39", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO40", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO41", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO42", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO43", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO44", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO45", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO46", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO47", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO48", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO49", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO50", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO51", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO52", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO53", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO54", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO55", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO56", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO57", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO58", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO59", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO60", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO61", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO62", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO63", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCDAT", description: "GPIO C Data Register (GPIO64 to 95)", offset: "0x28",
		bits: [
			{ name: "GPIO64", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Data Register for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Data Register for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Data Register for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Data Register for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Data Register for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Data Register for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Data Register for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Data Register for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Data Register for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCSET", description: "GPIO C Data Set Register (GPIO64 to 95)", offset: "0x2C",
		bits: [
			{ name: "GPIO64", description: "Output Set bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Output Set bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Output Set bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Output Set bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Output Set bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Output Set bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Output Set bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Output Set bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Output Set bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Output Set bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Output Set bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Output Set bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Output Set bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Output Set bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Output Set bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Output Set bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Output Set bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Output Set bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Output Set bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Output Set bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Output Set bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Output Set bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Output Set bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Output Set bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Output Set bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Output Set bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Output Set bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Output Set bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Output Set bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Output Set bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Output Set bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Output Set bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCCLEAR", description: "GPIO C Data Clear Register (GPIO64 to 95)", offset: "0x30",
		bits: [
			{ name: "GPIO64", description: "Output Clear bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Output Clear bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Output Clear bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Output Clear bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Output Clear bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Output Clear bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Output Clear bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Output Clear bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Output Clear bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Output Clear bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Output Clear bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Output Clear bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Output Clear bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Output Clear bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Output Clear bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Output Clear bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Output Clear bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Output Clear bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Output Clear bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Output Clear bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Output Clear bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Output Clear bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Output Clear bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Output Clear bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Output Clear bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Output Clear bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Output Clear bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Output Clear bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Output Clear bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Output Clear bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Output Clear bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Output Clear bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCTOGGLE", description: "GPIO C Data Toggle Register (GPIO64 to 95)", offset: "0x34",
		bits: [
			{ name: "GPIO64", description: "Output Toggle bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Output Toggle bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Output Toggle bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Output Toggle bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Output Toggle bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Output Toggle bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Output Toggle bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Output Toggle bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Output Toggle bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Output Toggle bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Output Toggle bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Output Toggle bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Output Toggle bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Output Toggle bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Output Toggle bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Output Toggle bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Output Toggle bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Output Toggle bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Output Toggle bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Output Toggle bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Output Toggle bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Output Toggle bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Output Toggle bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Output Toggle bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Output Toggle bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Output Toggle bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Output Toggle bit for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Output Toggle bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Output Toggle bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Output Toggle bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Output Toggle bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Output Toggle bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPCDIR", description: "GPIO C Direction Register (GPIO0 to 31)", offset: "0x38",
		bits: [
			{ name: "GPIO64", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO65", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO66", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO67", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO68", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO69", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO70", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO71", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO72", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO73", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO74", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO75", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO76", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO77", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO78", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO79", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO80", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO81", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO82", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO83", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO84", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO85", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO86", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO87", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO88", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO89", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO90", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO91", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO92", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO93", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO94", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO95", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDDAT", description: "GPIO D Data Register (GPIO96 to 127)", offset: "0x3C",
		bits: [
			{ name: "GPIO96", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDSET", description: "GPIO D Data Set Register (GPIO96 to 127)", offset: "0x40",
		bits: [
			{ name: "GPIO96", description: "Output Set bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Output Set bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Output Set bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Output Set bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Output Set bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Output Set bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Output Set bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Output Set bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Output Set bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDCLEAR", description: "GPIO D Data Clear Register (GPIO96 to 127)", offset: "0x44",
		bits: [
			{ name: "GPIO96", description: "Output Clear bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Output Clear bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Output Clear bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Output Clear bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Output Clear bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Output Clear bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Output Clear bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Output Clear bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Output Clear bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDTOGGLE", description: "GPIO D Data Toggle Register (GPIO96 to 127)", offset: "0x48",
		bits: [
			{ name: "GPIO96", description: "Output Toggle bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Output Toggle bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Output Toggle bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Output Toggle bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Output Toggle bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Output Toggle bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Output Toggle bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Output Toggle bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Output Toggle bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPDDIR", description: "GPIO D Direction Register (GPIO0 to 31)", offset: "0x4C",
		bits: [
			{ name: "GPIO96", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO97", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO98", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO99", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO100", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO101", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO103", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO105", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO127", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPFDAT", description: "GPIO F Data Register (GPIO160 to 191)", offset: "0x64",
		bits: [
			{ name: "GPIO160", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO161", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO162", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO163", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO164", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO165", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO166", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO167", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO168", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO169", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO170", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO171", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO172", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO173", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO174", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO175", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO176", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO177", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO178", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO179", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO180", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO181", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO182", description: "Data Register for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO183", description: "Data Register for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO184", description: "Data Register for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO185", description: "Data Register for this pin", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "GPIO186", description: "Data Register for this pin", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "GPIO187", description: "Data Register for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO188", description: "Data Register for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO189", description: "Data Register for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO190", description: "Data Register for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO191", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGDAT", description: "GPIO G Data Register (GPIO192 to 223)", offset: "0x78",
		bits: [
			{ name: "GPIO192", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO193", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO194", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO195", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO196", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO197", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO198", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO199", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO200", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO201", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO202", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO203", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO204", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO205", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO206", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO207", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO208", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO209", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO210", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO211", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO212", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO213", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO219", description: "Data Register for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Data Register for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Data Register for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Data Register for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Data Register for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGSET", description: "GPIO G Data Set Register (GPIO192 to 223)", offset: "0x7C",
		bits: [
			{ name: "GPIO219", description: "Output Set bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Output Set bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Output Set bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Output Set bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Output Set bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGCLEAR", description: "GPIO G Data Clear Register (GPIO192 to 223)", offset: "0x80",
		bits: [
			{ name: "GPIO219", description: "Output Clear bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Output Clear bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Output Clear bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Output Clear bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Output Clear bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGTOGGLE", description: "GPIO G Data Toggle Register (GPIO192 to 223)", offset: "0x84",
		bits: [
			{ name: "GPIO219", description: "Output Toggle bit for this pin", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Output Toggle bit for this pin", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Output Toggle bit for this pin", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Output Toggle bit for this pin", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Output Toggle bit for this pin", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPGDIR", description: "GPIO G Direction Register (GPIO0 to 31)", offset: "0x88",
		bits: [
			{ name: "GPIO219", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "GPIO220", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "GPIO221", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "GPIO222", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "GPIO223", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "GPHDAT", description: "GPIO H Data Register (GPIO224 to 255)", offset: "0x8C",
		bits: [
			{ name: "GPIO224", description: "Data Register for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Data Register for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Data Register for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Data Register for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Data Register for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Data Register for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Data Register for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Data Register for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Data Register for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Data Register for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Data Register for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Data Register for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Data Register for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Data Register for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Data Register for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Data Register for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Data Register for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Data Register for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Data Register for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Data Register for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Data Register for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Data Register for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Data Register for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Data Register for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Data Register for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Data Register for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHSET", description: "GPIO H Data Set Register (GPIO224 to 255)", offset: "0x90",
		bits: [
			{ name: "GPIO224", description: "Output Set bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Output Set bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Output Set bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Output Set bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Output Set bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Output Set bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Output Set bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Output Set bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Output Set bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Output Set bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Output Set bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Output Set bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Output Set bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Output Set bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Output Set bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Output Set bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Output Set bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Output Set bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Output Set bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Output Set bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Output Set bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Output Set bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Output Set bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Output Set bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Output Set bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Output Set bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHCLEAR", description: "GPIO H Data Clear Register (GPIO224 to 255)", offset: "0x94",
		bits: [
			{ name: "GPIO224", description: "Output Clear bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Output Clear bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Output Clear bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Output Clear bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Output Clear bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Output Clear bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Output Clear bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Output Clear bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Output Clear bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Output Clear bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Output Clear bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Output Clear bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Output Clear bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Output Clear bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Output Clear bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Output Clear bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Output Clear bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Output Clear bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Output Clear bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Output Clear bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Output Clear bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Output Clear bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Output Clear bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Output Clear bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Output Clear bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Output Clear bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHTOGGLE", description: "GPIO H Data Toggle Register (GPIO224 to 255)", offset: "0x98",
		bits: [
			{ name: "GPIO224", description: "Output Toggle bit for this pin", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Output Toggle bit for this pin", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Output Toggle bit for this pin", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Output Toggle bit for this pin", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Output Toggle bit for this pin", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Output Toggle bit for this pin", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Output Toggle bit for this pin", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Output Toggle bit for this pin", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Output Toggle bit for this pin", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Output Toggle bit for this pin", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Output Toggle bit for this pin", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Output Toggle bit for this pin", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Output Toggle bit for this pin", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Output Toggle bit for this pin", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Output Toggle bit for this pin", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Output Toggle bit for this pin", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Output Toggle bit for this pin", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Output Toggle bit for this pin", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Output Toggle bit for this pin", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Output Toggle bit for this pin", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Output Toggle bit for this pin", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Output Toggle bit for this pin", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Output Toggle bit for this pin", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Output Toggle bit for this pin", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Output Toggle bit for this pin", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Output Toggle bit for this pin", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPHDIR", description: "GPIO H Direction Register (GPIO0 to 31)", offset: "0x9C",
		bits: [
			{ name: "GPIO224", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "0", mask: "0x1" },
			{ name: "GPIO225", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "1", mask: "0x2" },
			{ name: "GPIO226", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "2", mask: "0x4" },
			{ name: "GPIO227", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "3", mask: "0x8" },
			{ name: "GPIO228", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "4", mask: "0x10" },
			{ name: "GPIO229", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "5", mask: "0x20" },
			{ name: "GPIO230", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "6", mask: "0x40" },
			{ name: "GPIO231", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "7", mask: "0x80" },
			{ name: "GPIO232", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "8", mask: "0x100" },
			{ name: "GPIO233", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "9", mask: "0x200" },
			{ name: "GPIO234", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "10", mask: "0x400" },
			{ name: "GPIO235", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "11", mask: "0x800" },
			{ name: "GPIO236", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "12", mask: "0x1000" },
			{ name: "GPIO237", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "13", mask: "0x2000" },
			{ name: "GPIO238", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "14", mask: "0x4000" },
			{ name: "GPIO239", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "15", mask: "0x8000" },
			{ name: "GPIO240", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "16", mask: "0x10000" },
			{ name: "GPIO241", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "17", mask: "0x20000" },
			{ name: "GPIO242", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "18", mask: "0x40000" },
			{ name: "GPIO243", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "19", mask: "0x80000" },
			{ name: "GPIO244", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "20", mask: "0x100000" },
			{ name: "GPIO245", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "21", mask: "0x200000" },
			{ name: "GPIO246", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "22", mask: "0x400000" },
			{ name: "GPIO247", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "23", mask: "0x800000" },
			{ name: "GPIO248", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "GPIO249", description: "Defines direction for this pin in GPIO mode", size: "1", shift: "25", mask: "0x2000000" },
		]
	},
	{ name: "GPADAT_R", description: "GPIO A Data Read Register", offset: "0x0",
		bits: [
		]
	},
	{ name: "GPBDAT_R", description: "GPIO B Data Read Register", offset: "0x4",
		bits: [
		]
	},
	{ name: "GPCDAT_R", description: "GPIO C Data Read Register", offset: "0x8",
		bits: [
		]
	},
	{ name: "GPDDAT_R", description: "GPIO D Data Read Register", offset: "0xC",
		bits: [
		]
	},
	{ name: "GPFDAT_R", description: "GPIO F Data Read Register", offset: "0x14",
		bits: [
		]
	},
	{ name: "GPGDAT_R", description: "GPIO G Data Read Register", offset: "0x18",
		bits: [
		]
	},
	{ name: "GPHDAT_R", description: "GPIO H Data Read Register", offset: "0x1C",
		bits: [
		]
	},
];
module.exports = {
	GPIORegisters: GPIORegisters,
}
