let OUTPUT_XBARRegisters = [
	{ name: "OUTPUTXBARSTATUS", description: "Output Signal Status register", offset: "0x10",
		bits: [
			{ name: "STS", description: "Output Signal Status", size: "1", shift: "0", mask: "0x1" },
		]
	},
	{ name: "OUTPUTXBARFLAG", description: "Output latched flag register", offset: "0x18",
		bits: [
			{ name: "FLG", description: "Output Signal Latched Flag Status", size: "1", shift: "0", mask: "0x1" },
		]
	},
	{ name: "OUTPUTXBARFLAGCLEAR", description: "Output latched flag clear register", offset: "0x1C",
		bits: [
			{ name: "FLG", description: "Output Signal Latched Flag Clear", size: "1", shift: "0", mask: "0x1" },
		]
	},
	{ name: "OUTPUTXBARFLAGFORCE", description: "Output latched flag Force register", offset: "0x20",
		bits: [
			{ name: "FLG", description: "Output Signal Latched Flag Force", size: "1", shift: "0", mask: "0x1" },
		]
	},
	{ name: "OUTPUTXBARFLAGINVERT", description: "Output Signal inversion", offset: "0x14",
		bits: [
			{ name: "XBAR1", description: "Invert XBAR Output Before Latch for", size: "1", shift: "0", mask: "0x1" },
			{ name: "XBAR2", description: "Invert XBAR Output Before Latch for", size: "1", shift: "1", mask: "0x2" },
			{ name: "XBAR3", description: "Invert XBAR Output Before Latch for", size: "1", shift: "2", mask: "0x4" },
			{ name: "XBAR4", description: "Invert XBAR Output Before Latch for", size: "1", shift: "3", mask: "0x8" },
			{ name: "XBAR5", description: "Invert XBAR Output Before Latch for", size: "1", shift: "4", mask: "0x10" },
			{ name: "XBAR6", description: "Invert XBAR Output Before Latch for", size: "1", shift: "5", mask: "0x20" },
			{ name: "XBAR7", description: "Invert XBAR Output Before Latch for", size: "1", shift: "6", mask: "0x40" },
			{ name: "XBAR8", description: "Invert XBAR Output Before Latch for", size: "1", shift: "7", mask: "0x80" },
			{ name: "XBAR9", description: "Invert XBAR Output Before Latch for", size: "1", shift: "8", mask: "0x100" },
			{ name: "XBAR10", description: "Invert XBAR Output Before Latch for", size: "1", shift: "9", mask: "0x200" },
			{ name: "XBAR11", description: "Invert XBAR Output Before Latch for", size: "1", shift: "10", mask: "0x400" },
			{ name: "XBAR12", description: "Invert XBAR Output Before Latch for", size: "1", shift: "11", mask: "0x800" },
			{ name: "XBAR13", description: "Invert XBAR Output Before Latch for", size: "1", shift: "12", mask: "0x1000" },
			{ name: "XBAR14", description: "Invert XBAR Output Before Latch for", size: "1", shift: "13", mask: "0x2000" },
			{ name: "XBAR15", description: "Invert XBAR Output Before Latch for", size: "1", shift: "14", mask: "0x4000" },
			{ name: "XBAR16", description: "Invert XBAR Output Before Latch for", size: "1", shift: "15", mask: "0x8000" },
		]
	},
	{ name: "OUTPUTXBAROUTLATCH", description: "Output Signal Select Latch", offset: "0x24",
		bits: [
			{ name: "XBAR1", description: "XBAR Output Latch Select for XBAR1", size: "1", shift: "0", mask: "0x1" },
			{ name: "XBAR2", description: "XBAR Output Latch Select for XBAR2", size: "1", shift: "1", mask: "0x2" },
			{ name: "XBAR3", description: "XBAR Output Latch Select for XBAR3", size: "1", shift: "2", mask: "0x4" },
			{ name: "XBAR4", description: "XBAR Output Latch Select for XBAR4", size: "1", shift: "3", mask: "0x8" },
			{ name: "XBAR5", description: "XBAR Output Latch Select for XBAR5", size: "1", shift: "4", mask: "0x10" },
			{ name: "XBAR6", description: "XBAR Output Latch Select for XBAR6", size: "1", shift: "5", mask: "0x20" },
			{ name: "XBAR7", description: "XBAR Output Latch Select for XBAR7", size: "1", shift: "6", mask: "0x40" },
			{ name: "XBAR8", description: "XBAR Output Latch Select for XBAR8", size: "1", shift: "7", mask: "0x80" },
			{ name: "XBAR9", description: "XBAR Output Latch Select for XBAR9", size: "1", shift: "8", mask: "0x100" },
			{ name: "XBAR10", description: "XBAR Output Latch Select for XBAR10", size: "1", shift: "9", mask: "0x200" },
			{ name: "XBAR11", description: "XBAR Output Latch Select for XBAR11", size: "1", shift: "10", mask: "0x400" },
			{ name: "XBAR12", description: "XBAR Output Latch Select for XBAR12", size: "1", shift: "11", mask: "0x800" },
			{ name: "XBAR13", description: "XBAR Output Latch Select for XBAR13", size: "1", shift: "12", mask: "0x1000" },
			{ name: "XBAR14", description: "XBAR Output Latch Select for XBAR14", size: "1", shift: "13", mask: "0x2000" },
			{ name: "XBAR15", description: "XBAR Output Latch Select for XBAR15", size: "1", shift: "14", mask: "0x4000" },
			{ name: "XBAR16", description: "XBAR Output Latch Select for XBAR16", size: "1", shift: "15", mask: "0x8000" },
		]
	},
	{ name: "OUTPUTXBAROUTSTRETCH", description: "Output Signal Stretched", offset: "0x28",
		bits: [
			{ name: "XBAR1", description: "XBAR Output Stretch Select for XBAR1", size: "1", shift: "0", mask: "0x1" },
			{ name: "XBAR2", description: "XBAR Output Stretch Select for XBAR2", size: "1", shift: "1", mask: "0x2" },
			{ name: "XBAR3", description: "XBAR Output Stretch Select for XBAR3", size: "1", shift: "2", mask: "0x4" },
			{ name: "XBAR4", description: "XBAR Output Stretch Select for XBAR4", size: "1", shift: "3", mask: "0x8" },
			{ name: "XBAR5", description: "XBAR Output Stretch Select for XBAR5", size: "1", shift: "4", mask: "0x10" },
			{ name: "XBAR6", description: "XBAR Output Stretch Select for XBAR6", size: "1", shift: "5", mask: "0x20" },
			{ name: "XBAR7", description: "XBAR Output Stretch Select for XBAR7", size: "1", shift: "6", mask: "0x40" },
			{ name: "XBAR8", description: "XBAR Output Stretch Select for XBAR8", size: "1", shift: "7", mask: "0x80" },
			{ name: "XBAR9", description: "XBAR Output Stretch Select for XBAR9", size: "1", shift: "8", mask: "0x100" },
			{ name: "XBAR10", description: "XBAR Output Stretch Select for", size: "1", shift: "9", mask: "0x200" },
			{ name: "XBAR11", description: "XBAR Output Stretch Select for", size: "1", shift: "10", mask: "0x400" },
			{ name: "XBAR12", description: "XBAR Output Stretch Select for", size: "1", shift: "11", mask: "0x800" },
			{ name: "XBAR13", description: "XBAR Output Stretch Select for", size: "1", shift: "12", mask: "0x1000" },
			{ name: "XBAR14", description: "XBAR Output Stretch Select for", size: "1", shift: "13", mask: "0x2000" },
			{ name: "XBAR15", description: "XBAR Output Stretch Select for", size: "1", shift: "14", mask: "0x4000" },
			{ name: "XBAR16", description: "XBAR Output Stretch Select for", size: "1", shift: "15", mask: "0x8000" },
		]
	},
	{ name: "OUTPUTXBAROUTLENGTH", description: "Output Signal Stretched", offset: "0x2C",
		bits: [
			{ name: "XBAR1", description: "XBAR Output Stretch Length Select for", size: "1", shift: "0", mask: "0x1" },
			{ name: "XBAR2", description: "XBAR Output Stretch Length Select for", size: "1", shift: "1", mask: "0x2" },
			{ name: "XBAR3", description: "XBAR Output Stretch Length Select for", size: "1", shift: "2", mask: "0x4" },
			{ name: "XBAR4", description: "XBAR Output Stretch Length Select for", size: "1", shift: "3", mask: "0x8" },
			{ name: "XBAR5", description: "XBAR Output Stretch Length Select for", size: "1", shift: "4", mask: "0x10" },
			{ name: "XBAR6", description: "XBAR Output Stretch Length Select for", size: "1", shift: "5", mask: "0x20" },
			{ name: "XBAR7", description: "XBAR Output Stretch Length Select for", size: "1", shift: "6", mask: "0x40" },
			{ name: "XBAR8", description: "XBAR Output Stretch Length Select for", size: "1", shift: "7", mask: "0x80" },
			{ name: "XBAR9", description: "XBAR Output Stretch Length Select for", size: "1", shift: "8", mask: "0x100" },
			{ name: "XBAR10", description: "XBAR Output Stretch Length Select for", size: "1", shift: "9", mask: "0x200" },
			{ name: "XBAR11", description: "XBAR Output Stretch Length Select for", size: "1", shift: "10", mask: "0x400" },
			{ name: "XBAR12", description: "XBAR Output Stretch Length Select for", size: "1", shift: "11", mask: "0x800" },
			{ name: "XBAR13", description: "XBAR Output Stretch Length Select for", size: "1", shift: "12", mask: "0x1000" },
			{ name: "XBAR14", description: "XBAR Output Stretch Length Select for", size: "1", shift: "13", mask: "0x2000" },
			{ name: "XBAR15", description: "XBAR Output Stretch Length Select for", size: "1", shift: "14", mask: "0x4000" },
			{ name: "XBAR16", description: "XBAR Output Stretch Length Select for", size: "1", shift: "15", mask: "0x8000" },
		]
	},
	{ name: "OUTPUTXBAROUTINVERT", description: "Output Signal Invert Select", offset: "0x30",
		bits: [
			{ name: "XBAR1", description: "Invert XBAR Output for XBAR1", size: "1", shift: "0", mask: "0x1" },
			{ name: "XBAR2", description: "Invert XBAR Output for XBAR2", size: "1", shift: "1", mask: "0x2" },
			{ name: "XBAR3", description: "Invert XBAR Output for XBAR3", size: "1", shift: "2", mask: "0x4" },
			{ name: "XBAR4", description: "Invert XBAR Output for XBAR4", size: "1", shift: "3", mask: "0x8" },
			{ name: "XBAR5", description: "Invert XBAR Output for XBAR5", size: "1", shift: "4", mask: "0x10" },
			{ name: "XBAR6", description: "Invert XBAR Output for XBAR6", size: "1", shift: "5", mask: "0x20" },
			{ name: "XBAR7", description: "Invert XBAR Output for XBAR7", size: "1", shift: "6", mask: "0x40" },
			{ name: "XBAR8", description: "Invert XBAR Output for XBAR8", size: "1", shift: "7", mask: "0x80" },
			{ name: "XBAR9", description: "Invert XBAR Output for XBAR9", size: "1", shift: "8", mask: "0x100" },
			{ name: "XBAR10", description: "Invert XBAR Output for XBAR10", size: "1", shift: "9", mask: "0x200" },
			{ name: "XBAR11", description: "Invert XBAR Output for XBAR11", size: "1", shift: "10", mask: "0x400" },
			{ name: "XBAR12", description: "Invert XBAR Output for XBAR12", size: "1", shift: "11", mask: "0x800" },
			{ name: "XBAR13", description: "Invert XBAR Output for XBAR13", size: "1", shift: "12", mask: "0x1000" },
			{ name: "XBAR14", description: "Invert XBAR Output for XBAR14", size: "1", shift: "13", mask: "0x2000" },
			{ name: "XBAR15", description: "Invert XBAR Output for XBAR15", size: "1", shift: "14", mask: "0x4000" },
			{ name: "XBAR16", description: "Invert XBAR Output for XBAR16", size: "1", shift: "15", mask: "0x8000" },
		]
	},
	{ name: "OUTPUTXBARLOCK", description: "Configuration Lock register", offset: "0x80",
		bits: [
			{ name: "LOCK", description: "Locks the configuration for", size: "1", shift: "0", mask: "0x1" },
			{ name: "KEY", description: "Write protection KEY", size: "16", shift: "16", mask: "0xFFFF0000" },
		]
	},
	{ name: "OUTPUTXBARG0SEL", description: "(0 <= i < 16) OUTPUTXBAR G0", offset: "(0x100U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG1SEL", description: "(0 <= i < 16) OUTPUTXBAR G1", offset: "(0x104U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG2SEL", description: "(0 <= i < 16) OUTPUTXBAR G2", offset: "(0x108U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG3SEL", description: "(0 <= i < 16) OUTPUTXBAR G3", offset: "(0x10CU + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG4SEL", description: "(0 <= i < 16) OUTPUTXBAR G4", offset: "(0x110U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG5SEL", description: "(0 <= i < 16) OUTPUTXBAR G5", offset: "(0x114U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG6SEL", description: "(0 <= i < 16) OUTPUTXBAR G6", offset: "(0x118U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG7SEL", description: "(0 <= i < 16) OUTPUTXBAR G7", offset: "(0x11CU + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG8SEL", description: "(0 <= i < 16) OUTPUTXBAR G8", offset: "(0x120U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
	{ name: "OUTPUTXBARG9SEL", description: "(0 <= i < 16) OUTPUTXBAR G9", offset: "(0x124U + ((i) * 64))", count: "16",
		bits: [
			{ name: "INPUT0", description: "Select bit for INPUT0", size: "1", shift: "0", mask: "0x1" },
			{ name: "INPUT1", description: "Select bit for INPUT1", size: "1", shift: "1", mask: "0x2" },
			{ name: "INPUT2", description: "Select bit for INPUT2", size: "1", shift: "2", mask: "0x4" },
			{ name: "INPUT3", description: "Select bit for INPUT3", size: "1", shift: "3", mask: "0x8" },
			{ name: "INPUT4", description: "Select bit for INPUT4", size: "1", shift: "4", mask: "0x10" },
			{ name: "INPUT5", description: "Select bit for INPUT5", size: "1", shift: "5", mask: "0x20" },
			{ name: "INPUT6", description: "Select bit for INPUT6", size: "1", shift: "6", mask: "0x40" },
			{ name: "INPUT7", description: "Select bit for INPUT7", size: "1", shift: "7", mask: "0x80" },
			{ name: "INPUT8", description: "Select bit for INPUT8", size: "1", shift: "8", mask: "0x100" },
			{ name: "INPUT9", description: "Select bit for INPUT9", size: "1", shift: "9", mask: "0x200" },
			{ name: "INPUT10", description: "Select bit for INPUT10", size: "1", shift: "10", mask: "0x400" },
			{ name: "INPUT11", description: "Select bit for INPUT11", size: "1", shift: "11", mask: "0x800" },
			{ name: "INPUT12", description: "Select bit for INPUT12", size: "1", shift: "12", mask: "0x1000" },
			{ name: "INPUT13", description: "Select bit for INPUT13", size: "1", shift: "13", mask: "0x2000" },
			{ name: "INPUT14", description: "Select bit for INPUT14", size: "1", shift: "14", mask: "0x4000" },
			{ name: "INPUT15", description: "Select bit for INPUT15", size: "1", shift: "15", mask: "0x8000" },
			{ name: "INPUT16", description: "Select bit for INPUT16", size: "1", shift: "16", mask: "0x10000" },
			{ name: "INPUT17", description: "Select bit for INPUT17", size: "1", shift: "17", mask: "0x20000" },
			{ name: "INPUT18", description: "Select bit for INPUT18", size: "1", shift: "18", mask: "0x40000" },
			{ name: "INPUT19", description: "Select bit for INPUT19", size: "1", shift: "19", mask: "0x80000" },
			{ name: "INPUT20", description: "Select bit for INPUT20", size: "1", shift: "20", mask: "0x100000" },
			{ name: "INPUT21", description: "Select bit for INPUT21", size: "1", shift: "21", mask: "0x200000" },
			{ name: "INPUT22", description: "Select bit for INPUT22", size: "1", shift: "22", mask: "0x400000" },
			{ name: "INPUT23", description: "Select bit for INPUT23", size: "1", shift: "23", mask: "0x800000" },
			{ name: "INPUT24", description: "Select bit for INPUT24", size: "1", shift: "24", mask: "0x1000000" },
			{ name: "INPUT25", description: "Select bit for INPUT25", size: "1", shift: "25", mask: "0x2000000" },
			{ name: "INPUT26", description: "Select bit for INPUT26", size: "1", shift: "26", mask: "0x4000000" },
			{ name: "INPUT27", description: "Select bit for INPUT27", size: "1", shift: "27", mask: "0x8000000" },
			{ name: "INPUT28", description: "Select bit for INPUT28", size: "1", shift: "28", mask: "0x10000000" },
			{ name: "INPUT29", description: "Select bit for INPUT29", size: "1", shift: "29", mask: "0x20000000" },
			{ name: "INPUT30", description: "Select bit for INPUT30", size: "1", shift: "30", mask: "0x40000000" },
			{ name: "INPUT31", description: "Select bit for INPUT31", size: "1", shift: "31", mask: "0x80000000" },
		]
	},
];
module.exports = {
	OUTPUT_XBARRegisters: OUTPUT_XBARRegisters,
}
