//###########################################################################
//
// FILE:   f29x_cpu1_system.c
//
// TITLE:  F29x CPU1 EtherCAT System APIs
//
// This file contains the source for any device system APIs that require
// modification for compatibility with EtherCAT stack usage.
//
//###########################################################################
// $TI Release: F29x EtherCAT Software $
// $Release Date: $
// $Copyright: Copyright (C) 2025 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

//
// Included Files
//
#include "f29x_cpu1_system.h"

//
// F29XCPU1_strcpy - String copy wrapper for compatibility with EtherCAT stack
//                     to store as 8-bit values.
//
void F29X_strcpy(void * __restrict dest, const void * __restrict src,
                       size_t n)
{
    //
    // Call standard strncpy from string.h
    //
    strncpy((char *)dest, (const char *)src, (size_t)n);
}

//
// End of File
//
