//###########################################################################
//
// FILE:   Example_2806xLEDBlink.c
//
// TITLE:  Timer based blinking LED Example
//
//!  \addtogroup f2806x_example_list
//!  <h1>Timer based blinking LED(timed_led_blink)</h1>
//!
//!  This example configures CPU Timer0 for a 500 msec period, and toggles the 
//!  GPIO34 LED once per interrupt. For testing purposes, this example
//!  also increments a counter each time the timer asserts an interrupt.
//!
//!  \b Watch \b Variables \n
//!  - CpuTimer0.InterruptCount
//!
//! \b External \b Connections \n
//!  Monitor the GPIO34 LED blink on (for 500 msec) and off (for 500 msec) on 
//!  the 2806x control card.
//
//###########################################################################
// $TI Release:  $
// $Release Date:  $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//

//###########################################################################
//
// FILE:   DSP28x_Project.h
//
// TITLE:  DSP28x Project Headerfile and Examples Include File
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################


//
// Included Files
//
//###########################################################################
//
// FILE:   F2806x_Cla_typedefs.h
//
// TITLE:  Variable type definitions
//
//###########################################################################
// $TI Release: $
// $Release Date:  $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// For Portability, User Is Recommended To Use Following Data Type Size
// Definitions For 16-bit and 32-Bit Signed/Unsigned Integers:
//
// CLA does not support 64-bit types
// This definition is only to allow inclusion of the standard header files
// which do use 64-bit types
//

typedef short           int16;
typedef long            int32;
typedef unsigned char   Uint8;
typedef unsigned short  Uint16;
typedef unsigned long   Uint32;
typedef float           float32;
typedef long double     float64;

//
// These types are also defined in DSP/BIOS 5.x's <std.h> and the
// SYS/BIOS 6.x's <xdc/std.h> files.  We need to protect their
// definition with the #ifndef/#define guard to avoid the duplicate
// definition warning.
//
// SYS/BIOS requires that the <xdc/std.h> file be included before
// any other .h files.
//

//
// Suppress warnings casting CLA pointers
//
#pragma diag_suppress 70,770,232

//
// Macros to manipulate pre-processor to generate a header file name
// at compile time that is based on the test name and can be used as
// an argument to #include
//


typedef unsigned long long Uint64;



//###########################################################################
//
// FILE:   F2806x_Device.h
//
// TITLE:  F2806x Device Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################




//
// User To Select Target Device:
//












//
// Common CPU Definitions:
//
extern __cregister volatile unsigned int IFR;
extern __cregister volatile unsigned int IER;




//
// For Portability, User Is Recommended To Use Following Data Type Size
// Definitions For 16-bit and 32-Bit Signed/Unsigned Integers:
//


//
// Include All Peripheral Header Files:
//
//###########################################################################
//
// FILE:   F2806x_Adc.h
//
// TITLE:  F2806x Device ADC Register Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################




//
// ADC Individual Register Bit Definitions:
//
struct ADCCTL1_BITS
{
    Uint16  TEMPCONV:1;             // 0    Temperature sensor connection
    Uint16  VREFLOCONV:1;           // 1    VSSA connection
    Uint16  INTPULSEPOS :1;         // 2    INT pulse generation control
    Uint16  ADCREFSEL:1;            // 3    Internal/external reference select
    Uint16  rsvd1:1;                // 4    Reserved
    Uint16  ADCREFPWD:1;            // 5    Reference buffers powerdown
    Uint16  ADCBGPWD:1;             // 6    ADC bandgap powerdown
    Uint16  ADCPWDN:1;              // 7    ADC powerdown
    Uint16  ADCBSYCHN:5;            // 12:8 ADC busy on a channel
    Uint16  ADCBSY:1;               // 13   ADC Busy
    Uint16  ADCENABLE:1;            // 14   ADC Enable
    Uint16  RESET:1;                // 15   ADC Master Reset
};

union ADCCTL1_REG
{
    Uint16 all;
    struct ADCCTL1_BITS bit;
};

struct ADCCTL2_BITS
{
    Uint16  CLKDIV2EN:1;        // 0    ADC CLK Div2 enable
    Uint16  ADCNONOVERLAP:1;    // 1    Non Sample Overlap enable
    Uint16  CLKDIV4EN:1;        // 2    ADC CLK Div4 enable
    Uint16  rsvd1:13;           // 15:3 Reserved
};

union ADCCTL2_REG
{
    Uint16 all;
    struct ADCCTL2_BITS bit;
};

struct ADCSAMPLEMODE_BITS
{
    Uint16  SIMULEN0:1;         // 0    Simultaneous sampling enable for SOC0
    Uint16  SIMULEN2:1;         // 1    Simultaneous sampling enable for SOC2
    Uint16  SIMULEN4:1;         // 2    Simultaneous sampling enable for SOC4
    Uint16  SIMULEN6:1;         // 3    Simultaneous sampling enable for SOC6
    Uint16  SIMULEN8:1;         // 4    Simultaneous sampling enable for SOC8
    Uint16  SIMULEN10:1;        // 5    Simultaneous sampling enable for SOC10
    Uint16  SIMULEN12:1;        // 6    Simultaneous sampling enable for SOC12
    Uint16  SIMULEN14:1;        // 7    Simultaneous sampling enable for SOC14
    Uint16  rsvd1:8;            // 15:8 Reserved
};

union ADCSAMPLEMODE_REG
{
    Uint16 all;
    struct ADCSAMPLEMODE_BITS   bit;
};

struct SOCPRICTL_BITS
{
    Uint16  SOCPRIORITY:5;      // 4:0  Start-of-conversion Priority
    Uint16  RRPOINTER:6;        // 10:5 Round Robin Pointer
    Uint16  rsvd1:4;            // 14:11    Reserved
    Uint16  ONESHOT:1;          // 15   One Shot Mode Enabled
};

union SOCPRICTL_REG
{
    Uint16 all;
    struct SOCPRICTL_BITS   bit;
};

struct ADCSOC_BITS
{
    Uint16  SOC0:1;         // 0    Start of conversion for CONV0
    Uint16  SOC1:1;         // 1    Start of conversion for CONV1
    Uint16  SOC2:1;         // 2    Start of conversion for CONV2
    Uint16  SOC3:1;         // 3    Start of conversion for CONV3
    Uint16  SOC4:1;         // 4    Start of conversion for CONV4
    Uint16  SOC5:1;         // 5    Start of conversion for CONV5
    Uint16  SOC6:1;         // 6    Start of conversion for CONV6
    Uint16  SOC7:1;         // 7    Start of conversion for CONV7
    Uint16  SOC8:1;         // 8    Start of conversion for CONV8
    Uint16  SOC9:1;         // 9    Start of conversion for CONV9
    Uint16  SOC10:1;        // 10   Start of conversion for CONV10
    Uint16  SOC11:1;        // 11   Start of conversion for CONV11
    Uint16  SOC12:1;        // 12   Start of conversion for CONV12
    Uint16  SOC13:1;        // 13   Start of conversion for CONV13
    Uint16  SOC14:1;        // 14   Start of conversion for CONV14
    Uint16  SOC15:1;        // 15   Start of conversion for CONV15
};

union ADCSOC_REG
{
    Uint16 all;
    struct ADCSOC_BITS  bit;
};

struct INTSEL1N2_BITS
{
    Uint16  INT1SEL:5;          // 4:0  INT1 EOC Source Select
    Uint16  INT1E:1;            // 5    INT1 Interrupt Enable
    Uint16  INT1CONT:1;         // 6    INT1 Continuous Mode Enable
    Uint16  rsvd1:1;            // 7    Reserved
    Uint16  INT2SEL:5;          // 12:8 INT2 EOC Source Select
    Uint16  INT2E:1;            // 13   INT2 Interrupt Enable
    Uint16  INT2CONT:1;         // 14   INT2 Continuous Mode Enable
    Uint16  rsvd2:1;            // 15   Reserved
};

union INTSEL1N2_REG
{
    Uint16 all;
    struct INTSEL1N2_BITS   bit;
};

struct INTSEL3N4_BITS
{
    Uint16  INT3SEL:5;          // 4:0  INT3 EOC Source Select
    Uint16  INT3E:1;            // 5    INT3 Interrupt Enable
    Uint16  INT3CONT:1;         // 6    INT3 Continuous Mode Enable
    Uint16  rsvd1:1;            // 7    Reserved
    Uint16  INT4SEL:5;          // 12:8 INT4 EOC Source Select
    Uint16  INT4E:1;            // 13   INT4 Interrupt Enable
    Uint16  INT4CONT:1;         // 14   INT4 Continuous Mode Enable
    Uint16  rsvd2:1;            // 15   Reserved
};

union INTSEL3N4_REG
{
    Uint16 all;
    struct INTSEL3N4_BITS   bit;
};

struct INTSEL5N6_BITS
{
    Uint16  INT5SEL:5;          // 4:0  INT5 EOC Source Select
    Uint16  INT5E:1;            // 5    INT5 Interrupt Enable
    Uint16  INT5CONT:1;         // 6    INT5 Continuous Mode Enable
    Uint16  rsvd1:1;            // 7    Reserved
    Uint16  INT6SEL:5;          // 12:8 INT6 EOC Source Select
    Uint16  INT6E:1;            // 13   INT6 Interrupt Enable
    Uint16  INT6CONT:1;         // 14   INT6 Continuous Mode Enable
    Uint16  rsvd2:1;            // 15   Reserved
};

union INTSEL5N6_REG
{
    Uint16 all;
    struct INTSEL5N6_BITS   bit;
};

struct INTSEL7N8_BITS
{
    Uint16  INT7SEL:5;          // 4:0  INT7 EOC Source Select
    Uint16  INT7E:1;            // 5    INT7 Interrupt Enable
    Uint16  INT7CONT:1;         // 6    INT7 Continuous Mode Enable
    Uint16  rsvd1:1;            // 7    Reserved
    Uint16  INT8SEL:5;          // 12:8 INT8 EOC Source Select
    Uint16  INT8E:1;            // 13   INT8 Interrupt Enable
    Uint16  INT8CONT:1;         // 14   INT8 Continuous Mode Enable
    Uint16  rsvd2:1;            // 15   Reserved
};

union INTSEL7N8_REG
{
    Uint16 all;
    struct INTSEL7N8_BITS   bit;
};

struct INTSEL9N10_BITS
{
    Uint16  INT9SEL:5;          // 4:0  INT9 EOC Source Select
    Uint16  INT9E:1;            // 5    INT9 Interrupt Enable
    Uint16  INT9CONT:1;         // 6    INT9 Continuous Mode Enable
    Uint16  rsvd1:1;            // 7    Reserved
    Uint16  INT10SEL:5;         // 12:8 INT10 EOC Source Select
    Uint16  INT10E:1;           // 13   INT10 Interrupt Enable
    Uint16  INT10CONT:1;        // 14   INT10 Continuous Mode Enable
    Uint16  rsvd2:1;            // 15   Reserved
};

union INTSEL9N10_REG
{
    Uint16 all;
    struct INTSEL9N10_BITS  bit;
};

struct ADCINT_BITS
{
    Uint16  ADCINT1:1;          // 0    ADC Interrupt Flag 1
    Uint16  ADCINT2:1;          // 1    ADC Interrupt Flag 2
    Uint16  ADCINT3:1;          // 2    ADC Interrupt Flag 3
    Uint16  ADCINT4:1;          // 3    ADC Interrupt Flag 4
    Uint16  ADCINT5:1;          // 4    ADC Interrupt Flag 5
    Uint16  ADCINT6:1;          // 5    ADC Interrupt Flag 6
    Uint16  ADCINT7:1;          // 6    ADC Interrupt Flag 7
    Uint16  ADCINT8:1;          // 7    ADC Interrupt Flag 8
    Uint16  ADCINT9:1;          // 8    ADC Interrupt Flag 9
    Uint16  rsvd1:7;            // 15:9 Reserved
};

union ADCINT_REG
{
    Uint16 all;
    struct ADCINT_BITS  bit;
};

struct ADCINTSOCSEL1_BITS
{
    Uint16  SOC0:2;         // 1:0  ADCINT Start-of-conversion Select
    Uint16  SOC1:2;         // 3:2  ADCINT Start-of-conversion Select
    Uint16  SOC2:2;         // 5:4  ADCINT Start-of-conversion Select
    Uint16  SOC3:2;         // 7:6  ADCINT Start-of-conversion Select
    Uint16  SOC4:2;         // 9:8  ADCINT Start-of-conversion Select
    Uint16  SOC5:2;         // 11:10    ADCINT Start-of-conversion Select
    Uint16  SOC6:2;         // 13:12    ADCINT Start-of-conversion Select
    Uint16  SOC7:2;         // 15:14    ADCINT Start-of-conversion Select
};

union ADCINTSOCSEL1_REG
{
    Uint16 all;
    struct ADCINTSOCSEL1_BITS   bit;
};

struct ADCINTSOCSEL2_BITS
{
    Uint16  SOC8:2;             // 1:0  ADCINT Start-of-conversion Select
    Uint16  SOC9:2;             // 3:2  ADCINT Start-of-conversion Select
    Uint16  SOC10:2;            // 5:4  ADCINT Start-of-conversion Select
    Uint16  SOC11:2;            // 7:6  ADCINT Start-of-conversion Select
    Uint16  SOC12:2;            // 9:8  ADCINT Start-of-conversion Select
    Uint16  SOC13:2;            // 11:10    ADCINT Start-of-conversion Select
    Uint16  SOC14:2;            // 13:12    ADCINT Start-of-conversion Select
    Uint16  SOC15:2;            // 15:14    ADCINT Start-of-conversion Select
};

union ADCINTSOCSEL2_REG
{
    Uint16 all;
    struct ADCINTSOCSEL2_BITS   bit;
};

struct ADCSOCxCTL_BITS
{
    Uint16  ACQPS:6;            // 5:0  Acquisition Pulse Size
    Uint16  CHSEL:4;            // 9:6  SOCx Channel Select
    Uint16  rsvd1:1;            // 10   Reserved
    Uint16  TRIGSEL:5;          // 15:11    SOCx Trigger Select
};

union ADCSOCxCTL_REG
{
    Uint16 all;
    struct ADCSOCxCTL_BITS  bit;
};

struct ADCREFTRIM_BITS
{
    Uint16  BG_FINE_TRIM:5;         // 4:0  Course Trim for Internal BG
    Uint16  BG_COARSE_TRIM:4;       // 8:5  Fine Trim for Internal BG
    Uint16  EXTREF_FINE_TRIM:5;     // 13:9 Fine Trim for External Reference
    Uint16  rsvd1:2;                // 15:14    Reserved
};

union ADCREFTRIM_REG
{
    Uint16 all;
    struct ADCREFTRIM_BITS  bit;
};

struct ADCOFFTRIM_BITS
{
    int16   OFFTRIM:9;          // 8:0  Offset Trim
    Uint16  rsvd1:7;            // 15:9 Reserved
};

union ADCOFFTRIM_REG
{
    Uint16 all;
    struct ADCOFFTRIM_BITS  bit;
};

struct COMPHYSTCTL_BITS
{
    Uint16  rsvd1:1;                   // 0    reserved
    Uint16  COMP1_HYST_DISABLE:1;      // 1    Comparator 1 Hysteresis Disable
    Uint16  rsvd2:4;                   // 5:2  reserved
    Uint16  COMP2_HYST_DISABLE:1;      // 6    Comparator 2 Hysteresis Disable
    Uint16  rsvd3:4;                   // 10:7 reserved
    Uint16  COMP3_HYST_DISABLE:1;      // 11   Comparator 3 Hysteresis Disable
    Uint16  rsvd4:4;                   // 15:12 reserved
};

union COMPHYSTCTL_REG
{
    Uint16      all;
    struct COMPHYSTCTL_BITS bit;
};

struct ADC_REGS
{
    union   ADCCTL1_REG         ADCCTL1;        // Control 1 Register
    union   ADCCTL2_REG         ADCCTL2;        // Control 2 Register
    Uint16                      rsvd1;          // Reserved
    Uint16                      rsvd2;          // Reserved
    union   ADCINT_REG          ADCINTFLG;      // Interrupt Flag Register
    union   ADCINT_REG          ADCINTFLGCLR;   // Interrupt Flag Clear Register
    union   ADCINT_REG          ADCINTOVF;      // Interrupt Overflow Register
    
    //
    // Interrupt Overflow Clear Register
    //
    union   ADCINT_REG          ADCINTOVFCLR;   
    
    //
    // Interrupt 1 and 2 Selection Register
    //
    union   INTSEL1N2_REG       INTSEL1N2;      
    
    //
    // Interrupt 3 and 4 Selection Register
    //
    union   INTSEL3N4_REG       INTSEL3N4;      
    
    //
    // Interrupt 5 and 6 Selection Register
    //
    union   INTSEL5N6_REG       INTSEL5N6;      
    
    //
    // Interrupt 7 and 8 Selection Register
    //
    union   INTSEL7N8_REG       INTSEL7N8;      
    
    //
    // Interrupt 9 Selection Register
    //
    union   INTSEL9N10_REG      INTSEL9N10;     
    
    Uint16                      rsvd3;          // Reserved
    Uint16                      rsvd4;          // Reserved
    Uint16                      rsvd5;          // Reserved
    union   SOCPRICTL_REG       SOCPRICTL;      // SOC Priority Control Register
    Uint16                      rsvd6;          // Reserved
    union   ADCSAMPLEMODE_REG   ADCSAMPLEMODE;  // Sampling Mode Register
    Uint16                      rsvd7;          // Reserved
    
    //
    // Interrupt SOC Selection 1 Register (for 8 channels)
    //
    union   ADCINTSOCSEL1_REG   ADCINTSOCSEL1;  
    
    //
    // Interrupt SOC Selection 2 Register (for 8 channels)
    //
    union   ADCINTSOCSEL2_REG   ADCINTSOCSEL2;  
    
    Uint16                      rsvd8;          // Reserved
    Uint16                      rsvd9;          // Reserved
    
    //
    // SOC Flag 1 Register (for 16 channels)
    //
    union   ADCSOC_REG          ADCSOCFLG1;     
    
    Uint16                      rsvd10;         // Reserved
    
    //
    // SOC Force 1 Register (for 16 channels)
    //
    union   ADCSOC_REG          ADCSOCFRC1;     
    
    Uint16                      rsvd11;         // Reserved
    
    //
    // SOC Overflow 1 Register (for 16 channels)
    //
    union   ADCSOC_REG          ADCSOCOVF1;     
    
    Uint16                      rsvd12;         // Reserved
    
    //
    // SOC Overflow Clear 1 Register (for 16 channels)
    //
    union   ADCSOC_REG          ADCSOCOVFCLR1;  
    
    Uint16                      rsvd13;         // Reserved
    union   ADCSOCxCTL_REG      ADCSOC0CTL;     // SOC0 Control Register
    union   ADCSOCxCTL_REG      ADCSOC1CTL;     // SOC1 Control Register
    union   ADCSOCxCTL_REG      ADCSOC2CTL;     // SOC2 Control Register
    union   ADCSOCxCTL_REG      ADCSOC3CTL;     // SOC3 Control Register
    union   ADCSOCxCTL_REG      ADCSOC4CTL;     // SOC4 Control Register
    union   ADCSOCxCTL_REG      ADCSOC5CTL;     // SOC5 Control Register
    union   ADCSOCxCTL_REG      ADCSOC6CTL;     // SOC6 Control Register
    union   ADCSOCxCTL_REG      ADCSOC7CTL;     // SOC7 Control Register
    union   ADCSOCxCTL_REG      ADCSOC8CTL;     // SOC8 Control Register
    union   ADCSOCxCTL_REG      ADCSOC9CTL;     // SOC9 Control Register
    union   ADCSOCxCTL_REG      ADCSOC10CTL;    // SOC10 Control Register
    union   ADCSOCxCTL_REG      ADCSOC11CTL;    // SOC11 Control Register
    union   ADCSOCxCTL_REG      ADCSOC12CTL;    // SOC12 Control Register
    union   ADCSOCxCTL_REG      ADCSOC13CTL;    // SOC13 Control Register
    union   ADCSOCxCTL_REG      ADCSOC14CTL;    // SOC14 Control Register
    union   ADCSOCxCTL_REG      ADCSOC15CTL;    // SOC15 Control Register
    Uint16                      rsvd14[16];     // Reserved
    union   ADCREFTRIM_REG      ADCREFTRIM;     // Reference Trim Register
    union   ADCOFFTRIM_REG      ADCOFFTRIM;     // Offset Trim Register
    Uint16                      rsvd15 [10];    // reserved
    
    //
    // COMP Hysteresis Control Register
    //
    union   COMPHYSTCTL_REG     COMPHYSTCTL;    
    
    Uint16                      rsvd16 [3];     // reserved
};

struct ADC_RESULT_REGS
{
    Uint16      ADCRESULT0;     // Conversion Result Buffer 0
    Uint16      ADCRESULT1;     // Conversion Result Buffer 1
    Uint16      ADCRESULT2;     // Conversion Result Buffer 2
    Uint16      ADCRESULT3;     // Conversion Result Buffer 3
    Uint16      ADCRESULT4;     // Conversion Result Buffer 4
    Uint16      ADCRESULT5;     // Conversion Result Buffer 5
    Uint16      ADCRESULT6;     // Conversion Result Buffer 6
    Uint16      ADCRESULT7;     // Conversion Result Buffer 7
    Uint16      ADCRESULT8;     // Conversion Result Buffer 8
    Uint16      ADCRESULT9;     // Conversion Result Buffer 9
    Uint16      ADCRESULT10;    // Conversion Result Buffer 10
    Uint16      ADCRESULT11;    // Conversion Result Buffer 11
    Uint16      ADCRESULT12;    // Conversion Result Buffer 12
    Uint16      ADCRESULT13;    // Conversion Result Buffer 13
    Uint16      ADCRESULT14;    // Conversion Result Buffer 14
    Uint16      ADCRESULT15;    // Conversion Result Buffer 15
};

//
// Adc External References & Function Declarations:
//
extern volatile struct ADC_REGS AdcRegs;
extern volatile struct ADC_RESULT_REGS AdcResult;




//
// End of file
//

//###########################################################################
//
// FILE:    F2806x_BootVars.h
//
// TITLE:   F2806x Boot Variable Definitions.
//
// NOTES:
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// External Boot ROM variable definitions:
//
extern Uint16 EmuKey;
extern Uint16 EmuBMode;
extern Uint32 Flash_CPUScaleFactor;
extern void (*Flash_CallbackPtr) (void);



//
// End of file.
//

//###########################################################################
//
// FILE:   F2806x_Cla.h
//
// TITLE:  F2806x Device CLA Register Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// CLA Individual Register Bit Definitions:
//
struct MCTL_BITS
{
	Uint16	HARDRESET:1;		// 0	Issue a hard reset
	Uint16	SOFTRESET:1;		// 1	Issue a soft reset
	Uint16	IACKE:1;			// 2	Enable IACK for task start
	Uint16	rsvd1:13;			// 15:3	Reserved
};

union MCTL_REG
{
	Uint16 all;
	struct MCTL_BITS	bit;
};

struct MMEMCFG_BITS
{
	Uint16	PROGE:1;			// 0	Program RAM Enable
	Uint16	rsvd1:3;			// 3:1	Reserved
	Uint16	RAM0E:1;			// 4	Data RAM 0 Enable
	Uint16	RAM1E:1;			// 5	Data RAM 1 Enable
	Uint16  RAM2E:1;			// 6	Data RAM 2 Enable
	Uint16	rsvd2:1;			// 7	Reserved
	Uint16	RAM0CPUE:1;			// 8	Data RAM 0 CPU Access Enable Bit
	Uint16	RAM1CPUE:1;			// 9    Data RAM 1 CPU Access Enable Bit
	Uint16	RAM2CPUE:1;			// 10	Data RAM 2 CPU Access Enable Bit
	Uint16	rsvd3:5;			// 15:11 Reserved
};

union MMEMCFG_REG
{
    Uint16 all;
	struct MMEMCFG_BITS	bit;
};

struct MPISRCSEL1_BITS
{
	Uint16	PERINT1SEL:4;			// 3:0	Source for CLA Interrupt 1
	Uint16	PERINT2SEL:4;			// 7:4	Source for CLA Interrupt 2
	Uint16	PERINT3SEL:4;			// 11:8	Source for CLA Interrupt 3
	Uint16	PERINT4SEL:4;			// 15:12	Source for CLA Interrupt 4
	Uint16	PERINT5SEL:4;			// 19:16	Source for CLA Interrupt 5
	Uint16	PERINT6SEL:4;			// 23:20	Source for CLA Interrupt 6
	Uint16	PERINT7SEL:4;			// 27:24	Source for CLA Interrupt 7
	Uint16	PERINT8SEL:4;			// 31:28	Source for CLA Interrupt 8
};

union MPISRCSEL1_REG
{
    Uint32 all;
	struct MPISRCSEL1_BITS	bit;
};

struct MIFR_BITS
{
	Uint16	INT1:1;			// 0	Interrupt 1 Flag
	Uint16	INT2:1;			// 1	Interrupt 2 Flag
	Uint16	INT3:1;			// 2	Interrupt 3 Flag
	Uint16	INT4:1;			// 3	Interrupt 4 Flag
	Uint16	INT5:1;			// 4	Interrupt 5 Flag
	Uint16	INT6:1;			// 5	Interrupt 6 Flag
	Uint16	INT7:1;			// 6	Interrupt 7 Flag
	Uint16	INT8:1;			// 7	Interrupt 8 Flag
	Uint16	rsvd1:8;		// 15:8	Reserved
};

union MIFR_REG
{
	Uint16 all;
	struct MIFR_BITS	bit;
};

union MIOVF_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

union MIFRC_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

union MICLR_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

union MICLROVF_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

union MIER_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

union MIRUN_REG
{
    Uint16              all;
    struct MIFR_BITS    bit;
};

struct MSTF_BITS
{
	Uint16	LVF:1;			// 0	Latched Overflow Flag
	Uint16	LUF:1;			// 1	Latched Underflow Flag
	Uint16	NF:1;			// 2	Negative Float Flag
	Uint16	ZF:1;			// 3	Zero Float Flag
	Uint16	rsvd1:2;		// 5:4	Reserved
	Uint16	TF:1;			// 6	Test Flag
	Uint16	rsvd2:2;		// 8:7	Reserved
	Uint16	RNDF32:1;		// 9	Rounding Mode
	Uint16	rsvd3:1;		// 10	Reserved
	Uint16	MEALLOW:1;		// 11	MEALLOW Status
	Uint16	RPCL:4;			// 15:12	Return PC: Low Portion
	Uint16	RPCH:8;			// 23:16	Return PC: High Portion
	Uint16	rsvd4:8;		// 31:24	Reserved
};

union MSTF_REG
{
	Uint32 all;
	struct MSTF_BITS	bit;
};

union MR_REG
{
    Uint32				i32;
	float				f32;
};

struct CLA_REGS
{
	Uint16					MVECT1;		// Task 1 Vecotr
	Uint16					MVECT2;		// Task 2 Vector
	Uint16					MVECT3;		// Task 3 Vector
	Uint16					MVECT4;		// Task 4 Vector
	Uint16					MVECT5;		// Task 5 Vector
	Uint16					MVECT6;		// Task 6 Vector
	Uint16					MVECT7;		// Task 7 Vecotr
	Uint16					MVECT8;		// Task 8 Vector
	Uint16					rsvd1[8];	// Reserved
	union	MCTL_REG		MCTL;		// CLA Control
	union	MMEMCFG_REG		MMEMCFG;	// CLA Memory Configuration
	Uint16					rsvd2[2];	// Reserved
	union	MPISRCSEL1_REG	MPISRCSEL1;	// CLA Interrupt Source Select
	Uint16					rsvd3[10];	// Reserved
	union	MIFR_REG		MIFR;		// CLA Interrupt Flag
	union	MIOVF_REG		MIOVF;		// CLA Interrupt Overflow Flag
	union	MIFRC_REG		MIFRC;		// CLA Interrupt Force
	union	MICLR_REG		MICLR;		// CLA Interrupt Flag Clear
	union	MICLROVF_REG	MICLROVF;	// CLA Interrupt Overflow Flag Clear
	union	MIER_REG		MIER;		// CLA Interrupt Enable
	union	MIRUN_REG		MIRUN;		// CLA Interrupt Run Status
	Uint16					rsvd4;		// Reserved
	Uint16					_MPC;		// CLA Program Counter
	Uint16					rsvd5;		// Reserved
	Uint16					_MAR0;		// CLA Auxillary Register 0
	Uint16					_MAR1;		// CLA Auxillary Register 1
	Uint16					rsvd6[2];	// Reserved
	union	MSTF_REG		_MSTF;		// CLA Floating-Point Status Register
	union	MR_REG			_MR0;		// CLA Result Register 0
	Uint32					rsvd7;		// Reserved
	union	MR_REG			_MR1;		// CLA Result Register 1
	Uint32					rsvd8;		// Reserved
	union	MR_REG			_MR2;		// CLA Result Register 2
	Uint32					rsvd9;		// Reserved
	union	MR_REG			_MR3;		// CLA Result Register 3
	Uint32					rsvd10;		// Reserved
};

//
// Cla External References & Function Declarations:
//
extern volatile struct CLA_REGS Cla1Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Comp.h
//
// TITLE:  F2806x Device COMP Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// COMP Individual Register Bit Definitions:
//
struct COMPCTL_BITS
{
	Uint16	COMPDACEN:1;	   // 0	Comparator/DAC Enable
	Uint16	COMPSOURCE:1;	   // 1	Source Select for inverting input
	Uint16	CMPINV:1;		   // 2	Invert Select for Comparator
	
    //
    // 7:3	Qualification Period for synchronized output
    //
    Uint16	QUALSEL:5;			
    
	Uint16	SYNCSEL:1;		   // 8	Synchronization select before ETPWM/GPIO
	Uint16	rsvd1:7;		   // 15:9	Reserved
};

union COMPCTL_REG
{
	Uint16 all;
	struct COMPCTL_BITS	bit;
};

struct COMPSTS_BITS
{
	Uint16	COMPSTS:1;			// 0	Logical latched value of the comparator
	Uint16	rsvd1:15;			// 15:1	Reserved
};

union COMPSTS_REG
{
	Uint16 all;
	struct COMPSTS_BITS	bit;
};

struct DACCTL_BITS
{
    Uint16   DACSOURCE:1;        // 0         DAC source control bits.
    Uint16   RAMPSOURCE:4;       // 4:01      Ramp generator source control bits
    Uint16   rsvd1:9;            // 13:05     reserved
    Uint16   FREE_SOFT:2;        // 15:14     Debug Mode Bit
};

union DACCTL_REG
{
    Uint16                         all;
    struct DACCTL_BITS             bit;
};

struct DACVAL_BITS
{
    Uint16	DACVAL:10;			// 9:0	DAC Value bits
	Uint16	rsvd1:6;			// 15:10	Reserved
};

union DACVAL_REG
{
	Uint16 all;
	struct DACVAL_BITS	bit;
};

//
//  Comparator Register Definitions
//
struct COMP_REGS
{
	union	COMPCTL_REG	COMPCTL;			// Comparator Control
	Uint16				rsvd1;				// Reserved
	union	COMPSTS_REG	COMPSTS;			// Compare Output States
    Uint16                     rsvd2;
    union  DACCTL_REG          DACCTL;
    Uint16                     rsvd3;
    union  DACVAL_REG          DACVAL;
    Uint16                     rsvd4;
    Uint16                     RAMPMAXREF_ACTIVE;
    Uint16                     rsvd5;
    Uint16                     RAMPMAXREF_SHDW;
    Uint16                     rsvd6;
    Uint16                     RAMPDECVAL_ACTIVE;
    Uint16                     rsvd7;
    Uint16                     RAMPDECVAL_SHDW;
    Uint16                     rsvd8;
    Uint16                     RAMPSTS;
    Uint16                     rsvd9[3];
};

//
// Comp External References & Function Declarations:
//
extern volatile struct COMP_REGS Comp1Regs;
extern volatile struct COMP_REGS Comp2Regs;
extern volatile struct COMP_REGS Comp3Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Cputimers.h
//
// TITLE:  F2806x Device CPUTIMERS Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// CPUTIMERS Individual Register Bit Definitions
//
struct TCR_BITS
{
	Uint16	rsvd1:4;		// 3:0  	Reserved
	Uint16	TSS:1;			// 4	CPU-Timer Top Status Bit
	Uint16	TRB:1;			// 5	CPU-Timer Reload Bit
	Uint16	rsvd2:4;		// 9:6	Reserved
	Uint16	SOFT:1;			// 10	CPU-Timer Emulation Mode
	Uint16	FREE:1;			// 11 	CPU-Timer Emulation Mode
	Uint16	rsvd3:2;		// 13:12	Reserved
	Uint16	TIE:1;			// 14	CPU-Timer Interrupt Enable
    Uint16	TIF:1;			// 15	CPU-Timer Interrupt Flag
};

union TCR_REG
{
	Uint16 all;
	struct TCR_BITS	bit;
};

struct TPR_BITS
{
    Uint16	TDDR:8;			// 7:0  	CPU-Timer Divide-Down
    Uint16	PSC:8;			// 15:8	CPU-Timer Prescale Counter
};

union TPR_REG
{
	Uint16 all;
	struct TPR_BITS	bit;
};

struct TPRH_BITS
{
	Uint16	TDDRH:8;		// 7:0  	CPU-Timer Divide-Down High Bits
	Uint16	PSCH:8;			// 15:8	CPU-Timer Prescale Counter High Bits
};

union TPRH_REG
{
	Uint16 all;
	struct TPRH_BITS	bit;
};

//
// TIM, TIMH: Timer register definitions:
//
struct TIM_REG
{
    Uint16  LSW;
    Uint16  MSW;
};

union TIM_GROUP
{
    Uint32          all;
    struct TIM_REG  half;
};

//
// PRD, PRDH: Period register definitions
//
struct PRD_REG
{
    Uint16  LSW;
    Uint16  MSW;
};

union PRD_GROUP
{
    Uint32          all;
    struct PRD_REG  half;
};

struct CPUTIMER_REGS
{
	union TIM_GROUP 	TIM;   		// Timer counter register
   	union PRD_GROUP 	PRD;   		// Period register
	union	TCR_REG		TCR;		// CPU-Timer Control Register
	Uint16				rsvd1;		// Reserved
	union	TPR_REG		TPR;		// CPU-Timer Prescale Register
	union	TPRH_REG	TPRH;		// CPU-Timer Prescale Register High
};

//
// Cputimers External References & Function Declarations:
//

//
// CPU Timer Support Variables:
//
struct CPUTIMER_VARS
{
    volatile struct  CPUTIMER_REGS  *RegsAddr;
    Uint32    InterruptCount;
    float   CPUFreqInMHz;
    float   PeriodInUSec;
};

//
// Function prototypes and external definitions:
//
void InitCpuTimers(void);
void ConfigCpuTimer(struct CPUTIMER_VARS *Timer, float Freq, float Period);

extern volatile struct CPUTIMER_REGS CpuTimer0Regs;
extern struct CPUTIMER_VARS CpuTimer0;

extern volatile struct CPUTIMER_REGS CpuTimer1Regs;
extern volatile struct CPUTIMER_REGS CpuTimer2Regs;

extern struct CPUTIMER_VARS CpuTimer1;
extern struct CPUTIMER_VARS CpuTimer2;

//
// Usefull Timer Operations:
//

//
// Start Timer:
//

//
// Stop Timer:
//

// Reload Timer With period Value:

//
// Read 32-Bit Timer Value:
//

//
// Read 32-Bit Period Value:
//

// Start Timer:

//
// Stop Timer:
//

// Reload Timer With period Value:

//
// Read 32-Bit Timer Value:
//

//
// Read 32-Bit Period Value:
//



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_DevEmu.h
//
// TITLE:  F2806x Device DEVEMU Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// DEVEMU Individual Register Bit Definitions:
//
struct DEVICECNF_BITS
{     
	Uint16	rsvd1:3;			// 2:0	Reserved
	Uint16	VMAPS:1;			// 3	VMAP Configure Status
	Uint16	rsvd2:1;			// 4	Reserved
	Uint16	XRSn:1;				// 5	Reset Input Signal Status
	Uint16	rsvd3:10;			// 15:6	Reserved
	Uint16  rsvd4:3;			// 18:16 Reserved
	Uint16	ENPROT:1;			// 19	Enable Write-Read Protection Mode Bit
	Uint16	rsvd5:7;			// 26:20 Reserved
	Uint16	TRSTn:1;			// 27	Read Status of TRSTn Signal
	Uint16	rsvd6:2;			// 29:28 Reserved
	Uint16	SYSCLK2DIV2DIS:1;	// 30 	SYSCLK2 Clock Divide by 2 Disable Bit
	Uint16	rsvd8:1;			// 31	Reserved
};

union DEVICECNF_REG 
{
	Uint32 all;
	struct DEVICECNF_BITS	bit;
};

//
// CLASSID
//
struct CLASSID_BITS
{
    Uint16 CLASSNO:8;            // 7:0   Class Number
    Uint16 PARTTYPE:8;           // 15:8  Part Type
};

union CLASSID_REG
{
    Uint16               all;
    struct CLASSID_BITS  bit;
};

struct DEV_EMU_REGS
{
    union DEVICECNF_REG DEVICECNF;  // Device Configuration
    union CLASSID_REG   CLASSID;    // Class ID
    Uint16              REVID;      // Device ID
};

//
// PARTID
//
struct PARTID_BITS
{
    Uint16 PARTNO:8;     // 7:0   Part Number
    Uint16 PARTTYPE:8;   // 15:8  Part Type
};

union PARTID_REG
{
    Uint16               all;
    struct PARTID_BITS   bit;
};

struct PARTID_REGS
{
    union PARTID_REG PARTID; // Part ID
};

//
// Devemu External References & Function Declarations:
//
extern volatile struct DEV_EMU_REGS DevEmuRegs;
extern volatile struct PARTID_REGS PartIdRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Dma.h
//
// TITLE:  F2806x Device DMA Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// DMA Individual Register Bit Definitions:
//
struct MODE_BITS
{
    Uint16  PERINTSEL:5;        // 4:0  Peripheral Interrupt and Sync Select
    Uint16  rsvd1:2;            // 6:5  Reserved
    Uint16  OVRINTE:1;          // 7    Overflow Interrupt Enable
    Uint16  PERINTE:1;          // 8    Peripheral Interrupt Enable
    Uint16  CHINTMODE:1;        // 9    Channel Interrupt Mode
    Uint16  ONESHOT:1;          // 10   One Shot Mode Bit
    Uint16  CONTINUOUS:1;       // 11   Continuous Mode Bit
    Uint16  rsvd2:2;            // 13:12    Reserved
    Uint16  DATASIZE:1;         // 14   Data Size Mode Bit
    Uint16  CHINTE:1;           // 15   Channel Interrupt Enable Bit
};

union MODE_REG
{
    Uint16 all;
    struct MODE_BITS    bit;
};

struct CONTROL_BITS
{
    Uint16  RUN:1;          // 0    Run Bit
    Uint16  HALT:1;         // 1    Halt Bit
    Uint16  SOFTRESET:1;    // 2    Soft Reset Bit
    Uint16  PERINTFRC:1;    // 3    Interrupt Force Bit
    Uint16  PERINTCLR:1;    // 4    Interrupt Clear Bit
    Uint16  rsvd2:2;        // 6:5  Reserved
    Uint16  ERRCLR:1;       // 7    Error Clear Bit
    Uint16  PERINTFLG:1;    // 8    Interrupt Flag Bit
    Uint16  SYNCFLG:1;      // 9    Sync Flag Bit
    Uint16  SYNCERR:1;      // 10   Sync Error Flag Bit
    Uint16  TRANSFERSTS:1;  // 11   Transfer Status Bit
    Uint16  BURSTSTS:1;     // 12   Burst Status Bit
    Uint16  RUNSTS:1;       // 13   Run Status Bit
    Uint16  OVRFLG:1;       // 14   Overflow Flag Bit
    Uint16  rsvd1:1;        // 15   Reserved
};

union CONTROL_REG
{
    Uint16 all;
    struct CONTROL_BITS bit;
};

struct DMACTRL_BITS
{
    Uint16  HARDRESET:1;            // 0    Hard Reset Bit
    Uint16  PRIORITYRESET:1;        // 1    Priority Reset Bit
    Uint16  rsvd1:14;               // 15:2 Reserved
};

union DMACTRL_REG
{
    Uint16 all;
    struct DMACTRL_BITS bit;
};

struct DEBUGCTRL_BITS
{
    Uint16  rsvd1:15;       // 14:0 Reserved
    Uint16  FREE:1;         // 15   Debug Mode Bit
};

union DEBUGCTRL_REG
{
    Uint16 all;
    struct DEBUGCTRL_BITS   bit;
};

struct PRIORITYCTRL1_BITS
{
    Uint16  CH1PRIORITY:1;      // 0    Ch1 Priority Bit
    Uint16  rsvd1:15;           // 15:1 Reserved
};

union PRIORITYCTRL1_REG
{
    Uint16 all;
    struct PRIORITYCTRL1_BITS   bit;
};

struct PRIORITYSTAT_BITS
{
    Uint16  ACTIVESTS:3;        // 2:0  Active Channel Status Bits
    Uint16  rsvd1:1;            // 3    Reserved
    Uint16  ACTIVESTS_SHADOW:3; // 6:4  Active Channel Status Shadow Bits
    Uint16  rsvd2:9;            // 15:7 Reserved
};

union PRIORITYSTAT_REG
{
    Uint16 all;
    struct PRIORITYSTAT_BITS    bit;
};

struct BURST_SIZE_BITS
{
    Uint16  BURSTSIZE:5;        // 4:0  Burst Transfer Size
    Uint16  rsvd1:11;           // 15:5 Reserved
};

union BURST_SIZE_REG
{
    Uint16 all;
    struct BURST_SIZE_BITS  bit;
};

struct BURST_COUNT_BITS
{
    Uint16  BURSTCOUNT:5;       // 4:0  Burst Transfer Count
    Uint16  rsvd1:11;           // 15:5 Reserved
};

union BURST_COUNT_REG
{
    Uint16 all;
    struct BURST_COUNT_BITS bit;
};

struct CH_REGS
{
    union   MODE_REG        MODE;                   // Mode Register
    union   CONTROL_REG     CONTROL;                // Control Register
    union   BURST_SIZE_REG  BURST_SIZE;             // Burst Size Register
    union   BURST_COUNT_REG BURST_COUNT;            // Burst Count Register
    
    //
    // Source Burst Step Register
    //
    int16                   SRC_BURST_STEP;         
    
    //
    // Destination Burst Step Register
    //
    int16                   DST_BURST_STEP;         
    
    Uint16                  TRANSFER_SIZE;          // Transfer Size Register
    Uint16                  TRANSFER_COUNT;         // Transfer Count Register
    
    //
    // Source Transfer Step Register
    //
    int16                   SRC_TRANSFER_STEP;      
    
    //
    // Destination Transfer Step Register
    //
    int16                   DST_TRANSFER_STEP;      
    
    Uint16                  SRC_WRAP_SIZE;    // Source Wrap Size Register
    Uint16                  SRC_WRAP_COUNT;   // Source Wrap Count Register
    int16                   SRC_WRAP_STEP;    // Source Wrap Step Register
    Uint16                  DST_WRAP_SIZE;    // Destination Wrap Size Register
    Uint16                  DST_WRAP_COUNT;   // Destination Wrap Count Register
    int16                   DST_WRAP_STEP;    // Destination Wrap Step Register
    
    //
    // Source Begin Address Shadow Register
    //
    Uint32                  SRC_BEG_ADDR_SHADOW;    
    
    //
    // Source Address Shadow Register
    //
    Uint32                  SRC_ADDR_SHADOW;        
    
    //
    // Source Begin Address Active Register
    //
    Uint32                  SRC_BEG_ADDR_ACTIVE;    
    
    //
    // Source Address Active Register
    //
    Uint32                  SRC_ADDR_ACTIVE;        
    
    //
    // Destination Begin Address Shadow Register
    //
    Uint32                  DST_BEG_ADDR_SHADOW;    
    
    //
    // Destination Address Shadow Register
    //
    Uint32                  DST_ADDR_SHADOW;        
    
    //
    // Destination Begin Address Active Register
    //
    Uint32                  DST_BEG_ADDR_ACTIVE;    
    
    //
    // Destination Address Active Registers
    //
    Uint32                  DST_ADDR_ACTIVE;        
};

struct DMA_REGS
{
    union   DMACTRL_REG         DMACTRL;        // DMA Control Register
    union   DEBUGCTRL_REG       DEBUGCTRL;      // Debug Control Register
    Uint16                      rsvd0;          // Reserved
    Uint16                      rsvd1;          // Reserved
    union   PRIORITYCTRL1_REG   PRIORITYCTRL1;  // Priority Control 1 Register
    Uint16                      rsvd2;          // Reserved
    union   PRIORITYSTAT_REG    PRIORITYSTAT;   // Priority Status Register
    Uint16                      rsvd3[25];      // Reserved
    struct CH_REGS              CH1;            // DMA Channel 1 Registers
    struct CH_REGS              CH2;            // DMA Channel 2 Registers
    struct CH_REGS              CH3;            // DMA Channel 3 Registers
    struct CH_REGS              CH4;            // DMA Channel 4 Registers
    struct CH_REGS              CH5;            // DMA Channel 5 Registers
    struct CH_REGS              CH6;            // DMA Channel 6 Registers
};

//
// Dma External References & Function Declarations:
//
extern volatile struct DMA_REGS DmaRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_ECan.h
//
// TITLE:  F2806x Device eCAN Register Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################




//
// eCAN Control & Status Registers
//

//
// eCAN Mailbox enable register (CANME) bit definitions
//
struct  CANME_BITS
{
    Uint16      ME0:1;     // 0   Enable Mailbox 0
    Uint16      ME1:1;     // 1   Enable Mailbox 1
    Uint16      ME2:1;     // 2   Enable Mailbox 2
    Uint16      ME3:1;     // 3   Enable Mailbox 3
    Uint16      ME4:1;     // 4   Enable Mailbox 4
    Uint16      ME5:1;     // 5   Enable Mailbox 5
    Uint16      ME6:1;     // 6   Enable Mailbox 6
    Uint16      ME7:1;     // 7   Enable Mailbox 7
    Uint16      ME8:1;     // 8   Enable Mailbox 8
    Uint16      ME9:1;     // 9   Enable Mailbox 9
    Uint16      ME10:1;    // 10  Enable Mailbox 10
    Uint16      ME11:1;    // 11  Enable Mailbox 11
    Uint16      ME12:1;    // 12  Enable Mailbox 12
    Uint16      ME13:1;    // 13  Enable Mailbox 13
    Uint16      ME14:1;    // 14  Enable Mailbox 14
    Uint16      ME15:1;    // 15  Enable Mailbox 15
    Uint16      ME16:1;    // 16  Enable Mailbox 16
    Uint16      ME17:1;    // 17  Enable Mailbox 17
    Uint16      ME18:1;    // 18  Enable Mailbox 18
    Uint16      ME19:1;    // 19  Enable Mailbox 19
    Uint16      ME20:1;    // 20  Enable Mailbox 20
    Uint16      ME21:1;    // 21  Enable Mailbox 21
    Uint16      ME22:1;    // 22  Enable Mailbox 22
    Uint16      ME23:1;    // 23  Enable Mailbox 23
    Uint16      ME24:1;    // 24  Enable Mailbox 24
    Uint16      ME25:1;    // 25  Enable Mailbox 25
    Uint16      ME26:1;    // 26  Enable Mailbox 26
    Uint16      ME27:1;    // 27  Enable Mailbox 27
    Uint16      ME28:1;    // 28  Enable Mailbox 28
    Uint16      ME29:1;    // 29  Enable Mailbox 29
    Uint16      ME30:1;    // 30  Enable Mailbox 30
    Uint16      ME31:1;    // 31  Enable Mailbox 31
};

//
// Allow access to the bit fields or entire register
//
union CANME_REG
{
    Uint32             all;
    struct CANME_BITS  bit;
};

//
// eCAN Mailbox direction register (CANMD) bit definitions
//
struct  CANMD_BITS
{
    Uint16      MD0:1;     // 0   0 -> Tx 1 -> Rx
    Uint16      MD1:1;     // 1   0 -> Tx 1 -> Rx
    Uint16      MD2:1;     // 2   0 -> Tx 1 -> Rx
    Uint16      MD3:1;     // 3   0 -> Tx 1 -> Rx
    Uint16      MD4:1;     // 4   0 -> Tx 1 -> Rx
    Uint16      MD5:1;     // 5   0 -> Tx 1 -> Rx
    Uint16      MD6:1;     // 6   0 -> Tx 1 -> Rx
    Uint16      MD7:1;     // 7   0 -> Tx 1 -> Rx
    Uint16      MD8:1;     // 8   0 -> Tx 1 -> Rx
    Uint16      MD9:1;     // 9   0 -> Tx 1 -> Rx
    Uint16      MD10:1;    // 10  0 -> Tx 1 -> Rx
    Uint16      MD11:1;    // 11  0 -> Tx 1 -> Rx
    Uint16      MD12:1;    // 12  0 -> Tx 1 -> Rx
    Uint16      MD13:1;    // 13  0 -> Tx 1 -> Rx
    Uint16      MD14:1;    // 14  0 -> Tx 1 -> Rx
    Uint16      MD15:1;    // 15  0 -> Tx 1 -> Rx
    Uint16      MD16:1;    // 16  0 -> Tx 1 -> Rx
    Uint16      MD17:1;    // 17  0 -> Tx 1 -> Rx
    Uint16      MD18:1;    // 18  0 -> Tx 1 -> Rx
    Uint16      MD19:1;    // 19  0 -> Tx 1 -> Rx
    Uint16      MD20:1;    // 20  0 -> Tx 1 -> Rx
    Uint16      MD21:1;    // 21  0 -> Tx 1 -> Rx
    Uint16      MD22:1;    // 22  0 -> Tx 1 -> Rx
    Uint16      MD23:1;    // 23  0 -> Tx 1 -> Rx
    Uint16      MD24:1;    // 24  0 -> Tx 1 -> Rx
    Uint16      MD25:1;    // 25  0 -> Tx 1 -> Rx
    Uint16      MD26:1;    // 26  0 -> Tx 1 -> Rx
    Uint16      MD27:1;    // 27  0 -> Tx 1 -> Rx
    Uint16      MD28:1;    // 28  0 -> Tx 1 -> Rx
    Uint16      MD29:1;    // 29  0 -> Tx 1 -> Rx
    Uint16      MD30:1;    // 30  0 -> Tx 1 -> Rx
    Uint16      MD31:1;    // 31  0 -> Tx 1 -> Rx
};

//
// Allow access to the bit fields or entire register
//
union CANMD_REG
{
    Uint32             all;
    struct CANMD_BITS  bit;
};

//
// eCAN Transmit Request Set register (CANTRS) bit definitions
//
struct  CANTRS_BITS
{
    Uint16      TRS0:1;     // 0   TRS for Mailbox 0
    Uint16      TRS1:1;     // 1   TRS for Mailbox 1
    Uint16      TRS2:1;     // 2   TRS for Mailbox 2
    Uint16      TRS3:1;     // 3   TRS for Mailbox 3
    Uint16      TRS4:1;     // 4   TRS for Mailbox 4
    Uint16      TRS5:1;     // 5   TRS for Mailbox 5
    Uint16      TRS6:1;     // 6   TRS for Mailbox 6
    Uint16      TRS7:1;     // 7   TRS for Mailbox 7
    Uint16      TRS8:1;     // 8   TRS for Mailbox 8
    Uint16      TRS9:1;     // 9   TRS for Mailbox 9
    Uint16      TRS10:1;    // 10  TRS for Mailbox 10
    Uint16      TRS11:1;    // 11  TRS for Mailbox 11
    Uint16      TRS12:1;    // 12  TRS for Mailbox 12
    Uint16      TRS13:1;    // 13  TRS for Mailbox 13
    Uint16      TRS14:1;    // 14  TRS for Mailbox 14
    Uint16      TRS15:1;    // 15  TRS for Mailbox 15
    Uint16      TRS16:1;    // 16  TRS for Mailbox 16
    Uint16      TRS17:1;    // 17  TRS for Mailbox 17
    Uint16      TRS18:1;    // 18  TRS for Mailbox 18
    Uint16      TRS19:1;    // 19  TRS for Mailbox 19
    Uint16      TRS20:1;    // 20  TRS for Mailbox 20
    Uint16      TRS21:1;    // 21  TRS for Mailbox 21
    Uint16      TRS22:1;    // 22  TRS for Mailbox 22
    Uint16      TRS23:1;    // 23  TRS for Mailbox 23
    Uint16      TRS24:1;    // 24  TRS for Mailbox 24
    Uint16      TRS25:1;    // 25  TRS for Mailbox 25
    Uint16      TRS26:1;    // 26  TRS for Mailbox 26
    Uint16      TRS27:1;    // 27  TRS for Mailbox 27
    Uint16      TRS28:1;    // 28  TRS for Mailbox 28
    Uint16      TRS29:1;    // 29  TRS for Mailbox 29
    Uint16      TRS30:1;    // 30  TRS for Mailbox 30
    Uint16      TRS31:1;    // 31  TRS for Mailbox 31
};

//
// Allow access to the bit fields or entire register
//
union CANTRS_REG
{
    Uint32              all;
    struct CANTRS_BITS  bit;
};

//
// eCAN Transmit Request Reset register (CANTRR) bit definitions
//
struct  CANTRR_BITS
{
    Uint16      TRR0:1;     // 0   TRR for Mailbox 0
    Uint16      TRR1:1;     // 1   TRR for Mailbox 1
    Uint16      TRR2:1;     // 2   TRR for Mailbox 2
    Uint16      TRR3:1;     // 3   TRR for Mailbox 3
    Uint16      TRR4:1;     // 4   TRR for Mailbox 4
    Uint16      TRR5:1;     // 5   TRR for Mailbox 5
    Uint16      TRR6:1;     // 6   TRR for Mailbox 6
    Uint16      TRR7:1;     // 7   TRR for Mailbox 7
    Uint16      TRR8:1;     // 8   TRR for Mailbox 8
    Uint16      TRR9:1;     // 9   TRR for Mailbox 9
    Uint16      TRR10:1;    // 10  TRR for Mailbox 10
    Uint16      TRR11:1;    // 11  TRR for Mailbox 11
    Uint16      TRR12:1;    // 12  TRR for Mailbox 12
    Uint16      TRR13:1;    // 13  TRR for Mailbox 13
    Uint16      TRR14:1;    // 14  TRR for Mailbox 14
    Uint16      TRR15:1;    // 15  TRR for Mailbox 15
    Uint16      TRR16:1;    // 16  TRR for Mailbox 16
    Uint16      TRR17:1;    // 17  TRR for Mailbox 17
    Uint16      TRR18:1;    // 18  TRR for Mailbox 18
    Uint16      TRR19:1;    // 19  TRR for Mailbox 19
    Uint16      TRR20:1;    // 20  TRR for Mailbox 20
    Uint16      TRR21:1;    // 21  TRR for Mailbox 21
    Uint16      TRR22:1;    // 22  TRR for Mailbox 22
    Uint16      TRR23:1;    // 23  TRR for Mailbox 23
    Uint16      TRR24:1;    // 24  TRR for Mailbox 24
    Uint16      TRR25:1;    // 25  TRR for Mailbox 25
    Uint16      TRR26:1;    // 26  TRR for Mailbox 26
    Uint16      TRR27:1;    // 27  TRR for Mailbox 27
    Uint16      TRR28:1;    // 28  TRR for Mailbox 28
    Uint16      TRR29:1;    // 29  TRR for Mailbox 29
    Uint16      TRR30:1;    // 30  TRR for Mailbox 30
    Uint16      TRR31:1;    // 31  TRR for Mailbox 31
};

//
// Allow access to the bit fields or entire register
//
union CANTRR_REG
{
    Uint32              all;
    struct CANTRR_BITS  bit;
};

//
// eCAN Transmit Acknowledge register (CANTA) bit definitions
//
struct  CANTA_BITS
{
    Uint16      TA0:1;     // 0   TA for Mailbox 0
    Uint16      TA1:1;     // 1   TA for Mailbox 1
    Uint16      TA2:1;     // 2   TA for Mailbox 2
    Uint16      TA3:1;     // 3   TA for Mailbox 3
    Uint16      TA4:1;     // 4   TA for Mailbox 4
    Uint16      TA5:1;     // 5   TA for Mailbox 5
    Uint16      TA6:1;     // 6   TA for Mailbox 6
    Uint16      TA7:1;     // 7   TA for Mailbox 7
    Uint16      TA8:1;     // 8   TA for Mailbox 8
    Uint16      TA9:1;     // 9   TA for Mailbox 9
    Uint16      TA10:1;    // 10  TA for Mailbox 10
    Uint16      TA11:1;    // 11  TA for Mailbox 11
    Uint16      TA12:1;    // 12  TA for Mailbox 12
    Uint16      TA13:1;    // 13  TA for Mailbox 13
    Uint16      TA14:1;    // 14  TA for Mailbox 14
    Uint16      TA15:1;    // 15  TA for Mailbox 15
    Uint16      TA16:1;    // 16  TA for Mailbox 16
    Uint16      TA17:1;    // 17  TA for Mailbox 17
    Uint16      TA18:1;    // 18  TA for Mailbox 18
    Uint16      TA19:1;    // 19  TA for Mailbox 19
    Uint16      TA20:1;    // 20  TA for Mailbox 20
    Uint16      TA21:1;    // 21  TA for Mailbox 21
    Uint16      TA22:1;    // 22  TA for Mailbox 22
    Uint16      TA23:1;    // 23  TA for Mailbox 23
    Uint16      TA24:1;    // 24  TA for Mailbox 24
    Uint16      TA25:1;    // 25  TA for Mailbox 25
    Uint16      TA26:1;    // 26  TA for Mailbox 26
    Uint16      TA27:1;    // 27  TA for Mailbox 27
    Uint16      TA28:1;    // 28  TA for Mailbox 28
    Uint16      TA29:1;    // 29  TA for Mailbox 29
    Uint16      TA30:1;    // 30  TA for Mailbox 30
    Uint16      TA31:1;    // 31  TA for Mailbox 31
};

//
// Allow access to the bit fields or entire register
//
union CANTA_REG
{
    Uint32             all;
    struct CANTA_BITS  bit;
};

//
// eCAN Transmit Abort Acknowledge register (CANAA) bit definitions
//
struct  CANAA_BITS
{
    Uint16      AA0:1;     // 0   AA for Mailbox 0
    Uint16      AA1:1;     // 1   AA for Mailbox 1
    Uint16      AA2:1;     // 2   AA for Mailbox 2
    Uint16      AA3:1;     // 3   AA for Mailbox 3
    Uint16      AA4:1;     // 4   AA for Mailbox 4
    Uint16      AA5:1;     // 5   AA for Mailbox 5
    Uint16      AA6:1;     // 6   AA for Mailbox 6
    Uint16      AA7:1;     // 7   AA for Mailbox 7
    Uint16      AA8:1;     // 8   AA for Mailbox 8
    Uint16      AA9:1;     // 9   AA for Mailbox 9
    Uint16      AA10:1;    // 10  AA for Mailbox 10
    Uint16      AA11:1;    // 11  AA for Mailbox 11
    Uint16      AA12:1;    // 12  AA for Mailbox 12
    Uint16      AA13:1;    // 13  AA for Mailbox 13
    Uint16      AA14:1;    // 14  AA for Mailbox 14
    Uint16      AA15:1;    // 15  AA for Mailbox 15
    Uint16      AA16:1;    // 16  AA for Mailbox 16
    Uint16      AA17:1;    // 17  AA for Mailbox 17
    Uint16      AA18:1;    // 18  AA for Mailbox 18
    Uint16      AA19:1;    // 19  AA for Mailbox 19
    Uint16      AA20:1;    // 20  AA for Mailbox 20
    Uint16      AA21:1;    // 21  AA for Mailbox 21
    Uint16      AA22:1;    // 22  AA for Mailbox 22
    Uint16      AA23:1;    // 23  AA for Mailbox 23
    Uint16      AA24:1;    // 24  AA for Mailbox 24
    Uint16      AA25:1;    // 25  AA for Mailbox 25
    Uint16      AA26:1;    // 26  AA for Mailbox 26
    Uint16      AA27:1;    // 27  AA for Mailbox 27
    Uint16      AA28:1;    // 28  AA for Mailbox 28
    Uint16      AA29:1;    // 29  AA for Mailbox 29
    Uint16      AA30:1;    // 30  AA for Mailbox 30
    Uint16      AA31:1;    // 31  AA for Mailbox 31
};

//
// Allow access to the bit fields or entire register
//
union CANAA_REG
{
    Uint32             all;
    struct CANAA_BITS  bit;
};

//
// eCAN Received Message Pending register (CANRMP) bit definitions 
//
struct  CANRMP_BITS
{
    Uint16      RMP0:1;     // 0   RMP for Mailbox 0
    Uint16      RMP1:1;     // 1   RMP for Mailbox 1
    Uint16      RMP2:1;     // 2   RMP for Mailbox 2
    Uint16      RMP3:1;     // 3   RMP for Mailbox 3
    Uint16      RMP4:1;     // 4   RMP for Mailbox 4
    Uint16      RMP5:1;     // 5   RMP for Mailbox 5
    Uint16      RMP6:1;     // 6   RMP for Mailbox 6
    Uint16      RMP7:1;     // 7   RMP for Mailbox 7
    Uint16      RMP8:1;     // 8   RMP for Mailbox 8
    Uint16      RMP9:1;     // 9   RMP for Mailbox 9
    Uint16      RMP10:1;    // 10  RMP for Mailbox 10
    Uint16      RMP11:1;    // 11  RMP for Mailbox 11
    Uint16      RMP12:1;    // 12  RMP for Mailbox 12
    Uint16      RMP13:1;    // 13  RMP for Mailbox 13
    Uint16      RMP14:1;    // 14  RMP for Mailbox 14
    Uint16      RMP15:1;    // 15  RMP for Mailbox 15
    Uint16      RMP16:1;    // 16  RMP for Mailbox 16
    Uint16      RMP17:1;    // 17  RMP for Mailbox 17
    Uint16      RMP18:1;    // 18  RMP for Mailbox 18
    Uint16      RMP19:1;    // 19  RMP for Mailbox 19
    Uint16      RMP20:1;    // 20  RMP for Mailbox 20
    Uint16      RMP21:1;    // 21  RMP for Mailbox 21
    Uint16      RMP22:1;    // 22  RMP for Mailbox 22
    Uint16      RMP23:1;    // 23  RMP for Mailbox 23
    Uint16      RMP24:1;    // 24  RMP for Mailbox 24
    Uint16      RMP25:1;    // 25  RMP for Mailbox 25
    Uint16      RMP26:1;    // 26  RMP for Mailbox 26
    Uint16      RMP27:1;    // 27  RMP for Mailbox 27
    Uint16      RMP28:1;    // 28  RMP for Mailbox 28
    Uint16      RMP29:1;    // 29  RMP for Mailbox 29
    Uint16      RMP30:1;    // 30  RMP for Mailbox 30
    Uint16      RMP31:1;    // 31  RMP for Mailbox 31

};

//
// Allow access to the bit fields or entire register 
//
union CANRMP_REG
{
    Uint32              all;
    struct CANRMP_BITS  bit;
};

//
// eCAN Received Message Lost register (CANRML) bit definitions 
//
struct  CANRML_BITS
{
    Uint16      RML0:1;     // 0   RML for Mailbox 0
    Uint16      RML1:1;     // 1   RML for Mailbox 1
    Uint16      RML2:1;     // 2   RML for Mailbox 2
    Uint16      RML3:1;     // 3   RML for Mailbox 3
    Uint16      RML4:1;     // 4   RML for Mailbox 4
    Uint16      RML5:1;     // 5   RML for Mailbox 5
    Uint16      RML6:1;     // 6   RML for Mailbox 6
    Uint16      RML7:1;     // 7   RML for Mailbox 7
    Uint16      RML8:1;     // 8   RML for Mailbox 8
    Uint16      RML9:1;     // 9   RML for Mailbox 9
    Uint16      RML10:1;    // 10  RML for Mailbox 10
    Uint16      RML11:1;    // 11  RML for Mailbox 11
    Uint16      RML12:1;    // 12  RML for Mailbox 12
    Uint16      RML13:1;    // 13  RML for Mailbox 13
    Uint16      RML14:1;    // 14  RML for Mailbox 14
    Uint16      RML15:1;    // 15  RML for Mailbox 15
    Uint16      RML16:1;    // 16  RML for Mailbox 16
    Uint16      RML17:1;    // 17  RML for Mailbox 17
    Uint16      RML18:1;    // 18  RML for Mailbox 18
    Uint16      RML19:1;    // 19  RML for Mailbox 19
    Uint16      RML20:1;    // 20  RML for Mailbox 20
    Uint16      RML21:1;    // 21  RML for Mailbox 21
    Uint16      RML22:1;    // 22  RML for Mailbox 22
    Uint16      RML23:1;    // 23  RML for Mailbox 23
    Uint16      RML24:1;    // 24  RML for Mailbox 24
    Uint16      RML25:1;    // 25  RML for Mailbox 25
    Uint16      RML26:1;    // 26  RML for Mailbox 26
    Uint16      RML27:1;    // 27  RML for Mailbox 27
    Uint16      RML28:1;    // 28  RML for Mailbox 28
    Uint16      RML29:1;    // 29  RML for Mailbox 29
    Uint16      RML30:1;    // 30  RML for Mailbox 30
    Uint16      RML31:1;    // 31  RML for Mailbox 31

};

//
// Allow access to the bit fields or entire register 
//
union CANRML_REG
{
    Uint32              all;
    struct CANRML_BITS  bit;
};

//
// eCAN Remote Frame Pending register (CANRFP) bit definitions 
//
struct  CANRFP_BITS
{
    Uint16      RFP0:1;     // 0   RFP for Mailbox 0
    Uint16      RFP1:1;     // 1   RFP for Mailbox 1
    Uint16      RFP2:1;     // 2   RFP for Mailbox 2
    Uint16      RFP3:1;     // 3   RFP for Mailbox 3
    Uint16      RFP4:1;     // 4   RFP for Mailbox 4
    Uint16      RFP5:1;     // 5   RFP for Mailbox 5
    Uint16      RFP6:1;     // 6   RFP for Mailbox 6
    Uint16      RFP7:1;     // 7   RFP for Mailbox 7
    Uint16      RFP8:1;     // 8   RFP for Mailbox 8
    Uint16      RFP9:1;     // 9   RFP for Mailbox 9
    Uint16      RFP10:1;    // 10  RFP for Mailbox 10
    Uint16      RFP11:1;    // 11  RFP for Mailbox 11
    Uint16      RFP12:1;    // 12  RFP for Mailbox 12
    Uint16      RFP13:1;    // 13  RFP for Mailbox 13
    Uint16      RFP14:1;    // 14  RFP for Mailbox 14
    Uint16      RFP15:1;    // 15  RFP for Mailbox 15
    Uint16      RFP16:1;    // 16  RFP for Mailbox 16
    Uint16      RFP17:1;    // 17  RFP for Mailbox 17
    Uint16      RFP18:1;    // 18  RFP for Mailbox 18
    Uint16      RFP19:1;    // 19  RFP for Mailbox 19
    Uint16      RFP20:1;    // 20  RFP for Mailbox 20
    Uint16      RFP21:1;    // 21  RFP for Mailbox 21
    Uint16      RFP22:1;    // 22  RFP for Mailbox 22
    Uint16      RFP23:1;    // 23  RFP for Mailbox 23
    Uint16      RFP24:1;    // 24  RFP for Mailbox 24
    Uint16      RFP25:1;    // 25  RFP for Mailbox 25
    Uint16      RFP26:1;    // 26  RFP for Mailbox 26
    Uint16      RFP27:1;    // 27  RFP for Mailbox 27
    Uint16      RFP28:1;    // 28  RFP for Mailbox 28
    Uint16      RFP29:1;    // 29  RFP for Mailbox 29
    Uint16      RFP30:1;    // 30  RFP for Mailbox 30
    Uint16      RFP31:1;    // 31  RFP for Mailbox 31
};

//
// Allow access to the bit fields or entire register 
//
union CANRFP_REG
{
    Uint32              all;
    struct CANRFP_BITS  bit;
};

//
// eCAN Global Acceptance Mask register (CANGAM) bit definitions 
//
struct  CANGAM_BITS
{
    Uint16 GAM150:16;    // 15:0  Global acceptance mask bits 0-15
    Uint16 GAM2816:13;   // 28:16 Global acceptance mask bits 16-28
    Uint16 rsvd:2;       // 30:29 reserved
    Uint16 AMI:1;        // 31    AMI bit
};

//
// Allow access to the bit fields or entire register 
//
union CANGAM_REG
{
    Uint32              all;
    struct CANGAM_BITS  bit;
};


//
// eCAN Master Control register (CANMC) bit definitions 
//
struct  CANMC_BITS
{
    Uint16      MBNR:5;     // 4:0   MBX # for CDR bit
    Uint16      SRES:1;     // 5     Soft reset
    Uint16      STM:1;      // 6     Self-test mode
    Uint16      ABO:1;      // 7     Auto bus-on
    Uint16      CDR:1;      // 8     Change data request
    Uint16      WUBA:1;     // 9     Wake-up on bus activity
    Uint16      DBO:1;      // 10    Data-byte order
    Uint16      PDR:1;      // 11    Power-down mode request
    Uint16      CCR:1;      // 12    Change configuration request
    Uint16      SCB:1;      // 13    SCC compatibility bit
    Uint16      TCC:1;      // 14    TSC MSB clear bit
    Uint16      MBCC:1;     // 15    TSC clear bit thru mailbox 16
    Uint16      SUSP:1;     // 16    SUSPEND free/soft bit
    Uint16      rsvd:15;    // 31:17  reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANMC_REG
{
    Uint32             all;
struct CANMC_BITS  bit;
};

//
// eCAN Bit -timing configuration register (CANBTC) bit definitions 
//
struct  CANBTC_BITS
{
    Uint16  TSEG2REG:3; // 2:0   TSEG2 register value
    Uint16  TSEG1REG:4; // 6:3   TSEG1 register value
    Uint16  SAM:1;      // 7     Sample-point setting
    Uint16  SJWREG:2;   // 9:8   Synchroniztion Jump Width register value
    Uint16  rsvd1:6;    // 15:10 reserved
    Uint16  BRPREG:8;   // 23:16 Baudrate prescaler register value
    Uint16  rsvd2:8;    // 31:24 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANBTC_REG
{
    Uint32              all;
    struct CANBTC_BITS  bit;
};

//
// eCAN Error & Status register (CANES) bit definitions 
//
struct  CANES_BITS
{
    Uint16   TM:1;       // 0     Transmit Mode
    Uint16   RM:1;       // 1     Receive Mode
    Uint16   rsvd1:1;    // 2     reserved
    Uint16   PDA:1;      // 3     Power-down acknowledge
    Uint16   CCE:1;      // 4     Change Configuration Enable
    Uint16   SMA:1;      // 5     Suspend Mode Acknowledge
    Uint16   rsvd2:10;   // 15:6  reserved
    Uint16   EW:1;       // 16    Warning status
    Uint16   EP:1;       // 17    Error Passive status
    Uint16   BO:1;       // 18    Bus-off status
    Uint16   ACKE:1;     // 19    Acknowledge error
    Uint16   SE:1;       // 20    Stuff error
    Uint16   CRCE:1;     // 21    CRC error
    Uint16   SA1:1;      // 22    Stuck at Dominant error
    Uint16   BE:1;       // 23    Bit error
    Uint16   FE:1;       // 24    Framing error
    Uint16   rsvd3:7;    // 31:25 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANES_REG
{
    Uint32             all;
    struct CANES_BITS  bit;
};


//
// eCAN Transmit Error Counter register (CANTEC) bit definitions 
//
struct  CANTEC_BITS
{
    Uint16 TEC:8;       // 7:0   TEC
    Uint16 rsvd1:8;     // 15:8  reserved
    Uint16 rsvd2:16;    // 31:16  reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANTEC_REG
{
    Uint32              all;
    struct CANTEC_BITS  bit;
};

//
// eCAN Receive Error Counter register (CANREC) bit definitions 
//
struct  CANREC_BITS
{
    Uint16 REC:8;       // 7:0   REC
    Uint16 rsvd1:8;     // 15:8  reserved
    Uint16 rsvd2:16;    // 31:16 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANREC_REG
{
    Uint32              all;
    struct CANREC_BITS  bit;
};

//
// eCAN Global Interrupt Flag 0 (CANGIF0) bit definitions 
//
struct  CANGIF0_BITS
{
    Uint16   MIV0:5;     // 4:0   Mailbox Interrupt Vector
    Uint16   rsvd1:3;    // 7:5   reserved
    Uint16   WLIF0:1;    // 8     Warning level interrupt flag
    Uint16   EPIF0:1;    // 9     Error-passive interrupt flag
    Uint16   BOIF0:1;    // 10    Bus-off interrupt flag
    Uint16   RMLIF0:1;   // 11    Received message lost interrupt flag
    Uint16   WUIF0:1;    // 12    Wakeup interrupt flag
    Uint16   WDIF0:1;    // 13    Write denied interrupt flag
    Uint16   AAIF0:1;    // 14    Abort Ack interrupt flag
    Uint16   GMIF0:1;    // 15    Global MBX interrupt flag
    Uint16   TCOF0:1;    // 16    TSC Overflow flag
    Uint16   MTOF0:1;    // 17    Mailbox Timeout flag
    Uint16   rsvd2:14;   // 31:18 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANGIF0_REG
{
    Uint32               all;
    struct CANGIF0_BITS  bit;
};

//
// eCAN Global Interrupt Mask register (CANGIM) bit definitions 
//
struct  CANGIM_BITS
{
    Uint16  I0EN:1;    // 0      Interrupt 0 enable
    Uint16  I1EN:1;    // 1      Interrupt 1 enable
    Uint16  GIL:1;     // 2      Global Interrupt Level
    Uint16  rsvd1:5;   // 7:3    reserved
    Uint16  WLIM:1;    // 8      Warning level interrupt mask
    Uint16  EPIM:1;    // 9      Error-passive interrupt mask
    Uint16  BOIM:1;    // 10     Bus-off interrupt mask
    Uint16  RMLIM:1;   // 11     Received message lost interrupt mask
    Uint16  WUIM:1;    // 12     Wakeup interrupt mask
    Uint16  WDIM:1;    // 13     Write denied interrupt mask
    Uint16  AAIM:1;    // 14     Abort Ack interrupt mask
    Uint16  rsvd2:1;   // 15     reserved
    Uint16  TCOM:1;    // 16     TSC overflow interrupt mask
    Uint16  MTOM:1;    // 17     MBX Timeout interrupt mask
    Uint16  rsvd3:14;  // 31:18  reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANGIM_REG
{
    Uint32              all;
    struct CANGIM_BITS  bit;
};


//
// eCAN Global Interrupt Flag 1 (eCANGIF1) bit definitions 
//
struct  CANGIF1_BITS
{
    Uint16      MIV1:5;     // 4:0   Mailbox Interrupt Vector
    Uint16      rsvd1:3;    // 7:5   reserved
    Uint16      WLIF1:1;    // 8     Warning level interrupt flag
    Uint16      EPIF1:1;    // 9     Error-passive interrupt flag
    Uint16      BOIF1:1;    // 10    Bus-off interrupt flag
    Uint16      RMLIF1:1;   // 11    Received message lost interrupt flag
    Uint16      WUIF1:1;    // 12    Wakeup interrupt flag
    Uint16      WDIF1:1;    // 13    Write denied interrupt flag
    Uint16      AAIF1:1;    // 14    Abort Ack interrupt flag
    Uint16      GMIF1:1;    // 15    Global MBX interrupt flag
    Uint16      TCOF1:1;    // 16    TSC Overflow flag
    Uint16      MTOF1:1;    // 17    Mailbox Timeout flag
    Uint16      rsvd2:14;   // 31:18 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANGIF1_REG
{
    Uint32               all;
    struct CANGIF1_BITS  bit;
};


//
// eCAN Mailbox Interrupt Mask register (CANMIM) bit definitions 
//
struct  CANMIM_BITS
{
    Uint16      MIM0:1;     // 0   MIM for Mailbox 0
    Uint16      MIM1:1;     // 1   MIM for Mailbox 1
    Uint16      MIM2:1;     // 2   MIM for Mailbox 2
    Uint16      MIM3:1;     // 3   MIM for Mailbox 3
    Uint16      MIM4:1;     // 4   MIM for Mailbox 4
    Uint16      MIM5:1;     // 5   MIM for Mailbox 5
    Uint16      MIM6:1;     // 6   MIM for Mailbox 6
    Uint16      MIM7:1;     // 7   MIM for Mailbox 7
    Uint16      MIM8:1;     // 8   MIM for Mailbox 8
    Uint16      MIM9:1;     // 9   MIM for Mailbox 9
    Uint16      MIM10:1;    // 10  MIM for Mailbox 10
    Uint16      MIM11:1;    // 11  MIM for Mailbox 11
    Uint16      MIM12:1;    // 12  MIM for Mailbox 12
    Uint16      MIM13:1;    // 13  MIM for Mailbox 13
    Uint16      MIM14:1;    // 14  MIM for Mailbox 14
    Uint16      MIM15:1;    // 15  MIM for Mailbox 15
    Uint16      MIM16:1;    // 16  MIM for Mailbox 16
    Uint16      MIM17:1;    // 17  MIM for Mailbox 17
    Uint16      MIM18:1;    // 18  MIM for Mailbox 18
    Uint16      MIM19:1;    // 19  MIM for Mailbox 19
    Uint16      MIM20:1;    // 20  MIM for Mailbox 20
    Uint16      MIM21:1;    // 21  MIM for Mailbox 21
    Uint16      MIM22:1;    // 22  MIM for Mailbox 22
    Uint16      MIM23:1;    // 23  MIM for Mailbox 23
    Uint16      MIM24:1;    // 24  MIM for Mailbox 24
    Uint16      MIM25:1;    // 25  MIM for Mailbox 25
    Uint16      MIM26:1;    // 26  MIM for Mailbox 26
    Uint16      MIM27:1;    // 27  MIM for Mailbox 27
    Uint16      MIM28:1;    // 28  MIM for Mailbox 28
    Uint16      MIM29:1;    // 29  MIM for Mailbox 29
    Uint16      MIM30:1;    // 30  MIM for Mailbox 30
    Uint16      MIM31:1;    // 31  MIM for Mailbox 31
};

//
// Allow access to the bit fields or entire register 
//
union CANMIM_REG
{
    Uint32              all;
    struct CANMIM_BITS  bit;
};

//
// eCAN Mailbox Interrupt Level register (CANMIL) bit definitions 
//
struct  CANMIL_BITS
{
    Uint16      MIL0:1;     // 0   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL1:1;     // 1   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL2:1;     // 2   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL3:1;     // 3   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL4:1;     // 4   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL5:1;     // 5   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL6:1;     // 6   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL7:1;     // 7   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL8:1;     // 8   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL9:1;     // 9   0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL10:1;    // 10  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL11:1;    // 11  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL12:1;    // 12  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL13:1;    // 13  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL14:1;    // 14  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL15:1;    // 15  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL16:1;    // 16  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL17:1;    // 17  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL18:1;    // 18  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL19:1;    // 19  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL20:1;    // 20  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL21:1;    // 21  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL22:1;    // 22  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL23:1;    // 23  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL24:1;    // 24  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL25:1;    // 25  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL26:1;    // 26  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL27:1;    // 27  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL28:1;    // 28  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL29:1;    // 29  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL30:1;    // 30  0 -> Int 9.5   1 -> Int 9.6
    Uint16      MIL31:1;    // 31  0 -> Int 9.5   1 -> Int 9.6
};

//
// Allow access to the bit fields or entire register 
//
union CANMIL_REG
{
    Uint32              all;
    struct CANMIL_BITS  bit;
};

//
// eCAN Overwrite Protection Control register (CANOPC) bit definitions 
//
struct  CANOPC_BITS
{
    Uint16      OPC0:1;     // 0   OPC for Mailbox 0
    Uint16      OPC1:1;     // 1   OPC for Mailbox 1
    Uint16      OPC2:1;     // 2   OPC for Mailbox 2
    Uint16      OPC3:1;     // 3   OPC for Mailbox 3
    Uint16      OPC4:1;     // 4   OPC for Mailbox 4
    Uint16      OPC5:1;     // 5   OPC for Mailbox 5
    Uint16      OPC6:1;     // 6   OPC for Mailbox 6
    Uint16      OPC7:1;     // 7   OPC for Mailbox 7
    Uint16      OPC8:1;     // 8   OPC for Mailbox 8
    Uint16      OPC9:1;     // 9   OPC for Mailbox 9
    Uint16      OPC10:1;    // 10  OPC for Mailbox 10
    Uint16      OPC11:1;    // 11  OPC for Mailbox 11
    Uint16      OPC12:1;    // 12  OPC for Mailbox 12
    Uint16      OPC13:1;    // 13  OPC for Mailbox 13
    Uint16      OPC14:1;    // 14  OPC for Mailbox 14
    Uint16      OPC15:1;    // 15  OPC for Mailbox 15
    Uint16      OPC16:1;    // 16  OPC for Mailbox 16
    Uint16      OPC17:1;    // 17  OPC for Mailbox 17
    Uint16      OPC18:1;    // 18  OPC for Mailbox 18
    Uint16      OPC19:1;    // 19  OPC for Mailbox 19
    Uint16      OPC20:1;    // 20  OPC for Mailbox 20
    Uint16      OPC21:1;    // 21  OPC for Mailbox 21
    Uint16      OPC22:1;    // 22  OPC for Mailbox 22
    Uint16      OPC23:1;    // 23  OPC for Mailbox 23
    Uint16      OPC24:1;    // 24  OPC for Mailbox 24
    Uint16      OPC25:1;    // 25  OPC for Mailbox 25
    Uint16      OPC26:1;    // 26  OPC for Mailbox 26
    Uint16      OPC27:1;    // 27  OPC for Mailbox 27
    Uint16      OPC28:1;    // 28  OPC for Mailbox 28
    Uint16      OPC29:1;    // 29  OPC for Mailbox 29
    Uint16      OPC30:1;    // 30  OPC for Mailbox 30
    Uint16      OPC31:1;    // 31  OPC for Mailbox 31
};

//
// Allow access to the bit fields or entire register 
//
union CANOPC_REG
{
    Uint32              all;
    struct CANOPC_BITS  bit;
};

//
// eCAN TX I/O Control Register (CANTIOC) bit definitions 
//
struct  CANTIOC_BITS
{
    Uint16  rsvd1:3;    // 2:0   reserved
    Uint16  TXFUNC:1;   // 3     TXFUNC
    Uint16  rsvd2:12;   // 15:4  reserved
    Uint16  rsvd3:16;   // 31:16 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANTIOC_REG
{
    Uint32               all;
    struct CANTIOC_BITS  bit;
};

//
// eCAN RX I/O Control Register (CANRIOC) bit definitions 
//
struct  CANRIOC_BITS
{
    Uint16  rsvd1:3;    // 2:0   reserved
    Uint16  RXFUNC:1;   // 3     RXFUNC
    Uint16  rsvd2:12;   // 15:4  reserved
    Uint16  rsvd3:16;   // 31:16 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANRIOC_REG
{
    Uint32               all;
    struct CANRIOC_BITS  bit;
};

//
// eCAN Time-out Control register (CANTOC) bit definitions 
//
struct  CANTOC_BITS
{
    Uint16      TOC0:1;     // 0   TOC for Mailbox 0
    Uint16      TOC1:1;     // 1   TOC for Mailbox 1
    Uint16      TOC2:1;     // 2   TOC for Mailbox 2
    Uint16      TOC3:1;     // 3   TOC for Mailbox 3
    Uint16      TOC4:1;     // 4   TOC for Mailbox 4
    Uint16      TOC5:1;     // 5   TOC for Mailbox 5
    Uint16      TOC6:1;     // 6   TOC for Mailbox 6
    Uint16      TOC7:1;     // 7   TOC for Mailbox 7
    Uint16      TOC8:1;     // 8   TOC for Mailbox 8
    Uint16      TOC9:1;     // 9   TOC for Mailbox 9
    Uint16      TOC10:1;    // 10  TOC for Mailbox 10
    Uint16      TOC11:1;    // 11  TOC for Mailbox 11
    Uint16      TOC12:1;    // 12  TOC for Mailbox 12
    Uint16      TOC13:1;    // 13  TOC for Mailbox 13
    Uint16      TOC14:1;    // 14  TOC for Mailbox 14
    Uint16      TOC15:1;    // 15  TOC for Mailbox 15
    Uint16      TOC16:1;    // 16  TOC for Mailbox 16
    Uint16      TOC17:1;    // 17  TOC for Mailbox 17
    Uint16      TOC18:1;    // 18  TOC for Mailbox 18
    Uint16      TOC19:1;    // 19  TOC for Mailbox 19
    Uint16      TOC20:1;    // 20  TOC for Mailbox 20
    Uint16      TOC21:1;    // 21  TOC for Mailbox 21
    Uint16      TOC22:1;    // 22  TOC for Mailbox 22
    Uint16      TOC23:1;    // 23  TOC for Mailbox 23
    Uint16      TOC24:1;    // 24  TOC for Mailbox 24
    Uint16      TOC25:1;    // 25  TOC for Mailbox 25
    Uint16      TOC26:1;    // 26  TOC for Mailbox 26
    Uint16      TOC27:1;    // 27  TOC for Mailbox 27
    Uint16      TOC28:1;    // 28  TOC for Mailbox 28
    Uint16      TOC29:1;    // 29  TOC for Mailbox 29
    Uint16      TOC30:1;    // 30  TOC for Mailbox 30
    Uint16      TOC31:1;    // 31  TOC for Mailbox 31
};

//
// Allow access to the bit fields or entire register 
//
union CANTOC_REG
{
    Uint32              all;
    struct CANTOC_BITS  bit;
};

//
// eCAN Time-out Status register (CANTOS) bit definitions 
//
struct  CANTOS_BITS
{
    Uint16      TOS0:1;     // 0   TOS for Mailbox 0
    Uint16      TOS1:1;     // 1   TOS for Mailbox 1
    Uint16      TOS2:1;     // 2   TOS for Mailbox 2
    Uint16      TOS3:1;     // 3   TOS for Mailbox 3
    Uint16      TOS4:1;     // 4   TOS for Mailbox 4
    Uint16      TOS5:1;     // 5   TOS for Mailbox 5
    Uint16      TOS6:1;     // 6   TOS for Mailbox 6
    Uint16      TOS7:1;     // 7   TOS for Mailbox 7
    Uint16      TOS8:1;     // 8   TOS for Mailbox 8
    Uint16      TOS9:1;     // 9   TOS for Mailbox 9
    Uint16      TOS10:1;    // 10  TOS for Mailbox 10
    Uint16      TOS11:1;    // 11  TOS for Mailbox 11
    Uint16      TOS12:1;    // 12  TOS for Mailbox 12
    Uint16      TOS13:1;    // 13  TOS for Mailbox 13
    Uint16      TOS14:1;    // 14  TOS for Mailbox 14
    Uint16      TOS15:1;    // 15  TOS for Mailbox 15
    Uint16      TOS16:1;    // 16  TOS for Mailbox 16
    Uint16      TOS17:1;    // 17  TOS for Mailbox 17
    Uint16      TOS18:1;    // 18  TOS for Mailbox 18
    Uint16      TOS19:1;    // 19  TOS for Mailbox 19
    Uint16      TOS20:1;    // 20  TOS for Mailbox 20
    Uint16      TOS21:1;    // 21  TOS for Mailbox 21
    Uint16      TOS22:1;    // 22  TOS for Mailbox 22
    Uint16      TOS23:1;    // 23  TOS for Mailbox 23
    Uint16      TOS24:1;    // 24  TOS for Mailbox 24
    Uint16      TOS25:1;    // 25  TOS for Mailbox 25
    Uint16      TOS26:1;    // 26  TOS for Mailbox 26
    Uint16      TOS27:1;    // 27  TOS for Mailbox 27
    Uint16      TOS28:1;    // 28  TOS for Mailbox 28
    Uint16      TOS29:1;    // 29  TOS for Mailbox 29
    Uint16      TOS30:1;    // 30  TOS for Mailbox 30
    Uint16      TOS31:1;    // 31  TOS for Mailbox 31
};

//
// Allow access to the bit fields or entire register 
//
union CANTOS_REG
{
    Uint32              all;
    struct CANTOS_BITS  bit;
};

//
// eCAN Control & Status register file 
//
struct ECAN_REGS
{
    union CANME_REG   CANME;          // Mailbox Enable
    union CANMD_REG   CANMD;          // Mailbox Direction
    union CANTRS_REG  CANTRS;         // Transmit Request Set
    union CANTRR_REG  CANTRR;         // Transmit Request Reset
    union CANTA_REG   CANTA;          // Transmit Acknowledge
    union CANAA_REG   CANAA;          // Abort Acknowledge
    union CANRMP_REG  CANRMP;         // Received Message Pending
    union CANRML_REG  CANRML;         // Received Message Lost
    union CANRFP_REG  CANRFP;         // Remote Frame Pending
    union CANGAM_REG  CANGAM;         // Global Acceptance Mask
    union CANMC_REG   CANMC;          // Master Control
    union CANBTC_REG  CANBTC;         // Bit Timing
    union CANES_REG   CANES;          // Error Status
    union CANTEC_REG  CANTEC;         // Transmit Error Counter
    union CANREC_REG  CANREC;         // Receive Error Counter
    union CANGIF0_REG CANGIF0;        // Global Interrupt Flag 0
    union CANGIM_REG  CANGIM;         // Global Interrupt Mask 0
    union CANGIF1_REG CANGIF1;        // Global Interrupt Flag 1
    union CANMIM_REG  CANMIM;         // Mailbox Interrupt Mask
    union CANMIL_REG  CANMIL;         // Mailbox Interrupt Level
    union CANOPC_REG  CANOPC;         // Overwrite Protection Control
    union CANTIOC_REG CANTIOC;        // TX I/O Control
    union CANRIOC_REG CANRIOC;        // RX I/O Control
    Uint32            CANTSC;         // Time-stamp counter
    union CANTOC_REG  CANTOC;         // Time-out Control
    union CANTOS_REG  CANTOS;         // Time-out Status
};

//
// eCAN Mailbox Registers                               
//

//
// eCAN Message ID (MSGID) bit definitions 
//
struct  CANMSGID_BITS
{
    Uint16      EXTMSGID_L:16;  // 15:0
    Uint16      EXTMSGID_H:2;   // 17:16
    Uint16      STDMSGID:11;    // 28:18
    Uint16      AAM:1;          // 29
    Uint16      AME:1;          // 30
    Uint16      IDE:1;          // 31
};

//
// Allow access to the bit fields or entire register 
//
union CANMSGID_REG
{
    Uint32                all;
    struct CANMSGID_BITS  bit;
};

//
// eCAN Message Control Register (MSGCTRL) bit definitions 
//
struct  CANMSGCTRL_BITS
{
    Uint16 DLC:4;          // 3:0
    Uint16 RTR:1;          // 4
    Uint16 rsvd1:3;        // 7:5   reserved
    Uint16 TPL:5;          // 12:8
    Uint16 rsvd2:3;        // 15:13 reserved
    Uint16 rsvd3:16;       // 31:16 reserved
};

//
// Allow access to the bit fields or entire register 
//
union CANMSGCTRL_REG
{
    Uint32                  all;
    struct CANMSGCTRL_BITS  bit;
};

//
// eCAN Message Data Register low (MDR_L) word definitions 
//
struct  CANMDL_WORDS
{
    Uint16      LOW_WORD:16; // 15:0
    Uint16      HI_WORD:16;  // 31:16
};

//
// eCAN Message Data Register low (MDR_L) byte definitions 
//
struct  CANMDL_BYTES
{
    Uint16      BYTE3:8;     // 7:0
    Uint16      BYTE2:8;     // 15:8
    Uint16      BYTE1:8;     // 23:16
    Uint16      BYTE0:8;     // 31:24
};

//
// Allow access to the bit fields or entire register 
//
union CANMDL_REG
{
    Uint32                all;
    struct CANMDL_WORDS   word;
    struct CANMDL_BYTES   byte;
};


//
// eCAN Message Data Register high  (MDR_H) word definitions 
//
struct  CANMDH_WORDS
{
    Uint16      LOW_WORD:16;    // 15:0
    Uint16      HI_WORD:16;     // 31:16
};

//
// eCAN Message Data Register low (MDR_H) byte definitions 
//
struct  CANMDH_BYTES
{
    Uint16      BYTE7:8;     // 7:0
    Uint16      BYTE6:8;     // 15:8
    Uint16      BYTE5:8;     // 23:16
    Uint16      BYTE4:8;     // 31:24
};

//
// Allow access to the bit fields or entire register 
//
union CANMDH_REG
{
    Uint32                  all;
    struct CANMDH_WORDS     word;
    struct CANMDH_BYTES     byte;
};

struct MBOX 
{
    union CANMSGID_REG     MSGID;
    union CANMSGCTRL_REG   MSGCTRL;
    union CANMDL_REG       MDL;
    union CANMDH_REG       MDH;
};

//
// eCAN Mailboxes             
//
struct ECAN_MBOXES 
{
    struct MBOX MBOX0;
    struct MBOX MBOX1;
    struct MBOX MBOX2;
    struct MBOX MBOX3;
    struct MBOX MBOX4;
    struct MBOX MBOX5;
    struct MBOX MBOX6;
    struct MBOX MBOX7;
    struct MBOX MBOX8;
    struct MBOX MBOX9;
    struct MBOX MBOX10;
    struct MBOX MBOX11;
    struct MBOX MBOX12;
    struct MBOX MBOX13;
    struct MBOX MBOX14;
    struct MBOX MBOX15;
    struct MBOX MBOX16;
    struct MBOX MBOX17;
    struct MBOX MBOX18;
    struct MBOX MBOX19;
    struct MBOX MBOX20;
    struct MBOX MBOX21;
    struct MBOX MBOX22;
    struct MBOX MBOX23;
    struct MBOX MBOX24;
    struct MBOX MBOX25;
    struct MBOX MBOX26;
    struct MBOX MBOX27;
    struct MBOX MBOX28;
    struct MBOX MBOX29;
    struct MBOX MBOX30;
    struct MBOX MBOX31;
};

//
// eCAN Local Acceptance Mask (LAM) bit definitions 
//
struct  CANLAM_BITS
{
    Uint16      LAM_L:16;     // 15:0
    Uint16      LAM_H:13;     // 28:16
    Uint16 rsvd1:2;           // 30:29   reserved
    Uint16      LAMI:1;       // 31
};

//
// Allow access to the bit fields or entire register 
//
union CANLAM_REG
{
    Uint32        all;
    struct CANLAM_BITS  bit;
};

//
// eCAN Local Acceptance Masks      
//

//
// eCAN LAM File 
//
struct LAM_REGS
{
    union CANLAM_REG LAM0;
    union CANLAM_REG LAM1;
    union CANLAM_REG LAM2;
    union CANLAM_REG LAM3;
    union CANLAM_REG LAM4;
    union CANLAM_REG LAM5;
    union CANLAM_REG LAM6;
    union CANLAM_REG LAM7;
    union CANLAM_REG LAM8;
    union CANLAM_REG LAM9;
    union CANLAM_REG LAM10;
    union CANLAM_REG LAM11;
    union CANLAM_REG LAM12;
    union CANLAM_REG LAM13;
    union CANLAM_REG LAM14;
    union CANLAM_REG LAM15;
    union CANLAM_REG LAM16;
    union CANLAM_REG LAM17;
    union CANLAM_REG LAM18;
    union CANLAM_REG LAM19;
    union CANLAM_REG LAM20;
    union CANLAM_REG LAM21;
    union CANLAM_REG LAM22;
    union CANLAM_REG LAM23;
    union CANLAM_REG LAM24;
    union CANLAM_REG LAM25;
    union CANLAM_REG LAM26;
    union CANLAM_REG LAM27;
    union CANLAM_REG LAM28;
    union CANLAM_REG LAM29;
    union CANLAM_REG LAM30;
    union CANLAM_REG LAM31;
};

//
// Mailbox MOTS File 
//
struct MOTS_REGS
{
    Uint32 MOTS0;
    Uint32 MOTS1;
    Uint32 MOTS2;
    Uint32 MOTS3;
    Uint32 MOTS4;
    Uint32 MOTS5;
    Uint32 MOTS6;
    Uint32 MOTS7;
    Uint32 MOTS8;
    Uint32 MOTS9;
    Uint32 MOTS10;
    Uint32 MOTS11;
    Uint32 MOTS12;
    Uint32 MOTS13;
    Uint32 MOTS14;
    Uint32 MOTS15;
    Uint32 MOTS16;
    Uint32 MOTS17;
    Uint32 MOTS18;
    Uint32 MOTS19;
    Uint32 MOTS20;
    Uint32 MOTS21;
    Uint32 MOTS22;
    Uint32 MOTS23;
    Uint32 MOTS24;
    Uint32 MOTS25;
    Uint32 MOTS26;
    Uint32 MOTS27;
    Uint32 MOTS28;
    Uint32 MOTS29;
    Uint32 MOTS30;
    Uint32 MOTS31;
};

//
// Mailbox MOTO File 
//
struct MOTO_REGS
{
    Uint32 MOTO0;
    Uint32 MOTO1;
    Uint32 MOTO2;
    Uint32 MOTO3;
    Uint32 MOTO4;
    Uint32 MOTO5;
    Uint32 MOTO6;
    Uint32 MOTO7;
    Uint32 MOTO8;
    Uint32 MOTO9;
    Uint32 MOTO10;
    Uint32 MOTO11;
    Uint32 MOTO12;
    Uint32 MOTO13;
    Uint32 MOTO14;
    Uint32 MOTO15;
    Uint32 MOTO16;
    Uint32 MOTO17;
    Uint32 MOTO18;
    Uint32 MOTO19;
    Uint32 MOTO20;
    Uint32 MOTO21;
    Uint32 MOTO22;
    Uint32 MOTO23;
    Uint32 MOTO24;
    Uint32 MOTO25;
    Uint32 MOTO26;
    Uint32 MOTO27;
    Uint32 MOTO28;
    Uint32 MOTO29;
    Uint32 MOTO30;
    Uint32 MOTO31;
};

//
// eCAN External References & Function Declarations:
//
extern volatile struct ECAN_REGS ECanaRegs;
extern volatile struct ECAN_MBOXES ECanaMboxes;
extern volatile struct LAM_REGS ECanaLAMRegs;
extern volatile struct MOTO_REGS ECanaMOTORegs;
extern volatile struct MOTS_REGS ECanaMOTSRegs;



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Ecap.h
//
// TITLE:  F2806x Device eCAP Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// eCAP Individual Register Bit Definitions:
//
struct ECCTL1_BITS
{
	Uint16	CAP1POL:1;		// 0	Capture Event 1 Polarity select
	Uint16	CTRRST1:1;		// 1	Counter Reset on Capture Event 1
	Uint16	CAP2POL:1;		// 2	Capture Event 2 Polarity select
	Uint16	CTRRST2:1;		// 3	Counter Reset on Capture Event 2
	Uint16	CAP3POL:1;		// 4	Capture Event 3 Polarity select
	Uint16	CTRRST3:1;		// 5	Counter Reset on Capture Event 3
	Uint16	CAP4POL:1;		// 6	Capture Event 4 Polarity select
	Uint16	CTRRST4:1;		// 7	Counter Reset on Capture Event 4
	Uint16	CAPLDEN:1;		// 8	Enable Loading CAP1-4 regs on a Cap Event
	Uint16	PRESCALE:5;		// 13:9	Event Filter prescale select
	Uint16	FREE_SOFT:2;	// 15:14	Emulation mode
};

union ECCTL1_REG
{
	Uint16 all;
	struct ECCTL1_BITS	bit;
};

struct ECCTL2_BITS
{
	Uint16	CONT_ONESHT:1;		// 0	Continuous or one-shot
	
    //
    // 2:1	"Stop value for one-shot, Wrap for continuous"
    //
    Uint16	STOP_WRAP:2;		
    
	Uint16	REARM:1;			// 3	One-shot re-arm
	Uint16	TSCTRSTOP:1;		// 4	TSCNT counter stop
	Uint16	SYNCI_EN:1;			// 5	Counter sync-in select
	Uint16	SYNCO_SEL:2;		// 7:6	Sync-out mode
	Uint16	SWSYNC:1;			// 8	SW forced counter sync
	Uint16	CAP_APWM:1;			// 9	CAP/APWM operating mode select
	Uint16	APWMPOL:1;			// 10	APWM output polarity select
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union ECCTL2_REG
{
	Uint16 all;
	struct ECCTL2_BITS	bit;
};

struct ECEINT_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	CEVT1:1;			// 1	Capture Event 1 Interrupt Enable
	Uint16	CEVT2:1;			// 2	Capture Event 2 Interrupt Enable
	Uint16	CEVT3:1;			// 3	Capture Event 3 Interrupt Enable
	Uint16	CEVT4:1;			// 4	Capture Event 4 Interrupt Enable
	Uint16	CTROVF:1;			// 5	Counter Overflow Interrupt Enable
	Uint16	CTR_EQ_PRD:1;		// 6	Period Equal Interrupt Enable
	Uint16	CTR_EQ_CMP:1;		// 7	Compare Equal Interrupt Enable
	Uint16	rsvd2:8;			// 15:8	Reserved
};

union ECEINT_REG
{
	Uint16 all;
	struct ECEINT_BITS	bit;
};


struct ECFLG_BITS
{
	Uint16	INT:1;				// 0	Global Flag
	Uint16	CEVT1:1;			// 1	Capture Event 1 Interrupt Flag
	Uint16	CEVT2:1;			// 2	Capture Event 2 Interrupt Flag
	Uint16	CEVT3:1;			// 3	Capture Event 3 Interrupt Flag
	Uint16	CEVT4:1;			// 4	Capture Event 4 Interrupt Flag
	Uint16	CTROVF:1;			// 5	Counter Overflow Interrupt Flag
	Uint16	CTR_EQ_PRD:1;		// 6	Period Equal Interrupt Flag
	Uint16	CTR_EQ_CMP:1;		// 7	Compare Equal Interrupt Flag
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union ECFLG_REG
{
	Uint16 all;
	struct ECFLG_BITS	bit;
};

struct ECAP_REGS
{
	Uint32				TSCTR;		// Time Stamp Counter
    Uint32				CTRPHS;		// Counter phase
	Uint32				CAP1;		// Capture 1
	Uint32				CAP2;		// Capture 2
	Uint32				CAP3;		// Capture 3
	Uint32				CAP4;		// Capture 4
	Uint16				rsvd1[8];	// Reserved
	union	ECCTL1_REG	ECCTL1;		// Capture Control Reg 1
	union	ECCTL2_REG	ECCTL2;		// Capture Control Reg 2
	union	ECEINT_REG	ECEINT;		// ECAP interrupt enable
	union	ECFLG_REG	ECFLG;		// ECAP interrupt flags
	union	ECFLG_REG	ECCLR;		// ECAP interrupt clear
	union	ECEINT_REG	ECFRC;		// ECAP interrupt force
	Uint16				rsvd2[6];	// Reserved
};

//
// Ecap External References & Function Declarations:
//
extern volatile struct ECAP_REGS ECap1Regs;
extern volatile struct ECAP_REGS ECap2Regs;
extern volatile struct ECAP_REGS ECap3Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Epwm.h
//
// TITLE:  F2806x Device EPWM Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// EPWM Individual Register Bit Definitions:
//
struct TBCTL_BITS
{
	Uint16	CTRMODE:2;			// 1:0	Counter Mode
	Uint16	PHSEN:1;			// 2	Phase Load Enable
	Uint16	PRDLD:1;			// 3	Active Period Load
	Uint16	SYNCOSEL:2;			// 5:4	Sync Output Select
	Uint16	SWFSYNC:1;			// 6	Software Force Sync Pulse
	Uint16	HSPCLKDIV:3;		// 9:7	High Speed TBCLK Pre-scaler
	Uint16	CLKDIV:3;			// 12:10	Time Base Clock Pre-scaler
	Uint16	PHSDIR:1;			// 13	Phase Direction Bit
	Uint16	FREE_SOFT:2;		// 15:14	Emulation Mode Bits
};

union TBCTL_REG
{
	Uint16 all;
	struct TBCTL_BITS	bit;
};

struct TBSTS_BITS
{
	Uint16	CTRDIR:1;			// 0	Counter Direction Status
	Uint16	SYNCI:1;			// 1	External Input Sync Status
	Uint16	CTRMAX:1;			// 2	Counter Max Latched Status
	Uint16	rsvd1:13;			// 15:3	Reserved
};

union TBSTS_REG
{
	Uint16 all;
	struct TBSTS_BITS	bit;
};

struct CMPCTL_BITS
{
	Uint16	LOADAMODE:2;		// 1:0	Active Compare A Load
	Uint16	LOADBMODE:2;		// 3:2	Active Compare B Load
	Uint16	SHDWAMODE:1;		// 4	Compare A Register Block Operating Mode
	Uint16	rsvd1:1;			// 5	Reserved
	Uint16	SHDWBMODE:1;		// 6	Compare B Register Block Operating Mode
	Uint16	rsvd2:1;			// 7	Reserved
	Uint16	SHDWAFULL:1;		// 8	Compare A Shadow Register Full Status
	Uint16	SHDWBFULL:1;		// 9	Compare B Shadow Register Full Status
    Uint16 rsvd3:6;             // 15:10  reserved
};

union CMPCTL_REG
{
	Uint16 all;
	struct CMPCTL_BITS	bit;
};

struct AQCTL_BITS
{
	Uint16	ZRO:2;			// 1:0	Action Counter = Zero
	Uint16	PRD:2;			// 3:2	Action Counter = Period
	Uint16	CAU:2;			// 5:4	Action Counter = Compare A Up
	Uint16	CAD:2;			// 7:6	Action Counter = Compare A Down
	Uint16	CBU:2;			// 9:8	Action Counter = Compare B Up
	Uint16	CBD:2;			// 11:10	Action Counter = Compare B Down
	Uint16	rsvd1:4;		// 15:12	Reserved
};

union AQCTL_REG
{
	Uint16 all;
	struct AQCTL_BITS	bit;
};

struct AQSFRC_BITS
{
	Uint16	ACTSFA:2;			// 1:0	Action when One-time SW Force A Invoked
	Uint16	OTSFA:1;			// 2	One-time SW Force A Output
	Uint16	ACTSFB:2;			// 4:3	Action when One-time SW Force B Invoked
	Uint16	OTSFB:1;			// 5	One-time SW Force A Output
	Uint16	RLDCSF:2;			// 7:6	Reload from Shadow Options
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union AQSFRC_REG
{
	Uint16 all;
	struct AQSFRC_BITS	bit;
};

struct AQCSFRC_BITS
{
	Uint16	CSFA:2;			// 1:0	Continuous Software Force on output A
	Uint16	CSFB:2;			// 3:2	Continuous Software Force on output B
	Uint16	rsvd1:12;		// 15:4	Reserved
};

union AQCSFRC_REG
{
	Uint16 all;
	struct AQCSFRC_BITS	bit;
};

struct DBCTL_BITS
{
	Uint16	OUT_MODE:2;			// 1:0	Dead Band Output Mode Control
	Uint16	POLSEL:2;			// 3:2	Polarity Select Control
	Uint16	IN_MODE:2;			// 5:4	Dead Band Input Select Mode Control
	Uint16	rsvd1:9;			// 14:6	Reserved
	Uint16	HALFCYCLE:1;		// 15	Half Cycle Clocking Enable
};

union DBCTL_REG
{
	Uint16 all;
	struct DBCTL_BITS	bit;
};

struct TZSEL_BITS
{
	Uint16	CBC1:1;			// 0	TZ1 CBC select
	Uint16	CBC2:1;			// 1	TZ2 CBC select
	Uint16	CBC3:1;			// 2	TZ3 CBC select
	Uint16	CBC4:1;			// 3	TZ4 CBC select
	Uint16	CBC5:1;			// 4	TZ5 CBC select
	Uint16	CBC6:1;			// 5	TZ6 CBC select
	Uint16	DCAEVT2:1;		// 6	DCAEVT2 CBC select
	Uint16	DCBEVT2:1;		// 7	DCBEVT2 CBC select
	Uint16	OSHT1:1;		// 8	One-shot TZ1 select
	Uint16	OSHT2:1;		// 9	One-shot TZ2 select
	Uint16	OSHT3:1;		// 10	One-shot TZ3 select
	Uint16	OSHT4:1;		// 11	One-shot TZ4 select
	Uint16	OSHT5:1;		// 12	One-shot TZ5 select
	Uint16	OSHT6:1;		// 13	One-shot TZ6 select
	Uint16	DCAEVT1:1;		// 14	One-shot DCAEVT1 select
	Uint16	DCBEVT1:1;		// 15	One-shot DCBEVT1 select
};

union TZSEL_REG
{
	Uint16 all;
	struct TZSEL_BITS	bit;
};

struct TZDCSEL_BITS
{
	Uint16	DCAEVT1:3;			// 2:0	Digital Compare Output A Event 1
	Uint16	DCAEVT2:3;			// 5:3	Digital Compare Output A Event 2
	Uint16	DCBEVT1:3;			// 8:6	Digital Compare Output B Event 1
	Uint16	DCBEVT2:3;			// 11:9	Digital Compare Output B Event 2
	Uint16	rsvd1:4;			// 15:12	Reserved
};

union TZDCSEL_REG
{
	Uint16 all;
	struct TZDCSEL_BITS	bit;
};

struct TZCTL_BITS
{
	Uint16	TZA:2;			// 1:0	TZ1 to TZ6 Trip Action On EPWMxA
	Uint16	TZB:2;			// 3:2	TZ1 to TZ6 Trip Action On EPWMxB
	Uint16	DCAEVT1:2;		// 5:4	EPWMxA action on DCAEVT1
	Uint16	DCAEVT2:2;		// 7:6	EPWMxA action on DCAEVT2
	Uint16	DCBEVT1:2;		// 9:8	EPWMxB action on DCBEVT1
	Uint16	DCBEVT2:2;		// 11:10	EPWMxB action on DCBEVT2
	Uint16	rsvd1:4;		// 15:12	Reserved
};

union TZCTL_REG
{
	Uint16 all;
	struct TZCTL_BITS	bit;
};

struct TZEINT_BITS
{
	Uint16	rsvd1:1;		// 0	Reserved
	Uint16	CBC:1;			// 1	Trip Zones Cycle By Cycle Int Enable
	Uint16	OST:1;			// 2	Trip Zones One Shot Int Enable
	Uint16	DCAEVT1:1;		// 3	Digital Compare A Event 1 Int Enable
	Uint16	DCAEVT2:1;		// 4	Digital Compare A Event 2 Int Enable
	Uint16	DCBEVT1:1;		// 5	Digital Compare B Event 1 Int Enable
	Uint16	DCBEVT2:1;		// 6	Digital Compare B Event 2 Int Enable
	Uint16	rsvd2:9;		// 15:7	Reserved
};

union TZEINT_REG
{
	Uint16 all;
	struct TZEINT_BITS	bit;
};

struct TZFLG_BITS
{
	Uint16	INT:1;			// 0	Global Int Status Flag
	Uint16	CBC:1;			// 1	Trip Zones Cycle By Cycle Flag
	Uint16	OST:1;			// 2	Trip Zones One Shot Flag
	Uint16	DCAEVT1:1;		// 3	Digital Compare A Event 1 Flag
	Uint16	DCAEVT2:1;		// 4	Digital Compare A Event 2 Flag
	Uint16	DCBEVT1:1;		// 5	Digital Compare B Event 1 Flag
	Uint16	DCBEVT2:1;		// 6	Digital Compare B Event 2 Flag
	Uint16	rsvd1:9;		// 15:7	Reserved
};

union TZFLG_REG
{
	Uint16 all;
	struct TZFLG_BITS	bit;
};

struct TZCLR_BITS
{
	Uint16	INT:1;			// 0	Global Interrupt Clear Flag
	Uint16	CBC:1;			// 1	Cycle-By-Cycle Flag Clear
	Uint16	OST:1;			// 2	One-Shot Flag Clear
	Uint16	DCAEVT1:1;		// 3	DCAVET1 Flag Clear
	Uint16	DCAEVT2:1;		// 4	DCAEVT2 Flag Clear
	Uint16	DCBEVT1:1;		// 5	DCBEVT1 Flag Clear
	Uint16	DCBEVT2:1;		// 6	DCBEVT2 Flag Clear
	Uint16	rsvd1:9;		// 15:7	Reserved
};

union TZCLR_REG
{
	Uint16 all;
	struct TZCLR_BITS	bit;
};

struct TZFRC_BITS
{
	Uint16	rsvd1:1;		// 0	Reserved
	Uint16	CBC:1;			// 1	Force Trip Zones Cycle By Cycle Event
	Uint16	OST:1;			// 2	Force Trip Zones One Shot Event
	Uint16	DCAEVT1:1;		// 3	Force Digital Compare A Event 1
	Uint16	DCAEVT2:1;		// 4	Force Digital Compare A Event 2
	Uint16	DCBEVT1:1;		// 5	Force Digital Compare B Event 1
	Uint16	DCBEVT2:1;		// 6	Force Digital Compare B Event 2
	Uint16	rsvd2:9;		// 15:7	Reserved
};

union TZFRC_REG
{
	Uint16 all;
	struct TZFRC_BITS	bit;
};

struct ETSEL_BITS
{
	Uint16	INTSEL:3;			// 2:0	EPWMxINTn Select
	Uint16	INTEN:1;			// 3	EPWMxINTn Enable
	Uint16	rsvd1:4;			// 7:4	Reserved
	Uint16	SOCASEL:3;			// 10:8	Start of Conversion A Select
	Uint16	SOCAEN:1;			// 11	Start of Conversion A Enable
	Uint16	SOCBSEL:3;			// 14:12	Start of Conversion B Select
	Uint16	SOCBEN:1;			// 15	Start of Conversion B Enable
};

union ETSEL_REG
{
	Uint16 all;
	struct ETSEL_BITS	bit;
};

struct ETPS_BITS
{
	Uint16	INTPRD:2;			// 1:0	EPWMxINTn Period Select
	Uint16	INTCNT:2;			// 3:2	EPWMxINTn Counter Register
	Uint16	rsvd1:4;			// 7:4	Reserved
	Uint16	SOCAPRD:2;			// 9:8	EPWMxSOCA Period Select
	Uint16	SOCACNT:2;			// 11:10	EPWMxSOCA Counter Register
	Uint16	SOCBPRD:2;			// 13:12	EPWMxSOCB Period Select
	Uint16	SOCBCNT:2;			// 15:14	EPWMxSOCB Counter
};

union ETPS_REG
{
	Uint16 all;
	struct ETPS_BITS	bit;
};

struct ETFLG_BITS
{
	Uint16	INT:1;			// 0	EPWMxINTn Flag
	Uint16	rsvd1:1;		// 1	Reserved
	Uint16	SOCA:1;			// 2	EPWMxSOCA Flag
	Uint16	SOCB:1;			// 3	EPWMxSOCB Flag
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union ETFLG_REG
{
	Uint16 all;
	struct ETFLG_BITS	bit;
};

struct ETCLR_BITS
{
	Uint16	INT:1;			// 0	EPWMxINTn Clear
	Uint16	rsvd1:1;		// 1	Reserved
	Uint16	SOCA:1;			// 2	EPWMxSOCA Clear
	Uint16	SOCB:1;			// 3	EPWMxSOCB Clear
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union ETCLR_REG
{
	Uint16 all;
	struct ETCLR_BITS	bit;
};

struct ETFRC_BITS
{
	Uint16	INT:1;			// 0	EPWMxINTn Force
	Uint16	rsvd1:1;		// 1	Reserved
	Uint16	SOCA:1;			// 2	EPWMxSOCA Force
	Uint16	SOCB:1;			// 3	EPWMxSOCB Force
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union ETFRC_REG
{
	Uint16 all;
	struct ETFRC_BITS	bit;
};

struct PCCTL_BITS
{
	Uint16	CHPEN:1;			// 0	PWM chopping enable
	Uint16	OSHTWTH:4;			// 4:1	One-shot pulse width
	Uint16	CHPFREQ:3;			// 7:5	Chopping clock frequency
	Uint16	CHPDUTY:3;			// 10:8	Chopping clock Duty cycle
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union PCCTL_REG
{
	Uint16 all;
	struct PCCTL_BITS	bit;
};

struct HRCNFG_BITS
{
	Uint16	EDGMODE:2;			// 1:0	ePWMxA Edge Mode Select Bits
	Uint16	CTLMODE:1;			// 2	ePWMxA Control Mode Select Bits
	Uint16	HRLOAD:2;			// 4:3	ePWMxA Shadow Mode Select Bits
	Uint16	SELOUTB:1;			// 5	EPWMB Output Selection Bit
	Uint16	AUTOCONV:1;			// 6	Autoconversion Bit
	Uint16	SWAPAB:1;			// 7	Swap EPWMA and EPWMB Outputs Bit
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union HRCNFG_REG
{
	Uint16 all;
	struct HRCNFG_BITS	bit;
};

struct HRPWR_BITS {       	// bits   description
   Uint16  rsvd1:6;     	// 5:0    reserved
   Uint16  MEPOFF:4;     	// 9:6    MEP Calibration Off Bits
   Uint16  rsvd2:6;      	// 15:10  reserved
};

union HRPWR_REG
{
   Uint16                  	all;
   struct HRPWR_BITS        bit;
};

struct HRPCTL_BITS
{
	Uint16	HRPE:1;				// 0	High Resolution Period Enable
	Uint16	PWMSYNCSEL:1;       // 1      PWMSYNC Source Select Bit 
	Uint16	TBPHSHRLOADE:1;		// 2	TBPHSHR Load Enable
	Uint16	rsvd1:13;			// 15:3	Reserved
};

union HRPCTL_REG
{
	Uint16 all;
	struct HRPCTL_BITS	bit;
};

struct DCTRIPSEL_BITS
{
	Uint16	DCAHCOMPSEL:4;	   // 3:0	Digital Compare A High COMP Input Select
	Uint16	DCALCOMPSEL:4;	   // 7:4	Digital Compare A Low COMP Input Select
	Uint16	DCBHCOMPSEL:4;	   // 11:8	Digital Compare B High COMP Input Select
	Uint16	DCBLCOMPSEL:4;	   // 15:12	Digital Compare B Low COMP Input Select
};

union DCTRIPSEL_REG
{
	Uint16 all;
	struct DCTRIPSEL_BITS	bit;
};

struct DCCTL_BITS
{
	Uint16	EVT1SRCSEL:1;			// 0	DCAEVT1 Source Signal
	Uint16	EVT1FRCSYNCSEL:1;		// 1	DCAEVT1 Force Sync Signal
	Uint16	EVT1SOCE:1;				// 2	DCAEVT1 SOC Enable
	Uint16	EVT1SYNCE:1;			// 3	DCAEVT1 SYNC Enable
	Uint16	rsvd1:4;				// 7:4	Reserved
	Uint16	EVT2SRCSEL:1;			// 8	DCAEVT2 Source Signal
	Uint16	EVT2FRCSYNCSEL:1;		// 9	DCAEVT2 Force Sync Signal
	Uint16	rsvd2:6;				// 15:10	Reserved
};

union DCCTL_REG
{
	Uint16 all;
	struct DCCTL_BITS	bit;
};

struct DCFCTL_BITS
{
	Uint16	SRCSEL:2;			// 1:0	Filter Block Signal Source Select
	Uint16	BLANKE:1;			// 2	Blanking Enable/Disable
	Uint16	BLANKINV:1;			// 3	Blanking Window Inversion
	
    //
    // 5:4	Pulse Select for Blanking & Capture Alignment
    //
    Uint16	PULSESEL:2;			
    
	Uint16	rsvd1:10;			// 15:6	Reserved
};

union DCFCTL_REG
{
	Uint16 all;
	struct DCFCTL_BITS	bit;
};

struct DCCAPCTL_BITS
{
	Uint16	CAPE:1;				// 0	Counter Capture Enable
	Uint16	SHDWMODE:1;			// 1	Counter Capture Mode
	Uint16	rsvd1:14;			// 15:2	Reserved
};

union DCCAPCTL_REG
{
	Uint16 all;
	struct DCCAPCTL_BITS	bit;
};

struct TBPHS_HRPWM_REG
{
    Uint16  TBPHSHR;       // 15:0   Extension register for HRPWM Phase (8 bits)
    Uint16  TBPHS;         // 31:16  Phase offset register
};

union TBPHS_HRPWM_GROUP
{
    Uint32                  all;
    struct TBPHS_HRPWM_REG  half;
};

struct CMPA_HRPWM_REG
{
    Uint16  CMPAHR;      // 15:0   Extension register for HRPWM compare (8 bits)
    Uint16  CMPA;        // 31:16  Compare A reg
};

union CMPA_HRPWM_GROUP
{
    Uint32                 all;
    struct CMPA_HRPWM_REG  half;
};

struct TBPRD_HRPWM_REG
{
    Uint16  TBPRDHR;     // 15:0   Extension register for HRPWM Period (8 bits)
    Uint16  TBPRD;       // 31:16  Timebase Period Register
};

union TBPRD_HRPWM_GROUP 
{
    Uint32                  all;
    struct TBPRD_HRPWM_REG  half;
};

struct EPWM_REGS
{
	union	TBCTL_REG			TBCTL;		// Time Base Control Register
	union	TBSTS_REG			TBSTS;		// Time Base Status Register
	union	TBPHS_HRPWM_GROUP   TBPHS;		// Union of TBPHS:TBPHSHR
	Uint16						TBCTR;		// Time Base Counter Register
	Uint16						TBPRD;		// Time Base Period Register
	
    //
    // Time Base Period High Resolution Register
    //
    Uint16						TBPRDHR;	
    
	union	CMPCTL_REG			CMPCTL;		// Counter Compare Control Register
	union	CMPA_HRPWM_GROUP 	CMPA;		// Union of CMPA:CMPAHR
	Uint16						CMPB;		// Counter Compare B Register
	
    //
    // Action Qualifier Control Register For Output A
    //
    union	AQCTL_REG			AQCTLA;		
    
    //
    // Action Qualifier Control Register For Output B
    //
	union	AQCTL_REG			AQCTLB;		
    
	//
    // Action Qualifier Software Force Register
    //
    union	AQSFRC_REG			AQSFRC;		
    
	//
    // Action Qualifier Continuous S/W Force Register
    //
    union	AQCSFRC_REG			AQCSFRC;	
    
    //
    // Dead-Band Generator Control Register
    //
	union	DBCTL_REG			DBCTL;		
    
    //
    // Dead-Band Generator Rising Edge Delay Count Register
    //
	Uint16						DBRED;		
    
    //
    // Dead-Band Generator Falling Edge Delay Count Register
    //
	Uint16						DBFED;		
    
	union	TZSEL_REG			TZSEL;		// Trip Zone Select Register
	
    //
    // Trip Zone Digital Comparator Select Register
    //
    union	TZDCSEL_REG			TZDCSEL;	
    
	union	TZCTL_REG			TZCTL;		// Trip Zone Control Register
	
    //
    // Trip Zone Enable Interrupt Register
    //
    union	TZEINT_REG			TZEINT;		
    
	union	TZFLG_REG			TZFLG;		// Trip Zone Flag Register
	union	TZCLR_REG			TZCLR;		// Trip Zone Clear Register
	union	TZFRC_REG			TZFRC;		// Trip Zone Force Register
	union	ETSEL_REG			ETSEL;		// Event Trigger Selection Register
	union	ETPS_REG			ETPS;		// Event Trigger Pre-Scale Register
	union	ETFLG_REG			ETFLG;		// Event Trigger Flag Register
	union	ETCLR_REG			ETCLR;		// Event Trigger Clear Register
	union	ETFRC_REG			ETFRC;		// Event Trigger Force Register
	union	PCCTL_REG			PCCTL;		// PWM Chopper Control Register
	Uint16						rsvd1;		// Reserved
	union	HRCNFG_REG			HRCNFG;		// HRPWM Configuration Register
    union   HRPWR_REG			HRPWR;      // HRPWM Power Register
	Uint16						rsvd2;		// Reserved
	Uint16						rsvd3;		// Reserved
	Uint16						rsvd4;		// Reserved
	Uint16						rsvd5;		// Reserved
	Uint16						HRMSTEP;	// HRPWM MEP Step Register
	Uint16						rsvd6;		// Reserved
	
    //
    // High Resolution Period Control Register
    //
    union	HRPCTL_REG			HRPCTL;		
    
	Uint16						rsvd7;		// Reserved
	
    //
    // Union of TBPRD:TBPRDHR mirror registers
    //
    union   TBPRD_HRPWM_GROUP   TBPRDM;     
    
    //
    // Union of CMPA:CMPAHR mirror registers
    //
    union   CMPA_HRPWM_GROUP    CMPAM;      
    
	Uint16						rsvd8[2];	// Reserved
	
    //
    // Digital Compare Trip Select Register
    //
    union	DCTRIPSEL_REG		DCTRIPSEL;	
    
    
	union	DCCTL_REG			DCACTL;	   // Digital Compare A Control Register
	union	DCCTL_REG			DCBCTL;	   // Digital Compare B Control Register
	
    //
    // Digital Compare Filter Control Register
    //
    union	DCFCTL_REG			DCFCTL;		
    
    //
    // Digital Compare Capture Control Register
    //
	union	DCCAPCTL_REG		DCCAPCTL;	
    
    //
    // Digital Compare Filter Offset Register
    //
	Uint16						DCFOFFSET;	
	
    //
    // Digital Compare Filter Offset Counter Register
    //
    Uint16						DCFOFFSETCNT;
    
    //
    // Digital Compare Filter Window Register
    //
	Uint16						DCFWINDOW;		
    
    //
    // Digital Compare Filter Window Counter Register
    //
	Uint16						DCFWINDOWCNT;	
    
    //
    // Digital Compare Counter Capture Register
    //
	Uint16						DCCAP;			
    
	Uint16                      rsvd9[6];
};

//
// Epwm External References & Function Declarations:
//
extern volatile struct EPWM_REGS EPwm1Regs;
extern volatile struct EPWM_REGS EPwm2Regs;
extern volatile struct EPWM_REGS EPwm3Regs;
extern volatile struct EPWM_REGS EPwm4Regs;
extern volatile struct EPWM_REGS EPwm5Regs;
extern volatile struct EPWM_REGS EPwm6Regs;
extern volatile struct EPWM_REGS EPwm7Regs;
extern volatile struct EPWM_REGS EPwm8Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Eqep.h
//
// TITLE:  F2806x Device EQEP Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// EQEP Individual Register Bit Definitions:
//
struct QDECCTL_BITS
{
	Uint16	rsvd1:5;		// 4:0	Reserved
	Uint16	QSP:1;			// 5	QEPS Input Polarity
	Uint16	QIP:1;			// 6	QEPI Input Polarity
	Uint16	QBP:1;			// 7	QEPB Input Polarity
	Uint16	QAP:1;			// 8	QEPA Input Polarity
	Uint16	IGATE:1;		// 9	Index Pulse Gating Option
	Uint16	SWAP:1;			// 10	CLK/DIR Signal Source for Position Counter
	Uint16	XCR:1;			// 11	External Clock Rate
	Uint16	SPSEL:1;		// 12	Sync Output Pin Select
	Uint16	SOEN:1;			// 13	Enable Position Compare Sync
	Uint16	QSRC:2;			// 15:14	Postion Counter Source
};

union QDECCTL_REG
{
	Uint16 all;
	struct QDECCTL_BITS	bit;
};

struct QEPCTL_BITS
{
	Uint16	WDE:1;			// 0	QEP watchdog enable
	Uint16	UTE:1;			// 1	QEP unit timer enable
	Uint16	QCLM:1;			// 2	QEP capture latch mode
	Uint16	QPEN:1;			// 3	Quadrature postotion counter enable
	Uint16	IEL:2;			// 5:4	Index event latch
	Uint16	SEL:1;			// 6	Strobe event latch
	Uint16	SWI:1;			// 7	Software init position counter
	Uint16	IEI:2;			// 9:8	Index event init of position count
	Uint16	SEI:2;			// 11:10	Strobe event init
	Uint16	PCRM:2;			// 13:12	Postion counter reset
	Uint16	FREE_SOFT:2;	// 15:14	Emulation mode
};

union QEPCTL_REG
{
	Uint16 all;
	struct QEPCTL_BITS	bit;
};

struct QCAPCTL_BITS
{
	Uint16	UPPS:4;			// 3:0	Unit position pre-scale
	Uint16	CCPS:3;			// 6:4	QEP capture timer pre-scale
	Uint16	rsvd1:8;		// 14:7	Reserved
	Uint16	CEN:1;			// 15	Enable QEP capture
};

union QCAPCTL_REG
{
	Uint16 all;
	struct QCAPCTL_BITS	bit;
};

struct QPOSCTL_BITS
{
	Uint16	PCSPW:12;		// 11:0	Position compare sync pulse width
	Uint16	PCE:1;			// 12	Position compare enable/disable
	Uint16	PCPOL:1;		// 13	Polarity of sync output
	Uint16	PCLOAD:1;		// 14	Position compare of shadow load
	Uint16	PCSHDW:1;		// 15	Position compare of shadow enable
};

union QPOSCTL_REG
{
	Uint16 all;
	struct QPOSCTL_BITS	bit;
};

struct QEINT_BITS
{
	Uint16	rsvd1:1;		// 0	Reserved
	Uint16	PCE:1;			// 1	Position counter error
	Uint16	QPE:1;			// 2	Quadrature phase error
	Uint16	QDC:1;			// 3	Quadrature dir change
	Uint16	WTO:1;			// 4	Watchdog timeout
	Uint16	PCU:1;			// 5	Position counter underflow
	Uint16	PCO:1;			// 6	Position counter overflow
	Uint16	PCR:1;			// 7	Position compare ready
	Uint16	PCM:1;			// 8	Position compare match
	Uint16	SEL:1;			// 9	Strobe event latch
	Uint16	IEL:1;			// 10	Event latch
	Uint16	UTO:1;			// 11	Unit timeout
	Uint16	rsvd2:4;		// 15:12	Reserved
};

union QEINT_REG
{
	Uint16 all;
	struct QEINT_BITS	bit;
};

struct QFLG_BITS
{
	Uint16	INT:1;			// 0	Global.interrupt
	Uint16	PCE:1;			// 1	Position counter error
	Uint16	PHE:1;			// 2	Quadrature phase error
	Uint16	QDC:1;			// 3	Quadrature dir change
	Uint16	WTO:1;			// 4	Watchdog timeout
	Uint16	PCU:1;			// 5	Position counter underflow
	Uint16	PCO:1;			// 6	Position counter overflow
	Uint16	PCR:1;			// 7	Position compare ready
	Uint16	PCM:1;			// 8	Position compare match
	Uint16	SEL:1;			// 9	Strobe event latch
	Uint16	IEL:1;			// 10	Event latch
	Uint16	UTO:1;			// 11	Unit timeout
	Uint16	rsvd1:4;		// 15:12	Reserved
};

union QFLG_REG
{
	Uint16 all;
	struct QFLG_BITS	bit;
};

struct QFRC_BITS
{
	Uint16	rsvd1:1;		// 0	Reserved
	Uint16	PCE:1;			// 1	Position counter error
	Uint16	PHE:1;			// 2	Quadrature phase error
	Uint16	QDC:1;			// 3	Quadrature dir change
	Uint16	WTO:1;			// 4	Watchdog timeout
	Uint16	PCU:1;			// 5	Position counter underflow
	Uint16	PCO:1;			// 6	Position counter overflow
	Uint16	PCR:1;			// 7	Position compare ready
	Uint16	PCM:1;			// 8	Position compare match
	Uint16	SEL:1;			// 9	Strobe event latch
	Uint16	IEL:1;			// 10	Event latch
	Uint16	UTO:1;			// 11	Unit timeout
	Uint16	rsvd2:4;		// 15:12	Reserved
};

union QFRC_REG
{
	Uint16 all;
	struct QFRC_BITS	bit;
};

struct QEPSTS_BITS
{
	Uint16	PCEF:1;			// 0	Position counter error
	Uint16	FIMF:1;			// 1	First index marker
	Uint16	CDEF:1;			// 2	Capture direction error
	Uint16	COEF:1;			// 3	Capture overflow error
	Uint16	QDLF:1;			// 4	QEP direction latch
	Uint16	QDF:1;			// 5	Quadrature direction
	Uint16	FIDF:1;			// 6	Direction on first index marker
	Uint16	UPEVNT:1;		// 7	Unit position event flag
	Uint16	rsvd1:8;		// 15:8	Reserved
};

union QEPSTS_REG
{
	Uint16 all;
	struct QEPSTS_BITS	bit;
};

struct EQEP_REGS
{
	Uint32				QPOSCNT;	// Position Counter
	Uint32				QPOSINIT;	// Position Counter Init
	Uint32				QPOSMAX;	// Maximum Position Count
	Uint32				QPOSCMP;	// Position Compare
	Uint32				QPOSILAT;	// Index Position Latch
	Uint32				QPOSSLAT;	// Strobe Position Latch
	Uint32				QPOSLAT;	// Position Latch
	Uint32				QUTMR;		// QEP Unit Timer
	Uint32				QUPRD;		// QEP Unit Period
	Uint16				QWDTMR;		// QEP Watchdog Timer
	Uint16				QWDPRD;		// QEP Watchdog Period
	union	QDECCTL_REG	QDECCTL;	// Quadrature Decoder Control
	union	QEPCTL_REG	QEPCTL;		// QEP Control
	union	QCAPCTL_REG	QCAPCTL;	// Qaudrature Capture Control
	union	QPOSCTL_REG	QPOSCTL;	// Position Compare Control
	union	QEINT_REG	QEINT;		// QEP Interrupt Control
	union	QFLG_REG	QFLG;		// QEP Interrupt Flag
	union	QFLG_REG	QCLR;		// QEP Interrupt Clear
	union	QFRC_REG	QFRC;		// QEP Interrupt Force
	union	QEPSTS_REG	QEPSTS;		// QEP Status
	Uint16				QCTMR;		// QEP Capture Timer
	Uint16				QCPRD;		// QEP Capture Period
	Uint16				QCTMRLAT;	// QEP Capture Latch
	Uint16				QCPRDLAT;	// QEP Capture Period Latch
	Uint16				rsvd1;		// Reserved
};

//
// Eqep External References & Function Declarations:
//
extern volatile struct EQEP_REGS EQep1Regs;
extern volatile struct EQEP_REGS EQep2Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Gpio.h
//
// TITLE:  F2806x Device GPIO Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// GPIO Individual Register Bit Definitions:
//
struct GPACTRL_BITS
{
    Uint16  QUALPRD0:8;         // 7:0  GPIO0 to 7 Qual Cycles
    Uint16  QUALPRD1:8;         // 15:8 GPIO8 to 15 Qual Cycles
    Uint16  QUALPRD2:8;         // 23:16    GPIO16 to 23 Qual Cycles
    Uint16  QUALPRD3:8;         // 31:24    GPIO24 to 31 Qual Cycles
};

union GPACTRL_REG
{
    Uint32 all;
    struct GPACTRL_BITS bit;
};

struct GPACTRL2_BITS {  // bits description
    Uint16  USB0IOEN:1;     // 0    USB I/O Enable Bit
    Uint16  rsvd1:15;       // 15:1 Reserved
};

union GPACTRL2_REG
{
    Uint16  all;
    struct GPACTRL2_BITS    bit;
};

struct GPBCTRL_BITS
{
    Uint16  QUALPRD0:8;         // 7:0  GPIO32 to 39 Qual Cycles
    Uint16  QUALPRD1:8;         // 15:8 GPIO40 to 47 Qual Cycles
    Uint16  QUALPRD2:8;         // 23:16    GPIO48 to 55 Qual Cycles
    Uint16  QUALPRD3:8;         // 31:24    GPIO56 to 63 Qual Cycles
};

union GPBCTRL_REG
{
    Uint32 all;
    struct GPBCTRL_BITS bit;
};

struct GPA1_BITS
{
    Uint16  GPIO0:2;            // 1:0  GPIO0
    Uint16  GPIO1:2;            // 3:2  GPIO1
    Uint16  GPIO2:2;            // 5:4  GPIO2
    Uint16  GPIO3:2;            // 7:6  GPIO3
    Uint16  GPIO4:2;            // 9:8  GPIO4
    Uint16  GPIO5:2;            // 11:10    GPIO5
    Uint16  GPIO6:2;            // 13:12    GPIO6
    Uint16  GPIO7:2;            // 15:14    GPIO7
    Uint16  GPIO8:2;            // 17:16    GPIO8
    Uint16  GPIO9:2;            // 19:18    GPIO9
    Uint16  GPIO10:2;           // 21:20    GPIO10
    Uint16  GPIO11:2;           // 23:22    GPIO11
    Uint16  GPIO12:2;           // 25:24    GPIO12
    Uint16  GPIO13:2;           // 27:26    GPIO13
    Uint16  GPIO14:2;           // 29:28    GPIO14
    Uint16  GPIO15:2;           // 31:30    GPIO15
};

union GPA1_REG
{
    Uint32 all;
    struct GPA1_BITS    bit;
};

struct GPA2_BITS
{
    Uint16  GPIO16:2;           // 1:0  GPIO16
    Uint16  GPIO17:2;           // 3:2  GPIO17
    Uint16  GPIO18:2;           // 5:4  GPIO18
    Uint16  GPIO19:2;           // 7:6  GPIO19
    Uint16  GPIO20:2;           // 9:8  GPIO20
    Uint16  GPIO21:2;           // 11:10    GPIO21
    Uint16  GPIO22:2;           // 13:12    GPIO22
    Uint16  GPIO23:2;           // 15:14    GPIO23
    Uint16  GPIO24:2;           // 17:16    GPIO24
    Uint16  GPIO25:2;           // 19:18    GPIO25
    Uint16  GPIO26:2;           // 21:20    GPIO26
    Uint16  GPIO27:2;           // 23:22    GPIO27
    Uint16  GPIO28:2;           // 25:24    GPIO28
    Uint16  GPIO29:2;           // 27:26    GPIO29
    Uint16  GPIO30:2;           // 29:28    GPIO30
    Uint16  GPIO31:2;           // 31:30    GPIO31
};

union GPA2_REG
{
    Uint32 all;
    struct GPA2_BITS    bit;
};

struct GPB1_BITS
{
    Uint16  GPIO32:2;           // 1:0  GPIO32
    Uint16  GPIO33:2;           // 3:2  GPIO33
    Uint16  GPIO34:2;           // 5:4  GPIO34
    Uint16  GPIO35:2;           // 7:6  GPIO35
    Uint16  GPIO36:2;           // 9:8  GPIO36
    Uint16  GPIO37:2;           // 11:10    GPIO37
    Uint16  GPIO38:2;           // 13:12    GPIO38
    Uint16  GPIO39:2;           // 15:14    GPIO39
    Uint16  GPIO40:2;           // 17:16    GPIO40
    Uint16  GPIO41:2;           // 19:18    GPIO41
    Uint16  GPIO42:2;           // 21:20    GPIO42
    Uint16  GPIO43:2;           // 23:22    GPIO43
    Uint16  GPIO44:2;           // 25:24    GPIO44
    Uint16  rsvd1:6;            // 31:26    Reserved
};

union GPB1_REG
{
    Uint32 all;
    struct GPB1_BITS    bit;
};

struct GPB2_BITS
{
    Uint16  rsvd1:4;            // 3:0  Reserved
    Uint16  GPIO50:2;           // 5:4  GPIO50
    Uint16  GPIO51:2;           // 7:6  GPIO51
    Uint16  GPIO52:2;           // 9:8  GPIO52
    Uint16  GPIO53:2;           // 11:10    GPIO53
    Uint16  GPIO54:2;           // 13:12    GPIO54
    Uint16  GPIO55:2;           // 15:14    GPIO55
    Uint16  GPIO56:2;           // 17:16    GPIO56
    Uint16  GPIO57:2;           // 19:18    GPIO57
    Uint16  GPIO58:2;           // 21:20    GPIO58
    Uint16  rsvd2:10;           // 31:22    Reserved
};

union GPB2_REG
{
    Uint32 all;
    struct GPB2_BITS    bit;
};

struct AIO_BITS
{
    Uint16  rsvd1:2;            // 1:0  Reserved
    Uint16  rsvd2:2;            // 3:2  Reserved
    Uint16  AIO2:2;             // 5:4  AIO2
    Uint16  rsvd3:2;            // 7:6  Reserved
    Uint16  AIO4:2;             // 9:8  AIO4
    Uint16  rsvd4:2;            // 11:10    Reserved
    Uint16  AIO6:2;             // 13:12    AIO6
    Uint16  rsvd5:2;            // 15:14    Reserved
    Uint16  rsvd6:2;            // 17:16    Reserved
    Uint16  rsvd7:2;            // 19:18    Reserved
    Uint16  AIO10:2;            // 21:20    AIO10
    Uint16  rsvd8:2;            // 23:22    Reserved
    Uint16  AIO12:2;            // 25:24    AIO12
    Uint16  rsvd9:2;            // 27:26    Reserved
    Uint16  AIO14:2;            // 29:28    AIO14
    Uint16  rsvd10:2;           // 31:30    Reserved
};

union AIO_REG
{
    Uint32 all;
    struct AIO_BITS bit;
};

struct GPADAT_BITS
{
    Uint16  GPIO0:1;            // 0    GPIO0 Data
    Uint16  GPIO1:1;            // 1    GPIO1 Data
    Uint16  GPIO2:1;            // 2    GPIO2 Data
    Uint16  GPIO3:1;            // 3    GPIO3 Data
    Uint16  GPIO4:1;            // 4    GPIO4 Data
    Uint16  GPIO5:1;            // 5    GPIO5 Data
    Uint16  GPIO6:1;            // 6    GPIO6 Data
    Uint16  GPIO7:1;            // 7    GPIO7 Data
    Uint16  GPIO8:1;            // 8    GPIO8 Data
    Uint16  GPIO9:1;            // 9    GPIO9 Data
    Uint16  GPIO10:1;           // 10   GPIO10 Data
    Uint16  GPIO11:1;           // 11   GPIO11 Data
    Uint16  GPIO12:1;           // 12   GPIO12 Data
    Uint16  GPIO13:1;           // 13   GPIO13 Data
    Uint16  GPIO14:1;           // 14   GPIO14 Data
    Uint16  GPIO15:1;           // 15   GPIO15 Data
    Uint16  GPIO16:1;           // 16   GPIO16 Data
    Uint16  GPIO17:1;           // 17   GPIO17 Data
    Uint16  GPIO18:1;           // 18   GPIO18 Data
    Uint16  GPIO19:1;           // 19   GPIO19 Data
    Uint16  GPIO20:1;           // 20   GPIO20 Data
    Uint16  GPIO21:1;           // 21   GPIO21 Data
    Uint16  GPIO22:1;           // 22   GPIO22 Data
    Uint16  GPIO23:1;           // 23   GPIO23 Data
    Uint16  GPIO24:1;           // 24   GPIO24 Data
    Uint16  GPIO25:1;           // 25   GPIO25 Data
    Uint16  GPIO26:1;           // 26   GPIO26 Data
    Uint16  GPIO27:1;           // 27   GPIO27 Data
    Uint16  GPIO28:1;           // 28   GPIO28 Data
    Uint16  GPIO29:1;           // 29   GPIO29 Data
    Uint16  GPIO30:1;           // 30   GPIO30 Data
    Uint16  GPIO31:1;           // 31   GPIO31 Data
};

union GPADAT_REG
{
    Uint32 all;
    struct GPADAT_BITS  bit;
};

struct GPBDAT_BITS
{
    Uint16  GPIO32:1;           // 0    GPIO32 Data
    Uint16  GPIO33:1;           // 1    GPIO33 Data
    Uint16  GPIO34:1;           // 2    GPIO34 Data
    Uint16  GPIO35:1;           // 3    GPIO35 Data
    Uint16  GPIO36:1;           // 4    GPIO36 Data
    Uint16  GPIO37:1;           // 5    GPIO37 Data
    Uint16  GPIO38:1;           // 6    GPIO38 Data
    Uint16  GPIO39:1;           // 7    GPIO39 Data
    Uint16  GPIO40:1;           // 8    GPIO40 Data
    Uint16  GPIO41:1;           // 9    GPIO41 Data
    Uint16  GPIO42:1;           // 10   GPIO42 Data
    Uint16  GPIO43:1;           // 11   GPIO43 Data
    Uint16  GPIO44:1;           // 12   GPIO44 Data
    Uint16  rsvd1:3;            // 15:13    Reserved
    Uint16  rsvd2:2;            // 17:16    Reserved
    Uint16  GPIO50:1;           // 18   GPIO50 Data
    Uint16  GPIO51:1;           // 19   GPIO51 Data
    Uint16  GPIO52:1;           // 20   GPIO52 Data
    Uint16  GPIO53:1;           // 21   GPIO53 Data
    Uint16  GPIO54:1;           // 22   GPIO54 Data
    Uint16  GPIO55:1;           // 23   GPIO55 Data
    Uint16  GPIO56:1;           // 24   GPIO56 Data
    Uint16  GPIO57:1;           // 25   GPIO57 Data
    Uint16  GPIO58:1;           // 26   GPIO58 Data
    Uint16  rsvd3:5;            // 31:27    Reserved
};

union GPBDAT_REG
{
    Uint32 all;
    struct GPBDAT_BITS  bit;
};

struct AIODAT_BITS
{
    Uint16  rsvd1:1;            // 0    Reserved
    Uint16  rsvd2:1;            // 1    Reserved
    Uint16  AIO2:1;             // 2    AIO2
    Uint16  rsvd3:1;            // 3    Reserved
    Uint16  AIO4:1;             // 4    AIO4
    Uint16  rsvd4:1;            // 5    Reserved
    Uint16  AIO6:1;             // 6    AIO6
    Uint16  rsvd5:1;            // 7    Reserved
    Uint16  rsvd6:1;            // 8    Reserved
    Uint16  rsvd7:1;            // 9    Reserved
    Uint16  AIO10:1;            // 10   AIO10
    Uint16  rsvd8:1;            // 11   Reserved
    Uint16  AIO12:1;            // 12   AIO12
    Uint16  rsvd9:1;            // 13   Reserved
    Uint16  AIO14:1;            // 14   AIO14
    Uint16  rsvd10:1;           // 15   Reserved
    Uint16  rsvd11:16;          // 31:16 Reserved
};

union AIODAT_REG
{
    Uint32 all;
    struct AIODAT_BITS  bit;
};

struct GPIOXINT_BITS
{
    Uint16  GPIOSEL:5;          // 4:0  Select GPIO Interrupt Input Source
    Uint16  rsvd1:11;           // 15:5 Reserved
};

union GPIOXINT_REG
{
    Uint16 all;
    struct GPIOXINT_BITS    bit;
};

struct GPIO_CTRL_REGS
{
    union   GPACTRL_REG     GPACTRL;    // GPIO A Control Register (GPIO0 to 31)
    
    //
    // GPIO A Qualifier Select 1 Register (GPIO0 to 15)
    //
    union   GPA1_REG        GPAQSEL1;   
    
    //
    // GPIO A Qualifier Select 2 Register (GPIO16 to 31)
    //
    union   GPA2_REG        GPAQSEL2;  
    
    union   GPA1_REG        GPAMUX1;    // GPIO A Mux 1 Register (GPIO0 to 15)
    union   GPA2_REG        GPAMUX2;    // GPIO A Mux 2 Register (GPIO16 to 31)
    
    //
    // GPIO A Direction Register (GPIO0 to 31)
    //
    union   GPADAT_REG      GPADIR;     
    
    union   GPADAT_REG      GPAPUD;     // GPIO A Pull-Up Disable Register
    union   GPACTRL2_REG    GPACTRL2;   // GPIO A Control Register 2
    Uint16                  rsvd1;      // Reserved
    
    //
    // GPIO B Control Register (GPIO32 to 63)
    //
    union   GPBCTRL_REG     GPBCTRL;    
    
    //
    // GPIO B Qualifier Select 1 Register (GPIO32 to 47)
    //
    union   GPB1_REG        GPBQSEL1;   
    
    //
    // GPIO B Qualifier Select 2 Register (GPIO48 to 63)
    //
    union   GPB2_REG        GPBQSEL2;   
    
    union   GPB1_REG        GPBMUX1;    // GPIO B Mux 1 Register (GPIO32 to 47)
    union   GPB2_REG        GPBMUX2;    // GPIO B Mux 2 Register (GPIO48 to 63)
    
    //
    // GPIO B Direction Register (GPIO32 to 63)
    //
    union   GPBDAT_REG      GPBDIR;     
    
    union   GPBDAT_REG      GPBPUD;     // GPIO B Pull-Up Disable Register
    Uint16                  rsvd2[24];  // Reserved
    union   AIO_REG         AIOMUX1;    // Analog IO Mux 1 Register
    Uint16                  rsvd3[2];   // Reserved
    union   AIODAT_REG      AIODIR;     // Analog IO Direction Register
    Uint16                  rsvd4[4];   // Reserved
};

struct GPIO_DATA_REGS
{
    union   GPADAT_REG      GPADAT;     // GPIO A Data Register (GPIO0 to 31)
    
    //
    // GPIO A Data Set Register (GPIO0 to 31)
    //
    union   GPADAT_REG      GPASET;     
    
    //
    // GPIO A Data Clear Register (GPIO0 to 31)
    //
    union   GPADAT_REG      GPACLEAR;   
    
    //
    // GPIO A Data Toggle Register (GPIO0 to 31)
    //
    union   GPADAT_REG      GPATOGGLE;  
    
    union   GPBDAT_REG      GPBDAT;     // GPIO B Data Register (GPIO32 to 63)
    
    //
    // GPIO B Data Set Register (GPIO32 to 63)
    //
    union   GPBDAT_REG      GPBSET;     
    
    //
    // GPIO B Data Clear Register (GPIO32 to 63)
    //
    union   GPBDAT_REG      GPBCLEAR;   
    
    //
    // GPIO B Data Toggle Register (GPIO32 to 63)
    //
    union   GPBDAT_REG      GPBTOGGLE;  
    
    Uint16                  rsvd1[8];   // Reserved
    
    union   AIODAT_REG      AIODAT;     // Analog IO Data Register (AIO0 to 15)
    
    //
    // Analog IO Data Set Register (AIO0 to 15)
    //
    union   AIODAT_REG      AIOSET;     
    
    //
    // Analog IO Data Clear Register (AIO0 to 15)
    //
    union   AIODAT_REG      AIOCLEAR;   
    
    //
    // Analog IO Data Toggle Register (AIO0 to 15)
    //
    union   AIODAT_REG      AIOTOGGLE;  
};

struct GPIO_INT_REGS
{
    //
    // XINT1 GPIO Input Select Register (GPIO0 to 31)
    //
    union   GPIOXINT_REG    GPIOXINT1SEL;   
    
    //
    // GPTRIP2 (TZ2n) Input Select Register (GPIO0 to 63)
    //
    union   GPIOXINT_REG    GPIOXINT2SEL;   
    
    //
    // GPTRIP3 (TZ3n) Input Select Register (GPIO0 to 63)
    //
    union   GPIOXINT_REG    GPIOXINT3SEL;   
    
    Uint16                  rsvd1[5];       // Reserved
    
    //
    // GPTRIP5 (XINT2) Input Select Register (GPIO0 to 63)
    //
    union   GPADAT_REG      GPIOLPMSEL;     
    
    Uint16                  rsvd2[22];      // Reserved
};

//
// Gpio External References & Function Declarations:
//
extern volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
extern volatile struct GPIO_DATA_REGS GpioDataRegs;
extern volatile struct GPIO_INT_REGS  GpioIntRegs;




//
// End of file
//

// TI File $
// Checkin $
//###########################################################################
//
// FILE:   F2806x_HRCap.h
//
// TITLE:  F2806x Device HRCAP Register Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// HRCAP Individual Register Bit Definitions:
//
struct HCCTL_BITS
{
    Uint16  SOFTRESET:1;            // 0    Soft reset
    Uint16  RISEINTE:1;             // 1    RISE capture interrupt enable
    Uint16  FALLINTE:1;             // 2    FALL capture interrupt enable
    Uint16  OVFINTE:1;              // 3    Counter overflow interrupt enable
    Uint16  rsvd1:4;                // 7:4  Reserved
    Uint16  HCCAPCLKSEL:1;          // 8    HRCAP Capture Clock Select Bit
    Uint16  rsvd2:7;                // 15:9 Reserved
};

union HCCTL_REG
{
    Uint16 all;
    struct HCCTL_BITS   bit;
};

struct HCIFR_BITS
{
    Uint16  INT:1;              // 0    Global interrupt flag
    Uint16  RISE:1;             // 1    RISE capture interrupt flag
    Uint16  FALL:1;             // 2    FALL capture interrupt flag
    Uint16  COUNTEROVF:1;       // 3    Counter overflow interrupt flag
    Uint16  RISEOVF:1;          // 4    RISE interrupt overflow event flag
    Uint16  rsvd1:11;           // 15:5 Reserved
};

union HCIFR_REG
{
    Uint16 all;
    struct HCIFR_BITS   bit;
};

struct HCICLR_BITS
{
    Uint16  INT:1;              // 0    Global interrupt clear
    Uint16  RISE:1;             // 1    RISE capture interrupt clear
    Uint16  FALL:1;             // 2    FALL capture interrupt clear
    Uint16  COUNTEROVF:1;       // 3    Counter overflow interrupt clear
    Uint16  RISEOVF:1;          // 4    RISE interrupt overflow event clear
    Uint16  rsvd1:11;           // 15:5 Reserved
};

union HCICLR_REG
{
    Uint16 all;
    struct HCICLR_BITS  bit;
};

struct HCIFRC_BITS
{
    Uint16  rsvd1:1;        // 0    Reserved
    Uint16  RISE:1;         // 1    RISE capture interrupt force
    Uint16  FALL:1;         // 2    FALL capture interrupt force
    Uint16  COUNTEROVF:1;   // 3    Counter overflow interrupt force
    Uint16  RISEOVF:1;      // 4    Rise Interrupt Overflow Event Flag Force Bit
    Uint16  rsvd2:11;       // 15:5 Reserved
};

union HCIFRC_REG
{
    Uint16 all;
    struct HCIFRC_BITS  bit;
};

struct HRCAP_REGS
{
    union   HCCTL_REG           HCCTL;         // HRCAP Control Register
    union   HCIFR_REG           HCIFR;         // HRCAP Interrupt Flag Register
    union   HCICLR_REG          HCICLR;        // HRCAP Interrupt Clear Register
    union   HCIFRC_REG          HCIFRC;        // HRCAP Interrupt Force Register
    Uint16                      HCCOUNTER;     // HRCAP 16-bit Counter Register
    Uint16                      rsvd1[11];     // Reserved
    
    //
    // HRCAP Capture Counter On Rising Edge 0 Register
    //
    Uint16                      HCCAPCNTRISE0;
    
    Uint16                      rsvd2;          // Reserved
    
    //
    // HRCAP Capture Counter On Falling Edge 0 Register
    //
    Uint16                      HCCAPCNTFALL0;
    
    Uint16                      rsvd3;          // Reserved
    Uint16                      rsvd4;          // Reserved
    Uint16                      rsvd5;          // Reserved
    Uint16                      rsvd6[2];       // Reserved
    
    //
    // HRCAP Capture Counter On Rising Edge 1 Register
    //
    Uint16                      HCCAPCNTRISE1;  
    
    Uint16                      rsvd7;          // Reserved
    
    //
    // HRCAP Capture Counter On Falling Edge 1 Register
    //
    Uint16                      HCCAPCNTFALL1;  
    
    Uint16                      rsvd8;          // Reserved
    Uint16                      rsvd9;          // Reserved
    Uint16                      rsvd10;         // Reserved
    Uint16                      rsvd11;         // Reserved
    Uint16                      rsvd12;         // Reserved
};

//
// Hrcap External References & Function Declarations:
//
extern volatile struct HRCAP_REGS HRCap1Regs;
extern volatile struct HRCAP_REGS HRCap2Regs;
extern volatile struct HRCAP_REGS HRCap3Regs;
extern volatile struct HRCAP_REGS HRCap4Regs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_I2c.h
//
// TITLE:  F2806x Device I2C Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// I2C Individual Register Bit Definitions
//
struct I2CMDR_BITS
{
    Uint16  BC:3;           // 2:0  Bit Count
    Uint16  FDF:1;          // 3    Free Data Format
    Uint16  STB:1;          // 4    START Byte Mode
    Uint16  IRS:1;          // 5    I2C Module Reset
    Uint16  DLB:1;          // 6    Digital Loopback Mode
    Uint16  RM:1;           // 7    Repeat Mode
    Uint16  XA:1;           // 8    Expanded Address Mode
    Uint16  TRX:1;          // 9    Transmitter Mode
    Uint16  MST:1;          // 10   Master Mode
    Uint16  STP:1;          // 11   STOP Condition
    Uint16  rsvd1:1;        // 12   Reserved
    Uint16  STT:1;          // 13   START Condition
    Uint16  FREE:1;         // 14   Debug Action
    Uint16  NACKMOD:1;      // 15   NACK Mode
};

union I2CMDR_REG
{
    Uint16 all;
    struct I2CMDR_BITS  bit;
};

struct I2CEMDR_BITS
{
    Uint16  BC:1;           // 0    Backward Compatability Mode
    Uint16  rsvd1:15;       // 15:1 Reserved
};

union I2CEMDR_REG
{
    Uint16 all;
    struct I2CEMDR_BITS bit;
};

struct I2CIER_BITS
{
    Uint16  ARBL:1;         // 0    Arbitration Lost
    Uint16  NACK:1;         // 1    No Acknowledgment
    Uint16  ARDY:1;         // 2    Register Access Ready
    Uint16  RRDY:1;         // 3    Receive Data Ready
    Uint16  XRDY:1;         // 4    Transmit Data Ready
    Uint16  SCD:1;          // 5    Stop Condition Detected
    Uint16  AAS:1;          // 6    Address as Slave
    Uint16  rsvd1:9;        // 15:7 Reserved
};

union I2CIER_REG
{
    Uint16 all;
    struct I2CIER_BITS  bit;
};

struct I2CSTR_BITS
{
    Uint16  ARBL:1;         // 0    Arbitration Lost
    Uint16  NACK:1;         // 1    No Acknowledgment
    Uint16  ARDY:1;         // 2    Register Access Ready
    Uint16  RRDY:1;         // 3    Receive Data Ready
    Uint16  XRDY:1;         // 4    Transmit Data Ready
    Uint16  SCD:1;          // 5    Stop Condition Detected
    Uint16  rsvd1:2;        // 7:6  Reserved
    Uint16  AD0:1;          // 8    Address 0
    Uint16  AAS:1;          // 9    Addressed as Slave
    Uint16  XSMT:1;         // 10   Transmit Shift Register Empty
    Uint16  RSFULL:1;       // 11   Receive Shift Register Full
    Uint16  BB:1;           // 12   Bus Busy
    Uint16  NACKSNT:1;      // 13   NACK Sent
    Uint16  SDIR:1;         // 14   Slave Direction
    Uint16  rsvd2:1;        // 15   Reserved
};

union I2CSTR_REG
{
    Uint16 all;
    struct I2CSTR_BITS  bit;
};

struct I2CISRC_BITS
{
    Uint16  INTCODE:3;          // 2:0  Interrupt Code
    Uint16  rsvd1:5;            // 7:3  Reserved
    Uint16  rsvd2:4;            // 11:8 Reserved
    Uint16  rsvd3:4;            // 15:12    Reserved
};

union I2CISRC_REG
{
    Uint16 all;
    struct I2CISRC_BITS bit;
};

struct I2CPSC_BITS
{
    Uint16  IPSC:8;         // 7:0  I2C Prescaler Divide Down
    Uint16  rsvd1:8;        // 15:8 Reserved
};

union I2CPSC_REG
{
    Uint16 all;
    struct I2CPSC_BITS  bit;
};

struct I2CFFTX_BITS
{
    Uint16  TXFFIL:5;           // 4:0  Transmit FIFO Interrupt Level
    Uint16  TXFFIENA:1;         // 5    Transmit FIFO Interrupt Enable
    Uint16  TXFFINTCLR:1;       // 6    Transmit FIFO Interrupt Flag Clear
    Uint16  TXFFINT:1;          // 7    Transmit FIFO Interrupt Flag Clear
    Uint16  TXFFST:5;           // 12:8 Transmit FIFO Status
    Uint16  TXFFRST:1;          // 13   Transmit FIFO Reset
    Uint16  I2CFFEN:1;          // 14   Transmit FIFO Enable
    Uint16  rsvd1:1;            // 15   Reserved
};

union I2CFFTX_REG
{
    Uint16 all;
    struct I2CFFTX_BITS bit;
};

struct I2CFFRX_BITS
{
    Uint16  RXFFIL:5;           // 4:0  Receive FIFO Interrupt Level
    Uint16  RXFFIENA:1;         // 5    Receive FIFO Interrupt Enable
    Uint16  RXFFINTCLR:1;       // 6    Receive FIFO Interrupt Flag Clear
    Uint16  RXFFINT:1;          // 7    Receive FIFO Interrupt Flag Clear
    Uint16  RXFFST:5;           // 12:8 Receive FIFO Status
    Uint16  RXFFRST:1;          // 13   Receive FIFO Reset
    Uint16  rsvd1:2;            // 15:14    Reserved
};

union I2CFFRX_REG
{
    Uint16 all;
    struct I2CFFRX_BITS bit;
};

struct I2C_REGS
{
    Uint16              I2COAR;     // I2C Own address
    union   I2CIER_REG  I2CIER;     // I2C Interrupt Enable
    union   I2CSTR_REG  I2CSTR;     // I2C Status
    Uint16              I2CCLKL;    // I2C Clock low-time divider
    Uint16              I2CCLKH;    // I2C Clock high-time divider
    Uint16              I2CCNT;     // I2C Data count
    Uint16              I2CDRR;     // I2C Data receive
    Uint16              I2CSAR;     // I2C Slave address
    Uint16              I2CDXR;     // I2C Data Transmit
    union   I2CMDR_REG  I2CMDR;     // I2C Mode
    union   I2CISRC_REG I2CISRC;    // I2C Interrupt Source
    union   I2CEMDR_REG I2CEMDR;    // I2C Extended Mode
    union   I2CPSC_REG  I2CPSC;     // I2C Prescaler
    Uint16              rsvd1[19];  // Reserved
    union   I2CFFTX_REG I2CFFTX;    // I2C FIFO Transmit
    union   I2CFFRX_REG I2CFFRX;    // I2C FIFO Receive
};

//
// I2c External References & Function Declarations:
//
extern volatile struct I2C_REGS I2caRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Mcbsp.h
//
// TITLE:  F2806x Device McBSP Register Definitions.
//
//###########################################################################
// $TI Release:  $   
// $Release Date: $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// McBSP Individual Register Bit Definitions:
//
struct DRR2_BITS
{
	Uint16	HWLB:8;			// 7:0	High word low byte
	Uint16	HWHB:8;			// 15:8	High word high byte
};

union DRR2_REG
{
	Uint16 all;
	struct DRR2_BITS	bit;
};

struct DRR1_BITS
{
	Uint16	LWLB:8;			// 7:0	Low word low byte
	Uint16	LWHB:8;			// 15:8	Low word high byte
};

union DRR1_REG
{
	Uint16 all;
	struct DRR1_BITS	bit;
};

struct DXR2_BITS
{
    Uint16	HWLB:8;			// 7:0	High word low byte
	Uint16	HWHB:8;			// 15:8	High word high byte
};

union DXR2_REG
{
	Uint16 all;
	struct DXR2_BITS	bit;
};

struct DXR1_BITS
{
	Uint16	LWLB:8;			// 7:0	Low word low byte
	Uint16	LWHB:8;			// 15:8	Low word high byte
};

union DXR1_REG
{
	Uint16 all;
	struct DXR1_BITS	bit;
};

struct SPCR2_BITS
{
	Uint16	XRST:1;			// 0	Transmitter reset
	Uint16	XRDY:1;			// 1	Transmitter ready
	Uint16	XEMPTY:1;		// 2	Transmitter empty
	Uint16	XSYNCERR:1;		// 3	Transmit sync error INT flag
	Uint16	XINTM:2;		// 5:4	Transmit Interupt mode bits
	Uint16	GRST:1;			// 6	Sample rate generator reset
	Uint16	FRST:1;			// 7	Frame sync logic reset
	Uint16	SOFT:1;			// 8	SOFT bit
	Uint16	FREE:1;			// 9	FREE bit
	Uint16	rsvd1:6;		// 15:10	Reserved
};

union SPCR2_REG
{
	Uint16 all;
	struct SPCR2_BITS	bit;
};

struct SPCR1_BITS
{
	Uint16	RRST:1;			// 0	Receiver reset
	Uint16	RRDY:1;			// 1	Receiver ready
	Uint16	RFULL:1;		// 2	Receiver full
	Uint16	RSYNCERR:1;		// 3	Receive sync error INT flag
	Uint16	RINTM:2;		// 5:4	Receive Interupt mode bits
	Uint16	rsvd1:1;		// 6	Reserved
	Uint16	DXENA:1;		// 7	DX delay enable
	Uint16	rsvd2:3;		// 10:8	Reserved
	Uint16	CLKSTP:2;		// 12:11	Clock stop mode
	Uint16	RJUST:2;		// 14:13	Rx sign extension and justification mode
	Uint16	DLB:1;			// 15	Digital loopback
};

union SPCR1_REG
{
	Uint16 all;
	struct SPCR1_BITS	bit;
};

struct RCR2_BITS
{
	Uint16	RDATDLY:2;			// 1:0  	Receive data delay
	Uint16	RFIG:1;				// 2	Receive frame sync ignore
	Uint16	RCOMPAND:2;			// 4:3	Receive Companding Mode selects
	Uint16	RWDLEN2:3;			// 7:5	Receive word length 2
	Uint16	RFRLEN2:7;			// 14:8	Receive Frame length 2
	Uint16	RPHASE:1;			// 15	Receive Phase
};

union RCR2_REG
{
	Uint16 all;
	struct RCR2_BITS	bit;
};

struct RCR1_BITS
{
	Uint16	rsvd1:5;			// 4:0  	Reserved
	Uint16	RWDLEN1:3;			// 7:5	Receive word length 1
	Uint16	RFRLEN1:7;			// 14:8 	Receive Frame length 1
	Uint16	rsvd2:1;			// 15	Reserved
};

union RCR1_REG
{
	Uint16 all;
	struct RCR1_BITS	bit;
};

struct XCR2_BITS
{
	Uint16	XDATDLY:2;			// 1:0  	Transmit data delay
	Uint16	XFIG:1;				// 2	Transmit frame sync ignore
	Uint16	XCOMPAND:2;			// 4:3	Transmit Companding Mode selects
	Uint16	XWDLEN2:3;			// 7:5	Transmit word length 2
	Uint16	XFRLEN2:7;			// 14:8	Transmit Frame length 2
	Uint16	XPHASE:1;			// 15	Transmit Phase
};

union XCR2_REG
{
	Uint16 all;
	struct XCR2_BITS	bit;
};

struct XCR1_BITS
{
	Uint16	rsvd1:5;			// 4:0  	Reserved
	Uint16	XWDLEN1:3;			// 7:5	Transmit word length 1
	Uint16	XFRLEN1:7;			// 14:8 	Transmit Frame length 1
	Uint16	rsvd2:1;			// 15	Reserved
};

union XCR1_REG
{
	Uint16 all;
	struct XCR1_BITS	bit;
};

struct SRGR2_BITS
{
	Uint16	FPER:12;			// 11:0  	Frame-sync period
	Uint16	FSGM:1;				// 12	Frame sync generator mode
	Uint16	CLKSM:1;			// 13	Sample rate generator mode
	Uint16	rsvd1:1;			// 14	Reserved
	Uint16	GSYNC:1;			// 15	CLKG sync
};

union SRGR2_REG
{
	Uint16 all;
	struct SRGR2_BITS	bit;
};

struct SRGR1_BITS
{
	Uint16	CLKGDV:8;		// 7:0	CLKG divider
	Uint16	FWID:8;			// 15:8	Frame width
};

union SRGR1_REG
{
	Uint16 all;
	struct SRGR1_BITS	bit;
};

struct MCR2_BITS
{
	Uint16	XMCM:2;				// 1:0	Transmit multichannel mode
	Uint16	XCBLK:3;			// 4:2	Transmit current block
	Uint16	XPABLK:2;			// 6:5	Transmit partition A Block
	Uint16	XPBBLK:2;			// 8:7	Transmit partition B Block
	Uint16	XMCME:1;			// 9	Transmit multi-channel enhance mode
	Uint16	rsvd1:6;			// 15:10	Reserved
};

union MCR2_REG
{
	Uint16 all;
	struct MCR2_BITS	bit;
};

struct MCR1_BITS
{
	Uint16	RMCM:1;				// 0	Receive multichannel mode
	Uint16	rsvd1:1;			// 1	Reserved
	Uint16	RCBLK:3;			// 4:2	Receive current block
	Uint16	RPABLK:2;			// 6:5	Receive partition A Block
	Uint16	RPBBLK:2;			// 8:7	Receive partition B Block
	Uint16	RMCME:1;			// 9	Receive multi-channel enhance mode
	Uint16	rsvd2:6;			// 15:10	Reserved
};

union MCR1_REG
{
	Uint16 all;
	struct MCR1_BITS	bit;
};

struct RCERA_BITS
{
	Uint16	RCEA0:1;			// 0	Receive Channel enable bit
	Uint16	RCEA1:1;			// 1	Receive Channel enable bit
	Uint16	RCEA2:1;			// 2	Receive Channel enable bit
	Uint16	RCEA3:1;			// 3	Receive Channel enable bit
	Uint16	RCEA4:1;			// 4	Receive Channel enable bit
	Uint16	RCEA5:1;			// 5	Receive Channel enable bit
	Uint16	RCEA6:1;			// 6	Receive Channel enable bit
	Uint16	RCEA7:1;			// 7	Receive Channel enable bit
	Uint16	RCEA8:1;			// 8	Receive Channel enable bit
	Uint16	RCEA9:1;			// 9	Receive Channel enable bit
	Uint16	RCEA10:1;			// 10	Receive Channel enable bit
	Uint16	RCEA11:1;			// 11	Receive Channel enable bit
	Uint16	RCEA12:1;			// 12	Receive Channel enable bit
	Uint16	RCEA13:1;			// 13	Receive Channel enable bit
	Uint16	RCEA14:1;			// 14	Receive Channel enable bit
	Uint16	RCEA15:1;			// 15	Receive Channel enable bit
};

union RCERA_REG
{
	Uint16 all;
	struct RCERA_BITS	bit;
};

struct RCERB_BITS
{
	Uint16	RCEB0:1;			// 0	Receive Channel enable bit
	Uint16	RCEB1:1;			// 1	Receive Channel enable bit
	Uint16	RCEB2:1;			// 2	Receive Channel enable bit
	Uint16	RCEB3:1;			// 3	Receive Channel enable bit
	Uint16	RCEB4:1;			// 4	Receive Channel enable bit
	Uint16	RCEB5:1;			// 5	Receive Channel enable bit
	Uint16	RCEB6:1;			// 6	Receive Channel enable bit
	Uint16	RCEB7:1;			// 7	Receive Channel enable bit
	Uint16	RCEB8:1;			// 8	Receive Channel enable bit
	Uint16	RCEB9:1;			// 9	Receive Channel enable bit
	Uint16	RCEB10:1;			// 10	Receive Channel enable bit
	Uint16	RCEB11:1;			// 11	Receive Channel enable bit
	Uint16	RCEB12:1;			// 12	Receive Channel enable bit
	Uint16	RCEB13:1;			// 13	Receive Channel enable bit
	Uint16	RCEB14:1;			// 14	Receive Channel enable bit
	Uint16	RCEB15:1;			// 15	Receive Channel enable bit
};

union RCERB_REG
{
	Uint16 all;
	struct RCERB_BITS	bit;
};

struct XCERA_BITS
{
	Uint16	XCERA0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERA1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERA2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERA3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERA4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERA5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERA6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERA7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERA8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERA9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERA10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERA11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERA12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERA13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERA14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERA15:1;			// 15	Transmit Channel enable bit
};

union XCERA_REG
{
	Uint16 all;
	struct XCERA_BITS	bit;
};

struct XCERB_BITS
{
	Uint16	XCERB0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERB1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERB2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERB3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERB4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERB5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERB6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERB7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERB8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERB9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERB10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERB11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERB12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERB13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERB14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERB15:1;			// 15	Transmit Channel enable bit
};

union XCERB_REG
{
	Uint16 all;
	struct XCERB_BITS	bit;
};

struct PCR_BITS
{
	Uint16	CLKRP:1;			// 0	Receive Clock polarity
	Uint16	CLKXP:1;			// 1	Transmit clock polarity
	Uint16	FSRP:1;				// 2	Receive Frame synchronization polarity
	Uint16	FSXP:1;				// 3	Transmit Frame synchronization polarity
	Uint16	rsvd1:1;			// 4	Reserved
	Uint16	rsvd2:1;			// 5	Reserved
	Uint16	rsvd3:1;			// 6	Reserved
	Uint16	SCLKME:1;			// 7	Sample clock mode selection
	Uint16	CLKRM:1;			// 8	Receiver Clock Mode
	Uint16	CLKXM:1;			// 9	Transmit Clock Mode.
	Uint16	FSRM:1;				// 10	Receive Frame Synchronization Mode
	Uint16	FSXM:1;				// 11	Transmit Frame Synchronization Mode
	Uint16	rsvd4:4;			// 15:12	Reserved
};

union PCR_REG
{
	Uint16 all;
	struct PCR_BITS	bit;
};

struct RCERC_BITS
{
	Uint16	RCEC0:1;			// 0	Receive Channel enable bit
	Uint16	RCEC1:1;			// 1	Receive Channel enable bit
	Uint16	RCEC2:1;			// 2	Receive Channel enable bit
	Uint16	RCEC3:1;			// 3	Receive Channel enable bit
	Uint16	RCEC4:1;			// 4	Receive Channel enable bit
	Uint16	RCEC5:1;			// 5	Receive Channel enable bit
	Uint16	RCEC6:1;			// 6	Receive Channel enable bit
	Uint16	RCEC7:1;			// 7	Receive Channel enable bit
	Uint16	RCEC8:1;			// 8	Receive Channel enable bit
	Uint16	RCEC9:1;			// 9	Receive Channel enable bit
	Uint16	RCEC10:1;			// 10	Receive Channel enable bit
	Uint16	RCEC11:1;			// 11	Receive Channel enable bit
	Uint16	RCEC12:1;			// 12	Receive Channel enable bit
	Uint16	RCEC13:1;			// 13	Receive Channel enable bit
	Uint16	RCEC14:1;			// 14	Receive Channel enable bit
	Uint16	RCEC15:1;			// 15	Receive Channel enable bit
};

union RCERC_REG
{
	Uint16 all;
	struct RCERC_BITS	bit;
};

struct RCERD_BITS
{
	Uint16	RCED0:1;			// 0	Receive Channel enable bit
	Uint16	RCED1:1;			// 1	Receive Channel enable bit
	Uint16	RCED2:1;			// 2	Receive Channel enable bit
	Uint16	RCED3:1;			// 3	Receive Channel enable bit
	Uint16	RCED4:1;			// 4	Receive Channel enable bit
	Uint16	RCED5:1;			// 5	Receive Channel enable bit
	Uint16	RCED6:1;			// 6	Receive Channel enable bit
	Uint16	RCED7:1;			// 7	Receive Channel enable bit
	Uint16	RCED8:1;			// 8	Receive Channel enable bit
	Uint16	RCED9:1;			// 9	Receive Channel enable bit
	Uint16	RCED10:1;			// 10	Receive Channel enable bit
	Uint16	RCED11:1;			// 11	Receive Channel enable bit
	Uint16	RCED12:1;			// 12	Receive Channel enable bit
	Uint16	RCED13:1;			// 13	Receive Channel enable bit
	Uint16	RCED14:1;			// 14	Receive Channel enable bit
	Uint16	RCED15:1;			// 15	Receive Channel enable bit
};

union RCERD_REG
{
	Uint16 all;
	struct RCERD_BITS	bit;
};

struct XCERC_BITS
{
	Uint16	XCERC0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERC1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERC2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERC3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERC4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERC5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERC6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERC7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERC8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERC9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERC10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERC11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERC12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERC13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERC14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERC15:1;			// 15	Transmit Channel enable bit
};

union XCERC_REG
{
	Uint16 all;
	struct XCERC_BITS	bit;
};

struct XCERD_BITS
{
	Uint16	XCERD0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERD1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERD2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERD3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERD4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERD5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERD6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERD7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERD8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERD9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERD10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERD11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERD12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERD13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERD14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERD15:1;			// 15	Transmit Channel enable bit
};

union XCERD_REG
{
	Uint16 all;
	struct XCERD_BITS	bit;
};

struct RCERE_BITS
{
	Uint16	RCEE0:1;			// 0	Receive Channel enable bit
	Uint16	RCEE1:1;			// 1	Receive Channel enable bit
	Uint16	RCEE2:1;			// 2	Receive Channel enable bit
	Uint16	RCEE3:1;			// 3	Receive Channel enable bit
	Uint16	RCEE4:1;			// 4	Receive Channel enable bit
	Uint16	RCEE5:1;			// 5	Receive Channel enable bit
	Uint16	RCEE6:1;			// 6	Receive Channel enable bit
	Uint16	RCEE7:1;			// 7	Receive Channel enable bit
	Uint16	RCEE8:1;			// 8	Receive Channel enable bit
	Uint16	RCEE9:1;			// 9	Receive Channel enable bit
	Uint16	RCEE10:1;			// 10	Receive Channel enable bit
	Uint16	RCEE11:1;			// 11	Receive Channel enable bit
	Uint16	RCEE12:1;			// 12	Receive Channel enable bit
	Uint16	RCEE13:1;			// 13	Receive Channel enable bit
	Uint16	RCEE14:1;			// 14	Receive Channel enable bit
	Uint16	RCEE15:1;			// 15	Receive Channel enable bit
};

union RCERE_REG
{
	Uint16 all;
	struct RCERE_BITS	bit;
};

struct RCERF_BITS
{
	Uint16	RCEF0:1;			// 0	Receive Channel enable bit
	Uint16	RCEF1:1;			// 1	Receive Channel enable bit
	Uint16	RCEF2:1;			// 2	Receive Channel enable bit
	Uint16	RCEF3:1;			// 3	Receive Channel enable bit
	Uint16	RCEF4:1;			// 4	Receive Channel enable bit
	Uint16	RCEF5:1;			// 5	Receive Channel enable bit
	Uint16	RCEF6:1;			// 6	Receive Channel enable bit
	Uint16	RCEF7:1;			// 7	Receive Channel enable bit
	Uint16	RCEF8:1;			// 8	Receive Channel enable bit
	Uint16	RCEF9:1;			// 9	Receive Channel enable bit
	Uint16	RCEF10:1;			// 10	Receive Channel enable bit
	Uint16	RCEF11:1;			// 11	Receive Channel enable bit
	Uint16	RCEF12:1;			// 12	Receive Channel enable bit
	Uint16	RCEF13:1;			// 13	Receive Channel enable bit
	Uint16	RCEF14:1;			// 14	Receive Channel enable bit
	Uint16	RCEF15:1;			// 15	Receive Channel enable bit
};

union RCERF_REG
{
	Uint16 all;
	struct RCERF_BITS	bit;
};

struct XCERE_BITS
{
	Uint16	XCERE0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERE1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERE2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERE3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERE4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERE5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERE6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERE7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERE8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERE9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERE10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERE11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERE12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERE13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERE14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERE15:1;			// 15	Transmit Channel enable bit
};

union XCERE_REG
{
	Uint16 all;
	struct XCERE_BITS	bit;
};

struct XCERF_BITS
{
	Uint16	XCERF0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERF1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERF2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERF3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERF4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERF5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERF6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERF7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERF8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERF9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERF10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERF11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERF12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERF13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERF14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERF15:1;			// 15	Transmit Channel enable bit
};

union XCERF_REG
{
	Uint16 all;
	struct XCERF_BITS	bit;
};

struct RCERG_BITS
{
	Uint16	RCEG0:1;			// 0	Receive Channel enable bit
	Uint16	RCEG1:1;			// 1	Receive Channel enable bit
	Uint16	RCEG2:1;			// 2	Receive Channel enable bit
	Uint16	RCEG3:1;			// 3	Receive Channel enable bit
	Uint16	RCEG4:1;			// 4	Receive Channel enable bit
	Uint16	RCEG5:1;			// 5	Receive Channel enable bit
	Uint16	RCEG6:1;			// 6	Receive Channel enable bit
	Uint16	RCEG7:1;			// 7	Receive Channel enable bit
	Uint16	RCEG8:1;			// 8	Receive Channel enable bit
	Uint16	RCEG9:1;			// 9	Receive Channel enable bit
	Uint16	RCEG10:1;			// 10	Receive Channel enable bit
	Uint16	RCEG11:1;			// 11	Receive Channel enable bit
	Uint16	RCEG12:1;			// 12	Receive Channel enable bit
	Uint16	RCEG13:1;			// 13	Receive Channel enable bit
	Uint16	RCEG14:1;			// 14	Receive Channel enable bit
	Uint16	RCEG15:1;			// 15	Receive Channel enable bit
};

union RCERG_REG
{
	Uint16 all;
	struct RCERG_BITS	bit;
};

struct RCERH_BITS
{
	Uint16	RCEH0:1;			// 0	Receive Channel enable bit
	Uint16	RCEH1:1;			// 1	Receive Channel enable bit
	Uint16	RCEH2:1;			// 2	Receive Channel enable bit
	Uint16	RCEH3:1;			// 3	Receive Channel enable bit
	Uint16	RCEH4:1;			// 4	Receive Channel enable bit
	Uint16	RCEH5:1;			// 5	Receive Channel enable bit
	Uint16	RCEH6:1;			// 6	Receive Channel enable bit
	Uint16	RCEH7:1;			// 7	Receive Channel enable bit
	Uint16	RCEH8:1;			// 8	Receive Channel enable bit
	Uint16	RCEH9:1;			// 9	Receive Channel enable bit
	Uint16	RCEH10:1;			// 10	Receive Channel enable bit
	Uint16	RCEH11:1;			// 11	Receive Channel enable bit
	Uint16	RCEH12:1;			// 12	Receive Channel enable bit
	Uint16	RCEH13:1;			// 13	Receive Channel enable bit
	Uint16	RCEH14:1;			// 14	Receive Channel enable bit
	Uint16	RCEH15:1;			// 15	Receive Channel enable bit
};

union RCERH_REG
{
	Uint16 all;
	struct RCERH_BITS	bit;
};

struct XCERG_BITS
{
	Uint16	XCERG0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERG1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERG2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERG3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERG4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERG5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERG6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERG7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERG8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERG9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERG10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERG11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERG12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERG13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERG14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERG15:1;			// 15	Transmit Channel enable bit
};

union XCERG_REG
{
	Uint16 all;
	struct XCERG_BITS	bit;
};

struct XCERH_BITS
{
	Uint16	XCERH0:1;			// 0	Transmit Channel enable bit
	Uint16	XCERH1:1;			// 1	Transmit Channel enable bit
	Uint16	XCERH2:1;			// 2	Transmit Channel enable bit
	Uint16	XCERH3:1;			// 3	Transmit Channel enable bit
	Uint16	XCERH4:1;			// 4	Transmit Channel enable bit
	Uint16	XCERH5:1;			// 5	Transmit Channel enable bit
	Uint16	XCERH6:1;			// 6	Transmit Channel enable bit
	Uint16	XCERH7:1;			// 7	Transmit Channel enable bit
	Uint16	XCERH8:1;			// 8	Transmit Channel enable bit
	Uint16	XCERH9:1;			// 9	Transmit Channel enable bit
	Uint16	XCERH10:1;			// 10	Transmit Channel enable bit
	Uint16	XCERH11:1;			// 11	Transmit Channel enable bit
	Uint16	XCERH12:1;			// 12	Transmit Channel enable bit
	Uint16	XCERH13:1;			// 13	Transmit Channel enable bit
	Uint16	XCERH14:1;			// 14	Transmit Channel enable bit
	Uint16	XCERH15:1;			// 15	Transmit Channel enable bit
};

union XCERH_REG
{
	Uint16 all;
	struct XCERH_BITS	bit;
};

struct MFFINT_BITS
{
	Uint16	XINT:1;			// 0	XINT  interrupt enable
	Uint16	rsvd1:1;		// 1	Reserved
	Uint16	RINT:1;			// 2	RINT  interrupt enable
	Uint16	rsvd2:13;		// 15:3	Reserved
};

union MFFINT_REG
{
	Uint16 all;
	struct MFFINT_BITS	bit;
};

struct McBSP_REGS
{
	union	DRR2_REG	DRR2;		// Data receive register bits 31-16
	union	DRR1_REG	DRR1;		// Data receive register bits 15-0
	union	DXR2_REG	DXR2;		// Data transmit register bits 31-16
	union	DXR1_REG	DXR1;		// Data transmit register bits 15-0
	union	SPCR2_REG	SPCR2;		// Control register 2
	union	SPCR1_REG	SPCR1;		// Control register 1
	union	RCR2_REG	RCR2;		// Receive Control register 2
	union	RCR1_REG	RCR1;		// Receive Control register 1
	union	XCR2_REG	XCR2;		// Transmit Control register 2
	union	XCR1_REG	XCR1;		// Transmit Control register 1
	union	SRGR2_REG	SRGR2;		// Sample rate generator register 2
	union	SRGR1_REG	SRGR1;		// Sample rate generator register 1
	union	MCR2_REG	MCR2;		// Multi-channel register 2
	union	MCR1_REG	MCR1;		// Multi-channel register 1
	union	RCERA_REG	RCERA;		// Receive channel enable partition A
	union	RCERB_REG	RCERB;		// Receive channel enable partition B
	union	XCERA_REG	XCERA;		// Transmit channel enable partition A
	union	XCERB_REG	XCERB;		// Transmit channel enable partition B
	union	PCR_REG		PCR;		// Pin Control register
	union	RCERC_REG	RCERC;		// Receive channel enable partition C
	union	RCERD_REG	RCERD;		// Receive channel enable partition D
	union	XCERC_REG	XCERC;		// Transmit channel enable partition C
	union	XCERD_REG	XCERD;		// Transmit channel enable partition D
	union	RCERE_REG	RCERE;		// Receive channel enable partition E
	union	RCERF_REG	RCERF;		// Receive channel enable partition F
	union	XCERE_REG	XCERE;		// Transmit channel enable partition E
	union	XCERF_REG	XCERF;		// Transmit channel enable partition F
	union	RCERG_REG	RCERG;		// Receive channel enable partition G
	union	RCERH_REG	RCERH;		// Receive channel enable partition H
	union	XCERG_REG	XCERG;		// Transmit channel enable partition G
	union	XCERH_REG	XCERH;		// Transmit channel enable partition H
	Uint16				rsvd1[4];	// Reserved
	union	MFFINT_REG	MFFINT;		// Interrupt enable
};

//
// Mcbsp External References & Function Declarations:
//
extern volatile struct McBSP_REGS McbspaRegs;




//
// End of file.
//

//###########################################################################
//
// FILE:   F2806x_NmiIntrupt.h
//
// TITLE:  F2806x Device NMI Interrupt Register Definitions
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
//  NMI Interrupt Register Bit Definitions
//
struct NMICFG_BITS
{
    Uint16   rsvd1:1;            // 0         Reserved
    Uint16   CLOCKFAIL:1;        // 1         Fail Interrupt Enable Bits
    Uint16   rsvd2:14;           // 15:2      Reserved
};

union NMICFG_REG
{
    Uint16                         all;
    struct NMICFG_BITS             bit;
};

struct NMIFLG_BITS
{
    Uint16   NMIINT:1;           // 0         NMI Interrupt Flag
    Uint16   CLOCKFAIL:1;        // 1         Clock Fail Interrupt Flags
    Uint16   rsvd1:14;           // 15:2      Reserved
};

union NMIFLG_REG
{
    Uint16                         all;
    struct NMIFLG_BITS             bit;
};

struct NMIFLGCLR_BITS
{
    Uint16   NMIINT:1;           // 0         NMIINT Flag Clear Bit
    Uint16   CLOCKFAIL:1;        // 1         Clock Fail Flag Clear Bit
    Uint16   rsvd1:14;           // 15:2      Reserved
};

union NMIFLGCLR_REG
{
    Uint16                         all;
    struct NMIFLGCLR_BITS          bit;
};

struct NMIFLGFRC_BITS
{
    Uint16   rsvd1:1;            // 0         Reserved
    Uint16   CLOCKFAIL:1;        // 1         Clock Fail Flag Force Bit
    Uint16   rsvd2:14;           // 15:2      Reserved
};

union NMIFLGFRC_REG
{
    Uint16                         all;
    struct NMIFLGFRC_BITS          bit;
};

//
//  NMI Interrupt Register Definitions
//
struct NMIINTRUPT_REGS
{
    union  NMICFG_REG          NMICFG;
    union  NMIFLG_REG          NMIFLG;
    union  NMIFLGCLR_REG       NMIFLGCLR;
    union  NMIFLGFRC_REG       NMIFLGFRC;
    Uint16                     NMIWDCNT;
    Uint16                     NMIWDPRD;
    Uint16                     rsvd1[10];
};

//
//  NMI Interrupt External References and Function Declarations
//
extern volatile struct NMIINTRUPT_REGS NmiIntruptRegs;



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Pie_ctrl.h
//
// TITLE:  F2806x Device PIE_CTRL Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date:  $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// PIE_CTRL Individual Register Bit Definitions:
//
struct PIECTRL_BITS
{
	Uint16	ENPIE:1;			// 0	Enable PIE Block
	Uint16	PIEVECT:15;			// 15:1	Fetched Vector Address
};

union PIECTRL_REG
{
	Uint16 all;
	struct PIECTRL_BITS	bit;
};

struct PIEIER_BITS
{
	Uint16	INTx1:1;			// 0	INTx1
	Uint16	INTx2:1;			// 1	INTx2
	Uint16	INTx3:1;			// 2	INTx3
	Uint16	INTx4:1;			// 3	INTx4
	Uint16	INTx5:1;			// 4	INTx5
	Uint16	INTx6:1;			// 5	INTx6
	Uint16	INTx7:1;			// 6	INTx7
	Uint16	INTx8:1;			// 7	INTx8
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union PIEIER_REG
{
	Uint16 all;
	struct PIEIER_BITS	bit;
};

struct PIEIFR_BITS
{
	Uint16	INTx1:1;			// 0	INTx1
	Uint16	INTx2:1;			// 1	INTx2
	Uint16	INTx3:1;			// 2	INTx3
	Uint16	INTx4:1;			// 3	INTx4
	Uint16	INTx5:1;			// 4	INTx5
	Uint16	INTx6:1;			// 5	INTx6
	Uint16	INTx7:1;			// 6	INTx7
	Uint16	INTx8:1;			// 7	INTx8
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union PIEIFR_REG
{
	Uint16 all;
	struct PIEIFR_BITS	bit;
};

struct PIEACK_BITS
{
	Uint16	ACK1:1;			// 0	Acknowledge PIE Interrupt Group 1
	Uint16	ACK2:1;			// 1	Acknowledge PIE Interrupt Group 2
	Uint16	ACK3:1;			// 2	Acknowledge PIE Interrupt Group 3
	Uint16	ACK4:1;			// 3	Acknowledge PIE Interrupt Group 4
	Uint16	ACK5:1;			// 4	Acknowledge PIE Interrupt Group 5
	Uint16	ACK6:1;			// 5	Acknowledge PIE Interrupt Group 6
	Uint16	ACK7:1;			// 6	Acknowledge PIE Interrupt Group 7
	Uint16	ACK8:1;			// 7	Acknowledge PIE Interrupt Group 8
	Uint16	ACK9:1;			// 8	Acknowledge PIE Interrupt Group 9
	Uint16	ACK10:1;		// 9	Acknowledge PIE Interrupt Group 10
	Uint16	ACK11:1;		// 10	Acknowledge PIE Interrupt Group 11
	Uint16	ACK12:1;		// 11	Acknowledge PIE Interrupt Group 12
	Uint16	rsvd1:4;		// 15:12	Reserved
};

union PIEACK_REG
{
	Uint16 all;
	struct PIEACK_BITS	bit;
};

struct PIE_CTRL_REGS
{
	union	PIECTRL_REG	PIECTRL;	// PIE Control Register
	union	PIEACK_REG	PIEACK;		// PIE Acknowledge Register
	union	PIEIER_REG	PIEIER1;	// PIE INT1 IER Register
	union	PIEIFR_REG	PIEIFR1;	// PIE INT1 IFR Register
	union	PIEIER_REG	PIEIER2;	// PIE INT2 IER Register
	union	PIEIFR_REG	PIEIFR2;	// PIE INT2 IFR Register
	union	PIEIER_REG	PIEIER3;	// PIE INT3 IER Register
	union	PIEIFR_REG	PIEIFR3;	// PIE INT3 IFR Register
	union	PIEIER_REG	PIEIER4;	// PIE INT4 IER Register
	union	PIEIFR_REG	PIEIFR4;	// PIE INT4 IFR Register
	union	PIEIER_REG	PIEIER5;	// PIE INT5 IER Register
	union	PIEIFR_REG	PIEIFR5;	// PIE INT5 IFR Register
	union	PIEIER_REG	PIEIER6;	// PIE INT6 IER Register
	union	PIEIFR_REG	PIEIFR6;	// PIE INT6 IFR Register
	union	PIEIER_REG	PIEIER7;	// PIE INT7 IER Register
	union	PIEIFR_REG	PIEIFR7;	// PIE INT7 IFR Register
	union	PIEIER_REG	PIEIER8;	// PIE INT8 IER Register
	union	PIEIFR_REG	PIEIFR8;	// PIE INT8 IFR Register
	union	PIEIER_REG	PIEIER9;	// PIE INT9 IER Register
	union	PIEIFR_REG	PIEIFR9;	// PIE INT9 IFR Register
	union	PIEIER_REG	PIEIER10;	// PIE INT10 IER Register
	union	PIEIFR_REG	PIEIFR10;	// PIE INT10 IFR Register
	union	PIEIER_REG	PIEIER11;	// PIE INT11 IER Register
	union	PIEIFR_REG	PIEIFR11;	// PIE INT11 IFR Register
	union	PIEIER_REG	PIEIER12;	// PIE INT12 IER Register
	union	PIEIFR_REG	PIEIFR12;	// PIE INT12 IFR Register
};

//
// Defines
//

//
// Pie_ctrl External References & Function Declarations:
//
extern volatile struct PIE_CTRL_REGS PieCtrlRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_PieVect.h
//
// TITLE:  F2806x Devices PIE Vector Table Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// PIE Interrupt Vector Table Definition:
//

//
// Create a user type called PINT (pointer to interrupt)
//
typedef interrupt void(*PINT)(void);

//
// Define Vector Table
//
struct PIE_VECT_TABLE 
{
    //
    // Reset is never fetched from this table.
    // It will always be fetched from 0x3FFFC0 in boot ROM
    //
    PINT     PIE1_RESERVED;
    PINT     PIE2_RESERVED;
    PINT     PIE3_RESERVED;
    PINT     PIE4_RESERVED;
    PINT     PIE5_RESERVED;
    PINT     PIE6_RESERVED;
    PINT     PIE7_RESERVED;
    PINT     PIE8_RESERVED;
    PINT     PIE9_RESERVED;
    PINT     PIE10_RESERVED;
    PINT     PIE11_RESERVED;
    PINT     PIE12_RESERVED;
    PINT     PIE13_RESERVED;

    //
    // Non-Peripheral Interrupts
    //
    PINT     TINT1;     // CPU-Timer1
    PINT     TINT2;     // CPU-Timer2
    PINT     DATALOG;   // Datalogging interrupt
    PINT     RTOSINT;   // RTOS interrupt
    PINT     EMUINT;    // Emulation interrupt
    PINT     NMI;       // Non-maskable interrupt
    PINT     ILLEGAL;   // Illegal operation TRAP
    PINT     USER1;     // User Defined trap 1
    PINT     USER2;     // User Defined trap 2
    PINT     USER3;     // User Defined trap 3
    PINT     USER4;     // User Defined trap 4
    PINT     USER5;     // User Defined trap 5
    PINT     USER6;     // User Defined trap 6
    PINT     USER7;     // User Defined trap 7
    PINT     USER8;     // User Defined trap 8
    PINT     USER9;     // User Defined trap 9
    PINT     USER10;    // User Defined trap 10
    PINT     USER11;    // User Defined trap 11
    PINT     USER12;    // User Defined trap 12

    //
    // Group 1 PIE Peripheral Vectors
    //
    
    //
    // ADC - if Group 10 ADCINT1 is enabled, this must be rsvd1_1
    //
    PINT     ADCINT1;   
    
    //
    // ADC - if Group 10 ADCINT2 is enabled, this must be rsvd1_2
    //
    PINT     ADCINT2;   
    
    PINT     rsvd1_3;
    PINT     XINT1;	    // External Interrupt 1
    PINT     XINT2;     // External Interrupt 2
    PINT     ADCINT9;   // ADC 9
    PINT     TINT0;     // Timer 0
    PINT     WAKEINT;   // WD

    //
    // Group 2 PIE Peripheral Vectors
    //
    PINT     EPWM1_TZINT;   // EPWM-1
    PINT     EPWM2_TZINT;   // EPWM-2
    PINT     EPWM3_TZINT;   // EPWM-3
    PINT     EPWM4_TZINT;   // EPWM-4
    PINT     EPWM5_TZINT;   // EPWM-5
    PINT     EPWM6_TZINT;   // EPWM-6
    PINT     EPWM7_TZINT;   // EPWM-7
    PINT     EPWM8_TZINT;  	// EPWM-8

    //
    // Group 3 PIE Peripheral Vectors
    //
    PINT     EPWM1_INT;  // EPWM-1
    PINT     EPWM2_INT;  // EPWM-2
    PINT     EPWM3_INT;  // EPWM-3
    PINT     EPWM4_INT;  // EPWM-4
    PINT     EPWM5_INT;  // EPWM-5
    PINT     EPWM6_INT;  // EPWM-6
    PINT     EPWM7_INT;  // EPWM-7
    PINT     EPWM8_INT;  // EPWM-8

    //
    // Group 4 PIE Peripheral Vectors
    //
    PINT     ECAP1_INT;  // ECAP-1
    PINT     ECAP2_INT;  // ECAP-2
    PINT     ECAP3_INT;  // ECAP-3
    PINT     rsvd4_4;
    PINT     rsvd4_5;
    PINT     rsvd4_6;
    PINT     HRCAP1_INT; // HRCAP-1
    PINT     HRCAP2_INT; // HRCAP-2

    //
    // Group 5 PIE Peripheral Vectors
    //
    PINT     EQEP1_INT;  // EQEP-1
    PINT     EQEP2_INT;  // EQEP-2
    PINT     rsvd5_3;
    PINT     HRCAP3_INT; // HRCAP-3
    PINT     HRCAP4_INT; // HRCAP-4
    PINT     rsvd5_6;
    PINT     rsvd5_7;
    PINT     USB0_INT;   // USB-0

    //
    // Group 6 PIE Peripheral Vectors
    //
    PINT     SPIRXINTA;     // SPI-A
    PINT     SPITXINTA;     // SPI-A
    PINT     SPIRXINTB;     // SPI-B
    PINT     SPITXINTB;     // SPI-B
    PINT     MRINTA;	    // McBSP-A
    PINT     MXINTA;        // McBSP-A
    PINT     rsvd6_7;
    PINT     rsvd6_8;

    //
    // Group 7 PIE Peripheral Vectors
    //
    PINT     DINTCH1;	// DMA CH1
    PINT     DINTCH2;	// DMA CH2
    PINT     DINTCH3;	// DMA CH3
    PINT     DINTCH4;	// DMA CH4
    PINT     DINTCH5;	// DMA CH5
    PINT     DINTCH6;	// DMA CH6
    PINT     rsvd7_7;
    PINT     rsvd7_8;

    //
    // Group 8 PIE Peripheral Vectors
    //
    PINT     I2CINT1A;  // I2C-A
    PINT     I2CINT2A;  // I2C-A
    PINT     rsvd8_3;
    PINT     rsvd8_4;
    PINT     rsvd8_5;
    PINT     rsvd8_6;
    PINT     rsvd8_7;
    PINT     rsvd8_8;

    //
    // Group 9 PIE Peripheral Vectors
    //
    PINT     SCIRXINTA;  // SCI-A
    PINT     SCITXINTA;  // SCI-A
    PINT     SCIRXINTB;  // SCI-B
    PINT     SCITXINTB;  // SCI-B
    PINT     ECAN0INTA;  // eCAN-A
    PINT     ECAN1INTA;  // eCAN-A
    PINT     rsvd9_7;
    PINT     rsvd9_8;

    //
    // Group 10 PIE Peripheral Vectors
    //
    
    //
    // Can be ADCINT1, but must make ADCINT1 in Group 1 space "reserved".
    //
    PINT     rsvd10_1; 
    
    //
    // Can be ADCINT2, but must make ADCINT2 in Group 1 space "reserved".
    //
    PINT     rsvd10_2; 
    
    PINT     ADCINT3;  // ADC
    PINT     ADCINT4;  // ADC
    PINT     ADCINT5;  // ADC
    PINT     ADCINT6;  // ADC
    PINT     ADCINT7;  // ADC
    PINT     ADCINT8;  // ADC

    //
    // Group 11 PIE Peripheral Vectors:
    //
    PINT     CLA1_INT1;  // CLA
    PINT     CLA1_INT2;  // CLA
    PINT     CLA1_INT3;  // CLA
    PINT     CLA1_INT4;  // CLA
    PINT     CLA1_INT5;  // CLA
    PINT     CLA1_INT6;  // CLA
    PINT     CLA1_INT7;  // CLA
    PINT     CLA1_INT8;  // CLA

    //
    // Group 12 PIE Peripheral Vectors:
    //
    PINT     XINT3;
    PINT     rsvd12_2;
    PINT     rsvd12_3;
    PINT     rsvd12_4;
    PINT     rsvd12_5;
    PINT     rsvd12_6;
    PINT     LVF;        // Latched overflow
    PINT     LUF;        // Latched underflow
};

//
// PIE Interrupt Vector Table External References & Function Declarations:
//
extern volatile struct PIE_VECT_TABLE PieVectTable;



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Spi.h
//
// TITLE:  F2806x Device SPI Register Definitions.
//
//###########################################################################
// $TI Release: $   
// $Release Date:  $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// SPI Individual Register Bit Definitions
//
struct SPICCR_BITS
{
	Uint16	SPICHAR:4;			// 3:0	Character Length Control
	Uint16	SPILBK:1;			// 4	SPI Loopback
	Uint16	rsvd1:1;			// 5	Reserved
	Uint16	CLKPOLARITY:1;		// 6	Shift Clock Polarity
	Uint16	SPISWRESET:1;		// 7	SPI Software Reset
	Uint16	rsvd2:8;			// 15:8	Reserved
};

union SPICCR_REG
{
	Uint16 all;
	struct SPICCR_BITS	bit;
};

struct SPICTL_BITS
{
	Uint16	SPIINTENA:1;		// 0	SPI Interupt Enable
	Uint16	TALK:1;				// 1	Master/Slave Transmit Enable
	Uint16	MASTER_SLAVE:1;		// 2	SPI Network Mode Control
	Uint16	CLK_PHASE:1;		// 3	SPI Clock Phase
	Uint16	OVERRUNINTENA:1;	// 4	Overrun Interrupt Enable
	Uint16	rsvd1:11;			// 15:5	Reserved
};

union SPICTL_REG
{
	Uint16 all;
	struct SPICTL_BITS	bit;
};

struct SPISTS_BITS
{
	Uint16	rsvd1:5;			// 4:0  	Reserved
	Uint16	BUFFULL_FLAG:1;		// 5	SPI Transmit Buffer Full Flag
	Uint16	INT_FLAG:1;			// 6	SPI Interrupt Flag
	Uint16	OVERRUN_FLAG:1;		// 7	SPI Receiver Overrun Flag
	Uint16	rsvd2:8;			// 15:8	Reserved
};

union SPISTS_REG
{
	Uint16 all;
	struct SPISTS_BITS	bit;
};

struct SPIFFTX_BITS
{
	Uint16	TXFFIL:5;			// 4:0	TXFIFO Interrupt level
	Uint16	TXFFIENA:1;			// 5	TXFIFO Interrupt Enable
	Uint16	TXFFINTCLR:1;		// 6	TXFIFO Interrupt clear
	Uint16	TXFFINT:1;			// 7	TXFIFO Interrupt
	Uint16	TXFFST:5;			// 12:8	Transmit FIFO Status
	Uint16	TXFIFO:1;			// 13	TXFIFO Reset
	Uint16	SPIFFENA:1;			// 14	FIFO Enhancements Enable
	Uint16	SPIRST:1;			// 15	SPI Reset
};

union SPIFFTX_REG
{
	Uint16 all;
	struct SPIFFTX_BITS	bit;
};

struct SPIFFRX_BITS
{
	Uint16	RXFFIL:5;			// 4:0	RXFIFO Interrupt level
	Uint16	RXFFIENA:1;			// 5	RXFIFO Interrupt Enable
	Uint16	RXFFINTCLR:1;		// 6	RXFIFO Interupt clear
	Uint16	RXFFINT:1;			// 7	RXFIFO Interrupt
	Uint16	RXFFST:5;			// 12:8	Receive FIFO Status
	Uint16	RXFIFORESET:1;		// 13	RXFIFO Reset
	Uint16	RXFFOVFCLR:1;		// 14	Receive FIFO Overflow Clear
	Uint16	RXFFOVF:1;			// 15	Receive FIFO Overflow Flag
};

union SPIFFRX_REG
{
	Uint16 all;
	struct SPIFFRX_BITS	bit;
};

struct SPIFFCT_BITS
{
	Uint16	TXDLY:8;			// 7:0 	FIFO Transmit Delay Bits
	Uint16	rsvd1:8;			// 15:8	Reserved
};

union SPIFFCT_REG
{
	Uint16 all;
	struct SPIFFCT_BITS	bit;
};

struct SPIPRI_BITS
{
    Uint16 TRIWIRE:1;         // 0      3-wire mode select bit
    Uint16 STEINV:1;          // 1      SPISTE inversion bit
    Uint16 rsvd1:2;           // 3:2    reserved
    Uint16 FREE:1;            // 4      Free emulation mode control
    Uint16 SOFT:1;            // 5      Soft emulation mode control
    Uint16 PRIORITY:1;        // 6      Interrupt priority select
    Uint16 rsvd2:9;           // 15:7   reserved
};

union SPIPRI_REG
{
	Uint16 all;
	struct SPIPRI_BITS	bit;
};

struct SPI_REGS
{
	union	SPICCR_REG	SPICCR;		// SPI Configuration Control Register
	union	SPICTL_REG	SPICTL;		// SPI Operation Control Register
	union	SPISTS_REG	SPISTS;		// SPI Status Register
	Uint16				rsvd1;		// Reserved
	Uint16				SPIBRR;		// SPI Baud Rate Register
	Uint16				rsvd2;		// Reserved
	Uint16				SPIRXEMU;	// SPI Emulation Buffer Register
	Uint16				SPIRXBUF;	// SPI Serial Input Buffer Register
	Uint16				SPITXBUF;	// SPI Serial Output Buffer Register
	Uint16				SPIDAT;		// SPI Serial Data Register
	union	SPIFFTX_REG	SPIFFTX;	// SPI FIFO Transmit Register
	union	SPIFFRX_REG	SPIFFRX;	// SPI FIFO Receive Register
	union	SPIFFCT_REG	SPIFFCT;	// SPI FIFO Control Register
	Uint16				rsvd3[2];	// Reserved
	union	SPIPRI_REG	SPIPRI;		// SPI Priority Control Register
};

//
// Spi External References & Function Declarations:
//
extern volatile struct SPI_REGS SpiaRegs;
extern volatile struct SPI_REGS SpibRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Sci.h
//
// TITLE:  F2806x Device SCI Register Definitions.
//
//###########################################################################
// $TI Release:  $   
// $Release Date:  $   
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// SCI Individual Register Bit Definitions:
//
struct SCICCR_BITS
{
    Uint16  SCICHAR:3;          // 2:0  Character length control
    Uint16  ADDRIDLE_MODE:1;    // 3    ADDR/IDLE Mode control
    Uint16  LOOPBKENA:1;        // 4    Loop Back enable
    Uint16  PARITYENA:1;        // 5    Parity enable
    Uint16  PARITY:1;           // 6    Even or Odd Parity
    Uint16  STOPBITS:1;         // 7    Number of Stop Bits
    Uint16  rsvd1:8;            // 15:8 Reserved
};

union SCICCR_REG
{
    Uint16 all;
    struct SCICCR_BITS  bit;
};

struct SCICTL1_BITS
{
    Uint16  RXENA:1;            // 0    SCI receiver enable
    Uint16  TXENA:1;            // 1    SCI transmitter enable
    Uint16  SLEEP:1;            // 2    SCI sleep
    Uint16  TXWAKE:1;           // 3    Transmitter wakeup method
    Uint16  rsvd1:1;            // 4    Reserved
    Uint16  SWRESET:1;          // 5    Software reset
    Uint16  RXERRINTENA:1;      // 6    Recieve interrupt enable
    Uint16  rsvd2:9;            // 15:7 Reserved
};

union SCICTL1_REG
{
    Uint16 all;
    struct SCICTL1_BITS bit;
};

struct SCICTL2_BITS
{
    Uint16  TXINTENA:1;         // 0    Transmit interrupt enable
    Uint16  RXBKINTENA:1;       // 1    Receiver-buffer break enable
    Uint16  rsvd1:4;            // 5:2  Reserved
    Uint16  TXEMPTY:1;          // 6    Transmitter empty flag
    Uint16  TXRDY:1;            // 7    Transmitter ready flag
    Uint16  rsvd2:8;            // 15:8 Reserved
};

union SCICTL2_REG
{
    Uint16 all;
    struct SCICTL2_BITS bit;
};

struct SCIRXST_BITS
{
    Uint16  rsvd1:1;        // 0    Reserved
    Uint16  RXWAKE:1;       // 1    Receiver wakeup detect flag
    Uint16  PE:1;           // 2    Parity error flag
    Uint16  OE:1;           // 3    Overrun error flag
    Uint16  FE:1;           // 4    Framing error flag
    Uint16  BRKDT:1;        // 5    Break-detect flag
    Uint16  RXRDY:1;        // 6    Receiver ready flag
    Uint16  RXERROR:1;      // 7    Receiver error flag
    Uint16  rsvd2:8;        // 15:8 Reserved
};

union SCIRXST_REG
{
    Uint16 all;
    struct SCIRXST_BITS bit;
};

struct SCIRXBUF_BITS
{
    Uint16  RXDT:8;         // 7:0      Receive word
    Uint16  rsvd1:6;        // 13:8 Reserved
    Uint16  SCIFFPE:1;      // 14   SCI PE error in FIFO mode
    Uint16  SCIFFFE:1;      // 15   SCI FE error in FIFO mode
};

union SCIRXBUF_REG
{
    Uint16 all;
    struct SCIRXBUF_BITS    bit;
};

struct SCIFFTX_BITS
{
    Uint16  TXFFIL:5;           // 4:0  Interrupt level
    Uint16  TXFFIENA:1;         // 5    Interrupt enable
    Uint16  TXFFINTCLR:1;       // 6    Clear INT flag
    Uint16  TXFFINT:1;          // 7    INT flag
    Uint16  TXFFST:5;           // 12:8 FIFO status
    Uint16  TXFIFOXRESET:1;     // 13   FIFO reset
    Uint16  SCIFFENA:1;         // 14   Enhancement enable
    Uint16  SCIRST:1;           // 15   SCI reset rx/tx channels
};

union SCIFFTX_REG
{
    Uint16 all;
    struct SCIFFTX_BITS bit;
};

struct SCIFFRX_BITS
{
    Uint16  RXFFIL:5;           // 4:0  Interrupt level
    Uint16  RXFFIENA:1;         // 5    Interrupt enable
    Uint16  RXFFINTCLR:1;       // 6    Clear INT flag
    Uint16  RXFFINT:1;          // 7    INT flag
    Uint16  RXFFST:5;           // 12:8     FIFO status
    Uint16  RXFIFORESET:1;      // 13   FIFO reset
    Uint16  RXFFOVRCLR:1;       // 14   Clear overflow
    Uint16  RXFFOVF:1;          // 15   FIFO overflow
};

union SCIFFRX_REG
{
    Uint16 all;
    struct SCIFFRX_BITS bit;
};

struct SCIFFCT_BITS
{
    Uint16  FFTXDLY:8;      // 7:0  FIFO transmit delay
    Uint16  rsvd1:5;        // 12:8 Reserved
    Uint16  CDC:1;          // 13   Auto baud mode enable
    Uint16  ABDCLR:1;       // 14   Auto baud clear
    Uint16  ABD:1;          // 15   Auto baud detect
};

union SCIFFCT_REG
{
    Uint16 all;
    struct SCIFFCT_BITS bit;
};

struct SCIPRI_BITS
{
    Uint16  rsvd1:3;        // 2:0  Reserved
    Uint16  FREE:1;         // 3    Free emulation suspend mode
    Uint16  SOFT:1;         // 4    Soft emulation suspend mode
    Uint16  rsvd2:3;        // 7:5  Reserved
    Uint16  rsvd3:8;        // 15:8 Reserved
};

union SCIPRI_REG
{
    Uint16 all;
    struct SCIPRI_BITS  bit;
};

struct SCI_REGS
{
    union   SCICCR_REG      SCICCR;     // Communications control register
    union   SCICTL1_REG     SCICTL1;    // Control register 1
    Uint16  SCIHBAUD;                   // Baud rate (high) register
    Uint16  SCILBAUD;                   // Baud rate (low) register
    union   SCICTL2_REG     SCICTL2;    // Control register 2
    union   SCIRXST_REG     SCIRXST;    // Recieve status register
    Uint16                  SCIRXEMU;   // Recieve emulation buffer register
    union   SCIRXBUF_REG    SCIRXBUF;   // Recieve data buffer
    Uint16                  rsvd1;      // Reserved
    Uint16                  SCITXBUF;   // Transmit data buffer
    union   SCIFFTX_REG     SCIFFTX;    // FIFO transmit register
    union   SCIFFRX_REG     SCIFFRX;    // FIFO recieve register
    union   SCIFFCT_REG     SCIFFCT;    // FIFO control register
    Uint16                  rsvd2;      // Reserved
    Uint16                  rsvd3;      // Reserved
    union   SCIPRI_REG      SCIPRI;     // FIFO Priority control
};

//
// Sci External References & Function Declarations:
//
extern volatile struct SCI_REGS SciaRegs;
extern volatile struct SCI_REGS ScibRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Sysctrl.h
//
// TITLE:  F2806x Device SYSCTRL Register Definitions.
//
//###########################################################################
// $TI Release: 2806x C/C++ Header Files V1.10 $
// $Release Date: April 7, 2011 $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################




//
// SYSCTRL Individual Register Bit Definitions:
//
struct XCLK_BITS
{
    Uint16	XCLKOUTDIV:2;			// 1:0 	XCLKOUT Divide Ratio
	Uint16	rsvd1:4;				// 5:2	Reserved
	Uint16	XCLKINSEL:1;			// 6	XCLKIN Source Select
	Uint16	rsvd2:9;				// 15:7	Reserved
};

union XCLK_REG
{
	Uint16 all;
	struct XCLK_BITS	bit;
};

struct PLLSTS_BITS
{
	Uint16	PLLLOCKS:1;			// 0	PLL lock status
	Uint16	rsvd1:1;			// 1	Reserved
	Uint16	PLLOFF:1;			// 2	PLL off bit
	Uint16	MCLKSTS:1;			// 3	Missing clock status bit
	Uint16	MCLKCLR:1;			// 4	Missing clock clear bit
	Uint16	OSCOFF:1;			// 5	Oscillator clock off
	Uint16	MCLKOFF:1;			// 6	Missing clock detect
	Uint16	DIVSEL:2;			// 8:7	Divide select (/4 default)
	Uint16	rsvd2:6;			// 14:9	Reserved
	Uint16	NORMRDYE:1;			// 15	VREG NORMRDY enable bit
};

union PLLSTS_REG
{
    Uint16 all;
	struct PLLSTS_BITS	bit;
};

struct CLKCTL_BITS
{
	Uint16	OSCCLKSRCSEL:1;	    // 0	Oscillator clock source select bit
	Uint16	OSCCLKSRC2SEL:1;	// 1	Oscillator 2 clock source select bit
	Uint16	WDCLKSRCSEL:1;		// 2	Watchdog clock source select bit
	Uint16	TMR2CLKSRCSEL:2;	// 4:3	CPU timer 2 clock source select bit
	Uint16	TMR2CLKPRESCALE:3;	// 7:5	CPU timer 2 clock pre-scale value
	Uint16	INTOSC1OFF:1;		// 8	Internal oscillator off bit
	
    //
    // 9	Internal oscillator 1 halt mode ignore bit
    //
    Uint16	INTOSC1HALTI:1;
    
	Uint16	INTOSC2OFF:1;		// 10	Internal oscillator 2 off bit
	
    //
    // 11	Internal oscillator 2 halt mode ignore bit
    //
    Uint16	INTOSC2HALTI:1;		
    
	Uint16	WDHALTI:1;			// 12	Watchdog halt mode ignore bit
	Uint16	XCLKINOFF:1;		// 13	XCLKIN off bit
	Uint16	XTALOSCOFF:1;		// 14	Crystal (External) oscillator off bit
	Uint16	NMIRESETSEL:1;		// 15	NMI reset select bit
};

union CLKCTL_REG
{
	Uint16 all;
	struct CLKCTL_BITS	bit;
};

struct INTOSC1TRIM_BITS
{
	Uint16	COARSETRIM:8;		// 7:0	8-bit coarse trim value
	Uint16	rsvd1:1;			// 8	Reserved
	Uint16	FINETRIM:6;			// 14:9	6-bit fine trim value
	Uint16	rsvd2:1;			// 15	Reserved
};

union INTOSC1TRIM_REG
{
	Uint16 all;
	struct INTOSC1TRIM_BITS	bit;
};

struct INTOSC2TRIM_BITS
{
	Uint16	COARSETRIM:8;		// 7:0	8-bit coarse trim value
	Uint16	rsvd1:1;			// 8	Reserved
	Uint16	FINETRIM:6;			// 14:9	6-bit fine trim value
	Uint16	rsvd2:1;			// 15	Reserved
};

union INTOSC2TRIM_REG
{
	Uint16 all;
	struct INTOSC2TRIM_BITS	bit;
};

struct PCLKCR2_BITS
{
	Uint16	rsvd1:8;			// 7:0	Reserved
	Uint16	HRCAP1ENCLK:1;		// 8 	HRCAP1 Clock Enable
	Uint16	HRCAP2ENCLK:1;		// 9	HRCAP2 Clock Enable
	Uint16	HRCAP3ENCLK:1;		// 10	HRCAP3 Clock Enable
	Uint16	HRCAP4ENCLK:1;		// 11	HRCAP4 Clock Enable
	Uint16	rsvd2:4;			// 15:12 Reserved
};

union PCLKCR2_REG
{
	Uint16 all;
	struct PCLKCR2_BITS	bit;
};

struct LOSPCP_BITS
{
	Uint16	LSPCLK:3;			// 2:0	Rate relative to SYSCLKOUT
	Uint16	rsvd1:13;			// 15:3	Reserved
};

union LOSPCP_REG
{
	Uint16 all;
	struct LOSPCP_BITS	bit;
};

struct PCLKCR0_BITS
{
	Uint16	HRPWMENCLK:1;		// 0	HRPWM Clock Enable
	Uint16	rsvd1:1;			// 1	Reserved
	Uint16	TBCLKSYNC:1;		// 2	EWPM Module TBCLK enable/sync
	Uint16	ADCENCLK:1;			// 3	Enable high speed clk to ADC1
	Uint16	I2CAENCLK:1;		// 4	I2C-A Clock Enable
	Uint16	rsvd2:1;			// 5	Reserved
	Uint16	rsvd3:2;			// 7:6	Reserved
	Uint16	SPIAENCLK:1;		// 8	SPI A Clock Enable
	Uint16	SPIBENCLK:1;		// 9	SPI B Clock Enable
	Uint16	SCIAENCLK:1;		// 10	SCI A Clock Enable
	Uint16	SCIBENCLK:1;		// 11	SCI B Clock Enable
	Uint16	MCBSPAENCLK:1;		// 12	McBSP-A Clock Enable
	Uint16	rsvd4:1;			// 13	Reserved
	Uint16	ECANAENCLK:1;		// 14	CAN A Clock Enable
	Uint16	rsvd5:1;			// 15	Reserved
};

union PCLKCR0_REG
{
	Uint16 all;
	struct PCLKCR0_BITS	bit;
};

struct PCLKCR1_BITS
{
	Uint16	EPWM1ENCLK:1;			// 0	EPWM1 Clock Enable
	Uint16	EPWM2ENCLK:1;			// 1	EPWM2 Clock Enable
	Uint16	EPWM3ENCLK:1;			// 2	EPWM3 Clock Enable
	Uint16	EPWM4ENCLK:1;			// 3	EPWM4 Clock Enable
	Uint16	EPWM5ENCLK:1;			// 4	EPWM5 Clock Enable
	Uint16	EPWM6ENCLK:1;			// 5	EPWM6 Clock Enable
	Uint16	EPWM7ENCLK:1;			// 6	EPWM7 Clock Enable
	Uint16	EPWM8ENCLK:1;			// 7	EPWM8 Clock Enable
	Uint16	ECAP1ENCLK:1;			// 8	ECAP1 Clock Enable
	Uint16	ECAP2ENCLK:1;			// 9	ECAP2 Clock Enable
	Uint16	ECAP3ENCLK:1;			// 10	ECAP3 Clock Enable
	Uint16	rsvd1:3;				// 13:11	Reserved
	Uint16	EQEP1ENCLK:1;			// 14	EQEP1 Clock Enable
	Uint16	EQEP2ENCLK:1;			// 15	EQEP2 Clock Enable
};

union PCLKCR1_REG
{
	Uint16 all;
	struct PCLKCR1_BITS	bit;
};

struct PCLKCR3_BITS
{
	Uint16	COMP1ENCLK:1;			// 0	COMP1 and DAC1 Clock Enable
	Uint16	COMP2ENCLK:1;			// 1	COMP2 and DAC2 Clock Enable
	Uint16	COMP3ENCLK:1;			// 2	COMP3 and DAC3 Clock Enable
	Uint16	rsvd1:5;				// 7:3	Reserved
	Uint16	CPUTIMER0ENCLK:1;		// 8	Enable SYSCLKOUT to CPUTIMER0
	Uint16	CPUTIMER1ENCLK:1;		// 9	Enable SYSCLKOUT to CPUTIMER1
	Uint16	CPUTIMER2ENCLK:1;		// 10	Enable SYSCLKOUT to CPUTIMER2
	Uint16	DMAENCLK:1;				// 11	DMA Clock Enable
	Uint16	rsvd2:1;				// 12	Reserved
	Uint16	rsvd3:1;				// 13	Reserved
	Uint16	CLA1ENCLK:1;			// 14	CLA Clock Enable
	Uint16	USB0ENCLK:1;			// 15	USB0 Clock Enable
};

union PCLKCR3_REG
{
	Uint16 all;
	struct PCLKCR3_BITS	bit;
};

struct PLLCR_BITS
{
	Uint16	DIV:5;				// 4:0	Set Clock ratio for the PLL
	Uint16	rsvd1:11;			// 15:4	Reserved
};

union PLLCR_REG
{
	Uint16 all;
	struct PLLCR_BITS	bit;
};

struct JTAGDEBUG_BITS
{
	Uint16	JTAGDIS:1;		// JTAG Port Disable Bit
	Uint16	rsvd1:15;		// Reserved
};

union JTAGDEBUG_REG
{
	Uint16	all;
	struct	JTAGDEBUG_BITS	bit;
};

struct LPMCR0_BITS
{
	Uint16	LPM:2;				// 1:0	Set the low power mode
	Uint16	QUALSTDBY:6;		// 7:2	Qualification
	Uint16	rsvd1:7;			// 14:8	Reserved
	
    //
    // 15	Enables WD to wake the device from STANDBY
    //
    Uint16	WDINTE:1;			
};

union LPMCR0_REG
{
	Uint16 all;
	struct LPMCR0_BITS	bit;
};

struct PLL2CTL_BITS
{
	Uint16	PLL2CLKSRCSEL:2;	// 1:0	PLL2 Clock Source Select Bits
	Uint16	PLL2EN:1;			// 2	PLL2 Enable Bit
	Uint16	rsvd1:13;			// 15:3	Reserved
};

union PLL2CTL_REG
{
	Uint16 all;
	struct PLL2CTL_BITS	bit;
};

struct PLL2MULT_BITS
{
	Uint16	PLL2MULT:4;		// 3:0	PLL2 Integer Multiplier
	Uint16	rsvd1:12;		// 15:4	Reserved
};

union PLL2MULT_REG
{
	Uint16 all;
	struct PLL2MULT_BITS	bit;
};

struct PLL2STS_BITS
{
	Uint16	PLL2LOCKS:1;	// 0	PLL2 Lock Status Bit
	Uint16	rsvd1:15;		// 15:1	Reserved
};

union PLL2STS_REG
{
	Uint16 all;
	struct PLL2STS_BITS	bit;
};

struct EPWMCFG_BITS
{
	Uint16	CONFIG:1;			// 0	EPWM to DMA/CLA Enable Bit
	Uint16	rsvd1:15;			// 15:1	Reserved
};

union EPWMCFG_REG
{
    Uint16 all;
	struct EPWMCFG_BITS	bit;
};

//
// System Power Control Registers
//

//
// BOR configuration register bit definitions
//
struct BORCFG_BITS
{
    Uint16 BORENZ:1;      // 0     BOR enable active low bit
    Uint16 rsvd1:15;      // 15:1  reserved
};

union BORCFG_REG
{
    Uint16              all;
    struct BORCFG_BITS  bit;
};

struct SYS_PWR_CTRL_REGS
{
    union    BORCFG_REG   BORCFG;       // 0 BOR Configuration Register
    Uint16   rsvd1[2];                  // 1-2
};

//
// CSM Status & Control register bit definitions
//
struct  CSMSCR_BITS
{
    Uint16     SECURE:1;    // 0     Secure flag
    Uint16     rsvd1:14;    // 14:1  Reserved
    Uint16     FORCESEC:1;  // 15    Force Secure control bit
};

//
// Allow access to the bit fields or entire register
//
union CSMSCR_REG
{
    Uint16             all;
    struct CSMSCR_BITS bit;
};

//
// CSM Register File
//
struct  CSM_REGS
{
    Uint16           KEY0;    // KEY reg bits 15-0
    Uint16           KEY1;    // KEY reg bits 31-16
    Uint16           KEY2;    // KEY reg bits 47-32
    Uint16           KEY3;    // KEY reg bits 63-48
    Uint16           KEY4;    // KEY reg bits 79-64
    Uint16           KEY5;    // KEY reg bits 95-80
    Uint16           KEY6;    // KEY reg bits 111-96
    Uint16           KEY7;    // KEY reg bits 127-112
    Uint16           rsvd1;   // Reserved
    Uint16           rsvd2;   // Reserved
    Uint16           rsvd3;   // Reserved
    Uint16           rsvd4;   // Reserved
    Uint16           rsvd5;   // Reserved
    Uint16           rsvd6;   // Reserved
    Uint16           rsvd7;   // Reserved
    union CSMSCR_REG CSMSCR;  // CSM Status & Control register
};

//
// Password locations
//
struct  CSM_PWL
{
    Uint16   PSWD0;  // PSWD bits 15-0
    Uint16   PSWD1;  // PSWD bits 31-16
    Uint16   PSWD2;  // PSWD bits 47-32
    Uint16   PSWD3;  // PSWD bits 63-48
    Uint16   PSWD4;  // PSWD bits 79-64
    Uint16   PSWD5;  // PSWD bits 95-80
    Uint16   PSWD6;  // PSWD bits 111-96
    Uint16   PSWD7;  // PSWD bits 127-112
};

//
// Flash Registers
//

struct FOPT_BITS
{
    Uint16	ENPIPE:1;			// 0	Enable Pipeline Mode
	Uint16	rsvd1:15;			// 15:1	Reserved
};

union FOPT_REG
{
	Uint16 all;
	struct FOPT_BITS	bit;
};

struct FPWR_BITS
{
	Uint16	PWR:2;				// 1:0	Power Mode Bits
	Uint16	rsvd1:14;			// 15:2	Reserved
};

union FPWR_REG
{
	Uint16 all;
	struct FPWR_BITS	bit;
};

struct FSTATUS_BITS
{
    Uint16	PWRS:2;				// 1:0	Power Mode Status Bits
	
    //
    // 2	Bank/Pump Sleep to Standby Wait Counter Status Bits
    //
    Uint16	STDBYWAITS:1;		
    
    //
	// 3	Bank/Pump Standby to Active Wait Counter Status Bits
    //
    Uint16	ACTIVEWAITS:1;		
    
	Uint16	rsvd1:4;			// 7:4	Reserved
	Uint16	V3STAT:1;			// 8	VDD3V Status Latch Bit
	Uint16	rsvd2:7;			// 15:9	Reserved
};

union FSTATUS_REG
{
	Uint16 all;
	struct FSTATUS_BITS	bit;
};

struct FSTDBYWAIT_BITS
{
	Uint16	STDBYWAIT:9;	// 8:0	Bank/Pump Sleep to Standby Wait Count Bits
    Uint16	rsvd1:7;		// 15:9	Reserved
};

union FSTDBYWAIT_REG
{
    Uint16 all;
	struct FSTDBYWAIT_BITS	bit;
};

struct FACTIVEWAIT_BITS
{
	Uint16	ACTIVEWAIT:9;	// 8:0	Bank/Pump Standby to Active Wait Count Bits
	Uint16	rsvd1:7;		// 15:9	Reserved
};

union FACTIVEWAIT_REG
{
    Uint16 all;
	struct FACTIVEWAIT_BITS	bit;
};

struct FBANKWAIT_BITS
{
	Uint16	RANDWAIT:4;			// 3:0	Flash Random Read Wait State Bits
	Uint16	rsvd1:4;			// 7:4	Reserved
	Uint16	PAGEWAIT:4;			// 11:8	Flash Paged Read Wait State Bits
	Uint16	rsvd2:4;			// 15:12	Reserved
};

union FBANKWAIT_REG
{
	Uint16 all;
	struct FBANKWAIT_BITS	bit;
};

struct FOTPWAIT_BITS
{
	Uint16	OTPWAIT:5;			// 4:0	OTP Read Wait State Bits
	Uint16	rsvd1:11;			// 15:5	Reserved
};

union FOTPWAIT_REG
{
	Uint16 all;
	struct FOTPWAIT_BITS	bit;
};

struct SYS_CTRL_REGS
{
	union	XCLK_REG		XCLK;		 // XCLKOUT Control
	union	PLLSTS_REG		PLLSTS;		 // PLL Status Register
	union	CLKCTL_REG		CLKCTL;		 // Clock Control Register
	Uint16					PLLLOCKPRD;	 // PLL Lock Period Register
	union	INTOSC1TRIM_REG	INTOSC1TRIM; // Internal Oscillator 1 Trim Register
	Uint16					rsvd1;		 // Reserved
	union	INTOSC2TRIM_REG	INTOSC2TRIM; // Internal Oscillator 2 Trim
	Uint16					rsvd2[2];	 // Reserved
	union	PCLKCR2_REG		PCLKCR2;	 // Peripheral Clock Control Regsiter 2
	Uint16					rsvd3;		 // Reserved
	
    //
    // Low-Speed Peripheral Clock Pre-Scaler Register
    //
    union	LOSPCP_REG		LOSPCP;		 
    
	union	PCLKCR0_REG		PCLKCR0;	 // Peripheral Clock Control Register 0
	union	PCLKCR1_REG		PCLKCR1;	 // Peripheral Clock Control Register 1
	union	LPMCR0_REG		LPMCR0;		 // Low Power Mode Control Register 0
	Uint16					rsvd4;		 // Reserved
	union	PCLKCR3_REG		PCLKCR3;	 // Peripheral Clock Control Register 3
	union	PLLCR_REG		PLLCR;		 // PLL Control Register
	Uint16					SCSR;		 // System Control and Status Register
	Uint16					WDCNTR;		 // Watchdog Counter Register
	Uint16					rsvd5;		 // Reserved
	Uint16					WDKEY;		 // Watchdog Reset Key Register
	Uint16					rsvd6[3];	 // Reserved
	Uint16					WDCR;		 // Watchdog Control Register
	union	JTAGDEBUG_REG	JTAGDEBUG;	 // JTAG Port Debug Register
	Uint16					rsvd7[5];	 // Reserved
	union	PLL2CTL_REG		PLL2CTL;	 // PLL2 Configuration Register
	Uint16					rsvd8;		 // Reserved
	union	PLL2MULT_REG	PLL2MULT;	 // PLL2 Multiplier Register
	Uint16					rsvd9;		 // Reserved
	union	PLL2STS_REG		PLL2STS;	 // PLL2 Lock Status Register
	Uint16					rsvd10;		 // Reserved
	Uint16					SYSCLK2CNTR; // SYSCLK2 Clock Counter Register
	Uint16					rsvd11[3];	 // Reserved
	union	EPWMCFG_REG		EPWMCFG;	 // EPWM DMA/CLA Configuration Register
	Uint16					rsvd12[5];	 // Reserved
};

struct FLASH_REGS
{
	union	FOPT_REG		FOPT;			// Option Register
	Uint16					rsvd1;			// Reserved
	union	FPWR_REG		FPWR;			// Power Modes Register
	union	FSTATUS_REG		FSTATUS;		// Status Register
	
    //
    // Pump/Bank Sleep to Standby Wait State Register
    //
    union	FSTDBYWAIT_REG	FSTDBYWAIT;		
    
    //
    // Pump/Bank Standby to Active Wait State Register
    //
	union	FACTIVEWAIT_REG	FACTIVEWAIT;	
    
	//
    // Bank Read Access Wait State Register
    //
    union	FBANKWAIT_REG	FBANKWAIT;		
    
    //
    // OTP Read Access Wait State Register
    //
	union	FOTPWAIT_REG	FOTPWAIT;		
};

//
// Sysctrl External References & Function Declarations:
//
extern volatile struct SYS_CTRL_REGS SysCtrlRegs;
extern volatile struct SYS_PWR_CTRL_REGS SysPwrCtrlRegs;
extern volatile struct CSM_PWL CsmPwl;
extern volatile struct CSM_REGS CsmRegs;
extern volatile struct FLASH_REGS FlashRegs;




//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Usb.h
//
// TITLE:  F2806x Device USB Register Definitions.
//
//###########################################################################
// $TI Release: 2806x C/C++ Header Files V1.10 $
// $Release Date: April 7, 2011 $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// USB Individual Register Bit Definitions:

struct USBFADDR_BITS
{
	Uint16	FUNCADDR:7;			// 6:0	Functional Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBFADDR_REG
{
	Uint16 all;
	struct USBFADDR_BITS	bit;
};

struct USBPOWER_BITS
{
	Uint16	PWRDNPHY:1;			// 0	Power Down PHY
	Uint16	SUSPEND:1;			// 1	Enable Suspend
	Uint16	RESUME:1;			// 2	Enable Resume Signaling
	Uint16	RESET:1;			// 3	Enable Reset Signaling
	Uint16	rsvd1:2;			// 5:4	Reserved
	Uint16	SOFT_CONN:1;		// 6	Soft Connect/Disconnect
	Uint16	ISOUP:1;			// 7	Isochronous Update
};

union USBPOWER_REG
{
	Uint16 all;
	struct USBPOWER_BITS	bit;
};

struct USBTXIS_BITS
{
	Uint16	EP0:1;			// 0	Transmit Endpoint 0 Interrupt
	Uint16	EP1:1;			// 1	Transmit Endpoint 1 Interrupt
	Uint16	EP2:1;			// 2	Transmit Endpoint 2 Interrupt
	Uint16	EP3:1;			// 3	Transmit Endpoint 3 Interrupt
	Uint16	rsvd1:12;		// 15:4	Reserved
};

union USBTXIS_REG
{
	Uint32 all;
	struct USBTXIS_BITS	bit;
};

struct USBRXIS_BITS
{
    Uint16	rsvd1:1;		// 0	Reserved
	Uint16	EP1:1;			// 1	Recieve Endpoint 1 Interrupt
	Uint16	EP2:1;			// 2	Recieve Endpoint 2 Interrupt
	Uint16	EP3:1;			// 3	Recieve Endpoint 3 Interrupt
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union USBRXIS_REG
{
	Uint32 all;
	struct USBRXIS_BITS	bit;
};

struct USBTXIE_BITS
{
	Uint16	EP0:1;			// 0	Transmit Endpoint 0 Interrupt Enable
	Uint16	EP1:1;			// 1	Transmit Endpoint 1 Interrupt Enable
	Uint16	EP2:1;			// 2	Transmit Endpoint 2 Interrupt Enable
	Uint16	EP3:1;			// 3	Transmit Endpoint 3 Interrupt Enable
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union USBTXIE_REG
{
	Uint32 all;
	struct USBTXIE_BITS	bit;
};

struct USBRXIE_BITS
{
	Uint16	rsvd1:1;		// 0	Reserved
	Uint16	EP1:1;			// 1	Recieve Endpoint 1 Interrupt Enable
	Uint16	EP2:1;			// 2	Recieve Endpoint 2 Interrupt Enable
	Uint16	EP3:1;			// 3	Recieve Endpoint 3 Interrupt Enable
	Uint16	rsvd2:12;		// 15:4	Reserved
};

union USBRXIE_REG
{
	Uint32 all;
	struct USBRXIE_BITS	bit;
};

struct USBIS_BITS
{
	Uint16	SUSPEND:1;			// 0	Suspend Signaling Detected Interrupt
	Uint16	RESUME:1;			// 1	Resume Signaling Detected Interrupt
	Uint16	RESET:1;			// 2	Reset Signaling Detected Interrupt
	Uint16	SOF:1;				// 3	New Frame Detected Interrupt
	Uint16	rsvd1:1;			// 4	Reserved
	Uint16	DISCON:1;			// 5	Device Disconnection Detected Interrupt
	Uint16	rsvd2:2;			// 7:6	Reserved
};

union USBIS_REG
{
	Uint16 all;
	struct USBIS_BITS	bit;
};

struct USBIE_BITS
{
	Uint16	SUSPEND:1;	// 0	Suspend Signaling Detected Interrupt Enable
	Uint16	RESUME:1;	// 1	Resume Signaling Detected Interrupt Enable
	Uint16	RESET:1;	// 2	Reset Signaling Detected Interrupt Enable
	Uint16	SOF:1;		// 3	New Frame Detected Interrupt Enable
	Uint16	rsvd1:1;	// 4	Reserved
	Uint16	DISCON:1;	// 5	Device Disconnection Detected Interrupt Enable
	Uint16	rsvd2:2;	// 7:6	Reserved
};

union USBIE_REG
{
	Uint16 all;
	struct USBIE_BITS	bit;
};

struct USBFRAME_BITS
{
	Uint16	FRAME:11;			// 10:0	Frame Number
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBFRAME_REG
{
    Uint32 all;
	struct USBFRAME_BITS	bit;
};

struct USBEPIDX_BITS
{
	Uint16	EPIDX:4;			// 3:0	Endpoint Index
	Uint16	rsvd1:4;			// 7:4	Reserved
};

union USBEPIDX_REG
{
	Uint16 all;
	struct USBEPIDX_BITS	bit;
};

struct USBTEST_BITS
{
	Uint16	rsvd1:5;			// 4:0	Reserved
	Uint16	FORCEFS:1;			// 5	Force Full Speed Upon Reset
	Uint16	FIFOACC:1;			// 6	FIFO Access
	Uint16	FORCEH:1;			// 7	Force Host Mode
};

union USBTEST_REG
{
	Uint16 all;
	struct USBTEST_BITS	bit;
};

struct USBDEVCTL_BITS
{
	Uint16	SESSION:1;			// 0	Session Start/End
	Uint16	HOSTREQ:1;			// 1	Host Request
	Uint16	HOST:1;				// 2	Host Mode
	Uint16	VBUS:2;				// 4:3	Vbus Level
	Uint16	LSDEV:1;			// 5	Low Speed Device Detected
	Uint16	FSDEV:1;			// 6	Full Speed Device Detected
	Uint16	DEV:1;				// 7	Device Mode
};

union USBDEVCTL_REG
{
	Uint16	all;
	struct USBDEVCTL_BITS	bit;
};

struct USBTXFIFOSZ_BITS
{
	Uint16	SIZE:4;				// 3:0	Max Packet Size
	Uint16	DPB:1;				// 4	Double Packet Buffer Support
	Uint16	rsvd1:3;			// 7:5	Reserved
};

union USBTXFIFOSZ_REG
{
	Uint16 	all;
	struct USBTXFIFOSZ_BITS	bit;
};

struct USBRXFIFOSZ_BITS
{
	Uint16	SIZE:4;				// 3:0	Max Packet Size
	Uint16	DPB:1;				// 4	Double Packet Buffer Support
	Uint16	rsvd1:3;			// 7:5	Reserved
};

union USBRXFIFOSZ_REG
{
	Uint16 	all;
	struct USBRXFIFOSZ_BITS	bit;
};

struct USBTXFIFOADD_BITS
{
	Uint16	ADDR:9;				// 8:0	Endpoint Data
	Uint16	rsvd1:7;			// 15:9	Reserved
};

union USBTXFIFOADD_REG
{
	Uint32 all;
	struct USBTXFIFOADD_BITS	bit;
};

struct USBRXFIFOADD_BITS
{
	Uint16	ADDR:9;				// 8:0	Endpoint Data
	Uint16	rsvd1:7;			// 15:9	Reserved
};

union USBRXFIFOADD_REG
{
	Uint32 all;
	struct USBRXFIFOADD_BITS	bit;
};

struct USBCONTIM_BITS
{
	Uint16	WTID:4;				// 3:0	Wait ID
	Uint16	WTCON:4;			// 7:4	Connect Wait
};

union USBCONTIM_REG
{
	Uint16 	all;
	struct USBCONTIM_BITS	bit;
};

struct USBTXFUNCADDR0_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXFUNCADDR0_REG
{
	Uint16	all;
	struct USBTXFUNCADDR0_BITS	bit;
};

struct USBTXHUBADDR0_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBTXHUBADDR0_REG
{
	Uint16 	all;
	struct USBTXHUBADDR0_BITS	bit;
};

struct USBTXHUBPORT0_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXHUBPORT0_REG
{
	Uint16 	all;
	struct USBTXHUBPORT0_BITS	bit;
};

struct USBTXFUNCADDR1_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXFUNCADDR1_REG
{
	Uint16 	all;
	struct USBTXFUNCADDR1_BITS	bit;
};

struct USBTXHUBADDR1_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBTXHUBADDR1_REG
{
	Uint16 	all;
	struct USBTXHUBADDR1_BITS	bit;
};

struct USBTXHUBPORT1_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXHUBPORT1_REG
{
	Uint16 	all;
	struct USBTXHUBPORT1_BITS	bit;
};

struct USBRXFUNCADDR1_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXFUNCADDR1_REG
{
	Uint16 	all;
	struct USBRXFUNCADDR1_BITS	bit;
};

struct USBRXHUBADDR1_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBRXHUBADDR1_REG
{
	Uint16 	all;
	struct USBRXHUBADDR1_BITS	bit;
};

struct USBRXHUBPORT1_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXHUBPORT1_REG
{
	Uint16 	all;
	struct USBRXHUBPORT1_BITS	bit;
};

struct USBTXFUNCADDR2_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXFUNCADDR2_REG
{
	Uint16 	all;
	struct USBTXFUNCADDR2_BITS	bit;
};

struct USBTXHUBADDR2_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBTXHUBADDR2_REG
{
	Uint16 	all;
	struct USBTXHUBADDR2_BITS	bit;
};

struct USBTXHUBPORT2_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXHUBPORT2_REG
{
	Uint16 	all;
	struct USBTXHUBPORT2_BITS	bit;
};

struct USBRXFUNCADDR2_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXFUNCADDR2_REG
{
	Uint16	all;
	struct USBRXFUNCADDR2_BITS	bit;
};

struct USBRXHUBADDR2_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBRXHUBADDR2_REG
{
	Uint16 	all;
	struct USBRXHUBADDR2_BITS	bit;
};

struct USBRXHUBPORT2_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXHUBPORT2_REG
{
	Uint16 	all;
	struct USBRXHUBPORT2_BITS	bit;
};

struct USBTXFUNCADDR3_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXFUNCADDR3_REG
{
	Uint16 	all;
	struct USBTXFUNCADDR3_BITS	bit;
};

struct USBTXHUBADDR3_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBTXHUBADDR3_REG
{
	Uint16 	all;
	struct USBTXHUBADDR3_BITS	bit;
};

struct USBTXHUBPORT3_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBTXHUBPORT3_REG
{
	Uint16 	all;
	struct USBTXHUBPORT3_BITS	bit;
};

struct USBRXFUNCADDR3_BITS
{
	Uint16	ADDR:7;				// 6:0	Device Address
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXFUNCADDR3_REG
{
	Uint16	all;
	struct USBRXFUNCADDR3_BITS	bit;
};

struct USBRXHUBADDR3_BITS
{
	Uint16	ADDR:7;				// 6:0	Hub Address
	Uint16	MULTTRAN:1;			// 7	Hub has Multiple Translators
};

union USBRXHUBADDR3_REG
{
	Uint16 	all;
	struct USBRXHUBADDR3_BITS	bit;
};

struct USBRXHUBPORT3_BITS
{
	Uint16	PORT:7;				// 6:0	Hub Port
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBRXHUBPORT3_REG
{
	Uint16 	all;
	struct USBRXHUBPORT3_BITS	bit;
};

struct USBCSRL0_BITS
{
	Uint16	RXRDY:1;				// 0	Receive Packet Ready
	Uint16	TXRDY:1;				// 1	Transmit Packet Ready
	Uint16	STALLED:1;				// 2	Endpoint Stalled
	Uint16	DATAEND_SETUP:1;		// 3	Data End/Setup Packet
	Uint16	SETEND_ERROR:1;			// 4	Setup End/Error
	Uint16	STALL_RQPKT:1;			// 5	Send Stall /Request Packet
	Uint16	RXRDYC_STATUS:1;		// 6	RXRDY Clear/STATUS Packet
	Uint16	SETENDC_NAKTO:1;		// 7	Setup End Clear/NAK Timeout
};

union USBCSRL0_REG
{
	Uint16 	all;
	struct USBCSRL0_BITS	bit;
};

struct USBCSRH0_BITS
{
	Uint16	FLUSH:1;			// 0	Flush FIFO
	Uint16	DT:1;				// 1	Data Toggle
	Uint16	DTWE:1;				// 2	Data Toggle Write Enable
	Uint16	rsvd1:5;			// 7:3	Reserved
};

union USBCSRH0_REG
{
	Uint16 	all;
	struct USBCSRH0_BITS	bit;
};

struct USBCOUNT0_BITS
{
	Uint16	COUNT:7;			// 6:0	FIFO Count
	Uint16	rsvd1:1;			// 7	Reserved
};

union USBCOUNT0_REG
{
	Uint16 	all;
	struct USBCOUNT0_BITS	bit;
};

struct USBTYPE0_BITS
{
	Uint16	rsvd1:6;			// 5:0	Reserved
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBTYPE0_REG
{
	Uint16 	all;
	struct USBTYPE0_BITS	bit;
};

struct USBNAKLMT_BITS
{
	Uint16	NAKLMT:5;			// 4:0	EP0 NAK Limit
	Uint16	rsvd1:3;			// 7:5	Reserved
};

union USBNAKLMT_REG
{
	Uint16 	all;
	struct USBNAKLMT_BITS	bit;
};

struct USBTXMAXP1_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBTXMAXP1_REG
{
	Uint32 all;
	struct USBTXMAXP1_BITS	bit;
};

struct USBTXCSRL1_BITS
{
	Uint16	TXRDY:1;			// 0	Transmit Packet Ready
	Uint16	FIFONE:1;			// 1	FIFO Not Empty
	Uint16	UNDRN_ERROR1:1;		// 2	Underun/Error
	Uint16	FLUSH:1;			// 3	Flush FIFO
	Uint16	STALL_SETUP:1;		// 4	Send Stall/Setup Packet
	Uint16	STALLED:1;			// 5	Endpoint Stalled
	Uint16	CLRDT:1;			// 6	Clear Data Toggle
	Uint16	NAKTO:1;			// 7	NAK Timeout
};

union USBTXCSRL1_REG
{
    Uint16 	all;
	struct USBTXCSRL1_BITS	bit;
};

struct USBTXCSRH1_BITS
{
	Uint16	DT:1;			// 0	Data Toggle
	Uint16	DTWE:1;			// 1	Data Toggle Write Enable
	Uint16	DMAMOD:1;		// 2	DMA Request Mode
	Uint16	FDT:1;			// 3	Force Data Toggle
	Uint16	DMAEN:1;		// 4	DMA Request Enable
	Uint16	MODE:1;			// 5	Mode
	Uint16	ISO:1;			// 6	Isochronous Transfers
	Uint16	AUTOSET:1;		// 7	Auto Set
};

union USBTXCSRH1_REG
{
	Uint16 	all;
	struct USBTXCSRH1_BITS	bit;
};

struct USBRXMAXP1_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBRXMAXP1_REG
{
	Uint32 all;
	struct USBRXMAXP1_BITS	bit;
};

struct USBRXCSRL1_BITS
{
	Uint16	RXRDY:1;			// 0	Recieve Packet Ready
	Uint16	FULL:1;				// 1	FIFO Full
	Uint16	OVERERROR1:1;		// 2	Overrun/Error
	Uint16	DATAERRNAKTO:1;	    // 3	Data Error/NAK Timeout
	Uint16	FLUSH:1;			// 4	Flush FIFO
	Uint16	STALLREQPKT:1;		// 5	Send Stall/Request Packet
	Uint16	STALLED:1;			// 6	Endpoint Stalled
	Uint16	CLRDT:1;			// 7	Clear Data Toggle
};

union USBRXCSRL1_REG
{
	Uint16 	all;
	struct USBRXCSRL1_BITS	bit;
};

struct USBRXCSRH1_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	DT:1;				// 1	Data Toggle
	Uint16	DTWE:1;				// 2	Data Toggle Write Enable
	Uint16	DMAMOD:1;			// 3	DMA Request Mode
	Uint16	DISNYETPIDERR:1;	// 4	Disable NYET / PID Error
	Uint16	DMAEN:1;			// 5	DMA Request Enable
	Uint16	ISOAUTORQ:1;		// 6	Isochronous Transfers/Auto Request
	Uint16	AUTOCL:1;			// 7	Auto Clear
};

union USBRXCSRH1_REG
{
	Uint16 	all;
	struct USBRXCSRH1_BITS	bit;
};

struct USBRXCOUNT1_BITS
{
	Uint16	COUNT:13;			// 12:0	Receive Packet Count
	Uint16	rsvd1:3;			// 15:13	Reserved
};

union USBRXCOUNT1_REG
{
	Uint32 	all;
	struct USBRXCOUNT1_BITS	bit;
};

struct USBTXTYPE1_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBTXTYPE1_REG
{
    Uint16 	all;
	struct USBTXTYPE1_BITS	bit;
};

struct USBRXTYPE1_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBRXTYPE1_REG
{
	Uint16 	all;
	struct USBRXTYPE1_BITS	bit;
};

struct USBTXMAXP2_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBTXMAXP2_REG
{
	Uint32 all;
	struct USBTXMAXP2_BITS	bit;
};

struct USBTXCSRL2_BITS
{
	Uint16	TXRDY:1;			// 0	Transmit Packet Ready
	Uint16	FIFONE:1;			// 1	FIFO Not Empty
	Uint16	UNDRNERROR2:1;		// 2	Underun/Error
	Uint16	FLUSH:1;			// 3	Flush FIFO
	Uint16	STALLSETUP:1;		// 4	Send Stall/Setup Packet
	Uint16	STALLED:1;			// 5	Endpoint Stalled
	Uint16	CLRDT:1;			// 6	Clear Data Toggle
	Uint16	NAKTO:1;			// 7	NAK Timeout
};

union USBTXCSRL2_REG
{
	Uint16 	all;
	struct USBTXCSRL2_BITS	bit;
};

struct USBTXCSRH2_BITS
{
	Uint16	DT:1;			// 0	Data Toggle
	Uint16	DTWE:1;			// 1	Data Toggle Write Enable
	Uint16	DMAMOD:1;		// 2	DMA Request Mode
	Uint16	FDT:1;			// 3	Force Data Toggle
	Uint16	DMAEN:1;		// 4	DMA Request Enable
	Uint16	MODE:1;			// 5	Mode
	Uint16	ISO:1;			// 6	Isochronous Transfers
	Uint16	AUTOSET:1;		// 7	Auto Set
};

union USBTXCSRH2_REG
{
	Uint16 	all;
	struct USBTXCSRH2_BITS	bit;
};

struct USBRXMAXP2_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBRXMAXP2_REG
{
	Uint32 all;
	struct USBRXMAXP2_BITS	bit;
};

struct USBRXCSRL2_BITS
{
	Uint16	RXRDY:1;			// 0	Recieve Packet Ready
	Uint16	FULL:1;				// 1	FIFO Full
	Uint16	OVERERROR2:1;		// 2	Overrun/Error
	Uint16	DATAERRNAKTO:1;	    // 3	Data Error/NAK Timeout
	Uint16	FLUSH:1;			// 4	Flush FIFO
	Uint16	STALLREQPKT:1;		// 5	Send Stall/Request Packet
	Uint16	STALLED:1;			// 6	Endpoint Stalled
	Uint16	CLRDT:1;			// 7	Clear Data Toggle
};

union USBRXCSRL2_REG
{
	Uint16 all;
	struct USBRXCSRL2_BITS	bit;
};

struct USBRXCSRH2_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	DT:1;				// 1	Data Toggle
	Uint16	DTWE:1;				// 2	Data Toggle Write Enable
	Uint16	DMAMOD:1;			// 3	DMA Request Mode
	Uint16	DISNYETPIDERR:1;	// 4	Disable NYET / PID Error
	Uint16	DMAEN:1;			// 5	DMA Request Enable
	Uint16	ISOAUTORQ:1;		// 6	Isochronous Transfers/Auto Request
	Uint16	AUTOCL:1;			// 7	Auto Clear
};

union USBRXCSRH2_REG
{
	Uint16 all;
	struct USBRXCSRH2_BITS	bit;
};

struct USBRXCOUNT2_BITS
{
	Uint16	COUNT:13;			// 12:0	Receive Packet Count
	Uint16	rsvd1:3;			// 15:13	Reserved
};

union USBRXCOUNT2_REG
{
	Uint32 all;
	struct USBRXCOUNT2_BITS	bit;
};

struct USBTXTYPE2_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBTXTYPE2_REG
{
	Uint16 	all;
	struct USBTXTYPE2_BITS	bit;
};

struct USBRXTYPE2_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBRXTYPE2_REG
{
	Uint16 	all;
	struct USBRXTYPE2_BITS	bit;
};

struct USBTXMAXP3_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBTXMAXP3_REG
{
	Uint32 all;
	struct USBTXMAXP3_BITS	bit;
};

struct USBTXCSRL3_BITS
{
	Uint16	TXRDY:1;			// 0	Transmit Packet Ready
	Uint16	FIFONE:1;			// 1	FIFO Not Empty
	Uint16	UNDRNERROR3:1;		// 2	Underun/Error
	Uint16	FLUSH:1;			// 3	Flush FIFO
	Uint16	STALLSETUP:1;		// 4	Send Stall/Setup Packet
	Uint16	STALLED:1;			// 5	Endpoint Stalled
	Uint16	CLRDT:1;			// 6	Clear Data Toggle
	Uint16	NAKTO:1;			// 7	NAK Timeout
};

union USBTXCSRL3_REG
{
	Uint16 	all;
	struct USBTXCSRL3_BITS	bit;
};

struct USBTXCSRH3_BITS
{
	Uint16	DT:1;			// 0	Data Toggle
	Uint16	DTWE:1;			// 1	Data Toggle Write Enable
	Uint16	DMAMOD:1;		// 2	DMA Request Mode
	Uint16	FDT:1;			// 3	Force Data Toggle
	Uint16	DMAEN:1;		// 4	DMA Request Enable
	Uint16	MODE:1;			// 5	Mode
	Uint16	ISO:1;			// 6	Isochronous Transfers
	Uint16	AUTOSET:1;		// 7	Auto Set
};

union USBTXCSRH3_REG
{
	Uint16 	all;
	struct USBTXCSRH3_BITS	bit;
};

struct USBRXMAXP3_BITS
{
	Uint16	MAXLOAD:11;			// 10:0	Maximum Payload
	Uint16	rsvd1:5;			// 15:11	Reserved
};

union USBRXMAXP3_REG
{
	Uint32 all;
	struct USBRXMAXP3_BITS	bit;
};

struct USBRXCSRL3_BITS
{
	Uint16	RXRDY:1;			// 0	Recieve Packet Ready
	Uint16	FULL:1;				// 1	FIFO Full
	Uint16	OVERERROR3:1;		// 2	Overrun/Error
	Uint16	DATAERRNAKTO:1;	    // 3	Data Error/NAK Timeout
	Uint16	FLUSH:1;			// 4	Flush FIFO
	Uint16	STALLREQPKT:1;		// 5	Send Stall/Request Packet
	Uint16	STALLED:1;			// 6	Endpoint Stalled
	Uint16	CLRDT:1;			// 7	Clear Data Toggle
};

union USBRXCSRL3_REG
{
	Uint16 	all;
	struct USBRXCSRL3_BITS	bit;
};

struct USBRXCSRH3_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	DT:1;				// 1	Data Toggle
	Uint16	DTWE:1;				// 2	Data Toggle Write Enable
	Uint16	DMAMOD:1;			// 3	DMA Request Mode
	Uint16	DISNYETPIDERR:1;	// 4	Disable NYET / PID Error
	Uint16	DMAEN:1;			// 5	DMA Request Enable
	Uint16	ISOAUTORQ:1;		// 6	Isochronous Transfers/Auto Request
	Uint16	AUTOCL:1;			// 7	Auto Clear
};

union USBRXCSRH3_REG
{
	Uint16 	all;
	struct USBRXCSRH3_BITS	bit;
};

struct USBRXCOUNT3_BITS
{
	Uint16	COUNT:13;			// 12:0	Receive Packet Count
	Uint16	rsvd1:3;			// 15:13	Reserved
};

union USBRXCOUNT3_REG
{
	Uint32 all;
	struct USBRXCOUNT3_BITS	bit;
};

struct USBTXTYPE3_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBTXTYPE3_REG
{
	Uint16 	all;
	struct USBTXTYPE3_BITS	bit;
};

struct USBRXTYPE3_BITS
{
	Uint16	TEP:4;				// 3:0	Target Endpoint Number
	Uint16	PROTO:2;			// 5:4	Protocol
	Uint16	SPEED:2;			// 7:6	Operating Speed
};

union USBRXTYPE3_REG
{
	Uint16 	all;
	struct USBRXTYPE3_BITS	bit;
};

struct USBRXDPKTBUFDIS_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	EP1:1;				// 1	EP1 RX Double Packet Buffer Disable
	Uint16	EP2:1;				// 2	EP2 RX Double Packet Buffer Disable
	Uint16	EP3:1;				// 3	EP3 RX Double Packet Buffer Disable
	Uint16	rsvd2:12;			// 15:4	Reserved
};

union USBRXDPKTBUFDIS_REG
{
	Uint32 all;
    struct USBRXDPKTBUFDIS_BITS	bit;
};

struct USBTXDPKTBUFDIS_BITS
{
	Uint16	rsvd1:1;			// 0	Reserved
	Uint16	EP1:1;				// 1	EP1 TX Double Packet Buffer Disable
	Uint16	EP2:1;				// 2	EP2 TX Double Packet Buffer Disable
	Uint16	EP3:1;				// 3	EP3 TX Double Packet Buffer Disable
	Uint16	rsvd2:12;			// 15:4	Reserved
};

union USBTXDPKTBUFDIS_REG
{
	Uint32 all;
	struct USBTXDPKTBUFDIS_BITS	bit;
};

struct USBEPC_BITS
{
	Uint16	EPEN:2;			// 1:0	External Power Supply Enable Configuration
	Uint16	EPENDE:1;		// 2	EPEN Drive Enable
	Uint16	rsvd1:1;		// 3	Reserved
	Uint16	PFLTEN:1;		// 4	Power Fault Input Enable
	Uint16	PFLTSEN:1;		// 5	Power Fault Sense
	Uint16	PFLTAEN:1;		// 6	Power Fault Action Enable
	Uint16	rsvd2:1;		// 7	Reserved
	Uint16	PFLTACT:2;		// 9:8	Power Fault Action
	Uint16	rsvd3:6;		// 15:10	Reserved
	Uint16	rsvd4:16;		// 31:16	Reserved
};

union USBEPC_REG
{
	Uint64 all;
	struct USBEPC_BITS	bit;
};

struct USBEPCRIS_BITS
{
	Uint16	PF:1;			// 0	Power Fault Interrupt Status
	Uint16	rsvd1:15;		// 15:1	Reserved
	Uint16	rsvd2:16;		// 31:16	Reserved
};

union USBEPCRIS_REG
{
	Uint64 all;
	struct USBEPCRIS_BITS	bit;
};

struct USBEPCIM_BITS
{
	Uint16	PF:1;				// 0	Power Fault Interrupt Mask
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBEPCIM_REG
{
	Uint64 all;
	struct USBEPCIM_BITS	bit;
};

struct USBEPCISC_BITS
{
	Uint16	PF:1;				// 0	Power Fault Interrupt Status and Clear
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBEPCISC_REG
{
	Uint64 all;
	struct USBEPCISC_BITS	bit;
};

struct USBDRRIS_BITS
{
	Uint16	RESUME:1;			// 0	Resume Interrupt Status
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBDRRIS_REG
{
	Uint64 all;
	struct USBDRRIS_BITS	bit;
};

struct USBDRIM_BITS
{
	Uint16	RESUME:1;			// 0	Resume Interrupt Mask
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBDRIM_REG
{
	Uint64 all;
	struct USBDRIM_BITS	bit;
};

struct USBDRISC_BITS
{
	Uint16	RESUME:1;			// 0	Resume Interrupt Status and Clear
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBDRISC_REG
{
	Uint64 all;
	struct USBDRISC_BITS	bit;
};

struct USBGPCS_BITS
{
	Uint16	DEVMOD:1;			// 0	Device Mode
	Uint16	DEVMODOTG:1;		// 1	Enable Device Mode
	Uint16	rsvd1:14;			// 15:2	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBGPCS_REG
{
	Uint64 all;
	struct USBGPCS_BITS	bit;
};

struct USBVDC_BITS
{
	Uint16	VBDEN:1;			// 0	Vbus Droop Enable
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBVDC_REG
{
	Uint64 all;
	struct USBVDC_BITS	bit;
};

struct USBVDCRIS_BITS
{
	Uint16	VD:1;				// 0	Vbus Droop Raw Interrupt Status
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBVDCRIS_REG
{
	Uint64 all;
	struct USBVDCRIS_BITS	bit;
};

struct USBVDCIM_BITS
{
	Uint16	VD:1;				// 0	Vbus Droop Interrupt Mask
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBVDCIM_REG
{
	Uint64 all;
	struct USBVDCIM_BITS	bit;
};

struct USBVDCISC_BITS
{
	Uint16	VD:1;				// 0	Vbus Droop Interrupt Status and Clear
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBVDCISC_REG
{
	Uint64 all;
	struct USBVDCISC_BITS	bit;
};

struct USBIDVRIS_BITS
{
	Uint16	ID:1;				// 0	ID Valid Detect Raw Interrupt Status
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBIDVRIS_REG
{
	Uint64 all;
	struct USBIDVRIS_BITS	bit;
};

struct USBIDVIM_BITS
{
	Uint16	ID:1;				// 0	ID Valid Detect Interrupt mask
	Uint16	rsvd1:15;			// 15:1	Reserved
	Uint16	rsvd2:16;			// 31:16	Reserved
};

union USBIDVIM_REG
{
	Uint64 all;
	struct USBIDVIM_BITS	bit;
};

struct USBIDVISC_BITS
{
	Uint16	ID:1;			// 0	ID Valid Detect Interrupt Status and Clear
    Uint16	rsvd1:15;		// 15:1	Reserved
	Uint16	rsvd2:16;		// 31:16	Reserved
};

union USBIDVISC_REG
{
	Uint64 all;
	struct USBIDVISC_BITS	bit;
};

struct USBDMASEL_BITS
{
	Uint16	DMAARX:4;			// 3:0	DMA A RX Select
	Uint16	DMAATX:4;			// 7:4	DMA A TX Select
	Uint16	DMABRX:4;			// 11:8	DMA B RX Select
	Uint16	DMABTX:4;			// 15:12	DMA B TX Select
	Uint16	DMACRX:4;			// 19:16	DMA C RX Select
	Uint16	DMACTX:4;			// 23:20	DMA C TX Select
	Uint16	rsvd1:8;			// 31:24	Reserved
};

union USBDMASEL_REG
{
	Uint64 all;
	struct USBDMASEL_BITS	bit;
};

struct USB_REGS
{
	union	USBFADDR_REG		USBFADDR;	// USB Device Functional Address
	union	USBPOWER_REG		USBPOWER;	// USB Power
	union	USBTXIS_REG			USBTXIS;	// USB Transmit Interrupt Status
	union	USBRXIS_REG			USBRXIS;	// USB Receive Interrupt Status
	union	USBTXIE_REG			USBTXIE;	// USB Transmit Interrupt Enable
	union	USBRXIE_REG			USBRXIE;	// USB Receive Interrupt Enable
	union	USBIS_REG			USBIS;		// USB General Interrupt Status
	union	USBIE_REG			USBIE;		// USB Interrupt Enable
	union	USBFRAME_REG		USBFRAME;	// USB Frame Value
	union	USBEPIDX_REG		USBEPIDX;	// USB Endpoint Index
	union	USBTEST_REG			USBTEST;	// USB Test Mode
	Uint32						rsvd1[8];	// Reserved
	Uint64						USBFIFO0;	// USB FIFO Endpoint 0
	Uint64						USBFIFO1;	// USB FIFO Endpoint 1
	Uint64						USBFIFO2;	// USB FIFO Endpoint 2
	Uint64						USBFIFO3;	// USB FIFO Endpoint 3
	Uint32						rsvd2[24];	// Reserved
	union	USBDEVCTL_REG		USBDEVCTL;	// USB Device Control
	union	USBTXFIFOSZ_REG		USBTXFIFOSZ;// USB Transmit Dynamic FIFO Sizing
	union	USBRXFIFOSZ_REG		USBRXFIFOSZ;// USB Receive Dynamic FIFO Sizing
	
    //
    // USB Transmit FIFO Start Address
    //
    union	USBTXFIFOADD_REG	USBTXFIFOADD;
    
	//
    // USB Receive FIFO Start Address
    //
    union	USBRXFIFOADD_REG	USBRXFIFOADD;
    
	Uint32						rsvd3[9];		// Reserved
	union	USBCONTIM_REG		USBCONTIM;		// USB Connect Timing
	Uint16						USBVPLEN;		// USB OTG VBUS Pulse Timing
	Uint16						rsvd4[1];		// Reserved
	
    //
    // USB Full-Speed Last Transaction to End of Frame Timing
    //
    Uint16						USBFSEOF;		
    
	//
    // USB Low-Speed Last Transaction to End of Frame Timing
    //
    Uint16						USBLSEOF;		
    
	Uint16						rsvd5[1];		// Reserved
	
    //
    // USB Transmit Functional Address Endpoint 0
    //
    union	USBTXFUNCADDR0_REG	USBTXFUNCADDR0;	
    
	Uint16						rsvd6[1];		// Reserved
	
    //
    // USB Transmit Hub Address Endpoint 0
    //
    union	USBTXHUBADDR0_REG	USBTXHUBADDR0;	
    
	//
    // USB Transmit Hub Port Endpoint 0
    //
    union	USBTXHUBPORT0_REG	USBTXHUBPORT0;	
	Uint32						rsvd7[2];		// Reserved
	
    //
    // USB Transmit Functional Address Endpoint 1
    //
    union	USBTXFUNCADDR1_REG	USBTXFUNCADDR1;	
    
	Uint16						rsvd8[1];		// Reserved
	
    //
    // USB Transmit Hub Address Endpoint 1
    //
    union	USBTXHUBADDR1_REG	USBTXHUBADDR1;	
    
	//
    // USB Transmit Hub Port Endpoint 1
    //
    union	USBTXHUBPORT1_REG	USBTXHUBPORT1;
	
    //
    // USB Receive Functional Address Endpoint 1
    //
    union	USBRXFUNCADDR1_REG	USBRXFUNCADDR1;	
    
	Uint16						rsvd9[1];		// Reserved
	
    //
    // USB Receive Hub Address Endpoint 1
    //
    union	USBRXHUBADDR1_REG	USBRXHUBADDR1;
    
	//
    // USB Receive Hub Port Endpoint 1
    //
    union	USBRXHUBPORT1_REG	USBRXHUBPORT1;	
    
    //
    // USB Transmit Functional Address Endpoint 2
    //
	union	USBTXFUNCADDR2_REG	USBTXFUNCADDR2;	
    
    Uint16						rsvd10[1];		// Reserved
	
    //
    // USB Transmit Hub Address Endpoint 2
    //
    union	USBTXHUBADDR2_REG	USBTXHUBADDR2;	
	
    //
    // USB Transmit Hub Port Endpoint 2
    //
    union	USBTXHUBPORT2_REG	USBTXHUBPORT2;
    
    //
    // USB Receive Functional Address Endpoint 2
    //
	union	USBRXFUNCADDR2_REG	USBRXFUNCADDR2;	
    
	Uint16						rsvd11[1];		// Reserved
	
    //
    // USB Receive Hub Address Endpoint 2
    //
    union	USBRXHUBADDR2_REG	USBRXHUBADDR2;
    
    //
    // USB Receive Hub Port Endpoint 2
    //
	union	USBRXHUBPORT2_REG	USBRXHUBPORT2;	
    
    //
    // USB Transmit Functional Address Endpoint 3
    //
	union	USBTXFUNCADDR3_REG	USBTXFUNCADDR3;
    

	Uint16						rsvd12[1];		// Reserved
	
    //
    // USB Transmit Hub Address Endpoint 3
    //
    union	USBTXHUBADDR3_REG	USBTXHUBADDR3;
    
	//
    // USB Transmit Hub Port Endpoint 3
    //
    union	USBTXHUBPORT3_REG	USBTXHUBPORT3;
    
    //
    // USB Receive Functional Address Endpoint 3
    //
	union	USBRXFUNCADDR3_REG	USBRXFUNCADDR3;
	Uint16						rsvd13[1];		// Reserved
	
    //
    // USB Receive Hub Address Endpoint 3
    //
    union	USBRXHUBADDR3_REG	USBRXHUBADDR3;
    
	//
    // USB Receive Hub Port Endpoint 3
    //
    union	USBRXHUBPORT3_REG	USBRXHUBPORT3;
	Uint32						rsvd14[49];		// Reserved
	
    //
    // USB Control and Status Endpoint 0 Low
    //
    union	USBCSRL0_REG		USBCSRL0;		
    
    //
    // USB Control and Status Endpoint 0 High
    //
	union	USBCSRH0_REG		USBCSRH0;		
    
	Uint32						rsvd15[2];		// Reserved
	
    //
    // USB Receive Byte Count Endpoint 0
    //
    union	USBCOUNT0_REG		USBCOUNT0;		
    
	Uint16						rsvd16[1];		// Reserved
	union	USBTYPE0_REG		USBTYPE0;		// USB Type Endpoint 0
	union	USBNAKLMT_REG		USBNAKLMT;		// USB NAK Limit
	Uint32						rsvd17[2];		// Reserved
	
    //
    // USB Maximum Transmit Data Endpoint 1
    //
    union	USBTXMAXP1_REG		USBTXMAXP1;		
    
    //
    // USB Transmit Control and Status Endpoint 1 Low
    //
	union	USBTXCSRL1_REG		USBTXCSRL1;		
    
    //
    // USB Transmit Control and Status Endpoint 1 High
    //
	union	USBTXCSRH1_REG		USBTXCSRH1;
    
    //
    // USB Maximum Receive Data Endpoint 1
    //
	union	USBRXMAXP1_REG		USBRXMAXP1;		
    
    //
    // USB Receive Control and Status Endpoint 1 Low
    //
	union	USBRXCSRL1_REG		USBRXCSRL1;
    
    //
    // USB Receive Control and Status Endpoint 1 High
    //
	union	USBRXCSRH1_REG		USBRXCSRH1;		
	
    //
    // USB Receive Byte Count Endpoint 1
    //
    union	USBRXCOUNT1_REG		USBRXCOUNT1;	
    
    //
    // USB Host Transmit Configure Type Endpoint 1
    //
	union	USBTXTYPE1_REG		USBTXTYPE1;		
    
    //
    // USB Host Transmit Interval Endpoint 1
    //
	Uint16						USBTXINTERVAL1;	
    
    //
    // USB Host Configure Receive Type Endpoint 1
    //
	union	USBRXTYPE1_REG		USBRXTYPE1;		
	
    //
    // USB Host Receive Polling Interval Endpoint 1
    //
    Uint16						USBRXINTERVAL1;	
	
    Uint32						rsvd18;			// Reserved
	
    //
    // USB Maximum Transmit Data Endpoint 2
    //
    union	USBTXMAXP2_REG		USBTXMAXP2;		
	
    //
    // USB Transmit Control and Status Endpoint 2 Low
    //
    union	USBTXCSRL2_REG		USBTXCSRL2;		
    
    //
    // USB Transmit Control and Status Endpoint 2 High
    //
	union	USBTXCSRH2_REG		USBTXCSRH2;		
	
    //
    // USB Maximum Receive Data Endpoint 2
    //
    union	USBRXMAXP2_REG		USBRXMAXP2;		
	
    //
    // USB Receive Control and Status Endpoint 2 Low
    //
    union	USBRXCSRL2_REG		USBRXCSRL2;		
	
    //
    // USB Receive Control and Status Endpoint 2 High
    //
    union	USBRXCSRH2_REG		USBRXCSRH2;		
    
    //
    // USB Receive Byte Count Endpoint 2
    //
	union	USBRXCOUNT2_REG		USBRXCOUNT2;	
	
    //
    // USB Host Transmit Configure Type Endpoint 2
    //
    union	USBTXTYPE2_REG		USBTXTYPE2;		
    
    //
    // USB Host Transmit Interval Endpoint 2
    //
	Uint16						USBTXINTERVAL2;	
    
    //
    // USB Host Configure Receive Type Endpoint 2
    //
	union	USBRXTYPE2_REG		USBRXTYPE2;		
    
    //
    // USB Host Receive Polling Interval Endpoint 2
    //
	Uint16						USBRXINTERVAL2;	
	
    Uint32						rsvd19;			// Reserved
	
    //
    // USB Maximum Transmit Data Endpoint 3
    //
    union	USBTXMAXP3_REG		USBTXMAXP3;		
    
    //
    // USB Transmit Control and Status Endpoint 3 Low
    //
	union	USBTXCSRL3_REG		USBTXCSRL3;		
	
    //
    // USB Transmit Control and Status Endpoint 3 High
    //
    union	USBTXCSRH3_REG		USBTXCSRH3;		
	
    //
    // USB Maximum Receive Data Endpoint 3
    //
    union	USBRXMAXP3_REG		USBRXMAXP3;		
	
    //
    // USB Receive Control and Status Endpoint 3 Low
    //
    union	USBRXCSRL3_REG		USBRXCSRL3;		
	
    //
    // USB Receive Control and Status Endpoint 3 High
    //
    union	USBRXCSRH3_REG		USBRXCSRH3;		
	
    //
    // USB Receive Byte Count Endpoint 3
    //
    union	USBRXCOUNT3_REG		USBRXCOUNT3;	
	
    //
    // USB Host Transmit Configure Type Endpoint 3
    //
    union	USBTXTYPE3_REG		USBTXTYPE3;		
	
    //
    // USB Host Transmit Interval Endpoint 3
    //
    Uint16						USBTXINTERVAL3;	
	
    //
    // USB Host Configure Receive Type Endpoint 3
    //
    union	USBRXTYPE3_REG		USBRXTYPE3;		
	
    //
    // USB Host Receive Polling Interval Endpoint 3
    //
    Uint16						USBRXINTERVAL3;	
	
    Uint32						rsvd20[227];	// Reserved
	
    //
    // USB Request Packet Count in Block Transfer Endpoint 1
    //
    Uint32						USBRQPKTCOUNT1;	
    
	Uint32						rsvd21;			// Reserved
	
    //
    // USB Request Packet Count in Block Transfer Endpoint 2
    //
    Uint32						USBRQPKTCOUNT2;
    
	Uint32						rsvd22;			// Reserved
	
    //
    // USB Request Packet Count in Block Transfer Endpoint 3
    //
    Uint32						USBRQPKTCOUNT3;	
    
    Uint32						rsvd23[25];		// Reserved
	
    //
    // USB Receive Double Packet Buffer Disable
    //
    union	USBRXDPKTBUFDIS_REG	USBRXDPKTBUFDIS;
	
    //
    // USB Transmit Double Packet Buffer Disable
    //
    union	USBTXDPKTBUFDIS_REG	USBTXDPKTBUFDIS;
    
	Uint32						rsvd24[94];		// Reserved
	union	USBEPC_REG			USBEPC;			// USB External Power Control
	
    //
    // USB External Power Control Raw Interrupt Status
    //
    union	USBEPCRIS_REG		USBEPCRIS;		

    //
    // USB External Power Control Interrupt Mask
    //
	union	USBEPCIM_REG		USBEPCIM;		
	
    //
    // USB External Power Control Interrupt Status and Clear
    //
    union	USBEPCISC_REG		USBEPCISC;		
	
    //
    // USB Device RESUME Raw Interrupt Status
    //
    union	USBDRRIS_REG		USBDRRIS;		
    
	//
    // USB Device RESUME Interrupt Mask
    //
    union	USBDRIM_REG			USBDRIM;		
    
    //
    // USB Device RESUME Interrupt Status and Clear
    //
	union	USBDRISC_REG		USBDRISC;		
    
    //
    // USB General-Purpose Control and Status
    //
	union	USBGPCS_REG			USBGPCS;		
    
	Uint32						rsvd25[8];		// Reserved
	union	USBVDC_REG			USBVDC;			// USB VBUS Droop Control
	
    //
    // USB VBUS Droop Control Raw Interrupt Status
    //
    union	USBVDCRIS_REG		USBVDCRIS;		
	
    //
    // USB VBUS Droop Control Interrupt Mask
    //
    union	USBVDCIM_REG		USBVDCIM;		
	
    //
    // USB VBUS Droop Control Interrupt Status and Clear
    //
    union	USBVDCISC_REG		USBVDCISC;		
    
	Uint32						rsvd26[2];		// Reserved
	
    //
    // USB ID Valid Detect Raw Interrupt Status
    //
    union	USBIDVRIS_REG		USBIDVRIS;		
	
    //
    // USB ID Valid Detect Interrupt Mask
    //
    union	USBIDVIM_REG		USBIDVIM;		
	
    //
    // USB ID Valid Detect Interrupt Status and Clear
    //
    union	USBIDVISC_REG		USBIDVISC;		
    
	union	USBDMASEL_REG		USBDMASEL;		// USB DMA Select
};

//
// Usb External References & Function Declarations:
//
extern volatile struct	USB_REGS	Usb0Regs;




//
// End of file
//

//###########################################################################
//
// FILE:  F2806x_XIntrupt.h
//
// TITLE: F2806x Device External Interrupt Register Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



struct XINTCR_BITS
{
    Uint16   ENABLE:1;    // 0      enable/disable
    Uint16   rsvd1:1;     // 1      reserved
    Uint16   POLARITY:2;  // 3:2    pos/neg, both triggered
    Uint16   rsvd2:12;    //15:4    reserved
};

union XINTCR_REG
{
    Uint16               all;
    struct XINTCR_BITS   bit;
};

//
// External Interrupt Register File:
//
struct XINTRUPT_REGS
{
    union XINTCR_REG XINT1CR;
    union XINTCR_REG XINT2CR;
    union XINTCR_REG XINT3CR;
    Uint16           rsvd1[5];
    Uint16           XINT1CTR;
    Uint16           XINT2CTR;
    Uint16           XINT3CTR;
    Uint16           rsvd2[5];
};

//
// External Interrupt References & Function Declarations:
//
extern volatile struct XINTRUPT_REGS XIntruptRegs;



//
// End of file
//











//
// Timer definitions based on System Clock
// 90 MHz devices
//



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Examples.h
//
// TITLE:  F2806x Device Definitions.
//
//###########################################################################
// $TI Release:  $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// Specify the PLL control register (PLLCR) and divide select (DIVSEL) value.
//

//#define DSP28_DIVSEL   0 // Enable /4 for SYSCLKOUT
//#define DSP28_DIVSEL   1 // Disable /4 for SYSCKOUT
//#define DSP28_DIVSEL   3 // Enable /1 for SYSCLKOUT

//
// Uncomment for 90 MHz devices [90 MHz = (10MHz * 18)/2]
//
//#define DSP28_PLLCR   17
//#define DSP28_PLLCR   16
//#define DSP28_PLLCR   15
//#define DSP28_PLLCR   14
//#define DSP28_PLLCR   13
//#define DSP28_PLLCR   12
//#define DSP28_PLLCR   11
//#define DSP28_PLLCR   10
//#define DSP28_PLLCR    9
//#define DSP28_PLLCR    8
//#define DSP28_PLLCR    7
//#define DSP28_PLLCR    6
//#define DSP28_PLLCR    5
//#define DSP28_PLLCR    4
//#define DSP28_PLLCR    3
//#define DSP28_PLLCR    2
//#define DSP28_PLLCR    1
//#define DSP28_PLLCR    0  // PLL is bypassed in this mode

//
//    Specify the clock rate of the CPU (SYSCLKOUT) in nS.
//
//    Take into account the input clock frequency and the PLL multiplier
//    selected in step 1.
//
//    Use one of the values provided, or define your own.
//    The trailing L is required tells the compiler to treat
//    the number as a 64-bit value.
//
//    Only one statement should be uncommented.
//
//    Example:   90MHz devices:
//             CLKIN is a 10 MHz crystal or internal 10 MHz oscillator
//
//             In step 1 the user specified PLLCR = 0x18 for a
//             90 MHz CPU clock (SYSCLKOUT = 90 MHz).
//
//             In this case, the CPU_RATE will be 11.111L
//             Uncomment the line: #define CPU_RATE 11.111L
//

//#define CPU_RATE   12.500L   // for a 80MHz CPU clock speed (SYSCLKOUT)
//#define CPU_RATE   16.667L   // for a 60MHz CPU clock speed (SYSCLKOUT)
//#define CPU_RATE   20.000L   // for a 50MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE   25.000L   // for a 40MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE   33.333L   // for a 30MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE   41.667L   // for a 24MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE   50.000L   // for a 20MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE   66.667L   // for a 15MHz CPU clock speed  (SYSCLKOUT)
//#define CPU_RATE  100.000L   // for a 10MHz CPU clock speed  (SYSCLKOUT)

//
// PLL2 Defines:	PLL2 output is the USB0 and HRCAP1-4 clock
//

//
// Specify input clock source to PLL2
//
//#define PLL2_PLLSRC		0x0		// PLL2 Input Osc1
//#define PLL2_PLLSRC		0x1 	// PLL2 Input Osc1
//#define PLL2_PLLSRC		0x3		// PLL2 Input XCLKIN

//
// Specify the PLL2 control register divide select (SYSCLK2DIV2DIS) 
// and (PLL2MULT) values.
//
//#define PLL2_SYSCLK2DIV2DIS  	1 	// PLL2 Output /1

//#define PLL2_PLLMULT   	15
//#define PLL2_PLLMULT   	14
//#define PLL2_PLLMULT   	13
//#define PLL2_PLLMULT   	12
//#define PLL2_PLLMULT   	11
//#define PLL2_PLLMULT   	10
//#define PLL2_PLLMULT    	9
//#define PLL2_PLLMULT    	8
//#define PLL2_PLLMULT    	7
//#define PLL2_PLLMULT    	5
//#define PLL2_PLLMULT    	4
//#define PLL2_PLLMULT    	3
//#define PLL2_PLLMULT    	2
//#define PLL2_PLLMULT    	1
//#define PLL2_PLLMULT    	0	// PLL is bypassed in this mode

//
// The following pointer to a function call calibrates the ADC and 
// internal oscillators
//

//
// Included Files
//

//
// Contains Prototypes for global functions within the .c files.
//
//###########################################################################
//
// FILE:   F2806x_GlobalPrototypes.h
//
// TITLE:  Global prototypes for F2806x Examples
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################


//
// Global Function Prototypes
//
extern void InitAdc(void);
extern void InitAdcAio(void);
extern void AdcOffsetSelfCal(void);
extern void AdcChanSelect(Uint16 ch_no);
extern Uint16 AdcConversion (void);
extern void InitPeripherals(void);
extern void DMAInitialize(void);

//
// DMA Channel 1
//
extern void DMACH1AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH1BurstConfig(Uint16 bsize, int16 srcbstep, int16 desbstep);
extern void DMACH1TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH1WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize, 
                             int16 deswstep);
extern void DMACH1ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot, 
                             Uint16 cont, Uint16 synce, Uint16 syncsel, 
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH1(void);

//
// DMA Channel 2
//
extern void DMACH2AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH2BurstConfig(Uint16 bsize, int16 srcbstep, int16 desbstep);
extern void DMACH2TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH2WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize, 
                             int16 deswstep);
extern void DMACH2ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot, 
                             Uint16 cont, Uint16 synce, Uint16 syncsel, 
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH2(void);

//
// DMA Channel 3
//
extern void DMACH3AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH3BurstConfig(Uint16 bsize, int16 srcbstep, int16 desbstep);
extern void DMACH3TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH3WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize,
                             int16 deswstep);
extern void DMACH3ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot, 
                             Uint16 cont, Uint16 synce, Uint16 syncsel,
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH3(void);

//
// DMA Channel 4
//
extern void DMACH4AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH4BurstConfig(Uint16 bsize, int16 srcbstep, int16 desbstep);
extern void DMACH4TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH4WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize,
                             int16 deswstep);
extern void DMACH4ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot,
                             Uint16 cont, Uint16 synce, Uint16 syncsel,
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH4(void);

//
// DMA Channel 5
//
extern void DMACH5AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH5BurstConfig(Uint16 bsize, int16 srcbstep, int16 desbstep);
extern void DMACH5TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH5WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize,
                             int16 deswstep);
extern void DMACH5ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot,
                             Uint16 cont, Uint16 synce, Uint16 syncsel, 
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH5(void);

//
// DMA Channel 6
//
extern void DMACH6AddrConfig(volatile Uint16 *DMA_Dest,
                             volatile Uint16 *DMA_Source);
extern void DMACH6BurstConfig(Uint16 bsize,Uint16 srcbstep, int16 desbstep);
extern void DMACH6TransferConfig(Uint16 tsize, int16 srctstep, int16 deststep);
extern void DMACH6WrapConfig(Uint16 srcwsize, int16 srcwstep, Uint16 deswsize,
                             int16 deswstep);
extern void DMACH6ModeConfig(Uint16 persel, Uint16 perinte, Uint16 oneshot,
                             Uint16 cont, Uint16 synce, Uint16 syncsel,
                             Uint16 ovrinte, Uint16 datasize, Uint16 chintmode,
                             Uint16 chinte);
extern void StartDMACH6(void);

extern void InitECap(void);
extern void InitECapGpio(void);

extern void InitECap1Gpio(void);
extern void InitECap2Gpio(void);
extern void InitECap3Gpio(void);

extern void InitComp(void);
extern void InitCompGpio(void);
extern void InitComp1Gpio(void);
extern void InitComp2Gpio(void);
extern void InitComp3Gpio(void);

extern void InitECan(void);
extern void InitECana(void);
extern void InitECanGpio(void);
extern void InitECanaGpio(void);

extern void InitEPwm(void);
extern void InitEPwmGpio(void);
extern void InitEPwm1Gpio(void);
extern void InitEPwm2Gpio(void);
extern void InitEPwm3Gpio(void);
extern void InitEPwm4Gpio(void);
extern void InitEPwm5Gpio(void);
extern void InitEPwm6Gpio(void);
extern void InitEPwm7Gpio(void);
extern void InitEPwm8Gpio(void);

extern void InitEQep(void);
extern void InitEQepGpio(void);
extern void InitEQep1Gpio(void);
extern void InitEQep2Gpio(void);

extern void InitGpio(void);

extern void InitHRCap(void);
extern void InitHRCapGpio(void);
extern void InitHRCap1Gpio(void);
extern void InitHRCap2Gpio(void);
extern void InitHRCap3Gpio(void);
extern void InitHRCap4Gpio(void);

extern void InitI2C(void);
extern void InitI2CGpio(void);

extern void InitMcbsp(void);
extern void InitMcbspa(void);
extern void delay_loop(void);
extern void clkg_delay_loop(void);
extern void InitMcbspGpio(void);
extern void InitMcbspaGpio(void);
extern void InitMcbspa8bit(void);
extern void InitMcbspa12bit(void);
extern void InitMcbspa16bit(void);
extern void InitMcbspa20bit(void);
extern void InitMcbspa24bit(void);
extern void InitMcbspa32bit(void);

extern void InitPieCtrl(void);
extern void InitPieVectTable(void);

extern void InitSci(void);
extern void InitSciGpio(void);
extern void InitSciaGpio(void);
extern void InitScibGpio(void);

extern void InitSpi(void);
extern void InitSpiGpio(void);
extern void InitSpiaGpio(void);
extern void InitSpibGpio(void);

extern void InitSysCtrl(void);
extern void InitTzGpio(void);
extern void InitXIntrupt(void);
extern void InitPll(Uint16 pllcr, Uint16 clkindiv);
extern void InitPll2(Uint16 clksrc, Uint16 pllmult, Uint16 clkdiv);
extern void InitPeripheralClocks(void);
extern void EnableInterrupts(void);
extern void DSP28x_usDelay(Uint32 Count);

extern void ServiceDog(void);
extern void DisableDog(void);

extern Uint16 CsmUnlock(void);
extern void IntOsc1Sel (void);
extern void IntOsc2Sel (void);
extern void XtalOscSel (void);
extern void ExtOscSel (void);

extern int16 GetTemperatureC(int16 sensorSample); // returns temp in deg. C
extern int16 GetTemperatureK(int16 sensorSample); // returns temp in deg. K
extern void Osc1Comp(int16 sensorSample);
extern void Osc2Comp(int16 sensorSample);

//
// DSP28_DBGIER.asm
//
extern void SetDBGIER(Uint16 dbgier);

//
// CAUTION - This function MUST be executed out of RAM. Executing it
// out of OTP/Flash will yield unpredictable results
//
extern void InitFlash(void);

//
// External symbols created by the linker cmd file
// DSP28 examples will use these to relocate code from one LOAD location
// in Flash to a different RUN location in internal RAM
//
extern Uint16 RamfuncsLoadStart;
extern Uint16 RamfuncsLoadEnd;
extern Uint16 RamfuncsRunStart;
extern Uint16 RamfuncsLoadSize;



//
// End of file
//


//###########################################################################
//
// FILE:   F2806x_EPwm_defines.h
//
// TITLE:  #defines used in EPwm examples
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// Defines
//

//
// Defines for TBCTL (Time-Base Control)
//

//
// CTRMODE bits
//

//
// PHSEN bit
//

//
// PRDLD bit
//

//
// SYNCOSEL bits
//

//
// HSPCLKDIV and CLKDIV bits
//

//
// PHSDIR bit
//

//
// Defines for CMPCTL (Compare Control)
//

//
// LOADAMODE and LOADBMODE bits

//
// SHDWAMODE and SHDWBMODE bits
//

//
// Defines for AQCTLA and AQCTLB (Action Qualifier Control)
//

//
// ZRO, PRD, CAU, CAD, CBU, CBD bits
//

//
// Defines for DBCTL (Dead-Band Control)
//

//
// OUT MODE bits
//

//
// POLSEL bits
//

//
// IN MODE
//

//
// Defines for CHPCTL (chopper control)
//

//
// CHPEN bit
//

//
// CHPFREQ bits
//

//
// CHPDUTY bits
//

//
// Defines for TZSEL (Trip Zone Select)
//

//
// CBCn and OSHTn bits
//

//
// Defines for TZCTL (Trip Zone Control)
//

//
// TZA and TZB bits
//

//
// Defines for TZDCSEL (Trip Zone Digital Compare)
//

//
// DCAEVT1, DCAEVT2, DCBEVT1, DCBEVT2 bits
//


//
// Defines for ETSEL (Event Trigger Select)
//

//
// Defines for ETPS (Event Trigger Pre-scale)
//

//
// INTPRD, SOCAPRD, SOCBPRD bits
//

//
// Defines for HRPWM (High Resolution PWM)
//

//
// HRCNFG
//




//
// Defines for DC (Digital Compare)
//

//
// DCTRIPSEL
//

//
// DCFCTL
//




//
// DCACTL/DCBCTL
//



//
// End of file
//

//###########################################################################
//
// FILE:    F2806x_I2cExample.h
//
// TITLE:   F2806x I2C Example Code Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################


//
// Defines
//

//
// Error Messages
//

//
// Clear Status Flags
//

//
// Interrupt Source Messages
//

//
// I2CMSG structure defines
//

//
// I2C Slave State defines
//

//
// I2C Slave Receiver messages defines
//

//
// I2C State defines
//

//
// I2C  Message Commands for I2CMSG struct
//

//
// Generic defines
//

//
// Structures
//

//
// I2C Message Structure
//
struct I2CMSG {
    //
    // Word stating what state msg is in:
    //   I2C_MSGCMD_INACTIVE = do not send msg
    //   I2C_MSGCMD_BUSY = msg start has been sent,
    //                     awaiting stop
    //   I2C_MSGCMD_SEND_WITHSTOP = command to send
    //       master trans msg complete with a stop bit
    //   I2C_MSGCMD_SEND_NOSTOP = command to send
    //       master trans msg without the stop bit
    //   I2C_MSGCMD_RESTART = command to send a restart
    //       as a master receiver with a stop bit
    //
    Uint16 MsgStatus;
    
    //
    // I2C address of slave msg is intended for
    //
    Uint16 SlaveAddress;
    
    //
    // Num of valid bytes in (or to be put in MsgBuffer)
    //
    Uint16 NumOfBytes;
    
    //
    // EEPROM address of data associated with msg (high byte)
    //
    Uint16 MemoryHighAddr;
    
    //
    // EEPROM address of data associated with msg (low byte)
    //
    Uint16 MemoryLowAddr;
    
    //
    // Array holding msg data - max that MAX_BUFFER_SIZE can be is 4 due to
    // the FIFO's
    //
    Uint16 MsgBuffer[4];
};



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Dma_defines.h
//
// TITLE:  #defines used in DMA examples
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################




//
// Defines
//
// MODE
//
// PERINTSEL bits

//
// OVERINTE bit
//

//
// PERINTE bit
//

//
// CHINTMODE bits
//

//
// ONESHOT bits
//

//
// CONTINOUS bit
//

//
// SYNCE bit
//

//
// SYNCSEL bit
//

//
// DATASIZE bit
//

//
// CHINTE bit
//



//
// End of file
//

//###########################################################################
//
// FILE:   F2806x_Cla_defines.h
//
// TITLE:  #defines used in CLA examples
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// Defines
//

//
// MCTL Register
//

//
// MMEMCFG Register
//

//
// MIER Interrupt Enable Register
//

//
// PERINT11SEL Interrupt Source Select Register
//








//
// Useful CLA Operation Macros:
//












//
// End of file
//


//
// Defines
//









//
// Include files not used with DSP/BIOS
//
//###########################################################################
//
// FILE:    F2806x_DefaultIsr.h
//
// TITLE:   F2806x Devices Default Interrupt Service Routines Definitions.
//
//###########################################################################
// $TI Release: $
// $Release Date: $
// $Copyright:
// Copyright (C) 2009-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################



//
// Default Interrupt Service Routine Declarations:
//
// The following function prototypes are for the
// default ISR routines used with the default PIE vector table.
// This default vector table is found in the F2806x_PieVect.h
// file.
//

//
// Non-Peripheral Interrupts
//
__interrupt void INT13_ISR(void);     // CPU-Timer 1
__interrupt void INT14_ISR(void);     // CPU-Timer 2
__interrupt void DATALOG_ISR(void);   // Datalogging interrupt
__interrupt void RTOSINT_ISR(void);   // RTOS interrupt
__interrupt void EMUINT_ISR(void);    // Emulation interrupt
__interrupt void NMI_ISR(void);       // Non-maskable interrupt
__interrupt void ILLEGAL_ISR(void);   // Illegal operation TRAP
__interrupt void USER1_ISR(void);     // User Defined trap 1
__interrupt void USER2_ISR(void);     // User Defined trap 2
__interrupt void USER3_ISR(void);     // User Defined trap 3
__interrupt void USER4_ISR(void);     // User Defined trap 4
__interrupt void USER5_ISR(void);     // User Defined trap 5
__interrupt void USER6_ISR(void);     // User Defined trap 6
__interrupt void USER7_ISR(void);     // User Defined trap 7
__interrupt void USER8_ISR(void);     // User Defined trap 8
__interrupt void USER9_ISR(void);     // User Defined trap 9
__interrupt void USER10_ISR(void);    // User Defined trap 10
__interrupt void USER11_ISR(void);    // User Defined trap 11
__interrupt void USER12_ISR(void);    // User Defined trap 12

//
// Group 1 PIE Interrupt Service Routines
//
__interrupt void ADCINT1_ISR(void);   // ADC INT1 ISR - 1.1 OR 10.1
__interrupt void ADCINT2_ISR(void);   // ADC INT2 ISR - 1.2 OR 10.2
__interrupt void XINT1_ISR(void);     // External interrupt 1
__interrupt void XINT2_ISR(void);     // External interrupt 2
__interrupt void ADCINT9_ISR(void);   // ADC INT9
__interrupt void TINT0_ISR(void);     // Timer 0
__interrupt void WAKEINT_ISR(void);   // WD

//
// Group 2 PIE Interrupt Service Routines
//
__interrupt void EPWM1_TZINT_ISR(void);    // EPWM Trip Zone-1
__interrupt void EPWM2_TZINT_ISR(void);    // EPWM Trip Zone-2
__interrupt void EPWM3_TZINT_ISR(void);    // EPWM Trip Zone-3
__interrupt void EPWM4_TZINT_ISR(void);    // EPWM Trip Zone-4
__interrupt void EPWM5_TZINT_ISR(void);    // EPWM Trip Zone-5
__interrupt void EPWM6_TZINT_ISR(void);    // EPWM Trip Zone-6
__interrupt void EPWM7_TZINT_ISR(void);    // EPWM Trip Zone-7
__interrupt void EPWM8_TZINT_ISR(void);	   // EPWM Trip Zone-8

//
// Group 3 PIE Interrupt Service Routines
//
__interrupt void EPWM1_INT_ISR(void);      // EPWM-1
__interrupt void EPWM2_INT_ISR(void);      // EPWM-2
__interrupt void EPWM3_INT_ISR(void);      // EPWM-3
__interrupt void EPWM4_INT_ISR(void);      // EPWM-4
__interrupt void EPWM5_INT_ISR(void);      // EPWM-5
__interrupt void EPWM6_INT_ISR(void);      // EPWM-6
__interrupt void EPWM7_INT_ISR(void);      // EPWM-7
__interrupt void EPWM8_INT_ISR(void);	   // EPWM-8

//
// Group 4 PIE Interrupt Service Routines
//
__interrupt void ECAP1_INT_ISR(void);      // ECAP-1
__interrupt void ECAP2_INT_ISR(void);      // ECAP-2
__interrupt void ECAP3_INT_ISR(void);      // ECAP-3
__interrupt void HRCAP1_INT_ISR(void);	   // HRCAP-1
__interrupt void HRCAP2_INT_ISR(void);	   // HRCAP-2

//
// Group 5 PIE Interrupt Service Routines
//
__interrupt void EQEP1_INT_ISR(void);      // EQEP-1
__interrupt void EQEP2_INT_ISR(void);      // EQEP-2
__interrupt void HRCAP3_INT_ISR(void);	   // HRCAP-3
__interrupt void HRCAP4_INT_ISR(void);	   // HRCAP-4
__interrupt void USB0_INT_ISR(void);	   // USB-0

//
// Group 6 PIE Interrupt Service Routines
//
__interrupt void SPIRXINTA_ISR(void);      // SPI-A
__interrupt void SPITXINTA_ISR(void);      // SPI-A
__interrupt void SPIRXINTB_ISR(void);	   // SPI-B
__interrupt void SPITXINTB_ISR(void);	   // SPI-B
__interrupt void MRINTA_ISR(void);         // McBSP-A
__interrupt void MXINTA_ISR(void);         // McBSP-A

//
// Group 7 PIE Interrupt Service Routines
//
__interrupt void DINTCH1_ISR(void);		 // DMA Channel 1
__interrupt void DINTCH2_ISR(void);		 // DMA Channel 2
__interrupt void DINTCH3_ISR(void);		 // DMA Channel 3
__interrupt void DINTCH4_ISR(void);		 // DMA Channel 4
__interrupt void DINTCH5_ISR(void);		 // DMA Channel 5
__interrupt void DINTCH6_ISR(void);		 // DMA Channel 6

//
// Group 8 PIE Interrupt Service Routines
//
__interrupt void I2CINT1A_ISR(void);       // I2C-A
__interrupt void I2CINT2A_ISR(void);       // I2C-A

//
// Group 9 PIE Interrupt Service Routines
//
__interrupt void SCIRXINTA_ISR(void);      // SCI-A
__interrupt void SCITXINTA_ISR(void);      // SCI-A
__interrupt void SCIRXINTB_ISR(void);      // SCI-B
__interrupt void SCITXINTB_ISR(void);      // SCI-B
__interrupt void ECAN0INTA_ISR(void);	   // ECAN-A
__interrupt void ECAN1INTA_ISR(void);	   // ECAN-A

//
// Group 10 PIE Interrupt Service Routines
//
// ADC INT1 ISR - 1.1 or 10.1
// ADC INT2 ISR - 1.2 or 10.2
__interrupt void ADCINT3_ISR(void);        // ADC INT3 ISR
__interrupt void ADCINT4_ISR(void);        // ADC INT4 ISR
__interrupt void ADCINT5_ISR(void);        // ADC INT5 ISR
__interrupt void ADCINT6_ISR(void);        // ADC INT6 ISR
__interrupt void ADCINT7_ISR(void);        // ADC INT7 ISR
__interrupt void ADCINT8_ISR(void);        // ADC INT8 ISR

//
// Group 11 PIE Interrupt Service Routines
//
__interrupt void CLA1_INT1_ISR(void);      // CLA1 INT1 ISR
__interrupt void CLA1_INT2_ISR(void);      // CLA1 INT2 ISR
__interrupt void CLA1_INT3_ISR(void);      // CLA1 INT3 ISR
__interrupt void CLA1_INT4_ISR(void);      // CLA1 INT4 ISR
__interrupt void CLA1_INT5_ISR(void);      // CLA1 INT5 ISR
__interrupt void CLA1_INT6_ISR(void);      // CLA1 INT6 ISR
__interrupt void CLA1_INT7_ISR(void);      // CLA1 INT7 ISR
__interrupt void CLA1_INT8_ISR(void);      // CLA1 INT8 ISR

//
// Group 12 PIE Interrupt Service Routines
//
__interrupt void XINT3_ISR(void);          // External interrupt 3
__interrupt void LVF_ISR(void);            // Latched overflow flag
__interrupt void LUF_ISR(void);            // Latched underflow flag

//
// Catch-all for Reserved Locations For testing purposes
//
__interrupt void PIE_RESERVED(void);       // Reserved for test
__interrupt void rsvd_ISR(void);           // for test
__interrupt void INT_NOTUSED_ISR(void);    // for unused interrupts



//
// End of file
//


//
// DO NOT MODIFY THIS LINE.
//



//
// End of file
//




//
// Function Prototypes statements for functions found within this file.
//
//
// Main
//

volatile const long bigArray[10000] = {0};

void wait_poll(){
    Uint32 attemps = 500000; //60s
    do{
        attemps--;
        attemps++;
        attemps--;
    }while(attemps != 0);

}

void main(void)
{
    //
    // Step 1. Initialize System Control:
    // PLL, WatchDog, enable Peripheral Clocks
    // This example function is found in the F2806x_SysCtrl.c file.
    //
    InitSysCtrl();

    //
    // Step 2. Initalize GPIO:
    // This example function is found in the F2806x_Gpio.c file and
    // illustrates how to set the GPIO to it's default state.
    //
    // InitGpio();  // Skipped for this example

    //
    // Step 3. Clear all interrupts and initialize PIE vector table:
    // Disable CPU interrupts
    //
    __asm(" setc INTM");

    //
    // Initialize the PIE control registers to their default state.
    // The default state is all PIE interrupts disabled and flags
    // are cleared.
    // This function is found in the F2806x_PieCtrl.c file.
    //
    InitPieCtrl();

    //
    // Disable CPU interrupts and clear all CPU interrupt flags
    //
    IER = 0x0000;
    IFR = 0x0000;

    //
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    // This will populate the entire table, even if the interrupt
    // is not used in this example.  This is useful for debug purposes.
    // The shell ISR routines are found in F2806x_DefaultIsr.c.
    // This function is found in F2806x_PieVect.c.
    //
    InitPieVectTable();

    //
    // Interrupts that are used in this example are re-mapped to
    // ISR functions found within this file.
    //
   // This is needed to disable write to EALLOW protected registers

    //
    // Step 4. Initialize the Device Peripheral. This function can be
    //         found in F2806x_CpuTimers.c
    //

    //
    // Configure CPU-Timer 0 to interrupt every 500 milliseconds:
    // 80MHz CPU Freq, 50 millisecond Period (in uSeconds)
    //

    //
    // To ensure precise timing, use write-only instructions to write to the
    // entire register. Therefore, if any of the configuration bits are changed
    // in ConfigCpuTimer and InitCpuTimers (in F2806x_CpuTimers.h), the
    // below settings must also be updated.
    //
    
    //
    // Use write-only instruction to set TSS bit = 0
    //
    CpuTimer0Regs.TCR.all = 0x4001;

    //
    // Step 5. User specific code, enable interrupts:
    //

    //
    // Configure GPIO34 as a GPIO output pin
    //
    __asm(" EALLOW");
    GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;
    GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;
    __asm(" EDIS");

    //
    // Enable CPU INT1 which is connected to CPU-Timer 0
    //
    IER |= 0x0001;

    //
    // Enable TINT0 in the PIE: Group 1 interrupt 7
    //
    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;

    //
    // Enable global Interrupts and higher priority real-time debug events
    //
    __asm(" clrc INTM");   // Enable Global interrupt INTM
    __asm(" clrc DBGM");   // Enable Global realtime interrupt DBGM

    //
    // Step 6. IDLE loop. Just sit and loop forever (optional)
    //
    for(;;){
        GpioDataRegs.GPBTOGGLE.bit.GPIO34 = 1;
        wait_poll();
    }
}


//
// End of File
//

