#include "DSP28x_Project.h"


Uint16 sdata[2], rdata[2];
Uint16 rdata_point;


void error(void)
{
	__asm("     ESTOP0");			/* Test failed!! Stop!			*/
	for (;;);
}

#if 0
void InitSpiaGpio()
{
	EALLOW;

	/**
	 * Enable internal pull-up for the selected pins
	 * Pull-ups can be enabled or disabled by the user.
	 * This will enable the pullups for the specified pins.
	 */
	GpioCtrlRegs.GPAPUD.bit.GPIO16 = 0;	/* Enable pull-up on GPIO16 (SPISIMOA)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO17 = 0;	/* Enable pull-up on GPIO17 (SPISOMIA)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO18 = 0;	/* Enable pull-up on GPIO18 (SPICLKA)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO19 = 0;	/* Enable pull-up on GPIO19 (SPISTEA)	*/

	/**
	 * Set qualification for selected pins to asynch only
	 * This will select asynch (no qualification) for the selected pins.
	 */
	GpioCtrlRegs.GPAQSEL2.bit.GPIO16 = 3;	/* Asynch input GPIO16 (SPISIMOA)	*/
	GpioCtrlRegs.GPAQSEL2.bit.GPIO17 = 3;	/* Asynch input GPIO17 (SPISOMIA)	*/
	GpioCtrlRegs.GPAQSEL2.bit.GPIO18 = 3;	/* Asynch input GPIO18 (SPICLKA)	*/
	GpioCtrlRegs.GPAQSEL2.bit.GPIO19 = 3;	/* Asynch input GPIO19 (SPISTEA)	*/

	/**
	 * Configure SPI-A pins using GPIO regs
	 * This specifies which of the possible GPIO pins will be SPI functional
	 * pins.
	 */
	GpioCtrlRegs.GPAMUX2.bit.GPIO16 = 1;	/* Configure GPIO16 as SPISIMOA		*/
	GpioCtrlRegs.GPAMUX2.bit.GPIO17 = 1;	/* Configure GPIO17 as SPISOMIA		*/
	GpioCtrlRegs.GPAMUX2.bit.GPIO18 = 1;	/* Configure GPIO18 as SPICLKA		*/
	GpioCtrlRegs.GPAMUX2.bit.GPIO19 = 1;	/* Configure GPIO19 as SPISTEA		*/

	EDIS;
}

void InitSpibGpio()
{
	EALLOW;

	/**
	 * Enable internal pull-up for the selected pins
	 * Pull-ups can be enabled or disabled by the user.
	 * This will enable the pullups for the specified pins.
	 */
	GpioCtrlRegs.GPAPUD.bit.GPIO12 = 0;	/* Enable pull-up on GPIO12 (SPISIMOB)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO13 = 0;   	/* Enable pull-up on GPIO13 (SPISOMIB)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO14 = 0;   	/* Enable pull-up on GPIO14 (SPICLKB)	*/
	GpioCtrlRegs.GPAPUD.bit.GPIO15 = 0;   	/* Enable pull-up on GPIO15 (SPISTEB)	*/

	/**
	 * Set qualification for selected pins to asynch only
	 * This will select asynch (no qualification) for the selected pins.
	 */
	GpioCtrlRegs.GPAQSEL1.bit.GPIO12 = 3; 	/* Asynch input GPIO12 (SPISIMOB)	*/
	GpioCtrlRegs.GPAQSEL1.bit.GPIO13 = 3; 	/* Asynch input GPIO13 (SPISOMIB)	*/
	GpioCtrlRegs.GPAQSEL1.bit.GPIO14 = 3; 	/* Asynch input GPIO14 (SPICLKB)	*/
	GpioCtrlRegs.GPAQSEL1.bit.GPIO15 = 3; 	/* Asynch input GPIO15 (SPISTEB)	*/

	/**
	 * Configure SPI-B pins using GPIO regs
	 * This specifies which of the possible GPIO pins will be SPI functional
	 * pins.
	 */
	GpioCtrlRegs.GPAMUX1.bit.GPIO12 = 3; 	/* Configure GPIO12 as SPISIMOB		*/
	GpioCtrlRegs.GPAMUX1.bit.GPIO13 = 3; 	/* Configure GPIO13 as SPISOMIB		*/
	GpioCtrlRegs.GPAMUX1.bit.GPIO14 = 3; 	/* Configure GPIO14 as SPICLKB		*/
	GpioCtrlRegs.GPAMUX1.bit.GPIO15 = 3; 	/* Configure GPIO15 as SPISTEB		*/

	EDIS;
}
#endif

void spi_fifo_init()
{
	SpiaRegs.SPICCR.bit.SPISWRESET = 0; 	/* Reset SPI				*/

	SpiaRegs.SPICCR.all = 0x001F;      	/* 16-bit character, Loopback mode	*/
	SpiaRegs.SPICTL.all = 0x0017; 		/* Int enabled, Master/Slave TX enable	*/
	SpiaRegs.SPISTS.all = 0x0000;
	SpiaRegs.SPIBRR = 0x0063;           	/* Baud rate				*/
	SpiaRegs.SPIFFTX.all = 0xC022;      	/* Enable FIFO's, TX FIFO level = 4	*/
	SpiaRegs.SPIFFRX.all = 0x0022;      	/* RX FIFO level = 4			*/
	SpiaRegs.SPIFFCT.all = 0x00;
	SpiaRegs.SPIPRI.all = 0x0010;

	SpiaRegs.SPICCR.bit.SPISWRESET = 1;  	/* Enable SPI				*/

	SpiaRegs.SPIFFTX.bit.TXFIFO = 1;
	SpiaRegs.SPIFFRX.bit.RXFIFORESET = 1;
}

__interrupt void spiTxFifoIsr(void)
{
	Uint16 i;

	for (i = 0; i < 2; i++)
		SpiaRegs.SPITXBUF = sdata[i];	/* Send data */

	for (i = 0; i < 2; i++)        		/* Increment data for next cycle	*/
		sdata[i] = sdata[i] + 1;

	SpiaRegs.SPIFFTX.bit.TXFFINTCLR = 1;  	/* Clear Interrupt flag			*/
	PieCtrlRegs.PIEACK.all |= 0x20;       	/* Issue PIE ACK			*/
}

__interrupt void spiRxFifoIsr(void)
{
	Uint16 i;
	for (i = 0; i < 2; i++)
		rdata[i] = SpiaRegs.SPIRXBUF; 	/* Read data				*/

	for (i = 0; i < 2; i++) {       	/* Check received data			*/
		if (rdata[i] != rdata_point + i)
			error();
	}

	rdata_point++;
	SpiaRegs.SPIFFRX.bit.RXFFOVFCLR = 1; 	/* Clear Overflow flag			*/
	SpiaRegs.SPIFFRX.bit.RXFFINTCLR = 1; 	/* Clear Interrupt flag			*/
	PieCtrlRegs.PIEACK.all |= 0x20;      	/* Issue PIE ack			*/
}

void main(void)
{
	Uint16 i;

	InitSysCtrl();				/* enable PLL, WatchDog, Peripheral Clk	*/
	InitSpiaGpio();				/* Setup SPI-A only			*/

	DINT;					/* Disable all CPU interrupts		*/
	IER = 0x0000;				/* Clear all CPU interrupts		*/
	IFR = 0x0000;

	InitPieCtrl();
	InitPieVectTable();

	EALLOW;    				/* write to EALLOW protected reg	*/
	PieVectTable.SPIRXINTA = &spiRxFifoIsr;	/* remap interrupt vector		*/
	PieVectTable.SPITXINTA = &spiTxFifoIsr;
	EDIS;      				/* disable EALLOW protected reg		*/

	spi_fifo_init();   			/* Initialize SPI FIFO only		*/

	for (i = 0; i < 2; i++)
		sdata[i] = i;			/* Initialize transmit buffer		*/

	rdata_point = 0;

	PieCtrlRegs.PIECTRL.bit.ENPIE = 1;	/* Enable the PIE block			*/
	PieCtrlRegs.PIEIER6.bit.INTx1 = 1;  	/* Enable PIE Group 6, INT 1		*/
	PieCtrlRegs.PIEIER6.bit.INTx2 = 1;   	/* Enable PIE Group 6, INT 2		*/
	IER = 0x20;                          	/* Enable CPU INT6			*/
	EINT;                             	/* Enable Global Interrupts		*/

	while (1) {

	}
}
