/*
 * Copyright (c) 2020 Texas Instruments Incorporated - http://www.ti.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef BOARD_H
#define BOARD_H

#ifndef USE_PERIPHERAL_FRAMES
#define USE_PERIPHERAL_FRAMES
#endif

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// EPWM4 -> myEPWM4 Pinmux
//
//
// EPWM4_A - GPIO Settings
//
#define GPIO_PIN_EPWM4_A 27
#define myEPWM4_EPWMA_GPIO 27
#define myEPWM4_EPWMA_PIN_CONFIG GPIO_27_EPWM4_A
//
// EPWM4_B - GPIO Settings
//
#define GPIO_PIN_EPWM4_B 28
#define myEPWM4_EPWMB_GPIO 28
#define myEPWM4_EPWMB_PIN_CONFIG GPIO_28_EPWM4_B

//
// EPWM2 -> myEPWM5 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define myEPWM5_EPWMA_GPIO 2
#define myEPWM5_EPWMA_PIN_CONFIG GPIO_2_EPWM2_A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 25
#define myEPWM5_EPWMB_GPIO 25
#define myEPWM5_EPWMB_PIN_CONFIG GPIO_25_EPWM2_B

//
// EPWM6 -> myEPWM6 Pinmux
//
//
// EPWM6_A - GPIO Settings
//
#define GPIO_PIN_EPWM6_A 14
#define myEPWM6_EPWMA_GPIO 14
#define myEPWM6_EPWMA_PIN_CONFIG GPIO_14_EPWM6_A
//
// EPWM6_B - GPIO Settings
//
#define GPIO_PIN_EPWM6_B 11
#define myEPWM6_EPWMB_GPIO 11
#define myEPWM6_EPWMB_PIN_CONFIG GPIO_11_EPWM6_B

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

//
// EPWM16 -> myEPWM2 Pinmux
//

//
// EPWM3 -> myEPWM3 Pinmux
//
//
// EPWM3_A - GPIO Settings
//
#define GPIO_PIN_EPWM3_A 4
#define myEPWM3_EPWMA_GPIO 4
#define myEPWM3_EPWMA_PIN_CONFIG GPIO_4_EPWM3_A
//
// EPWM3_B - GPIO Settings
//
#define GPIO_PIN_EPWM3_B 5
#define myEPWM3_EPWMB_GPIO 5
#define myEPWM3_EPWMB_PIN_CONFIG GPIO_5_EPWM3_B

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
#define myEPWM4_BASE EPWM4_BASE
#define myEPWM4_TBPRD 2000
#define myEPWM4_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM4_TBPHS 0
#define myEPWM4_CMPA 50
#define myEPWM4_CMPB 1950
#define myEPWM4_CMPC 0
#define myEPWM4_CMPD 0
#define myEPWM4_DBRED 0
#define myEPWM4_DBFED 0
#define myEPWM4_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM4_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM4_INTERRUPT_SOURCE EPWM_INT_TBCTR_ZERO
#define myEPWM5_BASE EPWM2_BASE
#define myEPWM5_TBPRD 2000
#define myEPWM5_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM5_TBPHS 0
#define myEPWM5_CMPA 50
#define myEPWM5_CMPB 50
#define myEPWM5_CMPC 0
#define myEPWM5_CMPD 0
#define myEPWM5_DBRED 0
#define myEPWM5_DBFED 0
#define myEPWM5_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM5_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM5_INTERRUPT_SOURCE EPWM_INT_TBCTR_ZERO
#define myEPWM6_BASE EPWM6_BASE
#define myEPWM6_TBPRD 2000
#define myEPWM6_COUNTER_MODE EPWM_COUNTER_MODE_UP_DOWN
#define myEPWM6_TBPHS 0
#define myEPWM6_CMPA 50
#define myEPWM6_CMPB 1950
#define myEPWM6_CMPC 0
#define myEPWM6_CMPD 0
#define myEPWM6_DBRED 0
#define myEPWM6_DBFED 0
#define myEPWM6_TZA_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM6_TZB_ACTION EPWM_TZ_ACTION_HIGH_Z
#define myEPWM6_INTERRUPT_SOURCE EPWM_INT_TBCTR_ZERO

//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

// Interrupt Settings for myEPWM4_ET_INT -> INT_EPWM4
#define myEPWM4_ET_INT INT_EPWM4
__attribute__((interrupt("INT"))) extern void epwm4ISR(void);

// Interrupt Settings for myEPWM5_ET_INT -> INT_EPWM2
#define myEPWM5_ET_INT INT_EPWM2
__attribute__((interrupt("INT"))) extern void epwm5ISR(void);

// Interrupt Settings for myEPWM6_ET_INT -> INT_EPWM6
#define myEPWM6_ET_INT INT_EPWM6
__attribute__((interrupt("INT"))) extern void epwm6ISR(void);


//*****************************************************************************
//
// RTDMA1 MPU Configurations
//
//*****************************************************************************


//*****************************************************************************
//
// RTDMA2 MPU Configurations
//
//*****************************************************************************


//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	EPWM_init();
void	INTERRUPT_init();
void	PinMux_init();
void	PERCONFIG_init();
void	RTDMA1_MPU_init();
void	RTDMA2_MPU_init();
void	GPIO_init();
//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
