// Included Files
//
#include "DSP28x_Project.h"     // DSP28x Headerfile
#include "F2806x_Cla_defines.h"  
#include "BoostHardware.h"
#include "stdio.h"
#include "F2806x_Epwm.h"
#include "boost_shared.h"
#include <stdbool.h>
#include "F2806x_CpuTimers.h"

struct CPUTIMER_VARS *Timer;


void PWMs_Config(void);
void PWM2_Config(void);


// CLA ISRs
__interrupt void cla1_task1_isr(void);
__interrupt void cla1_task2_isr(void);
__interrupt void cla1_task3_isr(void);

__interrupt void cpu_timer1_isr(void);


// These are defined by the linker file and used to copy the CLA code from its load address to its run address in CLA program memory
extern Uint16 Cla1funcsLoadStart;
extern Uint16 Cla1funcsLoadEnd;
extern Uint16 Cla1funcsLoadSize;
extern Uint16 Cla1funcsRunStart;
extern Uint16 Cla1Prog_Start;


// These are defined by the linker file and used to copy the CLA math tables from its load address to its run address into one of the CLA data RAMs
extern Uint16 Cla1mathTablesLoadStart;
extern Uint16 Cla1mathTablesLoadEnd;
extern Uint16 Cla1mathTablesLoadSize;
extern Uint16 Cla1mathTablesRunStart;

unsigned int Vin;
unsigned int HsinkTemp;

unsigned int ArrayA[300];
unsigned int ArrayB[300];
unsigned int ArrayC[300];


float PID1outArray[100];
float PID2outArray[100];
float PID3outArray[100];


extern Uint16 Cla1funcsLoadStart;
extern Uint16 Cla1funcsLoadEnd;
extern Uint16 Cla1funcsRunStart;
extern Uint16 Cla1funcsLoadSize;



#define FLASH

void DacDrvCnf(int16 n, int16 DACval, int16 DACsrc, int16 RAMPsrc, int16 Slope_initial);


void main(void)
{

  // Step 1: Setup the system clock Disable the watchdog timer, initialize the system clock,PLL and configure the peripheral clock.
  InitSysCtrl();

#ifdef FLASH
// Copy time critical code and Flash setup code to RAM The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart symbols are created by the linker. Refer to the linker files.
    MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);

// Call Flash Initialization to setup flash waitstates This function must reside in RAM
    InitFlash();       // Call the flash wrapper init function
#endif


    //Initialize PIE control Intialize PIE control, disable all interrupts and then copy over the PIE Vector table from BootROM to RAM
    DINT;                                      //Disable CPU Interrupts
    InitPieCtrl();
    IER = 0x00000000;
    IFR = 0x00000000;
    InitPieVectTable();

    // Assign user defined ISR to the PIE vector table
    EALLOW;
    PieVectTable.TINT1      = &cpu_timer1_isr;
    PieVectTable.CLA1_INT1  = &cla1_task1_isr;
    PieVectTable.CLA1_INT2  = &cla1_task2_isr;
    PieVectTable.CLA1_INT3  = &cla1_task3_isr;
    PieVectTable.CLA1_INT4  = &cla1_task4_isr;
    EDIS;

    // Enable INT11.1 INT 11.2. 11.3 in the PIE (CLA Task1,2,3,4)
    PieCtrlRegs.PIEIER11.bit.INTx1 = 1;
    PieCtrlRegs.PIEIER11.bit.INTx2 = 1;
    PieCtrlRegs.PIEIER11.bit.INTx3 = 1;
    PieCtrlRegs.PIEIER11.bit.INTx4 = 1;

    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;  //Enable Timer 1

    //Enable CLA interrupts
    IER |= M_INT11;
    IER |= M_INT13;                           // Enable CPU int1 which is connected to CPU-Timer1,
    IER |= M_INT2;

    /* Enable ADCINT1 in PIE */
    PieCtrlRegs.PIEIER1.bit.INTx1 = 1;  /* Enable INT 1.1 in the PIE */
    PieCtrlRegs.PIEIER1.bit.INTx2 = 1;  /* Enable INT 1.2 in the PIE */
    PieCtrlRegs.PIEIER10.bit.INTx3 = 1;  /* Enable INT 10.3 in the PIE */

    EINT;/* Enable Global interrupt INTM */
    ERTM;/* Enable Global realtime interrupt DBGM */

    // Compute all CLA task vectors
    EALLOW;
    Cla1Regs.MVECT1 = (Uint16)((Uint32)&Cla1Task1 -(Uint32)&Cla1Prog_Start);
    Cla1Regs.MVECT2 = (Uint16)((Uint32)&Cla1Task2 -(Uint32)&Cla1Prog_Start);
    Cla1Regs.MVECT3 = (Uint16)((Uint32)&Cla1Task3 -(Uint32)&Cla1Prog_Start);
    Cla1Regs.MVECT4 = (Uint16)((Uint32)&Cla1Task4 -(Uint32)&Cla1Prog_Start);
    EDIS;

    EALLOW;
    Cla1Regs.MPISRCSEL1.bit.PERINT1SEL = CLA_INT1_ADCINT1;   // ADCINT1 starts Task 1
    Cla1Regs.MPISRCSEL1.bit.PERINT2SEL = CLA_INT2_ADCINT2;   // ADCINT2 starts Task 2
    Cla1Regs.MPISRCSEL1.bit.PERINT3SEL = CLA_INT3_ADCINT3;   // ADCINT1 starts Task 3
    Cla1Regs.MMEMCFG.bit.PROGE = 1;                          // Map CLA program memory to the CLA
    Cla1Regs.MIER.all                   = 0x00FF;
    EDIS;

    EALLOW;
    MemCopy(&Cla1funcsLoadStart, &Cla1funcsLoadEnd, &Cla1funcsRunStart);
    EDIS;

    EALLOW;
    Cla1Regs.MMEMCFG.all = CLA_PROG_ENABLE|CLARAM0_ENABLE|CLARAM1_ENABLE|
                           CLARAM2_ENABLE|CLA_RAM1CPUE;
    Cla1Regs.MCTL.bit.IACKE = 1;
    EDIS;

    //Start Task4
    Cla1ForceTask4andWait();    /* used to initialize PID Parameters */

    //Configure GPIOs
    Gpio_select();

    //Configure ADC
    InitAdc();
    InitAdcAio();
    //AdcOffsetSelfCal();

    //Configure ADCs
    ADCs_Config();

    //Configure PWM
    PWMs_Config();

    //Configure Comparators
    Comparator_Config();

    InitCpuTimers();
    //configure timer1;Frequency in MHz, period in Useconds
    ConfigCpuTimer(&CpuTimer1,90,4000);

    // To ensure precise timing, use write-only instructions to write to the entire register. Therefore, if any
    // of the configuration bits are changed in ConfigCpuTimer and InitCpuTimers (in F2806x_CpuTimers.h), the
    // below settings must also be updated.
    CpuTimer1Regs.TCR.all = 0x4000; // Use write-only instruction to set TSS bit = 0


    while(1)
    {
    }

#if HARDWARE
 {
     __asm(" ESTOP0");
 }
 #endif

 }