/**********************************************************************
* File: Main_10.c -- File for Lab 10
* Devices: TMS320F28x7x
* Author: C2000 Technical Training, Texas Instruments
**********************************************************************/

#include "Lab.h"                        // Main include file
//#include "F2837xD_cputimervars.h"

//--- Global Variables
Uint16 DEBUG_TOGGLE = 1;                // Used for realtime mode investigation test
Uint16 SINE_ENABLE = 0;                 // Used for DAC waveform generation
Uint16 PWM_MODULATE = 0;                // Used for PWM modulation
Uint16 AdcBuf[ADC_BUF_LEN];             // ADC buffer allocation
Uint16 AdcBufFiltered[ADC_BUF_LEN];     // ADC filtered data buffer allocation
Uint16 DacOffset;                       // DAC offset
Uint16 DacOutput;                       // DAC output
Uint32 PwmDuty;                         // measured PWM duty cycle
Uint32 PwmPeriod;                       // measured PWM period
Uint16 ClaFilteredOutput;               // Output of CLA filter

float32 xDelay[FILTER_LEN] = {0,0,0,0,0};	// filter delay chain
float32 coeffs[FILTER_LEN] = {0.0625, 0.25, 0.375, 0.25, 0.0625};	// filter coefficients

#pragma DATA_SECTION(xDelay, "Cla1Data1");
#pragma DATA_SECTION(ClaFilteredOutput, "Cla1ToCpuMsgRAM");
#pragma DATA_SECTION(coeffs, "Cla1Data2");

#pragma DATA_SECTION(AdcBufRaw, "dmaMemBufs");
Uint16 AdcBufRaw[2*ADC_BUF_LEN];			// ADC raw data buffer allocation


void init_Gpio(void);
void init_pwm(void);
void init_tmr(void);
//void configureDAC(void);
void sinevalues(void);
void configureDAC(void);
void init_pwm(void);
void pwm(void);
void InitAdcall(void);

__interrupt void cpu_timer1_isr(void);
__interrupt void phA_0(void);
__interrupt void phB_0(void);
__interrupt void phC_0(void);
long int t,f1,C2;
int S1,S2,S3,a,b,c,d,C1;
float y,f2,S,m1a,m1au=0,m1al=0,m1b,m1bu,m1bl,m1c,m1cu,m1cl;
/**********************************************************************
* Function: main()
*
* Description: Main function for C28x workshop labs
**********************************************************************/
void main(void)
{

//--- CPU Initialization
	InitSysCtrl();						// Initialize the CPU (FILE: SysCtrl.c)
	InitGpio();							// Initialize the shared GPIO pins (FILE: Gpio.c)
	InitXbar();							// Initialize the input, output & ePWM X-Bar (FILE: Xbar.c)
	InitPieCtrl();						// Initialize and enable the PIE (FILE: PieCtrl.c)
	InitWatchdog();						// Initialize the Watchdog Timer (FILE: WatchDog.c)

//--- Copy all Flash sections that need to run from RAM (use memcpy() from RTS library)

// Section secureRamFuncs contains user defined code that runs from CSM secured RAM
	memcpy(&secureRamFuncs_runstart, &secureRamFuncs_loadstart, (Uint32)&secureRamFuncs_loadsize);

//--- Initialize the Flash and OTP
	InitFlash();                                     // Initialize the Flash

//--- Peripheral Initialization
	InitAdca();							// Initialize the ADC-A (FILE: Adc.c)
	InitAdcall();
	InitDacb();                         // Initialize the DAC-B (File: Dac.c)
	InitEPwm();							// Initialize the EPwm (FILE: EPwm.c)
	InitECap();							// Initialize the ECap (FILE: ECap.c) 
//	InitDma();							// Initialize the DMA (FILE: Dma.c)
	InitCla();							// Initialize the Cla (FILE: Cla.c) 
	init_tmr();
	configureDAC();
	init_pwm();

    GpioCtrlRegs.GPAGMUX1.bit.GPIO0 = 0;        // 0|0=GPIO  0|1=EPWM1A       0|2=rsvd         0|3=rsvd
    GpioCtrlRegs.GPAMUX1.bit.GPIO0  = 1;        // 1|0=GPIO  1|1=rsvd         1|2=SDAA         1|3=rsvd
    GpioCtrlRegs.GPAGMUX1.bit.GPIO1 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO1  = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO0   = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO1   = 1;

    GpioCtrlRegs.GPAGMUX1.bit.GPIO2 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO2  = 1;
    GpioCtrlRegs.GPAGMUX1.bit.GPIO3 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO3  = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO2   = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO3   = 1;


    GpioCtrlRegs.GPAGMUX1.bit.GPIO4 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO4  = 1;
    GpioCtrlRegs.GPAGMUX1.bit.GPIO5 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO5  = 1;
    GpioCtrlRegs.GPAGMUX1.bit.GPIO6 = 0;        // 0|0=GPIO  0|1=EPWM1B       0|2=rsvd         0|3=MFSRB
    GpioCtrlRegs.GPAMUX1.bit.GPIO6  = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO4   = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO5   = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO6   = 1;
    GpioCtrlRegs.GPAPUD.bit.GPIO6 = 1;    // Disable pull-up on GPIO5 (EPWM4A)
    GpioCtrlRegs.GPAPUD.bit.GPIO8 = 1;    // Disable pull-up on GPIO6 (EPWM5A)

    GpioCtrlRegs.GPAGMUX1.bit.GPIO7 = 0;
    GpioCtrlRegs.GPAMUX1.bit.GPIO7  = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO7   = 1;
    GpioCtrlRegs.GPAGMUX1.bit.GPIO8 = 0;
    GpioCtrlRegs.GPAMUX1.bit.GPIO8  = 1;
    GpioCtrlRegs.GPADIR.bit.GPIO8   = 1;

//--- Enable global interrupts
	asm(" CLRC INTM, DBGM");			// Enable global interrupts and realtime debug
    while (1)
    {
   //    f1=CpuTimer1Regs.TIM.all;
   //    f2=f1*5*0.000000001;
//       m1a=sin(f2*2*3.1459*50);
//       m1b=sin((f2*2*3.1459*50)-(2*3.1459/3));
//       m1c=sin((f2*2*3.1459*50)-(4*3.1459/3));
  //  AdcaRegs.ADCSOCFRC1.bit.SOC2 = 1;
 //       int i=0;
 //       do
//        { i=i+1;
//        }while (i<10);
    //    S=AdcaResultRegs.ADCRESULT2;
//        S1=(m1a*2000)+2047;
   //     S1 = (S1>>4)&0xFFF;
   //     DacaRegs.DACVALS.all = S1;
//        S2=(m1b*2000)+2047;
  //      S2 = (S2>>4)&0xFFF;
  //      C1 = (t>>4)&0xFFF;

    //    EPwm1Regs.CMPA.bit.CMPA = m1au;
   //     EPwm1Regs.CMPB.bit.CMPB = m1al;

     /*   EPwm2Regs.CMPA.bit.CMPA = m1bu;
        EPwm2Regs.CMPB.bit.CMPB = m1bl;

        EPwm3Regs.CMPA.bit.CMPA = m1cu;
        EPwm3Regs.CMPB.bit.CMPB = m1cl;*/

        AdcaRegs.ADCSOCFRC1.bit.SOC2 = 1;
        AdcaRegs.ADCSOCFRC1.bit.SOC3 = 1;

        d = 1000;

        EPwm1Regs.CMPA.bit.CMPA = d;
        EPwm1Regs.CMPB.bit.CMPB = d;

        EPwm2Regs.CMPA.bit.CMPA = d;
        EPwm2Regs.CMPB.bit.CMPB = d;

        EPwm3Regs.CMPA.bit.CMPA = d;
        EPwm3Regs.CMPB.bit.CMPB = d;

        EPwm4Regs.CMPA.bit.CMPA = d;
        EPwm4Regs.CMPB.bit.CMPB = d;

        EPwm5Regs.CMPA.bit.CMPA = d;
        EPwm5Regs.CMPB.bit.CMPB = d;

        C1=EPwm1Regs.TBCTR;
        C2=EPwm1Regs.CMPA.bit.CMPA;
        C1= (C1>>4)&0xFFF;
        C1=C1+1000;
        DacaRegs.DACVALS.all = C1;
      //  S3=(m1c*2000)+2047;
     //   DacaRegs.DACVALS.all = C1;


 //       pwm();
   }
//--- Main Loop
/*	while(1)							// endless loop - wait for an interrupt
	{
		asm(" NOP");
	}*/


} //end of main()

void pwm(void)
{

}

void InitAdcall(void)
{
EALLOW;

CpuSysRegs.PCLKCR13.bit.ADC_A       = 1;
CpuSysRegs.PCLKCR13.bit.ADC_B       = 1;
CpuSysRegs.PCLKCR13.bit.ADC_C       = 1;
CpuSysRegs.PCLKCR13.bit.ADC_D       = 1;

AdcaRegs.ADCCTL2.bit.PRESCALE       = 1;
AdcaRegs.ADCCTL2.bit.RESOLUTION     = 0;
AdcaRegs.ADCCTL2.bit.SIGNALMODE     = 0;

AdcaRegs.ADCCTL1.bit.INTPULSEPOS    = 1;
AdcaRegs.ADCCTL1.bit.ADCPWDNZ       = 1;

AdcaRegs.ADCSOC2CTL.bit.ACQPS       = 20;
AdcaRegs.ADCSOC2CTL.bit.CHSEL       = 2;
AdcaRegs.ADCSOC2CTL.bit.TRIGSEL     = 0;

AdcaRegs.ADCSOC3CTL.bit.ACQPS       = 20;
AdcaRegs.ADCSOC3CTL.bit.CHSEL       = 3;
AdcaRegs.ADCSOC3CTL.bit.TRIGSEL     = 0;


EDIS;
}

void configureDAC(void)
{
    EALLOW;

CpuSysRegs.PCLKCR16.bit.DAC_A = 1 ;
CpuSysRegs.PCLKCR16.bit.DAC_B = 1 ;
CpuSysRegs.PCLKCR16.bit.DAC_C = 1 ;

DacaRegs.DACCTL.bit.DACREFSEL= 1;
DacaRegs.DACCTL.bit.LOADMODE=0;
DacaRegs.DACOUTEN.bit.DACOUTEN=1;
DacaRegs.DACLOCK.bit.DACOUTEN = 1;

//DelayUs(5); // Delay for buffered DAC to power up

DacbRegs.DACCTL.bit.DACREFSEL=1;
DacbRegs.DACCTL.bit.LOADMODE=0;
DacbRegs.DACOUTEN.bit.DACOUTEN=1;
DacaRegs.DACLOCK.bit.DACOUTEN = 1;

    EDIS;
}
void init_tmr()
{
    EALLOW;

//  Set pre-scale counter to divide by 1 (SYSCLKOUT)
    CpuTimer1Regs.TPR.all  = 0;
    CpuTimer1Regs.TPRH.all  = 0;

    CpuTimer0Regs.TPR.all  = 0;
    CpuTimer0Regs.TPRH.all  = 0;


//  Free run timer
    CpuTimer1Regs.TCR.bit.FREE = 1;   // Timer Free Run
    CpuTimer1Regs.TCR.bit.SOFT = 1;
    CpuTimer0Regs.TCR.bit.FREE = 1;   // Timer Free Run
    CpuTimer0Regs.TCR.bit.SOFT = 1;

//  Initialize timer period
    CpuTimer1Regs.PRD.all = 4000000;
    CpuTimer0Regs.PRD.all = 4000000;


//  Reload all counter register with period value
    CpuTimer1Regs.TCR.bit.TRB = 1;
    CpuTimer0Regs.TCR.bit.TRB = 1;

//  0 = Disable/ 1 = Enable Timer Interrupt
    CpuTimer1Regs.TCR.bit.TIE = 1;
    CpuTimer0Regs.TCR.bit.TIE = 0;

//  Reset interrupt counters
    /*  CpuTimer1.InterruptCount = 0;
    CpuTimer0.InterruptCount = 0;*/

//  ISR functions found within this file.
    EALLOW;  // This is needed to write to EALLOW protected registers
    PieVectTable.TIMER1_INT = &cpu_timer1_isr;

    //  Reset interrupt counters

    EINT;   // Enable Global interrupt INTM
    ERTM;   // Enable Global realtime interrupt DBGM

}

void cpu_timer1_isr(void)
{
//   CpuTimer1.InterruptCount++;
   // The CPU acknowledges the interrupt.
    t=CpuTimer1Regs.TIM.all;
  //  t=t+1;
  /*  GpioDataRegs.GPACLEAR.bit.GPIO2 = 1;
//    GpioDataRegs.GPASET.bit.GPIO2 = 1;
    int i=0;
            do
            { i=i+1;
            }while (i<1000);

  GpioDataRegs.GPASET.bit.GPIO2 = 1;*/
    }

void init_pwm(void)
{
    EALLOW;


//  Ref to page 108
    ClkCfgRegs.CLKSRCCTL1.bit.OSCCLKSRCSEL = 0x0;      // such that oscclk takes from intosc2. intosc2 is 10MHz

    ClkCfgRegs.SYSPLLMULT.bit.IMULT=0x28;              // Pll CALCULATED FROM FORMULA IN PAGE 115 (SYS CONTROL)
    ClkCfgRegs.SYSPLLMULT.bit.FMULT=0x00;              // Pllsysclk is now at 400MHZ

    ClkCfgRegs.SYSPLLCTL1.bit.PLLEN = 1;               // to enable pll
    ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV=0x1;      // TO RUN SYSCLOCK IN 200MHz. WHICH IS PLLSYSCLK
    ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 4;     // Set initial divider at /8
    ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 1;           // Switch over to use PLL output, 200 MHz /8 = 25 MHz
    DelayUs(20/8);

    ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 2;      // Change to /4 divider
    DelayUs(20/4);                                     // Wait 20 us (just an example)

       ClkCfgRegs.SYSCLKDIVSEL.bit.PLLSYSCLKDIV = 1;   // Change to /2 divider hence fpllclk = 200
       DelayUs(20/4);

       CpuSysRegs.PCLKCR2.bit.EPWM1=1;                 // TO ENABLE EPWM MODULE 1
       CpuSysRegs.PCLKCR2.bit.EPWM2=1;                 // TO ENABLE EPWM MODULE 2
       CpuSysRegs.PCLKCR2.bit.EPWM3=1;                 // TO ENABLE EPWM MODULE 2
       CpuSysRegs.PCLKCR2.bit.EPWM4=1;                 // TO ENABLE EPWM MODULE 2
       CpuSysRegs.PCLKCR2.bit.EPWM5=1;

       ClkCfgRegs.SYSPLLCTL1.bit.PLLCLKEN = 1;           // Switch over to use PLL output

// SYS CLOCK running at 200 MHz
       ClkCfgRegs.PERCLKDIVSEL.bit.EPWMCLKDIV = 1;        // now EPWMclk is at 100 MHZ

    // EPWM 1block
        DevCfgRegs.SOFTPRES2.bit.EPWM1 = 1;                // ePWM1 is reset
        DevCfgRegs.SOFTPRES2.bit.EPWM1 = 0;                // ePWM1 is released from reset
        DevCfgRegs.CPUSEL0.bit.EPWM1=0;                    // Enable CPU1 to EPWM1
        EPwm1Regs.TBCTL.bit.CTRMODE = 0x3;                 // Disable the timer
        EPwm1Regs.TBCTL.all = 0xC533;                      // C533 means epwm is at 2khz. c4b3 means epwm is 4khz
        EPwm1Regs.TBCTL.bit.SYNCOSEL = 1;
        EPwm1Regs.TBCTL.bit.PRDLD = 0;
        EPwm1Regs.TBCTL.bit.FREE_SOFT = 2;
        EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0x0;
        EPwm1Regs.TBCTL.bit.CLKDIV = 0x0;                   // This means TBCLK=EPWMCLK=100MHz
        EPwm1Regs.TBCTR = 0x0000;                          // Clear timer counter
        EPwm1Regs.TBPRD = 1999;                            // EPWM CLK at 50 kHz
        EPwm1Regs.TBPHS.bit.TBPHS = 0x0000;                // Set timer phase
        EPwm1Regs.ETPS.all = 0x0000;                       // Configure interrupt at underflow of epwm1
        EPwm1Regs.ETSEL.all = 0x0009;                      // Enable interrupt at underflow of epwm1
        EPwm1Regs.ETSEL.bit.INTSEL = 1;
        EPwm1Regs.ETSEL.bit.INTEN = 0;
        EPwm1Regs.ETSEL.bit.INTSELCMP = 0;
     //test 25/11  EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
     //test 25/11   EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm1Regs.CMPCTL.bit.LOADAMODE = 0;
        EPwm1Regs.CMPCTL.bit.LOADBMODE = 0;
        EPwm1Regs.AQCTLA.bit.CAU = 1;                      // EPWM1A set to low on TBCTR=CMPA on up count
//        EPwm1Regs.AQCTLA.bit.CAD = 0;                      // EPWM1A set to High on TBCTR=CMPA on down count
//        EPwm1Regs.AQCTLB.bit.CBD = 0;
        EPwm1Regs.AQCTLB.bit.CBU = 1;
        EPwm1Regs.AQCTLA.bit.PRD = 2;
        EPwm1Regs.DBCTL.bit.OUT_MODE = 0;                  // Deadband disabled, DB will be generated by the gate drivers
        EPwm1Regs.TBCTL.bit.CTRMODE = 0x0;                 // Enable the timer in count up/down mode

        //EPWM 2 block
        DevCfgRegs.SOFTPRES2.bit.EPWM2 = 1;                // ePWM1 is reset
        DevCfgRegs.SOFTPRES2.bit.EPWM2 = 0;                // ePWM1 is released from reset
        DevCfgRegs.CPUSEL0.bit.EPWM2=0;                    // Enable CPU1 to EPWM1
        EPwm2Regs.TBCTL.bit.CTRMODE = 0x3;                 // Disable the timer
        EPwm2Regs.TBCTL.all = 0xC533;                      // C533 means epwm is at 2khz. c4b3 means epwm is 4khz
        EPwm2Regs.TBCTL.bit.SYNCOSEL = 1;
        EPwm2Regs.TBCTL.bit.PRDLD = 0;
        EPwm2Regs.TBCTL.bit.FREE_SOFT = 2;
        EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0x0;
        EPwm2Regs.TBCTL.bit.CLKDIV = 0x0;
        EPwm2Regs.TBCTR = 0x0000;                          // Clear timer counter
        EPwm2Regs.TBPRD = 1999;                            // EPWM CLK at 50 kHz
        EPwm2Regs.TBCTL.bit.PHSDIR = 0;                    // EPWM
        EPwm2Regs.TBCTL.bit.PHSEN = 1;
        EPwm2Regs.TBPHS.bit.TBPHS = 400;
     //   EPwm2Regs.TBPHS.bit.TBPHS = 0x0000;                // Set timer phase
        EPwm2Regs.ETPS.all = 0x0000;                       // Configure interrupt at underflow of epwm1
      //  EPwm2Regs.ETSEL.all = 0x0009;                      // Enable interrupt at underflow of epwm1
        EPwm2Regs.ETSEL.bit.INTSEL = 1;
        EPwm2Regs.ETSEL.bit.INTEN = 0;
        EPwm2Regs.ETSEL.bit.INTSELCMP = 0;
        EPwm2Regs.ETSEL.all = 0x0009;
        //test 25/11  EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        //test 25/11   EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm2Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        EPwm2Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm2Regs.CMPCTL.bit.LOADAMODE = 0;
        EPwm2Regs.CMPCTL.bit.LOADBMODE = 0;
        EPwm2Regs.AQCTLA.bit.CAU = 1;                      // EPWM1A set to low on TBCTR=CMPA on up count
     //   EPwm2Regs.AQCTLA.bit.CAD = 2;                      // EPWM1A set to High on TBCTR=CMPA on down count
     //   EPwm2Regs.AQCTLB.bit.CBD = 2;
        EPwm2Regs.AQCTLB.bit.CBU = 1;
        EPwm2Regs.AQCTLA.bit.PRD = 2;
        EPwm2Regs.DBCTL.bit.OUT_MODE = 0;                  // Deadband disabled, DB will be generated by the gate drivers
        EPwm2Regs.TBCTL.bit.CTRMODE = 0x0;                 // Enable the timer in count up/down mode

//EPWM 3 block

        DevCfgRegs.SOFTPRES2.bit.EPWM3 = 1;                // ePWM1 is reset
        DevCfgRegs.SOFTPRES2.bit.EPWM3 = 0;                // ePWM1 is released from reset
        DevCfgRegs.CPUSEL0.bit.EPWM3=0;                    // Enable CPU1 to EPWM1
        EPwm3Regs.TBCTL.bit.CTRMODE = 0x3;                 // Disable the timer
        EPwm3Regs.TBCTL.all = 0xC533;                      // C533 means epwm is at 2khz. c4b3 means epwm is 4khz
        EPwm3Regs.TBCTL.bit.SYNCOSEL = 1;
        EPwm3Regs.TBCTL.bit.PRDLD = 0;
        EPwm3Regs.TBCTL.bit.FREE_SOFT = 2;
        EPwm3Regs.TBCTL.bit.HSPCLKDIV = 0x0;
        EPwm3Regs.TBCTL.bit.CLKDIV = 0x0;
        EPwm3Regs.TBCTR = 0x0000;                          // Clear timer counter
        EPwm3Regs.TBPRD = 1999;                            // EPWM CLK at 50 kHz
        EPwm3Regs.TBCTL.bit.PHSDIR = 0;                    // EPWM
        EPwm3Regs.TBCTL.bit.PHSEN = 1;
        EPwm3Regs.TBPHS.bit.TBPHS = 800;
   //   EPwm3Regs.TBPHS.bit.TBPHS = 0x0000;                // Set timer phase
        EPwm3Regs.ETPS.all = 0x0000;                       // Configure interrupt at underflow of epwm1
   //   EPwm3Regs.ETSEL.all = 0x0009;                      // Enable interrupt at underflow of epwm1
        EPwm3Regs.ETSEL.bit.INTSEL = 1;
        EPwm3Regs.ETSEL.bit.INTEN = 0;
        EPwm3Regs.ETSEL.bit.INTSELCMP = 0;
  //      EPwm3Regs.ETSEL.all = 0x0009;
        //test 25/11  EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        //test 25/11   EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm3Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        EPwm3Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm3Regs.CMPCTL.bit.LOADAMODE = 0;
        EPwm3Regs.CMPCTL.bit.LOADBMODE = 0;
        EPwm3Regs.AQCTLA.bit.CAU = 1;                      // EPWM1A set to low on TBCTR=CMPA on up count
        //   EPwm2Regs.AQCTLA.bit.CAD = 2;                      // EPWM1A set to High on TBCTR=CMPA on down count
        //   EPwm2Regs.AQCTLB.bit.CBD = 2;
        EPwm3Regs.AQCTLB.bit.CBU = 1;
        EPwm3Regs.AQCTLA.bit.PRD = 2;
        EPwm3Regs.DBCTL.bit.OUT_MODE = 0;                  // Deadband disabled, DB will be generated by the gate drivers
        EPwm3Regs.TBCTL.bit.CTRMODE = 0x0;                 // Enable the timer in count up/down mode

//EPWM 4 block

        // to operate EPWM4A, pull up needs to be disabled

        DevCfgRegs.SOFTPRES2.bit.EPWM4 = 1;                // ePWM1 is reset
        DevCfgRegs.SOFTPRES2.bit.EPWM4 = 0;                // ePWM1 is released from reset
        DevCfgRegs.CPUSEL0.bit.EPWM4=0;                    // Enable CPU1 to EPWM1
        EPwm4Regs.TBCTL.bit.CTRMODE = 0x3;                 // Disable the timer
        EPwm4Regs.TBCTL.all = 0xC533;                      // C533 means epwm is at 2khz. c4b3 means epwm is 4khz
        EPwm4Regs.TBCTL.bit.SYNCOSEL = 1;
        EPwm4Regs.TBCTL.bit.PRDLD = 0;
        EPwm4Regs.TBCTL.bit.FREE_SOFT = 2;
        EPwm4Regs.TBCTL.bit.HSPCLKDIV = 0x0;
        EPwm4Regs.TBCTL.bit.CLKDIV = 0x0;
        EPwm4Regs.TBCTR = 0x0000;                          // Clear timer counter
        EPwm4Regs.TBPRD = 1999;                            // EPWM CLK at 50 kHz
        EPwm4Regs.TBCTL.bit.PHSDIR = 0;                    // EPWM
        EPwm4Regs.TBCTL.bit.PHSEN = 1;
        EPwm4Regs.TBPHS.bit.TBPHS = 1200;
   //   EPwm4Regs.TBPHS.bit.TBPHS = 0x0000;                // Set timer phase
        EPwm4Regs.ETPS.all = 0x0000;                       // Configure interrupt at underflow of epwm1
   //   EPwm4Regs.ETSEL.all = 0x0009;                      // Enable interrupt at underflow of epwm1
        EPwm4Regs.ETSEL.bit.INTSEL = 1;
        EPwm4Regs.ETSEL.bit.INTEN = 0;
        EPwm4Regs.ETSEL.bit.INTSELCMP = 0;
   //     EPwm4Regs.ETSEL.all = 0x0009;
        //test 25/11  EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        //test 25/11   EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm4Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
        EPwm4Regs.CMPCTL.bit.SHDWBMODE = 0;
        EPwm4Regs.CMPCTL.bit.LOADAMODE = 0;
        EPwm4Regs.CMPCTL.bit.LOADBMODE = 0;
        EPwm4Regs.AQCTLA.bit.CAU = 2;                      // EPWM1A set to low on TBCTR=CMPA on up count
        EPwm4Regs.AQCTLA.bit.CAD = 2;                      // EPWM1A set to High on TBCTR=CMPA on down count
        EPwm4Regs.AQCTLB.bit.CBD = 2;
        EPwm4Regs.AQCTLB.bit.CBU = 2;
        EPwm4Regs.AQCTLA.bit.PRD = 2;
        EPwm4Regs.AQCTLA.bit.ZRO = 2;
        EPwm4Regs.DBCTL.bit.OUT_MODE = 0;                  // Deadband disabled, DB will be generated by the gate drivers
        EPwm4Regs.TBCTL.bit.CTRMODE = 0x0;                 // Enable the timer in count up/down mode

//EPWM 5 Block
        // to operate EPWM4A, pull up needs to be disabled
        DevCfgRegs.SOFTPRES2.bit.EPWM5 = 1;                // ePWM1 is reset
                DevCfgRegs.SOFTPRES2.bit.EPWM5 = 0;                // ePWM1 is released from reset
                DevCfgRegs.CPUSEL0.bit.EPWM5=0;                    // Enable CPU1 to EPWM1
                EPwm5Regs.TBCTL.bit.CTRMODE = 0x3;                 // Disable the timer
                EPwm5Regs.TBCTL.all = 0xC533;                      // C533 means epwm is at 2khz. c4b3 means epwm is 4khz
                EPwm5Regs.TBCTL.bit.SYNCOSEL = 1;
                EPwm5Regs.TBCTL.bit.PRDLD = 0;
                EPwm5Regs.TBCTL.bit.FREE_SOFT = 2;
                EPwm5Regs.TBCTL.bit.HSPCLKDIV = 0x0;
                EPwm5Regs.TBCTL.bit.CLKDIV = 0x0;
                EPwm5Regs.TBCTR = 0x0000;                          // Clear timer counter
                EPwm5Regs.TBPRD = 1999;                            // EPWM CLK at 50 kHz
    //            EPwm5Regs.TBCTL.bit.PHSDIR = 0;                    // EPWM
                EPwm5Regs.TBCTL.bit.PHSEN = 1;
                EPwm5Regs.TBPHS.bit.TBPHS = 1600;
           //   EPwm5Regs.TBPHS.bit.TBPHS = 0x0000;                // Set timer phase
                EPwm5Regs.ETPS.all = 0x0000;                       // Configure interrupt at underflow of epwm1
           //   EPwm5Regs.ETSEL.all = 0x0009;                      // Enable interrupt at underflow of epwm1
                EPwm5Regs.ETSEL.bit.INTSEL = 1;
                EPwm5Regs.ETSEL.bit.INTEN = 0;
                EPwm5Regs.ETSEL.bit.INTSELCMP = 0;
           //     EPwm4Regs.ETSEL.all = 0x0009;
                //test 25/11  EPwm1Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
                //test 25/11   EPwm1Regs.CMPCTL.bit.SHDWBMODE = 0;
                EPwm5Regs.CMPCTL.bit.SHDWAMODE = 0;                // shadow A mode disabled
                EPwm5Regs.CMPCTL.bit.SHDWBMODE = 0;
                EPwm5Regs.CMPCTL.bit.LOADAMODE = 0;
                EPwm5Regs.CMPCTL.bit.LOADBMODE = 0;
                EPwm5Regs.AQCTLA.bit.CAU = 2;                      // EPWM1A set to low on TBCTR=CMPA on up count
                EPwm5Regs.AQCTLA.bit.CAD = 2;                      // EPWM1A set to High on TBCTR=CMPA on down count
                EPwm5Regs.AQCTLB.bit.CBD = 2;
                EPwm5Regs.AQCTLB.bit.CBU = 2;
                EPwm5Regs.AQCTLA.bit.PRD = 2;
                EPwm5Regs.AQCTLA.bit.ZRO = 2;
                EPwm5Regs.DBCTL.bit.OUT_MODE = 0;                  // Deadband disabled, DB will be generated by the gate drivers
                EPwm5Regs.TBCTL.bit.CTRMODE = 0x0;                 // Enable the timer in count up/down mode


        PieVectTable.EPWM1_INT = &phA_0;
        IER |= M_INT3;  // means enter third group of Interrupts Page 95
        IER |= M_INT1;
        PieCtrlRegs.PIEIER3.bit.INTx1=1; // interrupt 3.1= epwm 1 INT page 95

        PieVectTable.EPWM2_INT = &phB_0;
        IER |= M_INT3;  // means enter third group of Interrupts Page 95
        IER |= M_INT2;
        PieCtrlRegs.PIEIER3.bit.INTx2=1; // interrupt 3.1= epwm 1 INT page 95

        PieVectTable.EPWM3_INT = &phC_0;
     //   IER |= M_INT3;  // means enter third group of Interrupts Page 95
     //   IER |= M_INT3;
   //     PieCtrlRegs.PIEIER3.bit.INTx3=1; // interrupt 3.1= epwm 1 INT page 95

        CpuSysRegs.PCLKCR2.bit.EPWM3=1;                 // TO ENABLE EPWM MODULE 2
        CpuSysRegs.PCLKCR2.bit.EPWM4=1;                 // TO ENABLE EPWM MODULE 2
        CpuSysRegs.PCLKCR2.bit.EPWM5=1;                 // TO ENABLE EPWM MODULE 2

 //      PieVectTable.TIMER1_INT = &timer1_intsr;

       // Enable global Interrupts and higher priority real-time debug events:
           EINT;                                   // Enable Global interrupt INTM
           ERTM;                                   // Enable Global realtime interrupt DBGM
                     asm(" EALLOW");                         // Enable EALLOW protected register access
                        CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;   // TBCLK to ePWM modules enabled
           EDIS;


    //  Enable CPU INT3 which is connected to EPWM1-3 INT:
     //   IER |= M_INT13;


}

void phA_0(void)
{
    EALLOW;
    EPwm1Regs.ETCLR.bit.INT = 1;
    // Acknowledge this interrupt to receive more interrupts from group 3
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
   // GpioDataRegs.GPASET.bit.GPIO8 = 1;
        int i=0;
                do
                { i=i+1;
                }while (i<1000);

  //    GpioDataRegs.GPACLEAR.bit.GPIO8 = 1;

    a=1200;
    EDIS;
}
void phB_0(void)
{
    EALLOW;
    EPwm2Regs.ETCLR.bit.INT = 1;
    // Acknowledge this interrupt to receive more interrupts from group 3
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
    b=2;
    EDIS;
}
void phC_0(void)
{
    EALLOW;
    EPwm3Regs.ETCLR.bit.INT = 1;
    // Acknowledge this interrupt to receive more interrupts from group 3
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
 //   GpioDataRegs.GPACLEAR.bit.GPIO7 = 1;
    int y=0;
    if(y<100)
    {
        y=y+1;
    }
//    GpioDataRegs.GPASET.bit.GPIO7 = 1;
    c=2;
    EDIS;
}
/*** end of file *****************************************************/
