CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start

MEMORY
{
   /* Flash sectors */
   FLASH0_BEGIN     : origin = 0x080000, length = 0x000002  /* Bootloader Entry Point */
   FLASH0           : origin = 0x080002, length = 0x001FFE
   FLASH1           : origin = 0x082000, length = 0x002000  /* OTA Flag */
   FLASH2           : origin = 0x084000, length = 0x002000
   FLASH3           : origin = 0x086000, length = 0x002000
   FLASH4_BEGIN     : origin = 0x088000, length = 0x000002  /* Application_A Entry Point */
   FLASH4_5         : origin = 0x088002, length = 0x00FFFE  /* Application_A Flash(~64KW) */
   FLASH6_7         : origin = 0x098000, length = 0x008000  /* Bootloader Flash(64KW) */
   FLASH8_BEGIN     : origin = 0x0A8000, length = 0x000002  /* Application_A Entry Point */
   FLASH8_9         : origin = 0x0A8002, length = 0x00FFFE  /* Application_A Flash(~64KW) */
   FLASH10          : origin = 0x0B8000, length = 0x002000  /* Boot Mode Flag(CAN/Power) */
   FLASH11          : origin = 0x0BA000, length = 0x002000
   FLASH12          : origin = 0x0BC000, length = 0x002000
   FLASH13          : origin = 0x0BE000, length = 0x001FF0
// FLASH13_RSVD     : origin = 0x0BFFF0, length = 0x000010  /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */

   RAMM0_BEGIN      : origin = 0x000000, length = 0x000002  /* Boot to ram entry point */
   BOOT_RSVD        : origin = 0x000002, length = 0x0001AF  /* Part of M0, BOOT rom will use this for stack */
   RAMM0            : origin = 0x0001B1, length = 0x00024F
   RAMM1            : origin = 0x000400, length = 0x0003F8  /* allocated to stack */
// RAMM1_RSVD       : origin = 0x0007F8, length = 0x000008  /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */
   RAMD0            : origin = 0x00C000, length = 0x000800  /* Reserved for NoInitRam */
   RAMD1            : origin = 0x00C800, length = 0x000800  /* Reserved for stack if M0 is not enough */
   RAMLS0_2         : origin = 0x008000, length = 0x001800  /* 6KW, allocated to data(.data, .bss) */
   RAMLS3_7			: origin = 0x009800, length = 0x002800  /* 10KW, allocated to CLA RAM(CLAData, CLAscratch, .scratchpad, .bss_cla, .const_cla) */
   RAMGS0_7         : origin = 0x00D000, length = 0x008000  /* 32KW, CPU1 RAM code */
   RAMGS8_15        : origin = 0x015000, length = 0x007FF8  /* ~ 32KW, CPU1 RAM code */
// RAMGS15_RSVD     : origin = 0x01CFF8, length = 0x000008  /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */


   CPU1TOCPU2RAM    : origin = 0x03A000, length = 0x000800
   CPU2TOCPU1RAM    : origin = 0x03B000, length = 0x000800
   CPUTOCMRAM       : origin = 0x039000, length = 0x000800
   CMTOCPURAM       : origin = 0x038000, length = 0x000800

   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800

   RESET            : origin = 0x3FFFC0, length = 0x000002

   CLA1_MSGRAMLOW   : origin = 0x001480,   length = 0x000080
   CLA1_MSGRAMHIGH  : origin = 0x001500,   length = 0x000080
}


SECTIONS
{
   codestart        : > RAMM0_BEGIN
   .text            : > RAMGS0_7
   .cinit           : > RAMGS0_7
   .switch          : > RAMGS0_7
   .reset           : > RESET, TYPE = DSECT /* not used, */

   .stack           : > RAMM1


#if defined(__TI_EABI__)
	.bss             : > RAMLS0_2
   	.bss:output      : > RAMLS0_2
   	.init_array      : > RAMLS0_2
   	.const           : > RAMGS0_7
	.data            : > RAMLS0_2
    .sect_data_8bit  : > RAMLS0_2
    .sect_data_16bit : > RAMLS0_2
    .sect_data_32bit : > RAMLS0_2
    .sect_data_misc  : > RAMLS0_2
	.sysmem          : > RAMLS0_2
#else
   .pinit           : > RAMGS0_7
   .ebss            : > RAMGS0_7
   .econst          : > RAMGS0_7
   .esysmem         : > RAMGS0_7
#endif

   //ramgs0 : > RAMGS0, type=NOINIT
   //ramgs1 : > RAMGS1, type=NOINIT

   MSGRAM_CPU1_TO_CPU2 > CPU1TOCPU2RAM, type=NOINIT
   MSGRAM_CPU2_TO_CPU1 > CPU2TOCPU1RAM, type=NOINIT
   MSGRAM_CPU_TO_CM   > CPUTOCMRAM, type=NOINIT
   MSGRAM_CM_TO_CPU   > CMTOCPURAM, type=NOINIT

   //.ramgs15 : > RAMGS15

    /* CLA specific sections */
   Cla1Prog         : > RAMLS3_7

   CLADataLS0		: > RAMLS3_7
   CLADataLS1		: > RAMLS3_7

   Cla1ToCpuMsgRAM  : > CLA1_MSGRAMLOW, type=NOINIT
   CpuToCla1MsgRAM  : > CLA1_MSGRAMHIGH, type=NOINIT
   Cla1DataRam      : > RAMLS3_7
   DATA_RAMGS9_10   : > RAMGS0_7

   /* CLA C compiler sections */
   //
   // Must be allocated to memory the CLA has write access to
   //
   CLAscratch       :
                     { *.obj(CLAscratch)
                     . += CLA_SCRATCHPAD_SIZE;
                     *.obj(CLAscratch_end) } >  RAMLS3_7

   .scratchpad      : > RAMLS3_7
   .bss_cla		    : > RAMLS3_7
   .const_cla	    : > RAMLS3_7
   .TI.ramfunc : {} > RAMGS0_7
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
