/*******************************************************************************
 * Project Innovusion Lidar
 * (c) copyright 2023
 * Company Innovusion
 * All rights reserved
 * Secrecy Level STRICTLY CONFIDENTIAL
 ******************************************************************************/
/**
 * @file ApTest.c
 * @ingroup ApTest
 * @author Jason.Jin@cn.innovusion.com
 * Component ApTest is for demo and test.

 */

/*******************************************************************************
 *  INCLUDED HEADERS
 ******************************************************************************/
#include "ApTest.h"
#include "SimpleOS/SimpleOS.h"
#include "EcuM/EcuM.h"
/*******************************************************************************
 *  DEFINITIONS
 ******************************************************************************/


/*******************************************************************************
 *  COMPONENT VARIABLES
 ******************************************************************************/



/*******************************************************************************
 *  FUNCTION PROTOTYPES
 ******************************************************************************/

/*******************************************************************************
 *  FUNCTION DECLARATIONS
 ******************************************************************************/

/**
 * @brief ApTest_MainFunction
 * @details This function implements the state machine of EcuM component
 * @param None
 * @return None
 */
void ApTest_MainFunction(void)
{
    EcuMState_t eState = EcuM_GetState();

    if((eState == E_ECUM_STATE_RUN) && (SimpleOS_GetCurrentTick() > 20000))
    {
        EcuM_SelectShutdownTarget(E_SHUTDOWN_TARGET_SWITCH);
        EcuM_GoDown();
    }
}

/*******************************************************************************
 *  Local FUNCTION DECLARATIONS
 ******************************************************************************/


