/*-------------------------------------------------------------------------------------------------
 * Filename         : CFLASH.H  
 * Last Modified    : 26 Dec 2001.
 * Version          : 1.2
 * Originator       : Texas Instruments, DSP Digital Control Systems Group.
 *-------------------------------------------------------------------------------------------------
 * This header file provides a C based application the structures and 
 * function prototypes for interfacing to the assembly language 
 * implementation of the flash programming algorithms.
 * 
 *-------------------------------------------------------------------------------------------------
 * Revision History: 
 * Version 1.0 (25 May 2001):
 *              Created for embeddable flash programming algos.
 * 
 * Version 1.2 (25 May 2001):
 *              Updated version information only. No functional changes.
 * Version 1.3 (26 Dec 2001):
 *              Comments: Clarified a comment near line 31.
 */
/* Function prototypes
 * Prototypes for the functions implemented in the Clear, Erase, Program
 * and the CopyAlg modules.
 */
 
void extern copyClearAlgo(void);
void extern copyEraseAlgo(void);
void extern copyProgramAlgo(void);
void extern copyKernel(void);

/*    **NEVER** modify the following template to be any different
 *              from the template that is used to assemble
 *              the flash algos.
 */

typedef  struct FlashAlgoVars {
					int ADDR;
					int PAD;
					int READ;
					int DATA;
					int PAD1;
					int PLS_CNT;
					int LASTVER;
					int FL_SECST;
					int FL_SECEND;
					int FL_CMD;
					int ERASESEC;
					int DATA_PTR;
					int FAIL_CMD;
					int SECTOR_KEY;
					int SECTOR_CMD;
					int ALGO_STATUS;
					} FlashAlgoVars;
extern FlashAlgoVars flashAlgoVars;


void extern clearFlash(FlashAlgoVars *);
void extern eraseFlash(FlashAlgoVars *);
void extern programFlash(FlashAlgoVars *);



/* Define sector mask macros:
 * These are interpreted by the flash algorithms to 
 * operate on the specified sectors.
 */

#define SECTOR0 0x1
#define SECTOR1 0x2
#define SECTOR2 0x4 
#define SECTOR3 0x8


