;--------------------------------------------------------------------------------------------------
; Filename         : VAR.H	  
; Last Modified    : 26 Dec 2001.
; Version          : 1.3
; Originator       : Texas Instruments, DSP Digital Control Systems Group.
;--------------------------------------------------------------------------------------------------
;--------------------------------------------------------------------------------------------------
; Revision History
; 
; Ver 1.0 (25 May 2001)
;          Comments: New implementation for embeddable flash algos.
; Ver 1.2 (16 Oct 2001)
;          Comments: No changes to this file. Incremented rev only. 
; Ver 1.3 (26 Dec 2001)
;           Comments: Added the support for LF2401A.
;--------------------------------------------------------------------------------------------------
; VAR.H: VARIABLES AND TIMING DEFINITION SELECTIONS FOR THE FLASH PROGRAMMING TOOLS
;--------------------------------------------------------------------------------------------------
;--------------------------------------------------------------------------------------------------
; DEVICE SELECTION
;--------------------------------------------------------------------------------------------------
; Instructions for selecting the device type:
;--------------------------------------------------------------------------------------------------
;   1. Determine the device to be programmed. 
;
;   +-------------------+---------------------------+
;   | Device number     |   Device type setting     |
;   +-------------------+---------------------------+
;   |  'LF2401A         |   LF2401A                 |
;   +-------------------+---------------------------+
;   |  'LF2407          |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2407A         |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2406          |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2406A         |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2402          |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2402A         |   LF2407                  |
;   +-------------------+---------------------------+
;   |  'LF2403A         |   LF2407                  |
;   +-------------------+---------------------------+
;
;
;   2. Set the device type setting below. Change ONLY the DEV_TYPE setting.
;--------------------------------------------------------------------------------------------------

LF2401A     .set    0800h
LF2407      .set    0500h

DEV_TYPE    .set    LF2401A

;--------------------------------------------------------------------------------------------------
;
; CLOCK SETUP PROCEDURE:
;-------------------------------------------------------------------------------------
;       This file as distributed, configures the PLL to x4 and includes
;       timings at a CPU_CLK of 30MHz.
;
;       To change this 
;
;       Step 1: Select a Clock prescaler / clock input configuration.
;-------------------------------------------------------------------------------------
;       Step 2: Use one of the pre-set timing sets.
;               To do this uncomment the include statement to pull in
;               one of the timing information files: 
;                                               
;-------------------------------------------------------------------------------------
;       Step 3: If pre-set timing is not available for your needs,
;               see the Timings.xls worksheet to generate a custom
;               timings.h for your system.
;
;
;               Then, uncomment the include statement to include timings.xx
;                     where timings.xx is the filename you used when generating 
;                     a custom timing file.
;
;-------------------------------------------------------------------------------------
;       Step 4: Run the batch file buildall.bat to use the new timings.
;
;
;
;-------------------------------------------------------------------------------------
;       STEP 1:
;-------------------------------------------------------------------------------------
;
; Clock prescaler selection: 
; 
; The CPU clock is given as CPU_CLK = INPUT_CLK * PLL_RATIO.
;
; To choose the PLL_RATIO, uncomment ONLY ONE of the lines below.


PLL_RATIO_CONST         .set    0000h           ; CPU_CLK = INPUTCLK * 4.00

;PLL_RATIO_CONST         .set    0200h           ; CPU_CLK = INPUTCLK * 2.00
;PLL_RATIO_CONST         .set    0400h           ; CPU_CLK = INPUTCLK * 1.33
;PLL_RATIO_CONST         .set    0600h           ; CPU_CLK = INPUTCLK * 1.00
;PLL_RATIO_CONST         .set    0800h           ; CPU_CLK = INPUTCLK * 0.80
;PLL_RATIO_CONST         .set    0A00h           ; CPU_CLK = INPUTCLK * 0.66
;PLL_RATIO_CONST         .set    0C00h           ; CPU_CLK = INPUTCLK * 0.57
;PLL_RATIO_CONST         .set    0E00h           ; CPU_CLK = INPUTCLK * 0.50

;
;
;
;
;
;
;-------------------------------------------------------------------------------------
;       STEP 2:
;-------------------------------------------------------------------------------------
;
;       Uncomment ONLY one of the following:
;
;       .include        "timings.15"
;       .include        "timings.xx"
;


        .include        "timings.40"

;
;-------------------------------------------------------------------------------------
;       STEP 3: (If needed)
;-------------------------------------------------------------------------------------
;       Use timings.xls ( A Microsoft Excel file )
;       to generate the timings.xx file.
;
;
;-------------------------------------------------------------------------------------
;
;
;-------------------------------------------------------------------------------------
;       STEP 4: Re-build algos by running buildall.bat
;
;-------------------------------------------------------------------------------------
;
;
;       END OF CUSTOMIZATION 
;

            .globl    flashAlgoVars

flshvar     .struct
ADDR        .int
PAD         .int
READ        .int
DATA        .int
PAD1        .int
PLS_CNT     .int
LASTVER     .int
FL_SECST    .int
FL_SECEND   .int
FL_CMD      .int
ERASESEC    .int
DATA_PTR    .int
FAIL_CMD    .int
SECTOR_KEY  .int
SECTOR_CMD  .int
ALGO_STATUS .int
         
STACK0      .int
STACK1      .int
STACK2      .int
STACK3      .int
STACK4      .int
STACK5      .int
STACK6      .int
STACK7      .int

flshvar_len .endstruct

flashAlgoVars   .tag    flshvar

;-------------------------------------------------------------------------------------
;
;

;-------------------------------------------------------------------------------*
; Flash Control Registers
;-------------------------------------------------------------------------------*

PMPC 	.SET  0h
CTRL    .SET  1h
WADDR   .SET  2h
WDATA   .SET  3h
TCR     .SET  4h
ENAB    .SET  5h
SECT    .SET  6h
;

STICKS	.SET	64              ;# OF STICKS



;-------------------------------------------------------------------------------
; USer callable Flash Routines 
;-------------------------------------------------------------------------------

        .globl  CLEAR_FLASH
        .globl  ERASE_FLASH
        .globl  PROGRAM_FLASH

        .globl  _clearFlash
        .globl  _eraseFlash
        .globl  _programFlash



