*************************************************************
** Variable declaration file                               **
*                                                          **
* TMS320F2XX Flash Utilities.                              **
* Revision: 2.0,  9/10/97                                  **
*                                                          **
* Filename: svar21.asm                                     **
* Modified for F2xx: Sam Saba                      7/07/97 **
* Changes: Removed some unused variables. Added FL_ST and  **
*          FL_END. Tweaked DLOOP constants. Added more     **
*          comments.                                       **
*                                                          **
*                Ruben D. Perez                            **
*                DSP Applications                          **
*                Texas Instruments Inc.                    **
*                                                          **
*Note:                                                      *
*DLOOP is a delay loop variable used in flash algorithms.   *
*This is a function of CLKOUT1. If the F206 device runs at  *
*any CLKOUT1 speed other than 20MHz, DLOOP value should be  *
*re-defined as per the equation, explained below. Use of    *
*current DLOOP for flash programming at speeds other than   *
*20Mhz is not recommended!.                                 *        
*************************************************************
*
        .mmregs
BASE    .set    0300h           ;Base address for variables
                                ;can be changed to relocate
                                ;variable space in RAM.
B2_0    .set    BASE+0          ;Scatch pad registers.
B2_1    .set    BASE+1          ; 
B2_2    .set    BASE+2          ;
B2_3    .set    BASE+3          ;
B2_4    .set    BASE+4          ;
B2_5    .set    BASE+5          ;
B2_6    .set    BASE+6          ;
SPAD1   .set    BASE+7          ;
SPAD2   .set    BASE+8          ;

FL_ADRS .set    BASE+10         ;Flash load address.
FL_DATA .set    BASE+11         ;Flash load data.
ERROR    .set   BASE+15         ;Error flag register.

*Variables for ERASE and CLEAR
RPG_CNT .set    BASE+12         ;Program pulse count.
FL_ST  .set     BASE+13         ;Flash start addr/Seg Cntrl Reg.
FL_END .set     BASE+14         ;Flash end address.

*
*CONSTANTS
*
* Delay variables for CLEAR,ERASE and PROGRAM
D5      .set    0               ;5us delay
D10     .set    1               ;10us delay
D100    .set    21              ;100us delay
D5K     .set    1100            ;5ms delay
D7K     .set    1545            ;7ms delay

*DLOOP  .set                  ;5us delay loop @ 5MIPs
*DLOOP  .set                  ;5us delay loop @ 10MIPs
DLOOP  .set      86           ;5us delay loop @ 20MIPs
*
*DLOOP variable for variable CLKOUT1
*Calculate DLOOP in decimal using the equation 
* DLOOP=(5us*CLKOUT1)-14;
*Examples
*a. @15Mhz,  DLOOP= ;           Check these.
*b. @9.8304Mhz,  DLOOP= ;
*c. @16.384Mhz,  DLOOP= ;

* On-chip I/O registers
F_ACCESS0 .set    0FFE0h  ;F206 ACCESS CNTRL REGISTER 0.
F_ACCESS1 .set    0FFE1h  ;F206 ACCESS CNTRL REGISTER 1.
PMST      .set    0FFE4h  ;Defines SARAM in PM/DM and MP/MC bit.
F24X_ACCS .set    0FF0Fh  ;F240 ACCESS CNTRL REGISTER.
*
* Flash control register
* 15-8    - 7     6  5  4    3    2     1     0
* Seg_bits  Busy  Key   ver0 ver1 Write Erase Exe

;-------------------------------------------
;Register Declarations for F240 Peripherals |
;-------------------------------------------
;Watch-Dog(WD) / Real Time Int(RTI) / Phase Lock Loop(PLL) Registers
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RTI_CNTR	.set	07021h		;RTI Counter reg
WD_CNTR 	.set	07023h		;WD Counter reg
WD_KEY		.set	07025h		;WD Key reg
RTI_CNTL	.set	07027h		;RTI Control reg
WD_CNTL 	.set	07029h		;WD Control reg
PLL_CNTL1	.set	0702Bh		;PLL control reg 1
PLL_CNTL2	.set	0702Dh		;PLL control reg 2

