;--------------------------------------------------------------------------------------------------
; Filename         : RUNDEFS.H
; Last Modified    : 25 May 2001.
; Version          : 1.0
; Originator       : Texas Instruments, DSP Digital Control Systems Group.
;--------------------------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
; 
; Control Date:   March 6, 2001.
; Originator:     Texas Instruments, DSP Digital Control Systems Group.      
;
;-------------------------------------------------------------------------------
; Description:
;
; This file contains the values of the runtime addresses of the Clear, Erase and
; program algorithms. The copy routines use these addresses to copy the flash 
; algorithms from flash memory (load address) to RAM (run address). The flash
; programming routines for the TMS320LF240x device must be run from RAM.
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; Assembly options.
;-------------------------------------------------------------------------------
TRUE                    .set    0
FALSE                   .set    1

;-------------------------------------------------------------------------------
; Define the runtime memory addresses.
;-------------------------------------------------------------------------------
    .globl      ClearAlgoRunMain
    .globl      EraseAlgoRunMain
    .globl      ProgramAlgoRunMain
    .globl      ProgramAlgoRunSpl       
    .globl      ClearAlgoRunSpl         
    .globl      EraseAlgoRunSpl         

    .globl      KernelRun
    .globl      KernelStart
    .globl      KernelEnd
    

    .globl     ClearAlgoEndMain
    .globl     ProgramAlgoStartSpl
    .globl     EraseAlgoStartMain
    .globl     ProgramAlgoStartMain
    .globl     ClearAlgoEndSpl
    .globl     EraseAlgoEndMain
    .globl     EraseAlgoStartSpl
    .globl     ClearAlgoStartMain
    .globl     EraseAlgoEndSpl
    .globl     ProgramAlgoEndMain
    .globl     ClearAlgoStartSpl
    .globl     ProgramAlgoEndSpl


;-------------------------------------------------------------------------------
; Symbol declarations for the functions in the COPYALGO.ASM.
;-------------------------------------------------------------------------------
    .globl      COPY_CLEAR_ALGO
    .globl      COPY_ERASE_ALGO
    .globl      COPY_PROGRAM_ALGO
    .globl      COPY_KERNEL
    .globl      _copyClearAlgo
    .globl      _copyEraseAlgo
    .globl      _copyProgramAlgo
    .globl      _copyKernel


