;--------------------------------------------------------------------------------------------------
; Filename         : RUNDEFS.H
; Last Modified    : 26 Dec 2001.
; Version          : 1.3
; Originator       : Texas Instruments, DSP Digital Control Systems Group.
;--------------------------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
; Description:
;
; This file contains the values of the runtime addresses of the Clear, Erase and
; program algorithms. The copy routines use these addresses to copy the flash 
; algorithms from flash memory (load address) to RAM (run address). The flash
; programming routines for the TMS320LF240x device must be run from RAM.
;-------------------------------------------------------------------------------
;--------------------------------------------------------------------------------------------------
; Revision History
; 
; Ver 1.0 (25 May 2001)
;          Comments: New implementation for embeddable flash algos.
; Ver 1.2 (16 Oct 2001)
;          Comments: Modified the header to std format. No functional changes.
; Ver 1.3 (26 Dec 2001)
;           Comments: No changes to this file. Changed version number only.
;--------------------------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
; Assembly options.
;-------------------------------------------------------------------------------
TRUE                    .set    0
FALSE                   .set    1

;-------------------------------------------------------------------------------
; Define the runtime memory addresses.
;-------------------------------------------------------------------------------
    .globl      ClearAlgoRunMain
    .globl      EraseAlgoRunMain
    .globl      ProgramAlgoRunMain
    .globl      ProgramAlgoRunSpl       
    .globl      ClearAlgoRunSpl         
    .globl      EraseAlgoRunSpl         

    .globl      KernelRun
    .globl      KernelStart
    .globl      KernelEnd
    

    .globl     ClearAlgoEndMain
    .globl     ProgramAlgoStartSpl
    .globl     EraseAlgoStartMain
    .globl     ProgramAlgoStartMain
    .globl     ClearAlgoEndSpl
    .globl     EraseAlgoEndMain
    .globl     EraseAlgoStartSpl
    .globl     ClearAlgoStartMain
    .globl     EraseAlgoEndSpl
    .globl     ProgramAlgoEndMain
    .globl     ClearAlgoStartSpl
    .globl     ProgramAlgoEndSpl


;-------------------------------------------------------------------------------
; Symbol declarations for the functions in the COPYALGO.ASM.
;-------------------------------------------------------------------------------
    .globl      COPY_CLEAR_ALGO
    .globl      COPY_ERASE_ALGO
    .globl      COPY_PROGRAM_ALGO
    .globl      COPY_KERNEL
    .globl      _copyClearAlgo
    .globl      _copyEraseAlgo
    .globl      _copyProgramAlgo
    .globl      _copyKernel


