#include "MW_F2838x_MemoryMap.h"
#ifdef CLA_BLOCK_INCLUDED
// Define a size for the CLA scratchpad area that will be used
// by the CLA compiler for local symbols and temps
// Also force references to the special symbols that mark the
// scratchpad are. 
CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start
#endif //CLA_BLOCK_INCLUDED
MEMORY
{
PAGE 0 :
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */
   BEGIN                    : origin = 0x000000,                length = 0x000002
   BEGIN_FLASH              : origin = 0x080000,                length = 0x000002
   #ifdef CLA_BLOCK_INCLUDED
        #if BOOT_FROM_FLASH
            RAMLS_PROG      : origin = 0x008000, 				length = 0x001800
        #else
            RAMLS_PROG      : origin = 0x008000, 				length = 0x002800
        #endif //BOOT_FROM_FLASH
        RAMLS_CLA_PROG      : origin = 0x00B000, 				length = 0x001000
   #else
        #if BOOT_FROM_FLASH
            RAMLS_PROG      : origin = 0x008000, 				length = 0x002800
        #else
            RAMLS_PROG      : origin = 0x008000, 				length = 0x004000
        #endif //BOOT_FROM_FLASH
   #endif //CLA_BLOCK_INCLUDED
   
   #ifdef CPU1       
        #if (CPU1_RAMGS_PROG_LENGTH > 0)
            RAMGS_PROG      : origin = CPU1_RAMGS_PROG_START, 	length = CPU1_RAMGS_PROG_LENGTH
        #endif //(CPU1_RAMGS_PROG_LENGTH > 0)
   #else
        #if (CPU2_RAMGS_PROG_LENGTH > 0)
            RAMGS_PROG      : origin = CPU2_RAMGS_PROG_START, 	length = CPU2_RAMGS_PROG_LENGTH
       #endif //(CPU2_RAMGS_PROG_LENGTH > 0)
   #endif //CPU1

   /* Flash sectors */
   FLASHA_N                 : origin = 0x080002, 				length = 0x03FFFE	/* on-chip Flash */ 
   RESET                    : origin = 0x3FFFC0,                length = 0x000002
   
PAGE 1 :
   BOOT_RSVD           		: origin = 0x000002, 				length = 0x0001AE     /* Part of M0, BOOT rom will use this for stack */
   RAMM0M1                  : origin = 0x0001B0,                length = 0x000650
   RAMD0D1                  : origin = 0x00C000,                length = 0x001000
   
   #ifdef CLA_BLOCK_INCLUDED
        #if BOOT_FROM_FLASH
            RAMLS_CLA_DATA  : origin = 0x009800, 				length = 0x001800
        #else
            RAMLS_CLA_DATA  : origin = 0x00A800, 				length = 0x000800
        #endif //BOOT_FROM_FLASH
   #else
        #if BOOT_FROM_FLASH
            RAMLS_DATA      : origin = 0x00A800, 				length = 0x001800
        #endif //BOOT_FROM_FLASH
   #endif //CLA_BLOCK_INCLUDED
   
   #ifdef CPU1       
        RAMGS_DATA       	: origin = CPU1_RAMGS_DATA_START, 	length = CPU1_RAMGS_DATA_LENGTH
   #else	
		RAMGS_DATA       	: origin = CPU2_RAMGS_DATA_START, 	length = CPU2_RAMGS_DATA_LENGTH
   #endif //CPU1
   
   RAMGS_IPCBuffCPU1        : origin = RAMGS_IPC_CPU1_START,          length = RAMGS_IPC_CPU1_LENGTH
   RAMGS_IPCBuffCPU2        : origin = RAMGS_IPC_CPU2_START,          length = RAMGS_IPC_CPU2_LENGTH
   
   CLA1_MSGRAMLOW           : origin = 0x001480,                length = 0x000080
   CLA1_MSGRAMHIGH          : origin = 0x001500,                length = 0x000080
   
   CPU1TOCPU2RAM            : origin = 0x03A000,                length = 0x000800
   CPU2TOCPU1RAM            : origin = 0x03B000,                length = 0x000800
   
   CPUTOCMRAM               : origin = 0x039000,                length = 0x000800
   CMTOCPURAM               : origin = 0x038000,                length = 0x000800
   
   CANA_MSG_RAM             : origin = 0x049000,                length = 0x000800
   CANB_MSG_RAM             : origin = 0x04B000,                length = 0x000800
   
   #ifdef EMIF1_CS0_INCLUDED
      EMIF1_CS0_MEMORY    : origin = 0x80000000,                length = 0x10000000
   #endif //EMIF1_CS0_INCLUDED
   #ifdef EMIF1_CS2_INCLUDED
      EMIF1_CS2_MEMORY    : origin = 0x00100000,                length = 0x00200000
   #endif //EMIF1_CS2_INCLUDED
   #ifdef EMIF1_CS3_INCLUDED
      EMIF1_CS3_MEMORY    : origin = 0x00300000, 				length = 0x00080000
   #endif //EMIF1_CS3_INCLUDED				
   #ifdef EMIF1_CS4_INCLUDED				
      EMIF1_CS4_MEMORY    : origin = 0x00380000, 				length = 0x00060000
   #endif //EMIF1_CS4_INCLUDED				
   #ifdef EMIF2_CS0_INCLUDED				
      EMIF2_CS0_MEMORY    : origin = 0x90000000, 				length = 0x10000000
   #endif //EMIF2_CS0_INCLUDED				
   #ifdef EMIF2_CS2_INCLUDED				
      EMIF2_CS2_MEMORY    : origin = 0x00002000, 				length = 0x00001000
   #endif //EMIF2_CS2_INCLUDED
}

SECTIONS
{
#if BOOT_FROM_FLASH
   /* Allocate program areas: */
   codestart                : > BEGIN_FLASH,              PAGE = 0,        ALIGN(8)
   .text                    : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
   .cinit                   : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
   .switch                  : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
    #if defined(__TI_EABI__)
        .init_array         : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
       /* Initalized sections go in Flash */
       .const               : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
       .data                : > RAMGS_DATA,               PAGE = 1
       .TI.ramfunc          : {} LOAD = FLASHA_N,
                             RUN = RAMLS_PROG,
                             LOAD_START(RamfuncsLoadStart),
                             LOAD_SIZE(RamfuncsLoadSize),
                             LOAD_END(RamfuncsLoadEnd),
                             RUN_START(RamfuncsRunStart),
                             RUN_SIZE(RamfuncsRunSize),
                             RUN_END(RamfuncsRunEnd),
                             PAGE = 0, ALIGN(8)

       ramfuncs          	: LOAD = FLASHA_N,
                             RUN = RAMLS_PROG,
                             LOAD_START(MW_RamfuncsLoadStart),
                             LOAD_SIZE(MW_RamfuncsLoadSize),
                             LOAD_END(MW_RamfuncsLoadEnd),
                             RUN_START(MW_RamfuncsRunStart),
                             RUN_SIZE(MW_RamfuncsRunSize),
                             RUN_END(MW_RamfuncsRunEnd),
                             PAGE = 0, ALIGN(8)
    #else
        .pinit              : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
       /* Initalized sections go in Flash */
       .econst              : > FLASHA_N,                 PAGE = 0,        ALIGN(8)
       .TI.ramfunc          : {} LOAD = FLASHA_N,
                             RUN = RAMLS_PROG,
                             LOAD_START(_RamfuncsLoadStart),
                             LOAD_SIZE(_RamfuncsLoadSize),
                             LOAD_END(_RamfuncsLoadEnd),
                             RUN_START(_RamfuncsRunStart),
                             RUN_SIZE(_RamfuncsRunSize),
                             RUN_END(_RamfuncsRunEnd),
                             PAGE = 0, ALIGN(8)

        ramfuncs          	: LOAD = FLASHA_N,
                             RUN = RAMLS_PROG,
                             LOAD_START(_MW_RamfuncsLoadStart),
                             LOAD_SIZE(_MW_RamfuncsLoadSize),
                             LOAD_END(_MW_RamfuncsLoadEnd),
                             RUN_START(_MW_RamfuncsRunStart),
                             RUN_SIZE(_MW_RamfuncsRunSize),
                             RUN_END(_MW_RamfuncsRunEnd),
                             PAGE = 0, ALIGN(8)
    #endif // defined(__TI_EABI__)
    #ifdef CLA_BLOCK_INCLUDED
            #if defined(__TI_EABI__)
                /* CLA specific sections */
                Cla1Prog    : LOAD = FLASHA_N,
                              RUN = RAMLS_CLA_PROG,
                              LOAD_START(Cla1funcsLoadStart),
                              LOAD_END(Cla1funcsLoadEnd),
                              RUN_START(Cla1funcsRunStart),
                              LOAD_SIZE(Cla1funcsLoadSize),
                              PAGE = 0, ALIGN(8)
                .const_cla  : LOAD = FLASHA_N,
                              RUN = RAMLS_CLA_DATA,
                              RUN_START(Cla1ConstRunStart),
                              LOAD_START(Cla1ConstLoadStart),
                              LOAD_SIZE(Cla1ConstLoadSize),
                              PAGE = 1
                .bss        : > RAMGS_DATA,               PAGE = 1
                .bss:output : > RAMGS_DATA,               PAGE = 1
                .bss:cio    : > RAMGS_DATA,               PAGE = 1
            #else
                /* CLA specific sections */
                Cla1Prog    : LOAD = FLASHA_N,
                              RUN = RAMLS_CLA_PROG,
                              LOAD_START(_Cla1funcsLoadStart),
                              LOAD_END(_Cla1funcsLoadEnd),
                              RUN_START(_Cla1funcsRunStart),
                              LOAD_SIZE(_Cla1funcsLoadSize),
                              PAGE = 0, ALIGN(8)
                .const_cla	: LOAD = FLASHA_N,
                              RUN = RAMLS_CLA_DATA,
                              RUN_START(_Cla1ConstRunStart),
                              LOAD_START(_Cla1ConstLoadStart),
                              LOAD_SIZE(_Cla1ConstLoadSize),
                              PAGE = 1
                .ebss       : > RAMGS_DATA,               PAGE = 1
            #endif // defined(__TI_EABI__)
       #else
            #if defined(__TI_EABI__)
                .bss        : >> RAMGS_DATA | RAMLS_DATA, PAGE = 1
            #else
                .ebss       : >> RAMGS_DATA | RAMLS_DATA, PAGE = 1
            #endif // defined(__TI_EABI__)
       #endif //CLA_BLOCK_INCLUDED

   /* Allocate IQmath areas: */
   IQmath			        : > FLASHA_N,                 PAGE = 0,      ALIGN(8)  /* Math Code */
   IQmathTables		        : > FLASHA_N,                 PAGE = 0,      ALIGN(8)   
      
#else
   codestart        	    : > BEGIN,                    PAGE = 0
   .text                    : >> RAMLS_PROG | RAMGS_PROG, PAGE = 0
   .cinit           	    : > RAMLS_PROG,               PAGE = 0
   .switch          	    : > RAMLS_PROG,               PAGE = 0
   .TI.ramfunc              : > RAMLS_PROG,               PAGE = 0
   ramfuncs         	    : > RAMLS_PROG,               PAGE = 0
    #if defined(__TI_EABI__)
        .bss                : > RAMGS_DATA,               PAGE = 1
        .bss:output         : > RAMGS_DATA,               PAGE = 1
        .bss:cio            : > RAMGS_DATA,               PAGE = 1
        .init_array         : > RAMLS_PROG,               PAGE = 0
        .const              : > RAMLS_PROG,               PAGE = 0
        .data               : > RAMGS_DATA,               PAGE = 1
    #else
        .ebss               : > RAMGS_DATA,               PAGE = 1
        .pinit              : > RAMLS_PROG,               PAGE = 0
        .const              : > RAMLS_PROG,               PAGE = 0
    #endif // defined(__TI_EABI__)
   /* Allocate IQ math areas: */
   IQmath				    : > RAMLS_PROG,               PAGE = 0	/* Math Code */
   IQmathTables			    : > RAMLS_PROG,               PAGE = 0
   #ifdef CLA_BLOCK_INCLUDED
       /* CLA specific sections */
       Cla1Prog             : > RAMLS_CLA_PROG,           PAGE = 0
       .const_cla           : > RAMLS_CLA_DATA,           PAGE = 1
   #endif //CLA_BLOCK_INCLUDED
#endif //BOOT_FROM_FLASH 
    #if defined(__TI_EABI__)
        .sysmem             : > RAMD0D1,                  PAGE = 1
    #else
       .esysmem             : > RAMD0D1,                  PAGE = 1
       .cio                 : > RAMGS_DATA,               PAGE = 1
    #endif // defined(__TI_EABI__)
   .stack                   : > RAMM0M1,                  PAGE = 1
   .reset                   : > RESET,                    PAGE = 0,      TYPE = DSECT /* not used, */
   MSGRAM_CPU1_TO_CPU2      : > CPU1TOCPU2RAM,            PAGE = 1
   MSGRAM_CPU2_TO_CPU1      : > CPU2TOCPU1RAM,            PAGE = 1
   MSGRAM_CPU_TO_CM         : > CPUTOCMRAM,               PAGE = 1
   MSGRAM_CM_TO_CPU         : > CMTOCPURAM,               PAGE = 1   
   #if defined(EMIF1_CS0_INCLUDED) && defined(EMIF2_CS0_INCLUDED)
      .farbss               : > EMIF1_CS0_MEMORY | EMIF2_CS0_MEMORY,      PAGE = 1
      .farconst             : > EMIF1_CS0_MEMORY | EMIF2_CS0_MEMORY,      PAGE = 1
   #elif !defined(EMIF1_CS0_INCLUDED) && defined(EMIF2_CS0_INCLUDED)
      .farbss               : > EMIF2_CS0_MEMORY,          PAGE = 1
      .farconst             : > EMIF2_CS0_MEMORY,          PAGE = 1
   #elif defined(EMIF1_CS0_INCLUDED) && !defined(EMIF2_CS0_INCLUDED)
      .farbss              : > EMIF1_CS0_MEMORY,          PAGE = 1
      .farconst            : > EMIF1_CS0_MEMORY,          PAGE = 1
   #else
      //No EMIF memory sections
   #endif //defined(EMIF1_CS0_INCLUDED) && defined(EMIF2_CS0_INCLUDED)
   #ifdef EMIF1_CS0_INCLUDED
      Em1Cs0               : > EMIF1_CS0_MEMORY,          PAGE = 1
   #endif //EMIF1_CS0_INCLUDED
   #ifdef EMIF2_CS0_INCLUDED
       Em2Cs0              : > EMIF2_CS0_MEMORY,          PAGE = 1
   #endif //EMIF2_CS0_INCLUDED
   #ifdef EMIF1_CS2_INCLUDED
       Em1Cs2              : > EMIF1_CS2_MEMORY,          PAGE = 1
   #endif //EMIF1_CS2_INCLUDED
   #ifdef EMIF1_CS3_INCLUDED
       Em1Cs3              : > EMIF1_CS3_MEMORY,          PAGE = 1
   #endif //EMIF1_CS3_INCLUDED
   #ifdef EMIF1_CS4_INCLUDED
       Em1Cs4              : > EMIF1_CS4_MEMORY,          PAGE = 1
   #endif //EMIF1_CS4_INCLUDED
   #ifdef MW_EMIF2_CS2_INCLUDED
       Em2Cs2              : > EMIF2_CS2_MEMORY,          PAGE = 1
   #endif //MW_EMIF2_CS2_INCLUDED   
   #ifdef CLA_BLOCK_INCLUDED
       /* CLA C compiler sections */
       //
       // Must be allocated to memory the CLA has write access to
       //
       Cla1DataRam0		    : > RAMLS_CLA_DATA,           PAGE = 1

       Cla1ToCpuMsgRAM      : > CLA1_MSGRAMLOW, type=NOINIT               PAGE = 1
       CpuToCla1MsgRAM      : > CLA1_MSGRAMHIGH, type=NOINIT              PAGE = 1
       CLAscratch           :
                             { 
							     *.obj(CLAscratch)
							     . += CLA_SCRATCHPAD_SIZE;
							     *.obj(CLAscratch_end) 
						     } >  RAMLS_CLA_DATA,         PAGE = 1

       .scratchpad          : > RAMLS_CLA_DATA,           PAGE = 1
       .bss_cla		        : > RAMLS_CLA_DATA,           PAGE = 1
   #endif //CLA_BLOCK_INCLUDED

  #if defined(CPU1)  
       /* The following section definitions are required when using the IPC API Drivers */
            GROUP : > CPU1TOCPU2RAM,                      PAGE = 1
            {
                PUTBUFFER 
                PUTWRITEIDX 
                GETREADIDX 
                WRITEFLAG1CPU1
                WRITEFLAG2CPU1
                READFLAG1CPU1
                READFLAG2CPU1
            }
            GROUP : > CPU2TOCPU1RAM,                      PAGE = 1
            {
                GETBUFFER :     TYPE = DSECT
                GETWRITEIDX :   TYPE = DSECT
                PUTREADIDX :    TYPE = DSECT
                WRITEFLAG1CPU2 : TYPE = DSECT
                WRITEFLAG2CPU2 : TYPE = DSECT
                READFLAG1CPU2  : TYPE = DSECT
                READFLAG2CPU2  : TYPE = DSECT
            }
   #else
       /* The following section definitions are required when using the IPC API Drivers */ 
            GROUP : > CPU2TOCPU1RAM,                      PAGE = 1
            {
                PUTBUFFER 
                PUTWRITEIDX 
                GETREADIDX 
                WRITEFLAG1CPU2
                WRITEFLAG2CPU2
                READFLAG1CPU2			
                READFLAG2CPU2			
            }
            GROUP : > CPU1TOCPU2RAM,                      PAGE = 1
            {
                GETBUFFER :     TYPE = DSECT
                GETWRITEIDX :   TYPE = DSECT
                PUTREADIDX :    TYPE = DSECT
                WRITEFLAG1CPU1 : TYPE = DSECT
                WRITEFLAG2CPU1 : TYPE = DSECT
                READFLAG1CPU1  : TYPE = DSECT
                READFLAG2CPU1  : TYPE = DSECT
            }
   #endif //CPU1

    GROUP : > CPUTOCMRAM,                                 PAGE = 1
    {
        PUTBUFFERCPUX
        PUTWRITEIDXCPUX
        GETREADIDXCPUX
        WRITEFLAG1CPUX
        WRITEFLAG2CPUX
        READFLAG1CPUX
        READFLAG2CPUX
        VECTORDATA
    }
    GROUP : > CMTOCPURAM,                                 PAGE = 1
    {
        GETBUFFERCM :     TYPE = DSECT
        GETWRITEIDXCM :   TYPE = DSECT
        PUTREADIDXCM :    TYPE = DSECT
        WRITEFLAG1CM : TYPE = DSECT
        WRITEFLAG2CM : TYPE = DSECT
        READFLAG1CM  : TYPE = DSECT
        READFLAG2CM  : TYPE = DSECT
        VECTORDATA   : TYPE = DSECT
    } 

	GROUP : > RAMGS_IPCBuffCPU1,                          PAGE = 1
	{
		CPU1TOCPU2GSRAM
	}
	GROUP : > RAMGS_IPCBuffCPU2,                          PAGE = 1
	{
		CPU2TOCPU1GSRAM
	}
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/