/*####################################################
 * FILE: MW_c28xGlobalInterrupts.c
 * TITLE: Common board support functions specific for C2000 targets
 * Copyright 2020 The MathWorks, Inc.
 * ####################################################*/

/* ***************************************************************************/
/* the includes */
#include "MW_target_hardware_resources.h"

/* ***************************************************************************/
/* the globals */
Uint16 MW_InterruptDisableLock;


/* ***************************************************************************/
/* the functions*/

/* Global interrupt enable function */
void globalInterruptEnable(void)
{
    if (0 == MW_InterruptDisableLock)
    {
        /* Enabled the interrupts only if it was enabled before */
        __enable_interrupts(); /* Enable Global Interrupt INTM and realtime interrupt DBGM */
    }
}

/* Global interrupt disable function */
void globalInterruptDisable(void)
{
    /* Disable Global Interrupt INTM using __disable_interrupts()
     The function will return 0 if interrupt was enabled previously
     otherwise it will return 1 if the interrupt was previously disabled*/
    MW_InterruptDisableLock = __disable_interrupts();
    MW_InterruptDisableLock &= 0x1;   
}
