#include "F2837xD_Ipc_drivers.h"
#include "driverlib.h"
#include "device.h"

#include "stdio.h"
#include "string.h"

#include "led.h"
#include "key.h"
#include "sci.h"

#include "micro_printf.h"
#include "board.h"
#include "spi_test_v1.h"



#define delay_s(x) SysCtl_delay(((((long double)(x)) / (1.0L /  \
                              (long double)DEVICE_SYSCLK_FREQ)) - 9.0L) / 5.0L)
#define delay_ms(x) SysCtl_delay(((((long double)(x)) / (1000.0L /  \
                              (long double)DEVICE_SYSCLK_FREQ)) - 9.0L) / 5.0L)
#define delay_us(x) SysCtl_delay(((((long double)(x)) / (1000000.0L /  \
                              (long double)DEVICE_SYSCLK_FREQ)) - 9.0L) / 5.0L)

uint16_t KEY_Value = 0;


//int aaa =9876;
//uint32_t ccc =0;
//float bbb =22.22;

void main(void)
{
//ȷģʽ
#ifdef _STANDALONE
#ifdef _FLASH
    IPCBootCPU2(C1C2_BROM_BOOTMODE_BOOT_FROM_FLASH);
#else
    IPCBootCPU2(C1C2_BROM_BOOTMODE_BOOT_FROM_RAM);
#endif
#endif
    //豸ʼ  ر˴󲿷裬Ҫõȥ
    Device_init();
    //GPIOʼ
    Device_initGPIO();
//    initADC();
//    Interrupt_initModule();//ʼPIEPIEĴCPUжϡ
//    Interrupt_initVectorTable();//ָshell InterruptָʼPIE
    Board_init();
//    Interrupt_register(INT_ADCA1, adcA1ISR); // ȷʹӲƥжϺ(for test)
    // ʹADCжϲȷ
//    Interrupt_enable(INT_ADCA1);   //for test
//    EINT;
//    SCISendData("ADC Interrupt enabled\r\n");
//    SCISendData("Interrupt registered\r\n");
//    Interrupt_enableMaster(); //ж
    //ж
//    Interrupt_enableMaster();

    //LEDʼ
    LED_Init();
    //KEYʼ
    KEY_Init();
    //ʼ
    spi_initController(); // spi_test.cеĳʼ

    SCISendData("4.System initialization complete\r\n");

    LED1_OFF;
    LED2_OFF;

    while(1)
    {
        //ccc = Float_to_u32(bbb);
        //micro_print("hello %d %f\r\n",aaa,ccc);
        spi_updateController(); //  SPI ״̬

                // ȡǰ¶
//        short currentTemperature = read_current_temperature();

                // ӡ¶ȺϢ
//        micro_print("Temperature: %d %f\r\n", currentTemperature);
        delay_ms(1000);
        LED2_TOGGLE;

        KEY_Value = KEY_Scan(1);
        if(KEY_Value == KEY1_PRES)
        {
            LED1_ON;
            LED2_OFF;
        }
        else if(KEY_Value == KEY2_PRES)
        {
            LED2_ON;
            LED1_OFF;
        }

    }
}
