/*
 * sci.c
 *
 *  Created on: 2023623
 *      Author: wdh19
 */

#include "sci.h"

__interrupt void SCIA_RXFIFOISR(void)
{
    uint16_t i;
    SCI_clearInterruptStatus(SCIA_BASE, SCI_INT_RXFF);
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);

    while(SCI_getRxFIFOStatus(SCIA_BASE)!=SCI_FIFO_RX0)
    {
        i=SCI_readCharNonBlocking(SCIA_BASE);
        SCI_writeCharBlockingFIFO(SCIA_BASE,i);
    }

}

void Board_init()
{
    EALLOW;

    PinMux_init();//GPIO
    SCI_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX 
//
//*****************************************************************************
void PinMux_init()
{
    //
    // CPU1ģPinMux
    //
    //
    // SCIA -> mySCI0 Pinmux
    //
    GPIO_setMasterCore(mySCI0_SCIRX_GPIO, GPIO_CORE_CPU1);//ÿƺΪCPU1
    GPIO_setPinConfig(mySCI0_SCIRX_PIN_CONFIG);//Ƭ
    GPIO_setPadConfig(mySCI0_SCIRX_GPIO, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(mySCI0_SCIRX_GPIO, GPIO_QUAL_ASYNC);//޲˲

    GPIO_setMasterCore(mySCI0_SCITX_GPIO, GPIO_CORE_CPU1);//ÿƺΪCPU1
    GPIO_setPinConfig(mySCI0_SCITX_PIN_CONFIG);//Ƭ
    GPIO_setPadConfig(mySCI0_SCITX_GPIO, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);
    GPIO_setQualificationMode(mySCI0_SCITX_GPIO, GPIO_QUAL_ASYNC);//޲˲


}

//*****************************************************************************
//
// SCI Configurations
//
//*****************************************************************************
void SCI_init(){
    mySCI0_init();
}

void mySCI0_init(){
    //SCI
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SCIA);//ʹӦʱӣ

    //һЩʼ
    //SCIжԴ
    SCI_clearInterruptStatus(mySCI0_BASE, SCI_INT_RXFF | SCI_INT_TXFF | SCI_INT_FE | SCI_INT_OE | SCI_INT_PE | SCI_INT_RXERR | SCI_INT_RXRDY_BRKDT | SCI_INT_TXRDY);
    //FIFO־״̬
    SCI_clearOverflowStatus(mySCI0_BASE);
    SCI_resetTxFIFO(mySCI0_BASE);//λTX FIFO
    SCI_resetRxFIFO(mySCI0_BASE);//λRX FIFO
    SCI_resetChannels(mySCI0_BASE);//SCIͺͽͨ

    // SCIA
    SCI_setConfig(mySCI0_BASE, DEVICE_LSPCLK_FREQ, mySCI0_BAUDRATE, (SCI_CONFIG_WLEN_8|SCI_CONFIG_STOP_ONE|SCI_CONFIG_PAR_NONE));
    //ִһλSCIбĽ״̬־
    SCI_performSoftwareReset(mySCI0_BASE);// ʼSCIAFIFO

    //FIFO
    SCI_setFIFOInterruptLevel(mySCI0_BASE, SCI_FIFO_TX2, SCI_FIFO_RX1);//FIFO
    SCI_enableFIFO(mySCI0_BASE);////ʹSCIA_FIFO
    //ʹ SCI
    SCI_enableModule(mySCI0_BASE);//ʹܷͺͽա

    //ж
    Interrupt_register(INT_SCIA_RX, SCIA_RXFIFOISR);        //עSCIA_RX
    SCI_enableInterrupt(SCIA_BASE, SCI_INT_RXFF);           //ʹRX_FIFOж
    SCI_disableInterrupt(SCIA_BASE, SCI_INT_RXERR);         //ʧRX_ERRж
    Interrupt_enable(INT_SCIA_RX);                          //ʹSCIAж
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP9);          //GROUP9

}





