***********************************************************************
* File: InitExtMemIf.asm
* Devices: TMS320F2833x
* Author: David M. Alter, Texas Instruments Inc.
* History:
*   06/22/12 - original (D. Alter)
***********************************************************************
    .ref _c_int00
	.def InitExtMemIf

***********************************************************************
* Register Definitions
***********************************************************************
PCLKCR3		.set	0x00007020
;XTIMING7	.set	0x00000B2E
XTIMING6	.set	0x00000B2C
XINTFCNF2	.set	0x00000B34
GPAMUX2		.set    0x00006F88
GPBMUX1		.set    0x00006F96
GPCMUX1		.set    0x00006FA6
GPCMUX2		.set    0x00006FA8

***********************************************************************
* Function: InitExtMemIf
*
* Description: Initialized the external memory interface and pins
***********************************************************************
	.text
InitExtMemIf:
	EALLOW					;Enable EALLOW protected register access

;-----------------------------------
; PCLKCR3 Register
;
; Just set the bit we need (XINTFENCLK)
;-----------------------------------
    MOVZ DP, #PCLKCR3>>6	;Set data page for PCLKCR3 register
	OR @PCLKCR3, #0x1000	;Set XINTFENCLK bit (enable XINTF clock)

;-----------------------------------
; XINTFCNF2 Register
;
; Bits     Value   Name        Description
; 31-19    0's     rsvd
; 18-16    000     XTIMCLK     000=SYSCLKOUT/1, 001=SYSCLKOUT/2
; 15-12    0000    rsvd
; 11       0       HOLDAS      read-only
; 10       0       HOLDS       read-only
; 9        0       HOLD        0=HOLDn pin enabled, 1=HOLDn pin disabled
; 8        0       rsvd
; 7-6      00      WLEVEL      ready-only
; 5-4      00      rsvd
; 3         1      CLKOFF      0=XCLKOUT enable, 1=XCLKOUT disabled
; 2         1      CLKMODE     0=XCLKOUT is XTIMCLK, 1=XCLKOUT is XTIMCLK/2
; 1-0      11      WRBUFF      number of write buffer levels (max=3)
;
; value = 0x0000000F
;-----------------------------------
XINTFCNF2_MSW	.set	0x0000
XINTFCNF2_LSW	.set	0x000F

	MOVZ DP, #XINTFCNF2>>6
	MOV	@(XINTFCNF2+0), #XINTFCNF2_LSW
	MOV @(XINTFCNF2+1), #XINTFCNF2_MSW

;-----------------------------------
; XTIMING7 Register
;
; Bits     Value   Name        Description
; 31-23    0's     rsvd
; 22       0       X2TIMING    0=timings scaled 1:1, 1=timings scaled 2:1
; 21-18    0000    rsvd
; 17-16    11      XSIZE       01=32-bit bus, 11=16-bit bus
; 15       0       READYMODE   0=XREADY synchronous , 1=XREADY asynchronous
; 14       0       USEREADY    0=ignor XREADY, 1=use XREADY
; 13-12    01      XRDLEAD     read lead timing
; 11-9     011     XRDACTIVE   read active timing, [3]+1 for 10ns SRAM, [4]+1 for 12ns SRAM.  >(1.5ns F28335 + 12ns Dout + 14ns setup)
; 8-7      00      XRDTRAIL    read trail timing
; 6-5      01      XWRLEAD     write lead timing
; 4-2     010      XWRACTIVE   write active timing, [1]+1 = 2 clock cycles
; 1-0      01      XWRTRAIL    write trail timing
;
; value = 0x00031629
;-----------------------------------
XTIMING6_MSW	.set	0x0043
XTIMING6_LSW	.set	0xFFFF

    MOVZ DP, #XTIMING6>>6
	MOV	@(XTIMING6+0), #XTIMING6_LSW
	MOV @(XTIMING6+1), #XTIMING6_MSW

;-----------------------------------
; GPCMUX1 Register
;
; Bits     Value   Name        Description
; 31-30    10      GPIO79      10 = XD0
; 29-28    10      GPIO78      10 = XD1
; 27-26    10      GPIO77      10 = XD2
; 25-24    10      GPIO76      10 = XD3
; 23-22    10      GPIO75      10 = XD4
; 21-20    10      GPIO74      10 = XD5
; 19-18    10      GPIO73      10 = XD6
; 17-16    10      GPIO72      10 = XD7
; 15-14    10      GPIO71      10 = XD8
; 13-12    10      GPIO70      10 = XD9
; 11-10    10      GPIO69      10 = XD10
; 9-8      10      GPIO68      10 = XD11
; 7-6      10      GPIO67      10 = XD12
; 5-4      10      GPIO66      10 = XD13
; 3-2      10      GPIO65      10 = XD14
; 1-0      10      GPIO64      10 = XD15
;
; value = 0xAAAAAAAA
;-----------------------------------
GPCMUX1_MSW		.set	0xAAAA
GPCMUX1_LSW		.set	0xAAAA

    MOVZ DP, #GPCMUX1>>6
	MOV	@(GPCMUX1+0), #GPCMUX1_LSW
	MOV @(GPCMUX1+1), #GPCMUX1_MSW

;-----------------------------------
; GPCMUX2 Register
;
; Bits     Value   Name        Description
; 31-16    0's     rsvd
; 15-14    10      GPIO87      10 = XA15
; 13-12    10      GPIO86      10 = XA14
; 11-10    10      GPIO85      10 = XA13
; 9-8      10      GPIO84      00 = XA12
; 7-6      10      GPIO83      00 = XA11
; 5-4      10      GPIO82      00 = XA10
; 3-2      10      GPIO81      00 = XA9
; 1-0      10      GPIO80      00 = XA8
;
; value = 0x0000AAAA
;-----------------------------------
GPCMUX2_MSW		.set	0x0000
GPCMUX2_LSW		.set	0xAAAA

    MOVZ DP, #GPCMUX2>>6
	MOV	@(GPCMUX2+0), #GPCMUX2_LSW
	MOV @(GPCMUX2+1), #GPCMUX2_MSW

;-----------------------------------
; GPBMUX1 Register
;
; Bits     Value   Name        Description
; 31-30    10      GPIO47      10 = XA7
; 29-28    10      GPIO46      10 = XA6
; 27-26    10      GPIO45      10 = XA5
; 25-24    10      GPIO44      10 = XA4
; 23-22    10      GPIO43      10 = XA3
; 21-20    10      GPIO42      10 = XA2
; 19-18    10      GPIO41      10 = XA1
; 17-16    10      GPIO40      10 = XA0/XWE1n
; 15-14    10      GPIO39      10 = XA16
; 13-12    10      GPIO38      10 = XWE0n
; 11-10    10      GPIO37      10 = XZCS7n
; 9-8      00      GPIO36      00 = GPIO36
; 7-6      00      GPIO35      00 = GPIO35
; 5-4      00      GPIO34      00 = GPIO34
; 3-2      00      GPIO33      00 = GPIO33
; 1-0      00      GPIO32      00 = GPIO32
;
; value = 0xAAAAA800
;-----------------------------------
GPBMUX1_MSW		.set	0xFFFF
GPBMUX1_LSW		.set	0xFFC0

    MOVZ DP, #GPBMUX1>>6
	MOV	@(GPBMUX1+0), #GPBMUX1_LSW
	MOV @(GPBMUX1+1), #GPBMUX1_MSW

;-----------------------------------
; GPAMUX2 Register
;
; Bits     Value   Name        Description
; 31-30    10      GPIO31      10 = XA17
; 29-28    10      GPIO30      10 = XA18
; 27-26    00      GPIO29      00 = GPIO29
; 25-24    00      GPIO28      00 = GPIO28
; 23-22    00      GPIO27      00 = GPIO27
; 21-20    00      GPIO26      00 = GPIO26
; 19-18    00      GPIO25      00 = GPIO25
; 17-16    00      GPIO24      00 = GPIO24
; 15-14    00      GPIO23      00 = GPIO23
; 13-12    00      GPIO22      00 = GPIO22
; 11-10    00      GPIO21      00 = GPIO21
; 9-8      00      GPIO20      00 = GPIO20
; 7-6      00      GPIO19      00 = GPIO19
; 5-4      00      GPIO18      00 = GPIO18
; 3-2      00      GPIO17      00 = GPIO17
; 1-0      00      GPIO16      00 = GPIO16
;
; value = 0xA0000000
;-----------------------------------
GPAMUX2_MSW		.set	0xFF00
GPAMUX2_LSW		.set	0x0000

    MOVZ DP, #GPAMUX2>>6
	MOV	@(GPAMUX2+0), #GPAMUX2_LSW
	MOV @(GPAMUX2+1), #GPAMUX2_MSW

	EDIS					;Disable EALLOW protected register access
    LB _c_int00				;Branch to start of boot.asm in RTS library

;end InitExtMemIf
***********************************************************************

	.end
; end of file InitExtMemIf.asm
