MEMORY
{
PAGE 0:
    BEGINRAM:	 origin=0x0,      length=0x2
    RAMM0:	     origin=0x2,      length=0x3fe
    OTP:	     origin=0x380400, length=0x400
    FLASH:	     origin=0x300000, length=0x3fff6
    BEGINFLASH:	 origin=0x33fff6, length=0x2
    CSM_PWL:	 origin=0x3f7ff8, length=0x8
    IQTABLES:	 origin=0x3fe000, length=0xb50
    IQTABLES2:	 origin=0x3feb50, length=0x8c
    FPUTABLES:	 origin=0x3febdc, length=0x6a0
    ROM:	     origin=0x3ff27c, length=0xd44
    RESET:	     origin=0x3fffc0, length=0x2
    VECTORS:	 origin=0x3fffc2, length=0x3e
    RAML0L3:	 origin=0x8000,   length=0x4000
    ADC_CAL:	 origin=0x380080, length=0x9
    ZONE7P:	     origin=0x100000, length=0x1ffff
PAGE 1:
    RAML4L7:	 origin=0xc000,   length=0x4000
    RAMM1:	     origin=0x400,    length=0x400
    /*ZONE7D:	     origin=0x210000, length=0x10000*/
}
#if BOOT_FROM_FLASH
SECTIONS
{
    .vectors:	     load = 0x000000000
    .text:	         > FLASH,      PAGE = 0
    .switch:	     > FLASH,      PAGE = 0
    .bss:	         > RAML4L7,    PAGE = 1
    .ebss:	         >ZONE7P,    PAGE = 0
    .far:	         > RAML0L3,    PAGE = 0
    .cinit:	         > FLASH,      PAGE = 0
    .pinit:	         > FLASH,      PAGE = 0
    .const:	         > FLASH,      PAGE = 0
    .econst:	     > FLASH,      PAGE = 0
    .reset:	         > RESET,      PAGE = 0, TYPE = DSECT
    .data:	         > RAML4L7,    PAGE = 1
    .cio:	         > RAML0L3,    PAGE = 0
    .sysmem:	     > RAML4L7,    PAGE = 1
    .esysmem:	     > RAML4L7,    PAGE = 1
    .stack:	         > RAMM1,      PAGE = 1
    .rtdx_text:	     > FLASH,      PAGE = 0
    .rtdx_data:	     > RAML4L7,    PAGE = 1
    IQmath:	         > FLASH,      PAGE = 0
    codestart:	     > BEGINFLASH, PAGE = 0
    csmpasswds:	     > CSM_PWL,    PAGE = 0
    csm_rsvd:	     > RAMM0,      PAGE = 0
    ramfuncs:	     LOAD = FLASH,
		RUN = RAML0L3,
		LOAD_START(_RamfuncsLoadStart),
		LOAD_END(_RamfuncsLoadEnd),
		RUN_START(_RamfuncsRunStart),
		PAGE = 0
    .adc_cal:	     > ADC_CAL,    PAGE = 0, TYPE = NOLOAD
    /*external_ram:	 > ZONE7D,     PAGE = 1*/
    IQmathTables:	 > IQTABLES,   PAGE = 0, TYPE = NOLOAD
    IQmathTables2:	 > IQTABLES2,  PAGE = 0, TYPE = NOLOAD
    FPUmathTables:	 > FPUTABLES,  PAGE = 0, TYPE = NOLOAD
}
#else
SECTIONS
{
    .vectors:	 load = 0x000000000
    .text:	         >> RAML0L3 | RAMM0,      PAGE = 0
    .switch:	     >> RAML0L3 | RAMM0,      PAGE = 0
    .bss:	         >  RAML4L7,              PAGE = 1
    .ebss:	         >  ZONE7P,              PAGE = 0
    .far:	         >> RAML0L3 | RAMM0,      PAGE = 0
    .cinit:	         > RAMM0,      PAGE = 0
    .pinit:	         >> RAML0L3 | RAMM0,      PAGE = 0
    .const:	         >  RAML4L7,              PAGE = 1
    .econst:	     >  RAML4L7,              PAGE = 1
    .reset:	         >  RESET,                PAGE = 0, TYPE = DSECT
    .data:	         >  RAML4L7,              PAGE = 1
    .cio:	         >> RAML0L3 | RAMM0,      PAGE = 0
    .sysmem:	     >  RAML4L7,              PAGE = 1
    .esysmem:	     >  RAML4L7,              PAGE = 1
    .stack:	         >  RAMM1,                PAGE = 1
    .rtdx_text:	     >> RAML0L3 | RAMM0,      PAGE = 0
    .rtdx_data:	     >  RAML4L7,              PAGE = 1
    IQmath:	         >> RAML0L3 | RAMM0,      PAGE = 0
    codestart:	     >  BEGINRAM,             PAGE = 0
    csmpasswds:	     >  CSM_PWL,              PAGE = 0
    csm_rsvd:	     >> RAML0L3 | RAMM0,      PAGE = 0
    ramfuncs:	     >  RAML0L3,              PAGE = 0
    .adc_cal:	     >  ADC_CAL,              PAGE = 0 , TYPE = NOLOAD
    /*external_ram:	 >  ZONE7D,               PAGE = 1*/
    IQmathTables:	 >  IQTABLES,             PAGE = 0 , TYPE = NOLOAD
    IQmathTables2:	 >  IQTABLES2,            PAGE = 0 , TYPE = NOLOAD
    FPUmathTables:	 >  FPUTABLES,            PAGE = 0 , TYPE = NOLOAD
}
#endif