//==============================================================================================//
//              LINKER FILE                                                                  	//
//=============================================================================================c//

/*
RAMLS0	: origin = 0x008000, length = 0x000800
RAMLS1	: origin = 0x008800, length = 0x000800
RAMLS2	: origin = 0x009000, length = 0x000800
RAMLS3	: origin = 0x009800, length = 0x000800
RAMLS4	: origin = 0x00A000, length = 0x000800
RAMLS5	: origin = 0x00A800, length = 0x000800

RAMGS0	: origin = 0x00C000, length = 0x001000
RAMGS1	: origin = 0x00D000, length = 0x001000
RAMGS2	: origin = 0x00E000, length = 0x001000
RAMGS3	: origin = 0x00F000, length = 0x001000
RAMGS4	: origin = 0x010000, length = 0x001000
RAMGS5	: origin = 0x011000, length = 0x001000
RAMGS6	: origin = 0x012000, length = 0x001000
RAMGS7	: origin = 0x013000, length = 0x001000
RAMGS8	: origin = 0x014000, length = 0x001000
RAMGS9	: origin = 0x015000, length = 0x001000
RAMGS10	: origin = 0x016000, length = 0x001000
RAMGS11	: origin = 0x017000, length = 0x001000
RAMGS12	: origin = 0x018000, length = 0x001000
RAMGS13	: origin = 0x019000, length = 0x001000
RAMGS14	: origin = 0x01A000, length = 0x001000
RAMGS15	: origin = 0x01B000, length = 0x001000

FLASHA	: origin = 0x080000, length = 0x002000
FLASHB	: origin = 0x082000, length = 0x002000
FLASHC	: origin = 0x084000, length = 0x002000
FLASHD	: origin = 0x086000, length = 0x002000
FLASHE	: origin = 0x088000, length = 0x008000
FLASHF	: origin = 0x090000, length = 0x008000
FLASHG	: origin = 0x098000, length = 0x008000
FLASHH	: origin = 0x0A0000, length = 0x008000
FLASHI	: origin = 0x0A8000, length = 0x008000
FLASHJ	: origin = 0x0B0000, length = 0x008000
FLASHK	: origin = 0x0B8000, length = 0x002000
FLASHL	: origin = 0x0BA000, length = 0x002000
FLASHM	: origin = 0x0BC000, length = 0x002000
FLASHN	: origin = 0x0BE000, length = 0x002000

CPU2TOCPU1RAM	: origin = 0x03F800, length = 0x000400
CPU1TOCPU2RAM	: origin = 0x03FC00, length = 0x000400

CANA_MSG_RAM  	: origin = 0x049000, length = 0x000800
CANB_MSG_RAM   	: origin = 0x04B000, length = 0x000800
*/

#define OLD_BOOT

MEMORY
{
	// PROGRAM MEMORY
	PAGE 0 :

#ifdef OLD_BOOT
		BEGIN:			origin = 0x080000, length = 0x000002	// Used for the "boot to Flash" bootloader mode
#else
		BEGIN:			origin = 0x088000, length = 0x000002
#endif

		RESET:			origin = 0x3FFFC0, length = 0x000002	// Part of VECTORS at 0x003FFFC0-0x003FFFFF

		// RAM BLOCKS

		RAMM0:			origin = 0x000122, length = 0x0002DE
		RAMD0:			origin = 0x00B000, length = 0x000800

		RAMGS0_5:		origin = 0x00C000, length = 0x006000

		// FLASH BLOCKS

#ifdef OLD_BOOT
		FLASHA:			origin = 0x080002, length = 0x001FFE
#else
		FLASHA:			origin = 0x080000, length = 0x002000
#endif
//		FLASHB:			origin = 0x082000, length = 0x002000
//		FLASHC:			origin = 0x084000, length = 0x002000
//		FLASHD:			origin = 0x086000, length = 0x002000	// *** DO NOT USE, USED FOR CONFIGURATION DATA! ***

#ifdef OLD_BOOT
		FLASHE:			origin = 0x088000, length = 0x008000
#else
		FLASHE:			origin = 0x088002, length = 0x007FFE
#endif

	// DATA MEMORY
	PAGE 1 :

		BOOT_RSVD:		origin = 0x000002, length = 0x000120	// Part of M0, BOOT rom will use this for stack

		// RAM BLOCKS

		RAMM1:			origin = 0x000400, length = 0x000400
		RAMD1:			origin = 0x00B800, length = 0x000800

		RAMGS6_7:		origin = 0x012000, length = 0x002000
}


SECTIONS
{
	// PROGRAM SECTIONS

	codestart:			> BEGIN		PAGE = 0, ALIGN(4)

	.text:				> FLASHE	PAGE = 0, ALIGN(4)
	.cinit:				> FLASHE	PAGE = 0, ALIGN(4)
	.pinit:				> FLASHE	PAGE = 0, ALIGN(4)

	.TI.ramfunc:		LOAD = FLASHE,
	                	RUN = RAMGS0_5,
	                 	LOAD_START(_RamfuncsLoadStart),
	                  	LOAD_SIZE(_RamfuncsLoadSize),
	                  	LOAD_END(_RamfuncsLoadEnd),
	                  	RUN_START(_RamfuncsRunStart),
	                  	RUN_SIZE(_RamfuncsRunSize),
	                  	RUN_END(_RamfuncsRunEnd),
	                 	PAGE = 0, ALIGN(4)

	// UNITIALIZED DATA SECTIONS

	.stack:				> RAMM1		PAGE = 1
	.ebss:				> RAMGS6_7	PAGE = 1
	.esysmem:			> RAMGS6_7	PAGE = 1

	// INITIALIZED SECTIONS

	.econst:			> FLASHE	PAGE = 0, ALIGN(4)
	.switch:			> FLASHE	PAGE = 0, ALIGN(4)

	.reset:				> RESET		PAGE = 0, TYPE = DSECT
}

//==============================================================================================//
//              END OF FILE                                                                   	//
//=============================================================================================c//
