/*
 * define.h
 *
 *  Created on: Oct 3, 2024
 *      Author: dmh141
 */

#ifndef DEFINE_H_
#define DEFINE_H_


#define SPI_CS_GPIO 66

#define CS_LOW                      GPIO_writePin(SPI_CS_GPIO, 0)
#define CS_HIGH                     GPIO_writePin(SPI_CS_GPIO, 1)

//
// Opcodes for the external flash (8-bit)
// See S25FL512S data sheet, table 47 (Command Summary).
//
#define FAST_READ4 0x0C  // read fast (4-byte address)
#define READ4      0x13  // read (4-byte address)
#define DOR4       0x3C  // read dual out (4-byte address)
#define QOR4       0x6C  // read quad out (4-byte address)
#define DIOR4      0xBC  // dual I/O read (4-byte address)
#define QIOR4      0xEC  // quad I/O read (4-byte address)
#define DDRFR4     0x0E  // read DDR fast (4-byte address)
#define DDRDIOR4   0xBE  // DDR dual I/O read (4-byte address)
#define DDRQIOR4   0xEE  // DDR quad I/O read (4-byte address)
#define PP4        0x12  // page program (4-byte address)
#define QPP4       0x34  // quad page program (4-byte address)
#define SE4        0xDC  // erase 256 kB (4-byte address)
#define RDSR1      0x05  // read status register 1
#define WREN       0x06  // write enable
#define BE         0x60  // bulk erase
#define RDID       0x9F  // read identification
#define BRRD       0x16  // bank register read


#endif /* DEFINE_H_ */
