//
// Included Files
//
#include "F2837xD_device.h"
#include "F2837xD_GlobalPrototypes.h"
#include "F021_F2837xD_C28x.h"
#include "pin_map.h"
#include "gpio.h"
#include "device.h"
#include "F2837xD_cputimervars.h"
#include "define.h"

#define RUNNING_WITHOUT_BOOTLOADER

//
// Function to send RDSR1 opcode and return the status of the external flash
// - base is the SPI base address
//
uint16_t queryDeviceId(uint32_t base)
{
    uint16_t temp1, temp2;



    // read the bank register to see if its configured for 32-bit addresses
    CS_LOW;
    SPI_transmitByte(base, BRRD);
    temp1 = SPI_receiveByte(base, 0x0);
    CS_HIGH;





    // Pull chip select low.
    CS_LOW;

    // Send RDID opcode
    SPI_transmitByte(base, RDID);

    // Send dummy data to read response
    temp1 = SPI_receiveByte(base, 0x0);
    temp2 = SPI_receiveByte(base, 0x0);

    // Pull chip select high.
    CS_HIGH;

    // Read the status from the receive buffer
    return(temp1);
}

void initializeExternalFlash(void) {


    /////////////////////////////////////////////////////////////////
    // GPIO PinMux for external flash
    /////////////////////////////////////////////////////////////////

    // CS for external flash
    GPIO_setPinConfig(GPIO_66_GPIO66);

    // MISO for external flash
    GPIO_setPinConfig(GPIO_63_SPISIMOB);
    GPIO_setPadConfig(63, GPIO_PIN_TYPE_STD);
//    GPIO_setDirectionMode(66, GPIO_DIR_MODE_IN); // trying this
    GPIO_setQualificationMode(63, GPIO_QUAL_ASYNC);

    // MOSI for external flash
    GPIO_setPinConfig(GPIO_64_SPISOMIB);
    GPIO_setPadConfig(64, GPIO_PIN_TYPE_STD);
//    GPIO_setDirectionMode(66, GPIO_DIR_MODE_OUT); // trying this
    GPIO_setQualificationMode(64, GPIO_QUAL_ASYNC);

    // clock for external flash
    GPIO_setPinConfig(GPIO_65_SPICLKB);
    GPIO_setPadConfig(65, GPIO_PIN_TYPE_STD);
//    GPIO_setDirectionMode(66, GPIO_DIR_MODE_OUT); // trying this
    GPIO_setQualificationMode(65, GPIO_QUAL_ASYNC);
    /////////////////////////////////////////////////////////////////





    /////////////////////////////////////////////////////////////////
    // CS GPIO initialization for external flash
    /////////////////////////////////////////////////////////////////
    GPIO_setPadConfig(66, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(66, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(66, GPIO_DIR_MODE_OUT);
    GPIO_setControllerCore(66, GPIO_CORE_CPU1);
    /////////////////////////////////////////////////////////////////





    /////////////////////////////////////////////////////////////////
    // SPI initialization for external flash
    /////////////////////////////////////////////////////////////////
    EALLOW;

    SPI_disableModule(SPIB_BASE);

    SPI_setConfig(SPIB_BASE, DEVICE_LSPCLK_FREQ, SPI_PROT_POL0PHA1,  // Rising edge with delay
                  SPI_MODE_CONTROLLER, 1000000, 8); // bitRate = 1 MHz
    SPI_setPTESignalPolarity(SPIB_BASE, SPI_PTE_ACTIVE_LOW);
    SPI_disableFIFO(SPIB_BASE);
    SPI_disableLoopback(SPIB_BASE);
    SPI_setEmulationMode(SPIB_BASE, SPI_EMULATION_STOP_MIDWAY);
//    SPI_enableHighSpeedMode(SPIB_BASE);
    SPI_enableModule(SPIB_BASE);

    EDIS;
}

uint16_t initialize(void) {

    Fapi_StatusType oReturnCheck;
    uint16_t returnValue = 1;

    // Disable all interrupts
    (void)__disable_interrupts();

#ifdef RUNNING_WITHOUT_BOOTLOADER
    //
    // Initialize System Control. Enable Peripheral Clocks.
    //
    InitSysCtrl();

    //
    // Make sure the LSPCLK divider is set to the default (divide by 4)
    //
    SysCtl_setLowSpeedClock(SYSCTL_LSPCLK_PRESCALE_4);
//    SysCtl_setLowSpeedClock(SYSCTL_LSPCLK_PRESCALE_1);

    //
    // Turn on SPIB peripheral
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SPIB);

#else

    //
    // Disable the watchdog
    //
    DisableDog();

    //
    // Copy time critical code and Flash setup code to RAM. This includes the
    // following functions: InitFlash()
    //
    // The  RamfuncsLoadStart, RamfuncsLoadSize, and RamfuncsRunStart
    // symbols are created by the linker. Refer to the device .cmd file.
    //
    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize);

    //
    // Call Flash Initialization to setup flash waitstates. This function must
    // reside in RAM.
    //
    InitFlash();
#endif

    //
    // This function is required to initialize the Flash API based on system
    // frequency before any other Flash API operation can be performed.
    //
    oReturnCheck = Fapi_initializeAPI(F021_CPU0_BASE_ADDRESS, 120);

    if (oReturnCheck == Fapi_Status_Success) {

        //
        // Disable ECC before calling setActiveFlashBank() because of error
        // described in section 3.2.1 of the TMS320F2837xD Flash API reference
        // guide (spnu629a).
        //
        EALLOW;
        Flash0EccRegs.ECC_ENABLE.all = 0;

        //
        // Fapi_setActiveFlashBank function sets the flash bank and FMC for further
        // flash operations to be performed on the bank.
        //
        oReturnCheck = Fapi_setActiveFlashBank(Fapi_FlashBank0);

        //
        // Re-enable ECC after calling setActiveFlashBank() because of error
        // described in section 3.2.1 of the TMS320F2837xD Flash API reference
        // guide (spnu629a).
        //
        EALLOW;
        Flash0EccRegs.ECC_ENABLE.all = 0xA;

        if (oReturnCheck == Fapi_Status_Success) {

            //
            // Initialize GPIO and configure GPIO pins for CANTX/CANRX
            //
#ifdef RUNNING_WITHOUT_BOOTLOADER
            InitGpio();
#endif

            initializeExternalFlash();

            //
            // Step 3. Clear all interrupts and initialize PIE vector table:
            // Disable CPU interrupts
            // (Ignore the return value because it's just the old interrupt vector value)
            //
            (void)__disable_interrupts();

            //
            // Initialize the PIE control registers to their default state.
            // The default state is all PIE interrupts disabled and flags
            // are cleared.
            // This function is found in the F2837xD_PieCtrl.c file.
            //
            InitPieCtrl();

            //
            // Disable CPU interrupts and clear all CPU interrupt flags:
            //
            IER = 0x0000;
            IFR = 0x0000;

            //
            // Initialize the PIE vector table with pointers to the shell Interrupt
            // Service Routines (ISR).
            // This will populate the entire table, even if the interrupt
            // is not used in this example.  This is useful for debug purposes.
            // The shell ISR routines are found in F2837xD_DefaultIsr.c.
            // This function is found in F2837xD_PieVect.c.
            //
            InitPieVectTable();

            //
            // Initialize the Device Peripheral
            //
            InitCpuTimers();   // initialize the Cpu Timers


            //
            // Enable global Interrupts and higher priority real-time debug events
            // (Ignore the return value because it's just the old interrupt vector value)
            //
            (void)__enable_interrupts();   // Enable Global interrupt INTM
            ERTM;   // Enable Global realtime interrupt DBGM

            SysCtl_disableWatchdog();

            returnValue = 1;

        } // flash setting active bank success

    } // flash initialization success

    return returnValue;
}

/**
 * main.c
 */
int main(void)
{
    uint16_t initStatus = initialize();

    if (initStatus != 0) {

        //
        // Loop forever. Suspend or place breakpoints to observe the buffers.
        //
        while(1)
        {
            queryDeviceId(SPIB_BASE);
        }
    }
}
