#include "F28x_Project.h"



void ConfigureADC(void);
void Setup_ePWM(void);

__interrupt void adc_isr(void);
Uint16 adcresult0;


void main(void){
    InitSysCtrl();
    InitGpio();
    InitEPwm3Gpio();
    DINT;
    InitPieCtrl();
    IER = 0x0000;
    IFR = 0x0000;
    InitPieVectTable();
    ConfigureADC();
    Setup_ePWM();

    EALLOW;
    PieVectTable.ADCA1_INT = &adc_isr;
    EDIS;

    EALLOW;
    CpuSysRegs.PCLKCR0.bit.TBCLKSYNC = 1;
    EDIS;

    IER |= M_INT1; //rows
    PieCtrlRegs.PIEIER1.bit.INTx1 = 1;//column
    EINT;
    ERTM;

    while(1){

    }
}

void Setup_ePWM(void){
     EPwm3Regs.TBCTL.bit.CLKDIV = 7;
     EPwm3Regs.TBCTL.bit.HSPCLKDIV = 7;
     EPwm3Regs.TBCTL.bit.CTRMODE = 0;
     EPwm3Regs.TBPRD = 55804;
     EPwm3Regs.CMPA.bit.CMPA = 55804/2;
     EPwm3Regs.AQCTLA.all = 0x0012;

     EPwm3Regs.ETSEL.bit.SOCAEN = 1;
     EPwm3Regs.ETSEL.bit.SOCASEL = 1;
     EPwm3Regs.ETPS.bit.SOCAPRD = 1;

}

void ConfigureADC(void){
    EALLOW;
    AdcaRegs.ADCCTL2.bit.PRESCALE = 6;
    AdcSetMode(ADC_ADCA, 0, 0);
    AdcaRegs.ADCCTL1.bit.INTPULSEPOS = 1;
    AdcaRegs.ADCCTL1.bit.ADCPWDNZ = 1;
    DELAY_US(1000);

    AdcaRegs.ADCSOC0CTL.bit.CHSEL = 1;
    AdcaRegs.ADCSOC0CTL.bit.ACQPS = 19;
    AdcaRegs.ADCSOC0CTL.bit.TRIGSEL = 9;
    AdcaRegs.ADCINTSEL1N2.bit.INT1SEL = 0;
    AdcaRegs.ADCINTSEL1N2.bit.INT1E = 1;
    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    EDIS;
}

__interrupt void adc_isr(void){
    adcresult0 = AdcaResultRegs.ADCRESULT0;

    AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    if(1 == AdcaRegs.ADCINTOVF.bit.ADCINT1){
        AdcaRegs.ADCINTOVFCLR.bit.ADCINT1 = 1;
        AdcaRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;
    }

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}


